/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.Messages;

public class FrameCloser
extends WindowAdapter {
    private Commands currentCommands;
    GUIFactory currentGUI;
    PdfDecoder decode_pdf;
    private Printer currentPrinter;
    GUIThumbnailPanel thumbnails;
    Values commonValues;
    PropertiesFile properties;

    public FrameCloser(Commands commands, GUIFactory gUIFactory, PdfDecoder pdfDecoder, Printer printer, GUIThumbnailPanel gUIThumbnailPanel, Values values, PropertiesFile propertiesFile) {
        this.currentCommands = commands;
        this.currentGUI = gUIFactory;
        this.decode_pdf = pdfDecoder;
        this.currentPrinter = printer;
        this.thumbnails = gUIThumbnailPanel;
        this.commonValues = values;
        this.properties = propertiesFile;
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.properties.setValue("lastDocumentPage", String.valueOf(this.commonValues.getCurrentPage()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentCommands.flush();
        FrameCloser frameCloser = this;
        if (frameCloser.currentPrinter.isPrinting()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerBusyPrinting.message"));
        }
        FrameCloser frameCloser2 = this;
        if (!frameCloser2.commonValues.isProcessing()) {
            this.thumbnails.terminateDrawing();
            int n = 0;
            if (this.currentGUI.confirmClose()) {
                n = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerCloseing.message"), null, 0);
            }
            if (n == 0) {
                this.currentCommands.handleUnsaveForms();
                this.decode_pdf.closePdfFile();
                if (SimpleViewer.exitOnClose) {
                    System.exit(0);
                } else {
                    this.currentGUI.getFrame().setVisible(false);
                    if (this.currentGUI.getFrame() instanceof JFrame) {
                        ((JFrame)this.currentGUI.getFrame()).dispose();
                    }
                }
            }
        } else {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }
}

