/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.util.Stack;
import java.util.StringTokenizer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;

public class RecentDocuments {
    int noOfRecentDocs;
    PropertiesFile properties;
    private Stack previousFiles = new Stack();
    private Stack nextFiles = new Stack();

    public RecentDocuments(int n, PropertiesFile propertiesFile) {
        this.noOfRecentDocs = n;
        this.properties = propertiesFile;
    }

    static String getShortenedFileName(String string) {
        if (string.length() <= 30) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            return string.substring(0, 30);
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String string2 = string.substring(stringArray[0].length(), string.length() - stringArray[n - 1].length());
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (int i = n - 2; i > 0; --i) {
            int n2 = stringBuffer.lastIndexOf(stringArray[i]);
            int n3 = n2 + stringArray[i].length();
            stringBuffer.replace(n2, n3, "...");
            if (stringBuffer.toString().length() <= 30) break;
        }
        return stringArray[0] + stringBuffer + stringArray[n - 1];
    }

    public String getPreviousDocument() {
        String string = null;
        if (this.previousFiles.size() > 1) {
            this.nextFiles.push(this.previousFiles.pop());
            string = (String)this.previousFiles.pop();
        }
        return string;
    }

    public String getNextDocument() {
        String string = null;
        if (!this.nextFiles.isEmpty()) {
            string = (String)this.nextFiles.pop();
        }
        return string;
    }

    public void addToFileList(String string) {
        this.previousFiles.push(string);
    }
}

