/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.javafx;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.javafx.JavaFXFontMapper;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.ObjectStore;
import org.jpedal.render.output.javafx.JavaFXDisplay;
import org.jpedal.utils.LogWriter;

public class ExtractPagesAsJavaFX {
    private String user_dir = System.getProperty("user.dir");
    public static boolean outputMessages = false;
    String output_dir = null;
    String separator = System.getProperty("file.separator");
    PdfDecoder decode_pdf = null;
    private boolean useHiresImage = false;
    private String test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
    public static boolean isTest = false;
    private String password = "";
    private String firstPageName = null;
    private static boolean createTemplate = false;
    private static String saveTemplateFileName = "/Users/markee/Desktop/test.xml";
    private static boolean loadTemplate = false;
    private static String loadTemplateFileName;
    int end;
    int page;

    public ExtractPagesAsJavaFX() {
        ExtractPagesAsJavaFX.init();
    }

    public ExtractPagesAsJavaFX(String[] stringArray) {
        ExtractPagesAsJavaFX.init();
        String string = this.setParams(stringArray);
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + file + " not found");
            System.out.println("May need full path");
            return;
        }
        this.extraction(string, this.output_dir);
    }

    private static void init() {
        loadTemplateFileName = System.getProperty("org.jpedal.loadXML");
        loadTemplate = loadTemplateFileName != null && new File(loadTemplateFileName).exists();
        saveTemplateFileName = System.getProperty("org.jpedal.saveXML");
        if (saveTemplateFileName != null) {
            createTemplate = true;
            System.out.println("XXXXXCVBNM<>");
        } else {
            createTemplate = false;
        }
    }

    public void extraction(String string, String string2) {
        this.output_dir = string2;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        System.out.println("output_dir: " + string2);
        this.firstPageName = System.getProperty("org.jpedal.pdf2javafx.firstPageName");
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(string, string2);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                } else {
                    stringArray = file.list();
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            if (stringArray != null) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    if (stringArray[n].toLowerCase().endsWith(".pdf") && !stringArray[n].startsWith(".")) {
                        if (outputMessages) {
                            System.out.println(string + stringArray[n]);
                        }
                        this.decodeFile(string + stringArray[n], string2);
                    }
                    ++n;
                }
            }
        }
        if (outputMessages) {
            System.out.println("JavaFX created");
        }
    }

    private void decodeFile(String string, String string2) {
        String string3 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n == -1) {
            n = string.lastIndexOf(47);
        }
        if (n != -1) {
            string3 = string.substring(n + 1, string.length() - 4);
        } else if (!isTest && string.toLowerCase().endsWith(".pdf")) {
            string3 = string.substring(0, string.length() - 4);
        }
        try {
            this.decode_pdf = new PdfDecoder(true);
            if (!isTest) {
                FontMappings.setFontReplacements();
            }
            if (this.password != null) {
                this.decode_pdf.openPdfFile(string, this.password);
            } else {
                this.decode_pdf.openPdfFile(string);
            }
        }
        catch (Exception exception) {
            System.err.println("8.Exception " + exception + " in pdf code in " + string);
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
            if (!isTest) {
                throw new RuntimeException("Wrong password password used=>" + this.password + "<");
            }
        } else {
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
                throw new RuntimeException("Extraction not allowed");
            }
            this.extractPageAsJavaFX(string, string2, string3);
        }
        this.decode_pdf.closePdfFile();
    }

    public int getPageCount() {
        return this.end;
    }

    public int getPageReached() {
        return this.page;
    }

    private void extractPageAsJavaFX(String string, String string2, String string3) {
        File file;
        if (string2 != null && !(file = new File(string2)).exists()) {
            file.mkdirs();
        }
        int n = 1;
        this.end = this.decode_pdf.getPageCount();
        if (this.end > 10 && isTest) {
            this.end = 10;
        }
        if (outputMessages) {
            System.out.println("JavaFX file will be in  " + string2);
        }
        try {
            int n2;
            File file2;
            JavaFXFontMapper.setXMLTemplate(createTemplate);
            if (loadTemplate) {
                JavaFXFontMapper.loadCustomFontMappings(new FileInputStream(new File(loadTemplateFileName)));
            }
            if (!(file2 = new File(string2 + "img/icons")).exists()) {
                file2.mkdirs();
            }
            String[] stringArray = new String[]{"smstart.gif", "smback.gif", "smfback.gif", "smforward.gif", "smfforward.gif", "smend.gif", "logo.gif"};
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                InputStream inputStream = this.getClass().getResourceAsStream("/org/jpedal/examples/javafx/icons/" + stringArray[i]);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2 + this.separator + stringArray[i]));
                byte[] byArray = new byte[65536];
                while ((n2 = inputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
                bufferedOutputStream.close();
                inputStream.close();
            }
            this.page = n;
            while (this.page < this.end + 1) {
                int n4;
                int n5;
                String string4 = String.valueOf(this.page);
                if (this.firstPageName != null && this.page == n) {
                    string4 = this.firstPageName;
                } else {
                    String string5 = String.valueOf(this.end);
                    n5 = string5.length() - string4.length();
                    for (n4 = 0; n4 < n5; ++n4) {
                        string4 = '0' + string4;
                    }
                }
                if (outputMessages) {
                    System.out.println("Page " + string4);
                }
                int n6 = this.decode_pdf.getPdfPageData().getCropBoxX(this.page);
                n5 = this.decode_pdf.getPdfPageData().getCropBoxY(this.page);
                n4 = this.decode_pdf.getPdfPageData().getCropBoxWidth(this.page);
                n2 = this.decode_pdf.getPdfPageData().getCropBoxHeight(this.page);
                Rectangle rectangle = new Rectangle(0, 0, n4, n2);
                Point2D.Double double_ = new Point2D.Double(n4 / 2 + n6, n2 / 2 + n5);
                JavaFXDisplay javaFXDisplay = null;
                javaFXDisplay = new JavaFXDisplay(this.page, double_, rectangle, false, 100, new ObjectStore());
                float f = 1.0f;
                javaFXDisplay.setValue(2, (int)(f * 100.0f));
                javaFXDisplay.writeCustom(11, this.decode_pdf.getPdfPageData());
                javaFXDisplay.setValue(0, 0);
                javaFXDisplay.setOutputDir(string2, string3, string4);
                this.decode_pdf.addExternalHandler(javaFXDisplay, 20);
                javaFXDisplay.setBooleanValue(8, true);
                this.decode_pdf.decodePage(this.page);
                this.decode_pdf.flushObjectValues(true);
                ++this.page;
            }
        }
        catch (Exception exception) {
            this.decode_pdf.closePdfFile();
            throw new RuntimeException("Exception " + exception.getMessage() + " with thumbnails on File=" + string);
        }
        if (createTemplate) {
            JavaFXFontMapper.createXMLTemplate(saveTemplateFileName);
        }
    }

    public static void main(String[] stringArray) {
        if (outputMessages) {
            System.out.println("Simple demo to extract JavaFX version of a page");
        }
        new ExtractPagesAsJavaFX(stringArray);
    }

    private String setParams(String[] stringArray) {
        String string = this.test_file;
        int n = stringArray.length;
        if (n == 0) {
            ExtractPagesAsJavaFX.showCommandLineValues();
        } else if (n == 1) {
            string = stringArray[0];
        } else if (n < 6) {
            string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.endsWith("/") || string2.endsWith("\\")) {
                    this.output_dir = string2;
                    continue;
                }
                this.password = string2;
            }
        }
        return string;
    }

    private static void showCommandLineValues() {
        System.out.println("Example takes 2 or 3 parameters");
        System.out.println("Value 1 is the file name or directory of PDF files to process");
        System.out.println("Value 2 is the pass to write out JavaFX and directories and must end with / or \\ character)");
        System.out.println("Value 3 (optional) password for PDF file");
        System.exit(0);
    }

    private static boolean isNumber(String string) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(c < '0' | c > '9')) continue;
            bl = false;
            i = n;
        }
        return bl;
    }

    public String getOutputDir() {
        return this.output_dir;
    }
}

