/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.briss.utils;

import com.itextpdf.text.Rectangle;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RectangleHandler {
    private RectangleHandler() {
    }

    public static Rectangle calculateScaledRectangle(List<Rectangle> boxes, Float[] ratios, int rotation) {
        if (ratios == null || boxes.size() == 0) {
            return null;
        }
        Rectangle smallestBox = null;
        float smallestSquare = Float.MAX_VALUE;
        for (Rectangle box : boxes) {
            if (box == null) continue;
            if (smallestBox == null) {
                smallestBox = box;
            }
            if (!(smallestSquare > box.getWidth() * box.getHeight())) continue;
            smallestSquare = box.getWidth() * box.getHeight();
            smallestBox = box;
        }
        if (smallestBox == null) {
            return null;
        }
        float[] rotRatios = RectangleHandler.rotateRatios(ratios, rotation);
        Rectangle scaledBox = new Rectangle(smallestBox);
        scaledBox.setLeft(smallestBox.getLeft() + smallestBox.getWidth() * rotRatios[0]);
        scaledBox.setBottom(smallestBox.getBottom() + smallestBox.getHeight() * rotRatios[1]);
        scaledBox.setRight(smallestBox.getLeft() + smallestBox.getWidth() * (1.0f - rotRatios[2]));
        scaledBox.setTop(smallestBox.getBottom() + smallestBox.getHeight() * (1.0f - rotRatios[3]));
        return scaledBox;
    }

    private static float[] rotateRatios(Float[] ratios, int rotation) {
        float[] tmpRatios = new float[4];
        int i = 0;
        while (i < 4) {
            tmpRatios[i] = ratios[i].floatValue();
            ++i;
        }
        int tmpRotation = rotation;
        while (tmpRotation > 0 && tmpRotation < 360) {
            float tmpValue = tmpRatios[0];
            tmpRatios[0] = tmpRatios[1];
            tmpRatios[1] = tmpRatios[2];
            tmpRatios[2] = tmpRatios[3];
            tmpRatios[3] = tmpValue;
            tmpRotation += 90;
        }
        return tmpRatios;
    }
}

