/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class DLedFromOthersItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "DLedFromOthers";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
    }

    public DLedFromOthersItem(String table_id) {
        super(COLUMN_ID, 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long l = value = peer == null ? 0L : peer.getStats().getTotalBytesDownloadedByPeer() - peer.getStats().getTotalDataBytesSent();
        if (value < 0L) {
            value = 0L;
        }
        if (peer != null) {
            Long prev_value = (Long)peer.getData("DLedFromOther_prev");
            if (prev_value != null) {
                if (value < prev_value) {
                    value = prev_value;
                } else if (value > prev_value) {
                    peer.setData("DLedFromOther_prev", new Long(value));
                }
            } else {
                peer.setData("DLedFromOther_prev", new Long(value));
            }
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatByteCountToKiBEtc(value));
    }
}

