/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class CompletionItem
extends CoreTableColumn
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellDisposeListener,
TableCellSWTPaintListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    private static final int borderWidth = 1;
    public static final String COLUMN_ID = "completion";
    private static Font fontText;
    private Map mapCellLastPercentDone = new HashMap();
    private int marginHeight = -1;
    Color textColor;

    public CompletionItem(String sTableID) {
        this(sTableID, -1);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
    }

    public CompletionItem(String sTableID, int marginHeight) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 150, sTableID);
        this.marginHeight = marginHeight;
        this.initializeAsGraphic(-1, 150);
        this.setMinWidth(50);
    }

    public void cellAdded(TableCell cell) {
        if (this.marginHeight != -1) {
            cell.setMarginHeight(this.marginHeight);
        } else {
            cell.setMarginHeight(2);
        }
    }

    public void dispose(TableCell cell) {
        Image img;
        this.mapCellLastPercentDone.remove(cell);
        Graphic graphic = cell.getGraphic();
        if (graphic instanceof UISWTGraphic && (img = ((UISWTGraphic)graphic).getImage()) != null && !img.isDisposed()) {
            img.dispose();
        }
    }

    public void refresh(TableCell cell) {
        int lastPercentDone;
        int percentDone = this.getPercentDone(cell);
        Integer intObj = (Integer)this.mapCellLastPercentDone.get(cell);
        int n = lastPercentDone = intObj == null ? 0 : intObj;
        if (!cell.setSortValue(percentDone) && cell.isValid() && lastPercentDone == percentDone) {
            return;
        }
    }

    public void cellPaint(GC gcImage, TableCellSWT cell) {
        Rectangle imgBounds;
        int percentDone = this.getPercentDone(cell);
        Rectangle bounds = cell.getBounds();
        int yOfs = (bounds.height - 13) / 2;
        int x1 = bounds.width - 1 - 2;
        int y1 = bounds.height - 3 - yOfs;
        if (x1 < 10 || y1 < 3) {
            return;
        }
        boolean textYofs = false;
        if (y1 >= 28) {
            yOfs = 2;
            y1 = 16;
        }
        this.mapCellLastPercentDone.put(cell, new Integer(percentDone));
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgEnd = imageLoader.getImage("dl_bar_end");
        Image img0 = imageLoader.getImage("dl_bar_0");
        Image img1 = imageLoader.getImage("dl_bar_1");
        if (!imgEnd.isDisposed()) {
            gcImage.drawImage(imgEnd, bounds.x, bounds.y + yOfs);
            gcImage.drawImage(imgEnd, bounds.x + x1 + 1, bounds.y + yOfs);
        }
        int limit = x1 * percentDone / 1000;
        if (!img1.isDisposed() && limit > 0) {
            imgBounds = img1.getBounds();
            gcImage.drawImage(img1, 0, 0, imgBounds.width, imgBounds.height, bounds.x + 1, bounds.y + yOfs, limit, imgBounds.height);
        }
        if (percentDone < 1000 && !img0.isDisposed()) {
            imgBounds = img0.getBounds();
            gcImage.drawImage(img0, 0, 0, imgBounds.width, imgBounds.height, bounds.x + limit + 1, bounds.y + yOfs, x1 - limit, imgBounds.height);
        }
        imageLoader.releaseImage("dl_bar_end");
        imageLoader.releaseImage("dl_bar_0");
        imageLoader.releaseImage("dl_bar_1");
        if (this.textColor == null) {
            this.textColor = ColorCache.getColor(gcImage.getDevice(), "#005ACF");
        }
        gcImage.setForeground(this.textColor);
        String sPercent = DisplayFormatters.formatPercentFromThousands(percentDone);
        GCStringPrinter.printString(gcImage, sPercent, new Rectangle(bounds.x + 4, bounds.y + yOfs, bounds.width - 4, 13), true, false, 0x1000000);
    }

    private int getPercentDone(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return 0;
        }
        return dm.getStats().getDownloadCompleted(true);
    }
}

