/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnTorrentSpeed
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "torrentspeed";
    private Image imgUp;
    private Image imgDown;

    public ColumnTorrentSpeed(String tableID) {
        super(COLUMN_ID, 80, tableID);
        this.setAlignment(2);
        this.setType(1);
        this.setRefreshInterval(-2);
        this.setUseCoreDataSource(false);
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgUp = imageLoader.getImage("image.torrentspeed.up");
        this.imgDown = imageLoader.getImage("image.torrentspeed.down");
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "bytes"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell) {
        long sortValue;
        long value;
        if (!(cell.getDataSource() instanceof Download)) {
            return;
        }
        Download dm = (Download)cell.getDataSource();
        String prefix = "";
        if (dm == null) {
            value = 0L;
            sortValue = 0L;
        } else {
            int iState = dm.getState();
            if (iState == 4) {
                value = dm.getStats().getDownloadAverage();
                ((TableCellSWT)cell).setIcon(this.imgDown);
            } else if (iState == 5) {
                value = dm.getStats().getUploadAverage();
                ((TableCellSWT)cell).setIcon(this.imgUp);
            } else {
                ((TableCellSWT)cell).setIcon(null);
                value = 0L;
            }
            sortValue = value << 4 | (long)iState;
        }
        if (cell.setSortValue(sortValue) || !cell.isValid()) {
            cell.setText(value > 0L ? prefix + DisplayFormatters.formatByteCountToKiBEtcPerSec(value) : "");
        }
    }
}

