/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.ToolBarEnabler;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableViewTab<DATASOURCETYPE>
extends AbstractIView
implements IViewExtension,
ToolBarEnabler {
    private TableViewSWT<DATASOURCETYPE> tv;
    private Object parentDataSource;
    private final String propertiesPrefix;
    private Composite composite;

    public TableViewTab(String propertiesPrefix) {
        this.propertiesPrefix = propertiesPrefix;
    }

    public TableViewSWT<DATASOURCETYPE> getTableView() {
        return this.tv;
    }

    @Override
    public final void initialize(Composite composite) {
        this.tv = this.initYourTableView();
        if (this.parentDataSource != null) {
            this.tv.setParentDataSource(this.parentDataSource);
        }
        Composite parent = this.initComposite(composite);
        this.tv.initialize(parent);
        this.composite = parent != composite ? composite : this.tv.getComposite();
        this.tableViewTabInitComplete();
    }

    public void tableViewTabInitComplete() {
    }

    public Composite initComposite(Composite composite) {
        return composite;
    }

    public abstract TableViewSWT<DATASOURCETYPE> initYourTableView();

    @Override
    public final void dataSourceChanged(Object newDataSource) {
        this.parentDataSource = newDataSource;
        if (this.tv != null) {
            this.tv.setParentDataSource(newDataSource);
        }
    }

    @Override
    public final void refresh() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public final void delete() {
        if (this.tv != null) {
            this.tv.delete();
        }
        super.delete();
    }

    @Override
    public final String getData() {
        return this.getPropertiesPrefix() + ".title.short";
    }

    @Override
    public final String getFullTitle() {
        return MessageText.getString(this.getPropertiesPrefix() + ".title.full");
    }

    @Override
    public final void generateDiagnostics(IndentWriter writer) {
        if (this.tv != null) {
            this.tv.generate(writer);
        }
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public boolean toolBarItemActivated(String itemKey) {
        if (itemKey.equals("editcolumns") && this.tv instanceof TableViewSWTImpl) {
            ((TableViewSWTImpl)this.tv).showColumnEditor();
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBar(Map<String, Boolean> list) {
        list.put("editcolumns", true);
    }

    public String getPropertiesPrefix() {
        return this.propertiesPrefix;
    }

    @Override
    public Menu getPrivateMenu() {
        return null;
    }

    @Override
    public void viewActivated() {
        if (this.tv instanceof TableViewSWTImpl) {
            ((TableViewSWTImpl)this.tv).isVisible();
        }
    }

    @Override
    public void viewDeactivated() {
        if (this.tv instanceof TableViewSWTImpl) {
            ((TableViewSWTImpl)this.tv).isVisible();
        }
    }
}

