/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.peer;

import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.util.Arrays;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.PieceDistributionView;

public class RemotePieceDistributionView
extends PieceDistributionView {
    private PEPeer peer = null;

    public void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof Object[]) {
            newDataSource = ((Object[])newDataSource)[0];
        }
        if (newDataSource instanceof PEPeer) {
            this.peer = (PEPeer)newDataSource;
            this.pem = this.peer.getManager();
        } else {
            this.peer = null;
            this.pem = null;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                RemotePieceDistributionView.this.refresh();
            }
        });
    }

    public void refresh() {
        if (this.pem == null) {
            return;
        }
        if (this.peer instanceof PEPeerTransportProtocol) {
            PEPeerTransportProtocol pet = (PEPeerTransportProtocol)this.peer;
            BitFlags avl = pet.getAvailable();
            this.hasPieces = (boolean[])(avl == null ? null : avl.flags);
        } else if (this.peer.isSeed()) {
            this.hasPieces = new boolean[this.pem.getPieces().length];
            Arrays.fill(this.hasPieces, true);
        } else {
            this.hasPieces = null;
        }
        super.refresh();
    }
}

