/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowRefreshListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.CompositeMinSize;
import org.gudy.azureus2.ui.swt.help.HealthHelpWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;
import org.gudy.azureus2.ui.swt.views.FilesViewMenuUtil;
import org.gudy.azureus2.ui.swt.views.table.TableViewFilterCheck;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTPanelCreator;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.utils.CategoryUIUtils;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTorrentsView
extends TableViewTab<DownloadManager>
implements GlobalManagerListener,
ParameterListener,
DownloadManagerListener,
CategoryManagerListener,
CategoryListener,
KeyListener,
TableLifeCycleListener,
TableViewSWTPanelCreator,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
TableViewFilterCheck<DownloadManager>,
ToolBarEnabler,
TableRowRefreshListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    private AzureusCore azureus_core;
    private GlobalManager globalManager;
    protected boolean isSeedingView;
    private Composite cTablePanel;
    private Font fontButton = null;
    protected Composite cCategories;
    private DragSource dragSource = null;
    private DropTarget dropTarget = null;
    protected Text txtFilter = null;
    private Category currentCategory;
    private int drag_drop_line_start = -1;
    private TableRowCore[] drag_drop_rows = null;
    private boolean bDNDalwaysIncomplete;
    private TableViewSWT<DownloadManager> tv;
    private Composite cTableParentPanel;
    protected boolean viewActive;
    private boolean forceHeaderVisible = false;
    private TableSelectionListener defaultSelectedListener;
    private Composite filterParent;
    private boolean neverShowCatButtons;

    public MyTorrentsView() {
        super("MyTorrentsView");
    }

    public MyTorrentsView(AzureusCore _azureus_core, String tableID, boolean isSeedingView, TableColumnCore[] basicItems, Text txtFilter, Composite cCats) {
        super("MyTorrentsView");
        this.txtFilter = txtFilter;
        this.cCategories = cCats;
        this.init(_azureus_core, tableID, isSeedingView, isSeedingView ? DownloadTypeComplete.class : DownloadTypeIncomplete.class, basicItems);
    }

    @Override
    public TableViewSWT<DownloadManager> initYourTableView() {
        return this.tv;
    }

    public void init(AzureusCore _azureus_core, String tableID, boolean isSeedingView, Class<?> forDataSourceType, TableColumnCore[] basicItems) {
        this.isSeedingView = isSeedingView;
        this.tv = this.createTableView(forDataSourceType, tableID, basicItems);
        this.tv.setRowDefaultIconSize(new Point(16, 16));
        if (this.getRowDefaultHeight() > 0) {
            this.tv.setRowDefaultHeight(this.getRowDefaultHeight());
        }
        this.azureus_core = _azureus_core;
        this.globalManager = this.azureus_core.getGlobalManager();
        if (this.currentCategory == null) {
            this.currentCategory = CategoryManager.getCategory(1);
        }
        this.tv.addLifeCycleListener(this);
        this.tv.setMainPanelCreator(this);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addRefreshListener(this, false);
        if (this.tv.canHaveSubItems()) {
            this.tv.addRefreshListener(this);
        }
        this.tv.addTableDataSourceChangedListener(new TableDataSourceChangedListener(){

            public void tableDataSourceChanged(Object newDataSource) {
                if (newDataSource instanceof Category) {
                    MyTorrentsView.this.neverShowCatButtons = true;
                    MyTorrentsView.this.activateCategory((Category)newDataSource);
                }
            }
        }, true);
        this.forceHeaderVisible = COConfigurationManager.getBooleanParameter("MyTorrentsView.alwaysShowHeader");
        if (this.txtFilter != null) {
            Control[] children;
            this.filterParent = this.txtFilter.getParent();
            if (Constants.isWindows) {
                this.filterParent = this.filterParent.getParent();
            }
            Menu menuFilterHeader = new Menu(this.filterParent);
            final MenuItem menuItemAlwaysShow = new MenuItem(menuFilterHeader, 32);
            Messages.setLanguageText(menuItemAlwaysShow, "ConfigView.label.alwaysShowLibraryHeader");
            menuFilterHeader.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    menuItemAlwaysShow.setSelection(MyTorrentsView.this.forceHeaderVisible);
                }

                public void menuHidden(MenuEvent e) {
                }
            });
            menuItemAlwaysShow.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    COConfigurationManager.setParameter("MyTorrentsView.alwaysShowHeader", !MyTorrentsView.this.forceHeaderVisible);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.filterParent.setMenu(menuFilterHeader);
            for (Control control : children = this.filterParent.getChildren()) {
                if (control == this.txtFilter) continue;
                control.setMenu(menuFilterHeader);
            }
        }
    }

    @Override
    public void tableViewInitialized() {
        this.tv.addKeyListener(this);
        this.createTabs();
        if (this.txtFilter == null) {
            this.tv.enableFilterCheck(null, this);
        }
        this.createDragDrop();
        Utils.getOffOfSWTThread(new AERunnable(){

            public void runSupport() {
                COConfigurationManager.addAndFireParameterListeners(new String[]{"DND Always In Incomplete", "MyTorrentsView.alwaysShowHeader", "User Mode"}, MyTorrentsView.this);
                if (MyTorrentsView.this.currentCategory != null) {
                    MyTorrentsView.this.currentCategory.addCategoryListener(MyTorrentsView.this);
                }
                CategoryManager.addCategoryManagerListener(MyTorrentsView.this);
                MyTorrentsView.this.globalManager.addListener(MyTorrentsView.this, false);
                DownloadManager[] dms = MyTorrentsView.this.globalManager.getDownloadManagers().toArray(new DownloadManager[0]);
                for (int i = 0; i < dms.length; ++i) {
                    DownloadManager dm = dms[i];
                    dm.addListener(MyTorrentsView.this);
                    if (MyTorrentsView.this.isOurDownloadManager(dm)) continue;
                    dms[i] = null;
                }
                MyTorrentsView.this.tv.addDataSources(dms);
                MyTorrentsView.this.tv.processDataSourceQueue();
            }
        });
        this.cTablePanel.layout();
    }

    @Override
    public void tableViewDestroyed() {
        this.tv.removeKeyListener(this);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    Utils.disposeSWTObjects(new Object[]{MyTorrentsView.this.dragSource, MyTorrentsView.this.dropTarget, MyTorrentsView.this.fontButton});
                    MyTorrentsView.this.dragSource = null;
                    MyTorrentsView.this.dropTarget = null;
                    MyTorrentsView.this.fontButton = null;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        });
        Object[] dms = this.globalManager.getDownloadManagers().toArray();
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = (DownloadManager)dms[i];
            dm.removeListener(this);
        }
        if (this.currentCategory != null) {
            this.currentCategory.removeCategoryListener(this);
        }
        CategoryManager.removeCategoryManagerListener(this);
        this.globalManager.removeListener(this);
        COConfigurationManager.removeParameterListener("DND Always In Incomplete", this);
        COConfigurationManager.removeParameterListener("User Mode", this);
    }

    @Override
    public Composite createTableViewPanel(Composite composite) {
        composite.addListener(26, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.viewActive = true;
                MyTorrentsView.this.updateSelectedContent();
            }
        });
        composite.addListener(27, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.viewActive = false;
            }
        });
        this.cTableParentPanel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.cTableParentPanel.setLayout(layout);
        if (composite.getLayout() instanceof GridLayout) {
            this.cTableParentPanel.setLayoutData(new GridData(1808));
        }
        this.cTablePanel = new Composite(this.cTableParentPanel, 0);
        GridData gridData = new GridData(1808);
        this.cTablePanel.setLayoutData(gridData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.cTablePanel.setLayout(layout);
        this.cTablePanel.layout();
        return this.cTablePanel;
    }

    public void setForceHeaderVisible(boolean forceHeaderVisible) {
        this.forceHeaderVisible = forceHeaderVisible;
        if (this.cTablePanel != null && !this.cTablePanel.isDisposed()) {
            this.createTabs();
        }
    }

    private void createTabs() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.swt_createTabs();
            }
        });
    }

    private void swt_createTabs() {
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        boolean showCat = false;
        if (!this.neverShowCatButtons) {
            for (int i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                showCat = true;
                break;
            }
        }
        this.buildHeaderArea();
        if (this.cCategories != null && !this.cCategories.isDisposed()) {
            Control[] controls = this.cCategories.getChildren();
            for (int i = 0; i < controls.length; ++i) {
                controls[i].dispose();
            }
        }
        if (showCat) {
            this.buildCat((Category[])categories);
        } else if (this.cTableParentPanel != null && !this.cTableParentPanel.isDisposed()) {
            this.cTableParentPanel.layout();
        }
    }

    private void buildHeaderArea() {
        if (this.cCategories == null) {
            this.cCategories = new CompositeMinSize(this.cTableParentPanel, 0);
            ((CompositeMinSize)this.cCategories).setMinSize(new Point(-1, 24));
            GridData gridData = new GridData(131072, 128, true, false);
            this.cCategories.setLayoutData(gridData);
            this.cCategories.moveAbove(null);
        } else if (this.cCategories.isDisposed()) {
            return;
        }
        if (!(this.cCategories.getLayout() instanceof RowLayout)) {
            RowLayout rowLayout = new RowLayout();
            rowLayout.marginTop = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginLeft = 3;
            rowLayout.marginRight = 0;
            rowLayout.spacing = 0;
            rowLayout.wrap = true;
            this.cCategories.setLayout(rowLayout);
        }
        this.tv.enableFilterCheck(this.txtFilter, this);
    }

    private void buildCat(Category[] categories) {
        int iFontPixelsHeight = 10;
        int iFontPointHeight = iFontPixelsHeight * 72 / this.cCategories.getDisplay().getDPI().y;
        for (int i = 0; i < categories.length; ++i) {
            final Category category = categories[i];
            final Button catButton = new Button(this.cCategories, 2);
            catButton.addKeyListener(this);
            if (i == 0 && this.fontButton == null) {
                Font f = catButton.getFont();
                FontData fd = f.getFontData()[0];
                fd.setHeight(iFontPointHeight);
                this.fontButton = new Font((Device)this.cCategories.getDisplay(), fd);
            }
            catButton.setText("|");
            catButton.setFont(this.fontButton);
            catButton.pack(true);
            if (catButton.computeSize((int)100, (int)-1).y > 0) {
                RowData rd = new RowData();
                rd.height = catButton.computeSize((int)100, (int)-1).y - 2 + catButton.getBorderWidth() * 2;
                catButton.setLayoutData(rd);
            }
            String name = category.getName();
            if (category.getType() == 0) {
                catButton.setText(name);
            } else {
                Messages.setLanguageText(catButton, name);
            }
            catButton.setData("Category", category);
            if (category == this.currentCategory) {
                catButton.setSelection(true);
            }
            catButton.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int i;
                    Button curButton = (Button)e.widget;
                    boolean isEnabled = curButton.getSelection();
                    Control[] controls = MyTorrentsView.this.cCategories.getChildren();
                    if (!isEnabled) {
                        for (i = 0; i < controls.length; ++i) {
                            if (!(controls[i] instanceof Button)) continue;
                            curButton = (Button)controls[i];
                            break;
                        }
                    }
                    for (i = 0; i < controls.length; ++i) {
                        if (!(controls[i] instanceof Button)) continue;
                        Button b = (Button)controls[i];
                        if (b != curButton && b.getSelection()) {
                            b.setSelection(false);
                            continue;
                        }
                        if (b != curButton || b.getSelection()) continue;
                        b.setSelection(true);
                    }
                    MyTorrentsView.this.activateCategory((Category)curButton.getData("Category"));
                }
            });
            catButton.addListener(32, new Listener(){

                public void handleEvent(Event event2) {
                    Button curButton = (Button)event2.widget;
                    Category curCategory = (Category)curButton.getData("Category");
                    List dms = curCategory.getDownloadManagers(MyTorrentsView.this.globalManager.getDownloadManagers());
                    long ttlActive = 0L;
                    long ttlSize = 0L;
                    long ttlRSpeed = 0L;
                    long ttlSSpeed = 0L;
                    int count = 0;
                    for (DownloadManager dm : dms) {
                        if (!MyTorrentsView.this.isInCategory(dm, MyTorrentsView.this.currentCategory)) continue;
                        ++count;
                        if (dm.getState() == 50 || dm.getState() == 60) {
                            ++ttlActive;
                        }
                        ttlSize += dm.getSize();
                        ttlRSpeed += dm.getStats().getDataReceiveRate();
                        ttlSSpeed += dm.getStats().getDataSendRate();
                    }
                    String up_details = "";
                    String down_details = "";
                    if (category.getType() != 1) {
                        String up_str = MessageText.getString("GeneralView.label.maxuploadspeed");
                        String down_str = MessageText.getString("GeneralView.label.maxdownloadspeed");
                        String unlimited_str = MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited");
                        int up_speed = category.getUploadSpeed();
                        int down_speed = category.getDownloadSpeed();
                        up_details = up_str + ": " + (up_speed == 0 ? unlimited_str : DisplayFormatters.formatByteCountToKiBEtc(up_speed));
                        down_details = down_str + ": " + (down_speed == 0 ? unlimited_str : DisplayFormatters.formatByteCountToKiBEtc(down_speed));
                    }
                    if (count == 0) {
                        curButton.setToolTipText(down_details + "\n" + up_details + "\nTotal: 0");
                        return;
                    }
                    curButton.setToolTipText((up_details.length() == 0 ? "" : down_details + "\n" + up_details + "\n") + "Total: " + count + "\n" + "Downloading/Seeding: " + ttlActive + "\n" + "\n" + "Speed: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlRSpeed / (long)count) + "/" + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlSSpeed / (long)count) + "\n" + "Size: " + DisplayFormatters.formatByteCountToKiBEtc(ttlSize));
                }
            });
            final DropTarget tabDropTarget = new DropTarget(catButton, 23);
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            tabDropTarget.setTransfer(types);
            tabDropTarget.addDropListener(new DropTargetAdapter(){

                public void dragOver(DropTargetEvent e) {
                    e.detail = MyTorrentsView.this.drag_drop_line_start >= 0 ? 2 : 0;
                }

                public void drop(DropTargetEvent e) {
                    e.detail = 0;
                    if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                        MyTorrentsView.this.drag_drop_line_start = -1;
                        MyTorrentsView.access$1202(MyTorrentsView.this, null);
                        TorrentUtil.assignToCategory(MyTorrentsView.this.tv.getSelectedDataSources().toArray(), (Category)catButton.getData("Category"));
                    }
                }
            });
            catButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (tabDropTarget != null && !tabDropTarget.isDisposed()) {
                        tabDropTarget.dispose();
                    }
                }
            });
            Menu menu = new Menu(catButton.getShell(), 8);
            catButton.setMenu(menu);
            CategoryUIUtils.setupCategoryMenu(menu, category);
        }
        this.cCategories.getParent().layout(true, true);
    }

    public boolean isOurDownloadManager(DownloadManager dm) {
        if (!this.isInCategory(dm, this.currentCategory)) {
            return false;
        }
        boolean bCompleted = dm.isDownloadComplete(this.bDNDalwaysIncomplete);
        boolean bOurs = bCompleted && this.isSeedingView || !bCompleted && !this.isSeedingView;
        return bOurs;
    }

    @Override
    public boolean filterCheck(DownloadManager dm, String sLastSearch, boolean bRegexSearch) {
        boolean bOurs = true;
        if (sLastSearch.length() > 0) {
            try {
                String[][] names = new String[][]{{"", dm.getDisplayName()}, {"t:", dm.getTorrent().getAnnounceURL().getHost()}, {"st:", "" + dm.getState()}};
                String name = names[0][1];
                String tmpSearch = sLastSearch;
                for (int i = 0; i < names.length; ++i) {
                    if (!tmpSearch.startsWith(names[i][0])) continue;
                    tmpSearch = tmpSearch.substring(names[i][0].length());
                    name = names[i][1];
                }
                String s = bRegexSearch ? tmpSearch : "\\Q" + tmpSearch.replaceAll("[|;]", "\\\\E|\\\\Q") + "\\E";
                Pattern pattern = Pattern.compile(s, 2);
                if (!pattern.matcher(name).find()) {
                    bOurs = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return bOurs;
    }

    @Override
    public void filterSet(final String filter2) {
        if (this.forceHeaderVisible) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MyTorrentsView.this.txtFilter != null) {
                    boolean visible = filter2.length() > 0;
                    Object layoutData = MyTorrentsView.this.filterParent.getLayoutData();
                    if (layoutData instanceof FormData) {
                        boolean wasVisible;
                        FormData fd = (FormData)layoutData;
                        boolean bl = wasVisible = fd.height != 0;
                        if (visible != wasVisible) {
                            fd.height = visible ? -1 : 0;
                            MyTorrentsView.this.filterParent.setLayoutData(layoutData);
                            MyTorrentsView.this.filterParent.getParent().layout();
                        }
                    }
                    if (!visible) {
                        MyTorrentsView.this.tv.setFocus();
                    }
                }
            }
        });
    }

    @Override
    public void selected(TableRowCore[] rows) {
        this.updateSelectedContent();
        this.refreshTorrentMenu();
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
        this.refreshTorrentMenu();
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        this.updateSelectedContent();
        this.refreshTorrentMenu();
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    public void updateSelectedContent() {
        this.updateSelectedContent(false);
    }

    public void updateSelectedContent(boolean force) {
        if (this.cTablePanel == null || this.cTablePanel.isDisposed()) {
            return;
        }
        if (!this.isTableFocus() && !force) {
            return;
        }
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        ArrayList<SelectedContent> listSelected = new ArrayList<SelectedContent>(dataSources.length);
        for (Object ds : dataSources) {
            if (ds instanceof DownloadManager) {
                listSelected.add(new SelectedContent((DownloadManager)ds));
                continue;
            }
            if (!(ds instanceof DiskManagerFileInfo)) continue;
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            listSelected.add(new SelectedContent(fileInfo2.getDownloadManager(), fileInfo2.getIndex()));
        }
        ISelectedContent[] content = listSelected.toArray(new SelectedContent[0]);
        SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), content, this.tv);
    }

    private void refreshTorrentMenu() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null && uiFunctions instanceof UIFunctionsSWT) {
            ((UIFunctionsSWT)uiFunctions).refreshTorrentMenu();
        }
    }

    public DownloadManager[] getSelectedDownloads() {
        Object[] data_sources = this.tv.getSelectedDataSources().toArray();
        ArrayList<DownloadManager> list = new ArrayList<DownloadManager>();
        for (Object ds : data_sources) {
            if (!(ds instanceof DownloadManager)) continue;
            list.add((DownloadManager)ds);
        }
        return list.toArray(new DownloadManager[0]);
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int keyMask) {
        if (this.defaultSelectedListener != null) {
            this.defaultSelectedListener.defaultSelected(rows, keyMask);
            return;
        }
        this.showSelectedDetails();
    }

    private void showSelectedDetails() {
        Object[] dm_sources = this.tv.getSelectedDataSources().toArray();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        for (int i = 0; i < dm_sources.length; ++i) {
            if (!(dm_sources[i] instanceof DownloadManager) || uiFunctions == null) continue;
            uiFunctions.openView(5, dm_sources[i]);
        }
    }

    public void overrideDefaultSelected(TableSelectionListener defaultSelectedListener) {
        this.defaultSelectedListener = defaultSelectedListener;
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (sColumnName.equals("health")) {
            MenuItem item = new MenuItem(menuThisColumn, 8);
            Messages.setLanguageText(item, "MyTorrentsView.menu.health");
            Utils.setMenuItemImage(item, "st_explain");
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    HealthHelpWindow.show(Display.getDefault());
                }
            });
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        boolean hasSelection;
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        DownloadManager[] dms = this.getSelectedDownloads();
        if (dms.length == 0 && dataSources.length > 0) {
            ArrayList<DiskManagerFileInfo> listFileInfos = new ArrayList<DiskManagerFileInfo>();
            DownloadManager firstFileDM = null;
            for (Object ds : dataSources) {
                if (!(ds instanceof DiskManagerFileInfo)) continue;
                DiskManagerFileInfo info = (DiskManagerFileInfo)ds;
                if (firstFileDM != null && !firstFileDM.equals(info.getDownloadManager())) break;
                firstFileDM = info.getDownloadManager();
                listFileInfos.add(info);
            }
            if (listFileInfos.size() > 0) {
                FilesViewMenuUtil.fillMenu(this.tv, menu, firstFileDM, listFileInfos.toArray(new DiskManagerFileInfo[0]));
                return;
            }
        }
        boolean bl = hasSelection = dms.length > 0;
        if (hasSelection) {
            TorrentUtil.fillTorrentMenu(menu, dms, this.azureus_core, this.cTablePanel, true, this.isSeedingView ? 2 : 1, this.tv);
            new MenuItem(menu, 2);
        }
    }

    private void createDragDrop() {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            if (this.dragSource != null && !this.dragSource.isDisposed()) {
                this.dragSource.dispose();
            }
            if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
                this.dropTarget.dispose();
            }
            this.dragSource = this.tv.createDragSource(3);
            if (this.dragSource != null) {
                this.dragSource.setTransfer(types);
                this.dragSource.addDragListener(new DragSourceAdapter(){
                    private String eventData;

                    public void dragStart(DragSourceEvent event2) {
                        Object[] selectedDataSources;
                        TableRowCore[] rows = MyTorrentsView.this.tv.getSelectedRows();
                        if (rows.length != 0) {
                            event2.doit = true;
                            MyTorrentsView.this.drag_drop_line_start = rows[0].getIndex();
                            MyTorrentsView.access$1202(MyTorrentsView.this, rows);
                        } else {
                            event2.doit = false;
                            MyTorrentsView.this.drag_drop_line_start = -1;
                            MyTorrentsView.access$1202(MyTorrentsView.this, null);
                        }
                        boolean onlyDMs = true;
                        StringBuffer sb = new StringBuffer();
                        for (Object ds : selectedDataSources = MyTorrentsView.this.tv.getSelectedDataSources(true)) {
                            DiskManagerFileInfo fileInfo2;
                            DownloadManager dm;
                            TOTorrent torrent;
                            if (ds instanceof DownloadManager) {
                                DownloadManager dm2 = (DownloadManager)ds;
                                TOTorrent torrent2 = dm2.getTorrent();
                                if (torrent2 == null) continue;
                                try {
                                    sb.append(torrent2.getHashWrapper().toBase32String());
                                    sb.append('\n');
                                }
                                catch (TOTorrentException e) {}
                                continue;
                            }
                            if (!(ds instanceof DiskManagerFileInfo) || (torrent = (dm = (fileInfo2 = (DiskManagerFileInfo)ds).getDownloadManager()).getTorrent()) == null) continue;
                            try {
                                sb.append(torrent.getHashWrapper().toBase32String());
                                sb.append(';');
                                sb.append(fileInfo2.getIndex());
                                sb.append('\n');
                                onlyDMs = false;
                            }
                            catch (TOTorrentException e) {
                                // empty catch block
                            }
                        }
                        this.eventData = (onlyDMs ? "DownloadManager\n" : "DiskManagerFileInfo\n") + sb.toString();
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        event2.data = this.eventData;
                    }
                });
            }
            this.dropTarget = this.tv.createDropTarget(31);
            if (this.dropTarget != null) {
                this.dropTarget.setTransfer(new Transfer[]{HTMLTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                this.dropTarget.addDropListener(new DropTargetAdapter(){
                    Point enterPoint = null;

                    public void dropAccept(DropTargetEvent event2) {
                        event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
                    }

                    public void dragEnter(DropTargetEvent event2) {
                        if (MyTorrentsView.this.drag_drop_line_start < 0) {
                            if (event2.detail != 1) {
                                if ((event2.operations & 4) > 0) {
                                    event2.detail = 4;
                                } else if ((event2.operations & 1) > 0) {
                                    event2.detail = 1;
                                }
                            }
                        } else if (TextTransfer.getInstance().isSupportedType(event2.currentDataType)) {
                            event2.detail = event2.item == null ? 0 : 2;
                            event2.feedback = 8;
                            this.enterPoint = new Point(event2.x, event2.y);
                        }
                    }

                    public void dragOver(DropTargetEvent event2) {
                        if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                            if (MyTorrentsView.this.drag_drop_rows.length > 0 && !(MyTorrentsView.this.drag_drop_rows[0].getDataSource(true) instanceof DownloadManager)) {
                                event2.detail = 0;
                                return;
                            }
                            event2.detail = event2.item == null ? 0 : 2;
                            event2.feedback = 8 | (this.enterPoint != null && this.enterPoint.y > event2.y ? 2 : 4);
                        }
                    }

                    public void drop(DropTargetEvent event2) {
                        if (!(event2.data instanceof String)) {
                            TorrentOpener.openDroppedTorrents(event2, true);
                            return;
                        }
                        String data = (String)event2.data;
                        if (data.startsWith("DiskManagerFileInfo\n")) {
                            return;
                        }
                        if (!data.startsWith("DownloadManager\n")) {
                            TorrentOpener.openDroppedTorrents(event2, true);
                            return;
                        }
                        event2.detail = 0;
                        if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                            int drag_drop_line_end;
                            event2.detail = 0;
                            TableRowCore row = MyTorrentsView.this.tv.getRow(event2);
                            if (row == null) {
                                return;
                            }
                            if (row.getParentRowCore() != null) {
                                row = row.getParentRowCore();
                            }
                            if ((drag_drop_line_end = row.getIndex()) != MyTorrentsView.this.drag_drop_line_start) {
                                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                                MyTorrentsView.this.moveRowsTo(MyTorrentsView.this.drag_drop_rows, dm.getPosition());
                                event2.detail = 2;
                            }
                            MyTorrentsView.this.drag_drop_line_start = -1;
                            MyTorrentsView.access$1202(MyTorrentsView.this, null);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.log(new LogEvent(LOGID, "failed to init drag-n-drop", t));
        }
    }

    private void moveRowsTo(TableRowCore[] rows, int iNewPos) {
        if (rows == null || rows.length == 0) {
            return;
        }
        TableColumnCore sortColumn = this.tv.getSortColumn();
        boolean isSortAscending = sortColumn == null ? true : sortColumn.isSortAscending();
        for (int i = 0; i < rows.length; ++i) {
            TableRowCore row = rows[i];
            Object ds = row.getDataSource(true);
            if (!(ds instanceof DownloadManager)) continue;
            DownloadManager dm = (DownloadManager)ds;
            int iOldPos = dm.getPosition();
            this.globalManager.moveTo(dm, iNewPos);
            if (isSortAscending) {
                if (iOldPos <= iNewPos) continue;
                ++iNewPos;
                continue;
            }
            if (iOldPos >= iNewPos) continue;
            --iNewPos;
        }
        boolean bForceSort = sortColumn.getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    @Override
    public void tableRefresh() {
        if (this.tv.isDisposed()) {
            return;
        }
        this.refreshTorrentMenu();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.character;
        if (key <= 26 && key > 0) {
            key += 96;
        }
        if (e.stateMask == 393216) {
            if (key == 115) {
                ManagerUtils.asyncStopAll();
                e.doit = false;
                return;
            }
            if (e.keyCode == 0x1000002) {
                this.moveSelectedTorrents(10);
                e.doit = false;
                return;
            }
            if (e.keyCode == 0x1000001) {
                this.moveSelectedTorrents(-10);
                e.doit = false;
                return;
            }
        }
        if (e.stateMask == SWT.MOD1) {
            switch (key) {
                case 97: {
                    if (e.widget == this.txtFilter) break;
                    this.tv.selectAll();
                    e.doit = false;
                    break;
                }
                case 99: {
                    if (e.widget == this.txtFilter) break;
                    this.tv.clipboardSelected();
                    e.doit = false;
                    break;
                }
                case 105: {
                    this.showSelectedDetails();
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
        }
        if (e.stateMask == 262144) {
            switch (e.keyCode) {
                case 0x1000001: {
                    this.moveSelectedTorrentsUp();
                    e.doit = false;
                    break;
                }
                case 0x1000002: {
                    this.moveSelectedTorrentsDown();
                    e.doit = false;
                    break;
                }
                case 0x1000007: {
                    this.moveSelectedTorrentsTop();
                    e.doit = false;
                    break;
                }
                case 0x1000008: {
                    this.moveSelectedTorrentsEnd();
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
            switch (key) {
                case 114: {
                    TorrentUtil.resumeTorrents(this.tv.getSelectedDataSources().toArray());
                    e.doit = false;
                    break;
                }
                case 115: {
                    Utils.getOffOfSWTThread(new AERunnable(){

                        public void runSupport() {
                            TorrentUtil.stopDataSources(MyTorrentsView.this.tv.getSelectedDataSources().toArray());
                        }
                    });
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
        }
        if (e.stateMask == 0 && e.keyCode == 127 && e.widget != this.txtFilter) {
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    TorrentUtil.removeDataSources(MyTorrentsView.this.tv.getSelectedDataSources().toArray());
                }
            });
            e.doit = false;
            return;
        }
        if (e.keyCode != 8 && ((e.stateMask & 0xFFFDFFFF) != 0 || e.character < ' ')) {
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void moveSelectedTorrentsDown() {
        DownloadManager[] dms = this.getSelectedDownloads();
        Arrays.sort(dms, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager a, DownloadManager b) {
                return a.getPosition() - b.getPosition();
            }
        });
        for (int i = dms.length - 1; i >= 0; --i) {
            DownloadManager dm = dms[i];
            if (!dm.getGlobalManager().isMoveableDown(dm)) continue;
            dm.getGlobalManager().moveDown(dm);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    private void moveSelectedTorrentsUp() {
        DownloadManager[] dms = this.getSelectedDownloads();
        Arrays.sort(dms, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager a, DownloadManager b) {
                return a.getPosition() - b.getPosition();
            }
        });
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = dms[i];
            if (!dm.getGlobalManager().isMoveableUp(dm)) continue;
            dm.getGlobalManager().moveUp(dm);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    private void moveSelectedTorrents(int by) {
        DownloadManager dm;
        int i;
        DownloadManager[] dms = this.getSelectedDownloads();
        if (dms.length <= 0) {
            return;
        }
        int[] newPositions = new int[dms.length];
        if (by < 0) {
            Arrays.sort(dms, new Comparator<DownloadManager>(){

                @Override
                public int compare(DownloadManager a, DownloadManager b) {
                    return a.getPosition() - b.getPosition();
                }
            });
        } else {
            Arrays.sort(dms, new Comparator<DownloadManager>(){

                @Override
                public int compare(DownloadManager a, DownloadManager b) {
                    return b.getPosition() - a.getPosition();
                }
            });
        }
        int count = this.globalManager.downloadManagerCount(this.isSeedingView);
        for (i = 0; i < dms.length; ++i) {
            dm = dms[i];
            int pos = dm.getPosition() + by;
            if (pos < i + 1) {
                pos = i + 1;
            } else if (pos > count - i) {
                pos = count - i;
            }
            newPositions[i] = pos;
        }
        for (i = 0; i < dms.length; ++i) {
            dm = dms[i];
            this.globalManager.moveTo(dm, newPositions[i]);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    private void moveSelectedTorrentsTop() {
        this.moveSelectedTorrentsTopOrEnd(true);
    }

    private void moveSelectedTorrentsEnd() {
        this.moveSelectedTorrentsTopOrEnd(false);
    }

    private void moveSelectedTorrentsTopOrEnd(boolean moveToTop) {
        DownloadManager[] dms = this.getSelectedDownloads();
        if (dms.length == 0) {
            return;
        }
        if (moveToTop) {
            this.globalManager.moveTop(dms);
        } else {
            this.globalManager.moveEnd(dms);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        if (bForceSort) {
            this.tv.columnInvalidate("#");
            this.tv.refreshTable(bForceSort);
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        if (parameterName == null || parameterName.equals("DND Always In Incomplete")) {
            this.bDNDalwaysIncomplete = COConfigurationManager.getBooleanParameter("DND Always In Incomplete");
        }
        if (parameterName == null || parameterName.equals("MyTorrentsView.alwaysShowHeader")) {
            this.setForceHeaderVisible(COConfigurationManager.getBooleanParameter("MyTorrentsView.alwaysShowHeader"));
        }
    }

    @Override
    public void refreshToolBar(Map<String, Boolean> list) {
        Map<String, Boolean> states = TorrentUtil.calculateToolbarStates(SelectedContentManager.getCurrentlySelectedContent(), this.tv.getTableID());
        list.putAll(states);
    }

    @Override
    public boolean toolBarItemActivated(String itemKey) {
        if (itemKey.equals("top")) {
            this.moveSelectedTorrentsTop();
            return true;
        }
        if (itemKey.equals("bottom")) {
            this.moveSelectedTorrentsEnd();
            return true;
        }
        if (itemKey.equals("up")) {
            this.moveSelectedTorrentsUp();
            return true;
        }
        if (itemKey.equals("down")) {
            this.moveSelectedTorrentsDown();
            return true;
        }
        if (itemKey.equals("run")) {
            TorrentUtil.runDataSources(this.tv.getSelectedDataSources().toArray());
            return true;
        }
        if (itemKey.equals("start")) {
            TorrentUtil.queueDataSources(this.tv.getSelectedDataSources().toArray(), true);
            return true;
        }
        if (itemKey.equals("stop")) {
            TorrentUtil.stopDataSources(this.tv.getSelectedDataSources().toArray());
            return true;
        }
        if (itemKey.equals("remove")) {
            TorrentUtil.removeDataSources(this.tv.getSelectedDataSources().toArray());
            return true;
        }
        return false;
    }

    @Override
    public void downloadManagerAdded(Category category, DownloadManager manager) {
        if (this.isOurDownloadManager(manager)) {
            this.tv.addDataSource(manager);
        }
    }

    @Override
    public void downloadManagerRemoved(Category category, DownloadManager removed) {
        this.tv.removeDataSource(removed);
    }

    @Override
    public void stateChanged(DownloadManager manager, int state) {
        final TableRowCore row = this.tv.getRow(manager);
        if (row != null) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    row.refresh(true);
                    if (row.isSelected()) {
                        MyTorrentsView.this.updateSelectedContent();
                    }
                }
            });
        }
    }

    @Override
    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        if (this.isOurDownloadManager(download)) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    MyTorrentsView.this.updateSelectedContent();
                }
            });
        }
    }

    @Override
    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    @Override
    public void completionChanged(DownloadManager manager, boolean bCompleted) {
        if (this.isOurDownloadManager(manager)) {
            if (this.currentCategory == null || this.currentCategory.getType() == 1) {
                this.tv.addDataSource(manager);
            } else {
                int catType = this.currentCategory.getType();
                Category manager_category = manager.getDownloadState().getCategory();
                if (manager_category == null) {
                    if (catType == 2) {
                        this.tv.addDataSource(manager);
                    }
                } else if (this.currentCategory.getName().equals(manager_category.getName())) {
                    this.tv.addDataSource(manager);
                }
            }
        } else if (this.isSeedingView && !bCompleted || !this.isSeedingView && bCompleted) {
            this.tv.removeDataSource(manager);
        }
    }

    @Override
    public void downloadComplete(DownloadManager manager) {
    }

    private void activateCategory(Category category) {
        if (category != this.currentCategory) {
            if (this.currentCategory != null) {
                this.currentCategory.removeCategoryListener(this);
            }
            if (category != null) {
                category.addCategoryListener(this);
            }
            this.currentCategory = category;
        }
        this.tv.processDataSourceQueue();
        Object[] managers = this.globalManager.getDownloadManagers().toArray();
        ArrayList<DownloadManager> listRemoves = new ArrayList<DownloadManager>();
        ArrayList<DownloadManager> listAdds = new ArrayList<DownloadManager>();
        for (int i = 0; i < managers.length; ++i) {
            DownloadManager dm = (DownloadManager)managers[i];
            boolean bHave = this.tv.isUnfilteredDataSourceAdded(dm);
            if (!this.isOurDownloadManager(dm)) {
                if (!bHave) continue;
                listRemoves.add(dm);
                continue;
            }
            if (bHave) continue;
            listAdds.add(dm);
        }
        this.tv.removeDataSources((DownloadManager[])listRemoves.toArray(new DownloadManager[0]));
        this.tv.addDataSources((DownloadManager[])listAdds.toArray(new DownloadManager[0]));
        this.tv.processDataSourceQueue();
    }

    public boolean isInCurrentCategory(DownloadManager manager) {
        return this.isInCategory(manager, this.currentCategory);
    }

    private boolean isInCategory(DownloadManager manager, Category category) {
        if (category == null) {
            return true;
        }
        int type = category.getType();
        if (type == 1) {
            return true;
        }
        Category dmCategory = manager.getDownloadState().getCategory();
        if (dmCategory == null) {
            return type == 2;
        }
        return category.equals(dmCategory);
    }

    @Override
    public void categoryAdded(Category category) {
        this.createTabs();
    }

    @Override
    public void categoryRemoved(Category category) {
        if (this.currentCategory == category) {
            this.activateCategory(CategoryManager.getCategory(1));
        } else {
            this.activateCategory(this.currentCategory);
        }
        this.createTabs();
    }

    @Override
    public void categoryChanged(Category category) {
    }

    @Override
    public void downloadManagerAdded(DownloadManager dm) {
        dm.addListener(this);
        this.downloadManagerAdded(null, dm);
    }

    @Override
    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removeListener(this);
        DownloadBar.close(dm);
        this.downloadManagerRemoved(null, dm);
    }

    @Override
    public void destroyInitiated() {
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    @Override
    public void updateLanguage() {
        super.updateLanguage();
        this.getComposite().layout(true, true);
    }

    public boolean isTableFocus() {
        return this.viewActive;
    }

    public Image obfusticatedImage(Image image) {
        return this.tv.obfusticatedImage(image);
    }

    protected TableViewSWT<DownloadManager> createTableView(Class<?> forDataSourceType, String tableID, TableColumnCore[] basicItems) {
        int tableExtraStyle = COConfigurationManager.getIntParameter("MyTorrentsView.table.style");
        return new TableViewSWTImpl<DownloadManager>(forDataSourceType, tableID, this.getPropertiesPrefix(), basicItems, "#", tableExtraStyle | 2 | 0x10000 | 0x10000000 | 0x40){

            @Override
            public void setSelectedRows(TableRowCore[] rows) {
                super.setSelectedRows(rows);
                MyTorrentsView.this.updateSelectedContent();
            }
        };
    }

    protected int getRowDefaultHeight() {
        return -1;
    }

    @Override
    public void rowRefresh(TableRow row) {
        DiskManagerFileInfoSet fileInfos;
        if (!(row instanceof TableRowCore)) {
            return;
        }
        TableRowCore rowCore = (TableRowCore)row;
        Object ds = rowCore.getDataSource(true);
        if (!(ds instanceof DownloadManager)) {
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (rowCore.getSubItemCount() == 0 && dm.getTorrent() != null && !dm.getTorrent().isSimpleTorrent() && rowCore.isVisible() && dm.getNumFileInfos() > 0 && (fileInfos = dm.getDiskManagerFileInfoSet()) != null) {
            Object[] files = fileInfos.getFiles();
            boolean copied = false;
            int pos = 0;
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo fileInfo2 = files[i];
                if (fileInfo2.isSkipped() && (fileInfo2.getStorageType() == 2 || fileInfo2.getStorageType() == 4)) continue;
                if (pos != i) {
                    if (!copied) {
                        Object[] oldFiles = files;
                        files = new DiskManagerFileInfo[files.length];
                        System.arraycopy(oldFiles, 0, files, 0, files.length);
                        copied = true;
                    }
                    files[pos] = files[i];
                }
                ++pos;
            }
            if (pos != files.length) {
                Object[] oldFiles = files;
                files = new DiskManagerFileInfo[pos];
                System.arraycopy(oldFiles, 0, files, 0, pos);
            }
            rowCore.setSubItems(files);
        }
    }

    static /* synthetic */ TableRowCore[] access$1202(MyTorrentsView x0, TableRowCore[] x1) {
        x0.drag_drop_rows = x1;
        return x1;
    }
}

