/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;

public class ShellSlider {
    private final boolean DEBUG = false;
    private int STEP = 8;
    private int PAUSE = 30;
    private Shell shell;
    private Rectangle shellBounds = null;
    private Rectangle endBounds;
    private final int direction;
    private final boolean slideIn;

    public ShellSlider(final Shell shell, int direction, final Rectangle endBounds) {
        this.shell = shell;
        this.endBounds = endBounds;
        this.slideIn = true;
        this.direction = direction;
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (shell.isDisposed()) {
                    return;
                }
                switch (ShellSlider.this.direction) {
                    default: 
                }
                shell.setLocation(endBounds.x, endBounds.y);
                Rectangle displayBounds = null;
                try {
                    boolean ok = false;
                    Monitor[] monitors = shell.getDisplay().getMonitors();
                    for (int i = 0; i < monitors.length; ++i) {
                        Monitor monitor = monitors[i];
                        displayBounds = monitor.getBounds();
                        if (!displayBounds.contains(endBounds.x, endBounds.y)) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        displayBounds = shell.getMonitor().getBounds();
                    }
                }
                catch (Throwable t) {
                    displayBounds = shell.getDisplay().getBounds();
                }
                ShellSlider.this.shellBounds = new Rectangle(endBounds.x, displayBounds.y + displayBounds.height, endBounds.width, 0);
                shell.setBounds(ShellSlider.this.shellBounds);
                shell.setVisible(true);
            }
        });
    }

    public ShellSlider(Shell shell, int direction) {
        this.shell = shell;
        this.slideIn = false;
        this.direction = direction;
    }

    private boolean canContinue() {
        if (this.shell == null || this.shell.isDisposed()) {
            return false;
        }
        if (this.shellBounds == null) {
            return true;
        }
        if (this.slideIn) {
            if (this.direction == 128) {
                return this.shellBounds.y > this.endBounds.y;
            }
        } else if (this.direction == 131072) {
            return this.shellBounds.width > 10;
        }
        return false;
    }

    public void run() {
        while (this.canContinue()) {
            long lStartedAt = System.currentTimeMillis();
            this.shell.getDisplay().syncExec(new AERunnable(){

                public void runSupport() {
                    if (ShellSlider.this.shell == null || ShellSlider.this.shell.isDisposed()) {
                        return;
                    }
                    if (ShellSlider.this.shellBounds == null) {
                        ShellSlider.this.shellBounds = ShellSlider.this.shell.getBounds();
                    }
                    if (ShellSlider.this.slideIn) {
                        switch (ShellSlider.this.direction) {
                            case 128: {
                                int delta = Math.min(((ShellSlider)ShellSlider.this).endBounds.height - ((ShellSlider)ShellSlider.this).shellBounds.height, ShellSlider.this.STEP);
                                ((ShellSlider)ShellSlider.this).shellBounds.height += delta;
                                delta = Math.min(((ShellSlider)ShellSlider.this).shellBounds.y - ((ShellSlider)ShellSlider.this).endBounds.y, ShellSlider.this.STEP);
                                ((ShellSlider)ShellSlider.this).shellBounds.y -= delta;
                                break;
                            }
                        }
                    } else {
                        switch (ShellSlider.this.direction) {
                            case 131072: {
                                int delta = Math.min(((ShellSlider)ShellSlider.this).shellBounds.width, ShellSlider.this.STEP);
                                ((ShellSlider)ShellSlider.this).shellBounds.width -= delta;
                                ((ShellSlider)ShellSlider.this).shellBounds.x += delta;
                                if (((ShellSlider)ShellSlider.this).shellBounds.width != 0) break;
                                ShellSlider.this.shell.dispose();
                                return;
                            }
                        }
                    }
                    ShellSlider.this.shell.setBounds(ShellSlider.this.shellBounds);
                    ShellSlider.this.shell.update();
                }
            });
            try {
                long lDrawTime = System.currentTimeMillis() - lStartedAt;
                long lSleepTime = (long)this.PAUSE - lDrawTime;
                if (lSleepTime < 15L) {
                    double d = ((double)lDrawTime + 15.0) / (double)this.PAUSE;
                    this.PAUSE = (int)((double)this.PAUSE * d);
                    this.STEP = (int)((double)this.STEP * d);
                    lSleepTime = 15L;
                }
                Thread.sleep(lSleepTime);
            }
            catch (Exception exception) {}
        }
    }
}

