/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.shells.IWizardPage;

public abstract class MultipageWizard {
    private Shell shell;
    private int shellStyle;
    private Composite topPanel;
    private Composite contentPanel;
    private Label titleLabel;
    private Label descriptionLabel;
    private Map pages = new LinkedHashMap();
    private StackLayout contentStackLayout;
    private IWizardPage currentPage;
    private IWizardPage previousPage;
    private List initializedPages = new ArrayList();

    public abstract void createPages();

    private void init() {
        this.shell = ShellFactory.createMainShell(this.shellStyle);
        this.createControls();
        this.createPages();
    }

    private void createControls() {
        GridLayout gLayout = new GridLayout();
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.verticalSpacing = 0;
        this.shell.setLayout(gLayout);
        Utils.setShellIcon(this.shell);
        this.topPanel = new Composite(this.shell, 0);
        this.topPanel.setLayoutData(new GridData(4, 128, true, false));
        GridLayout gLayout1 = new GridLayout();
        gLayout1.marginBottom = 10;
        this.topPanel.setLayout(gLayout1);
        this.topPanel.setBackground(this.shell.getDisplay().getSystemColor(25));
        this.topPanel.setBackgroundMode(2);
        Label separator1 = new Label(this.shell, 258);
        separator1.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.contentPanel = new Composite(this.shell, 0);
        this.contentPanel.setLayoutData(new GridData(4, 4, true, true));
        this.contentStackLayout = new StackLayout();
        this.contentPanel.setLayout(this.contentStackLayout);
        this.titleLabel = new Label(this.topPanel, 0);
        this.titleLabel.setLayoutData(new GridData(4, 128, true, false));
        FontUtils.setFontHeight(this.titleLabel, 16, 0);
        this.descriptionLabel = new Label(this.topPanel, 64);
        GridData gData = new GridData(4, 4, true, true);
        gData.horizontalIndent = 10;
        this.descriptionLabel.setLayoutData(gData);
        this.shell.layout(true, true);
    }

    public void fullScreen(boolean isFullScreen) {
        this.topPanel.setVisible(false == isFullScreen);
        ((GridData)this.topPanel.getLayoutData()).exclude = isFullScreen;
        this.shell.layout(true, true);
    }

    public boolean addPage(IWizardPage page) {
        if (null == page) {
            return false;
        }
        if (this.pages.containsKey(page.getPageID())) {
            Debug.out("MultipageWizard:: a page with this ID already exists ID:" + page.getPageID());
            return false;
        }
        this.pages.put(page.getPageID(), page);
        if (page.isInitOnStartup()) {
            page.createControls(this.contentPanel);
            this.initializedPages.add(page.getPageID());
        }
        return true;
    }

    public boolean isFirstPage(String pageID) {
        if (!this.pages.isEmpty()) {
            return pageID.equals(((IWizardPage)this.pages.values().iterator().next()).getPageID());
        }
        return false;
    }

    public boolean isLastPage(String pageID) {
        if (!this.pages.isEmpty()) {
            IWizardPage page2 = null;
            for (IWizardPage page2 : this.pages.values()) {
            }
            if (null != page2) {
                return page2.getPageID().equals(pageID);
            }
        }
        return false;
    }

    public boolean removePage(IWizardPage page) {
        if (null == page) {
            return false;
        }
        if (!this.pages.containsKey(page.getPageID())) {
            Debug.out("MultipageWizard:: a page with this ID is not found ID:" + page.getPageID());
            return false;
        }
        this.pages.remove(page.getPageID());
        page.performDispose();
        return true;
    }

    public void showPage(String pageID) {
        if (!this.pages.containsKey(pageID)) {
            Debug.out("MultipageWizard:: a page with this ID is not found ID:" + pageID);
            return;
        }
        IWizardPage page = (IWizardPage)this.pages.get(pageID);
        if (null != this.currentPage) {
            if (this.currentPage.getPageID().equals(page.getPageID())) {
                return;
            }
            this.currentPage.performAboutToBeHidden();
        }
        if (!this.initializedPages.contains(page.getPageID())) {
            page.createControls(this.contentPanel);
            this.initializedPages.add(page.getPageID());
        }
        page.performAboutToBeShown();
        this.previousPage = this.currentPage;
        this.currentPage = page;
        this.contentStackLayout.topControl = page.getControl();
        this.update();
        this.contentPanel.layout(true);
    }

    public void open() {
        if (!this.pages.isEmpty()) {
            IWizardPage page = (IWizardPage)this.pages.values().iterator().next();
            this.showPage(page.getPageID());
        }
        this.shell.open();
    }

    private void update() {
        if (null != this.currentPage) {
            this.setText(this.currentPage.getWindowTitle());
            this.setTitle(this.currentPage.getTitle());
            this.setDescription(this.currentPage.getDesciption());
        }
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title + "");
    }

    public void setDescription(String description) {
        this.descriptionLabel.setText(description + "");
    }

    public IWizardPage getPage(String pageID) {
        if (!this.pages.containsKey(pageID)) {
            Debug.out("MultipageWizard:: a Page with this ID is not found ID:" + pageID);
            return null;
        }
        return (IWizardPage)this.pages.get(pageID);
    }

    public void performCancel() {
        this.close();
    }

    public void performNext() {
        if (this.pages.isEmpty()) {
            return;
        }
        if (null == this.currentPage) {
            IWizardPage page = (IWizardPage)this.pages.values().iterator().next();
            this.showPage(page.getPageID());
        } else {
            boolean foundCurrent = false;
            for (IWizardPage page : this.pages.values()) {
                if (foundCurrent) {
                    this.showPage(page.getPageID());
                    return;
                }
                if (!page.getPageID().equals(this.currentPage.getPageID())) continue;
                foundCurrent = true;
            }
            if (!foundCurrent) {
                Debug.out("MultipageWizard:: there is no more page to go to");
            }
        }
    }

    public void performBack() {
        if (null != this.previousPage) {
            this.showPage(this.previousPage.getPageID());
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public void close() {
        this.shell.close();
    }

    public Object getData(String key) {
        return this.shell.getData(key);
    }

    public Point getLocation() {
        return this.shell.getLocation();
    }

    public Point getSize() {
        return this.shell.getSize();
    }

    public String getText() {
        return this.shell.getText();
    }

    public String getToolTipText() {
        return this.shell.getToolTipText();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.shell.setBounds(x, y, width, height);
    }

    public void setData(String key, Object value) {
        this.shell.setData(key, value);
    }

    public void setLocation(int x, int y) {
        this.shell.setLocation(x, y);
    }

    public void setSize(int width, int height) {
        this.shell.setSize(width, height);
    }

    public void setText(String string) {
        this.shell.setText(string);
    }

    public void setToolTipText(String string) {
        this.shell.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        this.shell.setVisible(visible);
    }

    public Image getImage() {
        return this.shell.getImage();
    }

    public void setImage(Image image) {
        this.shell.setImage(image);
    }
}

