/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.awt.Frame;
import java.awt.Panel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.plugins.PluginUISWTSkinObject;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventCancelledException;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;

public class UISWTViewImpl
extends AbstractIView
implements UISWTViewCore,
IViewExtension {
    public static final String CFG_PREFIX = "Views.plugins.";
    private PluginUISWTSkinObject skinObject;
    private Object dataSource = null;
    private boolean useCoreDataSource = false;
    private final UISWTViewEventListener eventListener;
    private Composite composite;
    private final String sViewID;
    private int iControlType = 0;
    private boolean bFirstGetCompositeCall = true;
    private final String sParentID;
    private String sTitle = null;
    private Boolean hasFocus = null;

    public UISWTViewEventListener getEventListener() {
        return this.eventListener;
    }

    public UISWTViewImpl(String sParentID, String sViewID, UISWTViewEventListener eventListener) throws Exception {
        this(sParentID, sViewID, eventListener, null);
    }

    public UISWTViewImpl(String sParentID, String sViewID, UISWTViewEventListener eventListener, Object datasource) throws Exception {
        this.sParentID = sParentID;
        this.sViewID = sViewID;
        this.eventListener = eventListener;
        this.dataSource = datasource;
        if (eventListener instanceof UISWTViewCoreEventListener) {
            this.useCoreDataSource = true;
        }
        if (!eventListener.eventOccurred(new UISWTViewEventImpl(this, 0, this))) {
            throw new UISWTViewEventCancelledException();
        }
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public String getViewID() {
        return this.sViewID;
    }

    public void closeView() {
        try {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions != null) {
                uiFunctions.closePluginView(this);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void setControlType(int iControlType) {
        if (iControlType == 1 || iControlType == 0 || iControlType == 257) {
            this.iControlType = iControlType;
        }
    }

    public int getControlType() {
        return this.iControlType;
    }

    public void triggerEvent(int eventType, Object data) {
        if (eventType == 3 && this.hasFocus != null && this.hasFocus.booleanValue()) {
            return;
        }
        if (eventType == 4 && this.hasFocus != null && !this.hasFocus.booleanValue()) {
            return;
        }
        try {
            this.eventListener.eventOccurred(new UISWTViewEventImpl(this, eventType, data));
        }
        catch (Throwable t) {
            throw new UIRuntimeException("UISWTView.triggerEvent:: ViewID=" + this.sViewID + "; EventID=" + eventType + "; data=" + data, t);
        }
    }

    private boolean triggerEvent2(int eventType, Object data) {
        try {
            return this.eventListener.eventOccurred(new UISWTViewEventImpl(this, eventType, data));
        }
        catch (Throwable t) {
            throw new UIRuntimeException("UISWTView.triggerEvent:: ViewID=" + this.sViewID + "; EventID=" + eventType + "; data=" + data, t);
        }
    }

    public void setTitle(String title) {
        this.sTitle = title;
    }

    public void dataSourceChanged(Object newDataSource) {
        this.dataSource = PluginCoreUtils.convert(newDataSource, this.useCoreDataSource);
        this.triggerEvent(1, this.dataSource);
    }

    public void setDataSource(Object ds) {
        this.dataSourceChanged(ds);
    }

    public void delete() {
        this.triggerEvent(7, null);
        super.delete();
    }

    public Composite getComposite() {
        if (this.bFirstGetCompositeCall) {
            this.bFirstGetCompositeCall = false;
        }
        return this.composite;
    }

    public PluginInterface getPluginInterface() {
        if (this.eventListener instanceof UISWTViewEventListenerHolder) {
            return ((UISWTViewEventListenerHolder)this.eventListener).getPluginInterface();
        }
        return null;
    }

    public String getData() {
        String key = CFG_PREFIX + this.sViewID + ".title";
        if (MessageText.keyExists(key)) {
            return key;
        }
        return this.sViewID;
    }

    public String getFullTitle() {
        if (this.sTitle != null) {
            return this.sTitle;
        }
        return super.getFullTitle();
    }

    public void initialize(Composite parent) {
        if (this.iControlType == 0) {
            GridData gridData;
            Layout parentLayout = parent.getLayout();
            if (parentLayout instanceof FormLayout) {
                this.composite = parent;
            } else {
                this.composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(1, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                this.composite.setLayout(layout);
                gridData = new GridData(1808);
                this.composite.setLayoutData(gridData);
            }
            this.triggerEvent(2, this.composite);
            if (this.composite.getLayout() instanceof GridLayout) {
                Control[] children = this.composite.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    Control control = children[i];
                    Object layoutData = control.getLayoutData();
                    if (layoutData != null && layoutData instanceof GridData) continue;
                    if (layoutData != null) {
                        Logger.log(new LogEvent(LogIDs.PLUGIN, 1, "Plugin View '" + this.sViewID + "' tried to setLayoutData of " + control + " to a " + layoutData.getClass().getName()));
                    }
                    gridData = children.length == 1 ? new GridData(4, 4, true, true) : new GridData();
                    control.setLayoutData(gridData);
                }
            }
        } else if (this.iControlType == 1) {
            this.composite = new Composite(parent, 0x1000000);
            FillLayout layout = new FillLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout(layout);
            GridData gridData = new GridData(1808);
            this.composite.setLayoutData(gridData);
            Frame f = SWT_AWT.new_Frame(this.composite);
            Panel pan = new Panel();
            f.add(pan);
            this.triggerEvent(2, pan);
        } else if (this.iControlType == 257) {
            this.triggerEvent(2, this.getSkinObject());
        }
    }

    public void refresh() {
        this.triggerEvent(5, null);
    }

    public void updateLanguage() {
        super.updateLanguage();
        this.triggerEvent(6, null);
    }

    public String getParentID() {
        return this.sParentID;
    }

    public boolean requestClose() {
        return this.triggerEvent2(8, null);
    }

    public boolean useCoreDataSource() {
        return this.useCoreDataSource;
    }

    public void setUseCoreDataSource(boolean useCoreDataSource) {
        if (this.useCoreDataSource == useCoreDataSource) {
            return;
        }
        this.useCoreDataSource = useCoreDataSource;
        this.dataSourceChanged(this.dataSource);
    }

    public PluginUISWTSkinObject getSkinObject() {
        return this.skinObject;
    }

    public void setSkinObject(PluginUISWTSkinObject skinObject, Composite c) {
        this.skinObject = skinObject;
        this.composite = c;
    }

    public Menu getPrivateMenu() {
        return null;
    }

    public void viewActivated() {
        this.triggerEvent(3, null);
    }

    public void viewDeactivated() {
        this.triggerEvent(4, null);
    }
}

