/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.importtorrent.wizard;

import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.importtorrent.wizard.ImportTorrentWizard;
import org.gudy.azureus2.ui.swt.importtorrent.wizard.ImportTorrentWizardFinishPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class ImportTorrentWizardOutputPanel
extends AbstractWizardPanel {
    protected boolean file_valid = false;

    public ImportTorrentWizardOutputPanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("importTorrentWizard.torrentfile.title"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData(gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout(layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 380;
        label.setLayoutData(gridData);
        Messages.setLanguageText(label, "importTorrentWizard.torrentfile.message");
        label = new Label(panel, 0);
        Messages.setLanguageText(label, "importTorrentWizard.torrentfile.path");
        final Text textPath = new Text(panel, 2048);
        gridData = new GridData(768);
        textPath.setLayoutData(gridData);
        textPath.setText(((ImportTorrentWizard)this.wizard).getTorrentFile());
        Button browse = new Button(panel, 8);
        Messages.setLanguageText(browse, "importTorrentWizard.torrentfile.browse");
        browse.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                FileDialog fd = new FileDialog(ImportTorrentWizardOutputPanel.this.wizard.getWizardWindow(), 8192);
                fd.setFileName(textPath.getText());
                fd.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                String path = fd.open();
                if (path != null) {
                    textPath.setText(path);
                }
            }
        });
        textPath.addListener(24, new Listener(){

            public void handleEvent(Event event2) {
                String path = textPath.getText();
                ImportTorrentWizardOutputPanel.this.pathSet(path);
            }
        });
        textPath.setText(((ImportTorrentWizard)this.wizard).getTorrentFile());
        textPath.setFocus();
    }

    protected void pathSet(String path) {
        ((ImportTorrentWizard)this.wizard).setTorrentFile(path);
        this.file_valid = false;
        try {
            File f = new File(path);
            if (f.exists()) {
                if (f.isFile()) {
                    this.wizard.setErrorMessage("");
                    this.file_valid = true;
                } else {
                    this.wizard.setErrorMessage(MessageText.getString("importTorrentWizard.torrentfile.invalidPath"));
                }
            } else {
                this.wizard.setErrorMessage("");
                this.file_valid = true;
            }
        }
        catch (Exception e) {
            this.wizard.setErrorMessage(MessageText.getString("importTorrentWizard.torrentfile.invalidPath"));
        }
        this.wizard.setFinishEnabled(this.file_valid);
    }

    public boolean isFinishEnabled() {
        return this.file_valid;
    }

    public boolean isFinishSelectionOK() {
        return ((ImportTorrentWizard)this.wizard).performImport();
    }

    public IWizardPanel getFinishPanel() {
        return new ImportTorrentWizardFinishPanel((ImportTorrentWizard)this.wizard, (IWizardPanel)this);
    }
}

