/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.regex.Pattern;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.KeyBindings;
import org.gudy.azureus2.ui.swt.views.table.TableColumnOrTreeColumn;

public class Messages {
    private static final Pattern HIG_ELLIP_EXP = Pattern.compile("([\\.]{3})");

    private Messages() {
    }

    public static void updateLanguageForControl(Widget widget) {
        block18: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block17: {
                                        if (widget == null || widget.isDisposed()) {
                                            return;
                                        }
                                        Messages.updateLanguageFromData(widget, null);
                                        Messages.updateToolTipFromData(widget);
                                        if (!(widget instanceof CTabFolder)) break block17;
                                        CTabFolder folder = (CTabFolder)widget;
                                        CTabItem[] items = folder.getItems();
                                        for (int i = 0; i < items.length; ++i) {
                                            Messages.updateLanguageForControl(items[i]);
                                            Messages.updateLanguageForControl(items[i].getControl());
                                        }
                                        break block18;
                                    }
                                    if (!(widget instanceof TabFolder)) break block19;
                                    TabFolder folder = (TabFolder)widget;
                                    TabItem[] items = folder.getItems();
                                    for (int i = 0; i < items.length; ++i) {
                                        Messages.updateLanguageForControl(items[i]);
                                        Messages.updateLanguageForControl(items[i].getControl());
                                    }
                                    break block18;
                                }
                                if (!(widget instanceof CoolBar)) break block20;
                                CoolItem[] items = ((CoolBar)widget).getItems();
                                for (int i = 0; i < items.length; ++i) {
                                    Control control = items[i].getControl();
                                    Messages.updateLanguageForControl(control);
                                }
                                break block18;
                            }
                            if (!(widget instanceof ToolBar)) break block21;
                            ToolItem[] items = ((ToolBar)widget).getItems();
                            for (int i = 0; i < items.length; ++i) {
                                Messages.updateLanguageForControl(items[i]);
                            }
                            break block18;
                        }
                        if (!(widget instanceof Composite)) break block22;
                        Composite group = (Composite)widget;
                        Control[] controls = group.getChildren();
                        for (int i = 0; i < controls.length; ++i) {
                            Messages.updateLanguageForControl(controls[i]);
                        }
                        if (widget instanceof Table) {
                            Table table = (Table)widget;
                            TableColumn[] columns = table.getColumns();
                            for (int i = 0; i < columns.length; ++i) {
                                Messages.updateLanguageFromData(columns[i], null);
                            }
                            Messages.updateLanguageForControl(table.getMenu());
                            Event event2 = new Event();
                            event2.type = 39;
                            event2.widget = widget;
                            widget.notifyListeners(39, event2);
                        } else if (widget instanceof Tree) {
                            Tree tree = (Tree)widget;
                            TreeItem[] treeitems = tree.getItems();
                            for (int i = 0; i < treeitems.length; ++i) {
                                Messages.updateLanguageForControl(treeitems[i]);
                            }
                        } else if (widget instanceof TreeItem) {
                            TreeItem treeItem = (TreeItem)widget;
                            TreeItem[] treeitems = treeItem.getItems();
                            for (int i = 0; i < treeitems.length; ++i) {
                                Messages.updateLanguageForControl(treeitems[i]);
                            }
                        }
                        group.layout();
                        break block18;
                    }
                    if (!(widget instanceof MenuItem)) break block23;
                    MenuItem menuItem = (MenuItem)widget;
                    Messages.updateLanguageForControl(menuItem.getMenu());
                    break block18;
                }
                if (!(widget instanceof Menu)) break block24;
                Menu menu = (Menu)widget;
                if (menu.getStyle() == 8) {
                    System.out.println("POP_UP");
                }
                MenuItem[] items = menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    Messages.updateLanguageForControl(items[i]);
                }
                break block18;
            }
            if (!(widget instanceof TreeItem)) break block18;
            TreeItem treeitem = (TreeItem)widget;
            TreeItem[] treeitems = treeitem.getItems();
            for (int i = 0; i < treeitems.length; ++i) {
                Messages.updateLanguageFromData(treeitems[i], null);
            }
        }
    }

    public static void setLanguageText(Widget widget, String key) {
        Messages.setLanguageText(widget, key, false);
    }

    public static void setLanguageText(Widget widget, String key, String[] params) {
        Messages.setLanguageText(widget, key, params, false);
    }

    public static void setLanguageText(Widget widget, String key, boolean setTooltipOnly) {
        Messages.setLanguageText(widget, key, null, setTooltipOnly);
    }

    private static void setLanguageText(Widget widget, String key, String[] params, boolean setTooltipOnly) {
        widget.setData(key);
        if (!setTooltipOnly) {
            Messages.updateLanguageFromData(widget, params);
        }
        Messages.updateToolTipFromData(widget);
    }

    private static void updateToolTipFromData(Widget widget) {
        String key;
        if (widget instanceof Control) {
            String key2 = (String)widget.getData();
            if (key2 != null) {
                String toolTip;
                if (!key2.endsWith(".tooltip")) {
                    key2 = key2 + ".tooltip";
                }
                if (!(toolTip = MessageText.getString(key2)).equals('!' + key2 + '!')) {
                    ((Control)widget).setToolTipText(toolTip);
                }
            }
        } else if (widget instanceof ToolItem) {
            String key3 = (String)widget.getData();
            if (key3 != null) {
                String toolTip;
                if (!key3.endsWith(".tooltip")) {
                    key3 = key3 + ".tooltip";
                }
                if (!(toolTip = MessageText.getString(key3)).equals('!' + key3 + '!')) {
                    ((ToolItem)widget).setToolTipText(toolTip.replaceAll("Meta\\+", Constants.isOSX ? "Cmd+" : "Ctrl+"));
                }
            }
        } else if (widget instanceof TableColumn && (key = (String)widget.getData()) != null) {
            String toolTip;
            if (!key.endsWith(".info")) {
                key = key + ".info";
            }
            if ((toolTip = MessageText.getString(key, (String)null)) == null) {
                toolTip = MessageText.getString(key.substring(0, key.length() - 5), (String)null);
            }
            if (toolTip != null) {
                try {
                    ((TableColumn)widget).setToolTipText(toolTip);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }

    private static void updateLanguageFromData(Widget widget, String[] params) {
        if (widget == null || widget.isDisposed()) {
            return;
        }
        if (widget.getData() != null) {
            String key = null;
            try {
                key = (String)widget.getData();
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (key == null) {
                return;
            }
            if (key.endsWith(".tooltip")) {
                return;
            }
            String message = params == null ? MessageText.getString((String)widget.getData()) : MessageText.getString((String)widget.getData(), params);
            if (widget instanceof MenuItem) {
                boolean indent;
                MenuItem menuItem = (MenuItem)widget;
                boolean bl = indent = menuItem.getData("IndentItem") != null;
                if (Constants.isOSX) {
                    message = HIG_ELLIP_EXP.matcher(message).replaceAll("\u2026");
                }
                menuItem.setText(indent ? "  " + message : message);
                if (menuItem.getAccelerator() != 0) {
                    KeyBindings.setAccelerator(menuItem, (String)menuItem.getData());
                }
            } else if (widget instanceof TableColumn) {
                TableColumn tc = (TableColumn)widget;
                tc.setText(message);
            } else if (widget instanceof Label) {
                ((Label)widget).setText(message.replaceAll("& ", "&& "));
            } else if (widget instanceof CLabel) {
                ((CLabel)widget).setText(message.replaceAll("& ", "&& "));
            } else if (widget instanceof Group) {
                ((Group)widget).setText(message);
            } else if (widget instanceof Button) {
                ((Button)widget).setText(message);
            } else if (widget instanceof CTabItem) {
                ((CTabItem)widget).setText(message);
            } else if (widget instanceof TabItem) {
                ((TabItem)widget).setText(message);
            } else if (widget instanceof TreeItem) {
                ((TreeItem)widget).setText(message);
            } else if (widget instanceof Shell) {
                ((Shell)widget).setText(message);
            } else if (widget instanceof ToolItem) {
                ((ToolItem)widget).setText(message);
            } else if (widget instanceof Text) {
                ((Text)widget).setText(message);
            } else if (widget instanceof TableColumnOrTreeColumn) {
                ((TableColumnOrTreeColumn)((Object)widget)).setText(message);
            } else if (widget instanceof TreeColumn) {
                ((TreeColumn)widget).setText(message);
            } else {
                Debug.out("No cast for " + widget.getClass().getName());
            }
        }
    }

    public static void setLanguageTooltip(Widget widget, String key) {
        if (widget == null || widget.isDisposed()) {
            return;
        }
        widget.setData(key);
        Messages.updateTooltipLanguageFromData(widget);
    }

    public static void updateTooltipLanguageFromData(Widget widget) {
        if (widget == null || widget.isDisposed()) {
            return;
        }
        if (widget.getData() != null) {
            String sToolTip = MessageText.getString((String)widget.getData());
            if (widget instanceof CLabel) {
                ((CLabel)widget).setToolTipText(sToolTip);
            } else if (widget instanceof Label) {
                ((Label)widget).setToolTipText(sToolTip);
            } else if (widget instanceof Text) {
                ((Text)widget).setToolTipText(sToolTip);
            } else {
                System.out.println("No cast for " + widget.getClass().getName());
            }
        }
    }
}

