/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alerts {
    private static List<LogAlert> alert_queue = new ArrayList<LogAlert>();
    private static AEMonitor alert_queue_mon = new AEMonitor("Alerts:Q");
    private static ArrayList<String> alert_history = new ArrayList(0);
    private static ArrayList<LogAlert> listUnviewedLogAlerts = new ArrayList(0);
    private static AEMonitor alert_history_mon = new AEMonitor("Alerts:H");
    private static ArrayList<AlertHistoryListener> listMessageHistoryListeners = new ArrayList(1);
    private static boolean initialisation_complete = false;
    private static volatile boolean stopping;
    private static List<AlertListener> listeners;

    private Alerts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void showAlert(LogAlert alert) {
        AlertHistoryListener[] array;
        Display display = SWTThread.getInstance().getDisplay();
        if (alert.err != null) {
            alert.details = Debug.getStackTrace(alert.err);
        }
        for (AlertListener l : listeners) {
            if (l.allowPopup(alert.relatedTo, alert.entryType)) continue;
            return;
        }
        if (stopping || display.isDisposed()) {
            try {
                alert_queue_mon.enter();
                List close_alerts = COConfigurationManager.getListParameter("Alerts.raised.at.close", new ArrayList());
                HashMap<String, Object> alert_map = new HashMap<String, Object>();
                alert_map.put("type", new Long(alert.entryType));
                alert_map.put("message", alert.text);
                alert_map.put("timeout", new Long(alert.getGivenTimeoutSecs()));
                if (alert.details != null) {
                    alert_map.put("details", alert.details);
                }
                close_alerts.add(alert_map);
                COConfigurationManager.setParameter("Alerts.raised.at.close", close_alerts);
                Object var5_4 = null;
                alert_queue_mon.exit();
                return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                alert_queue_mon.exit();
                throw throwable;
            }
        }
        if (display.isDisposed()) {
            return;
        }
        String key = alert.err == null ? alert.text : alert.text + ":" + alert.err.toString();
        try {
            alert_history_mon.enter();
            if (!alert.repeatable) {
                if (alert_history.contains(key)) {
                    Object var7_9 = null;
                    alert_history_mon.exit();
                    return;
                }
                alert_history.add(key);
                if (alert_history.size() > 512) {
                    alert_history.remove(0);
                }
            }
            listUnviewedLogAlerts.add(alert);
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            alert_history_mon.exit();
            throw throwable;
        }
        Object var7_10 = null;
        alert_history_mon.exit();
        for (AlertHistoryListener l : array = listMessageHistoryListeners.toArray(new AlertHistoryListener[0])) {
            l.alertHistoryAdded(alert);
        }
    }

    public static void initComplete() {
        new AEThread2("Init Complete", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    alert_queue_mon.enter();
                    initialisation_complete = true;
                    for (int i = 0; i < alert_queue.size(); ++i) {
                        LogAlert alert = (LogAlert)alert_queue.get(i);
                        Alerts.showAlert(alert);
                    }
                    List close_alerts = COConfigurationManager.getListParameter("Alerts.raised.at.close", new ArrayList());
                    if (close_alerts.size() > 0) {
                        COConfigurationManager.setParameter("Alerts.raised.at.close", new ArrayList());
                        String intro = MessageText.getString("alert.raised.at.close") + "\n";
                        for (int i = 0; i < close_alerts.size(); ++i) {
                            try {
                                Map alert_map = (Map)close_alerts.get(i);
                                BDecoder.decodeStrings(alert_map);
                                String details = MapUtils.getMapString(alert_map, "details", null);
                                int timeout = MapUtils.getMapInt(alert_map, "timeout", -1);
                                int entryType = MapUtils.getMapInt(alert_map, "type", 0);
                                String message = intro + MapUtils.getMapString(alert_map, "message", "");
                                LogAlert logAlert = new LogAlert(false, entryType, message, timeout);
                                logAlert.details = details;
                                Alerts.showAlert(logAlert);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    alert_queue.clear();
                    Object var11_12 = null;
                    alert_queue_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    alert_queue_mon.exit();
                    throw throwable;
                }
            }
        }.start();
    }

    public static void stopInitiated() {
        stopping = true;
    }

    public static void init() {
        Logger.addListener(new ILogAlertListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alertRaised(LogAlert alert) {
                if (!initialisation_complete) {
                    try {
                        alert_queue_mon.enter();
                        alert_queue.add(alert);
                        Object var3_2 = null;
                        alert_queue_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        alert_queue_mon.exit();
                        throw throwable;
                    }
                    return;
                }
                Alerts.showAlert(alert);
            }
        });
    }

    public static void addListener(AlertListener l) {
        listeners.add(l);
    }

    public static ArrayList<LogAlert> getUnviewedLogAlerts() {
        return new ArrayList<LogAlert>(listUnviewedLogAlerts);
    }

    public static void addMessageHistoryListener(AlertHistoryListener l) {
        listMessageHistoryListeners.add(l);
    }

    public static void markAlertAsViewed(LogAlert alert) {
        boolean removed = listUnviewedLogAlerts.remove(alert);
        if (removed) {
            AlertHistoryListener[] array;
            for (AlertHistoryListener l : array = listMessageHistoryListeners.toArray(new AlertHistoryListener[0])) {
                l.alertHistoryRemoved(alert);
            }
        }
    }

    static {
        listeners = new ArrayList<AlertListener>();
    }

    public static interface AlertHistoryListener {
        public void alertHistoryAdded(LogAlert var1);

        public void alertHistoryRemoved(LogAlert var1);
    }

    public static interface AlertListener {
        public boolean allowPopup(Object[] var1, int var2);
    }
}

