/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.download;

import java.io.File;
import java.util.Map;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;
import org.gudy.azureus2.pluginsimpl.remote.disk.RPDiskManagerFileInfo;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadAnnounceResult;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadScrapeResult;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadStats;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;

public class RPDownload
extends RPObject
implements Download {
    protected transient Download delegate;
    public RPTorrent torrent;
    public RPDownloadStats stats;
    public RPDownloadAnnounceResult announce_result;
    public RPDownloadScrapeResult scrape_result;
    public int position;
    public boolean force_start;

    public static RPDownload create(Download _delegate) {
        RPDownload res = (RPDownload)RPDownload._lookupLocal(_delegate);
        if (res == null) {
            res = new RPDownload(_delegate);
        }
        return res;
    }

    protected RPDownload(Download _delegate) {
        super(_delegate);
        if (this.delegate.getTorrent() != null) {
            this.torrent = (RPTorrent)RPDownload._lookupLocal(this.delegate.getTorrent());
            if (this.torrent == null) {
                this.torrent = RPTorrent.create(this.delegate.getTorrent());
            }
        }
        this.stats = (RPDownloadStats)RPDownload._lookupLocal(this.delegate.getStats());
        if (this.stats == null) {
            this.stats = RPDownloadStats.create(this.delegate.getStats());
        }
        this.announce_result = (RPDownloadAnnounceResult)RPDownload._lookupLocal(this.delegate.getLastAnnounceResult());
        if (this.announce_result == null) {
            this.announce_result = RPDownloadAnnounceResult.create(this.delegate.getLastAnnounceResult());
        }
        this.scrape_result = (RPDownloadScrapeResult)RPDownload._lookupLocal(this.delegate.getLastScrapeResult());
        if (this.scrape_result == null) {
            this.scrape_result = RPDownloadScrapeResult.create(this.delegate.getLastScrapeResult());
        }
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (Download)_delegate;
        this.position = this.delegate.getPosition();
        this.force_start = this.delegate.isForceStart();
    }

    public Object _setLocal() throws RPException {
        Object res = this._fixupLocal();
        if (this.torrent != null) {
            this.torrent._setLocal();
        }
        this.stats._setLocal();
        this.announce_result._setLocal();
        this.scrape_result._setLocal();
        return res;
    }

    public void _setRemote(RPRequestDispatcher dispatcher) {
        super._setRemote(dispatcher);
        if (this.torrent != null) {
            this.torrent._setRemote(dispatcher);
        }
        this.stats._setRemote(dispatcher);
        this.announce_result._setRemote(dispatcher);
        this.scrape_result._setRemote(dispatcher);
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        if (method.equals("initialize")) {
            try {
                this.delegate.initialize();
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("start")) {
            try {
                this.delegate.start();
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("restart")) {
            try {
                this.delegate.restart();
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("stop")) {
            try {
                this.delegate.stop();
            }
            catch (DownloadException e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("remove")) {
            try {
                this.delegate.remove();
            }
            catch (Throwable e) {
                return new RPReply(e);
            }
            return null;
        }
        if (method.equals("setForceStart[boolean]")) {
            boolean b = (Boolean)request2.getParams()[0];
            this.delegate.setForceStart(b);
            return null;
        }
        if (method.equals("setPosition[int]")) {
            int p = (Integer)request2.getParams()[0];
            this.delegate.setPosition(p);
            return null;
        }
        if (method.equals("moveUp")) {
            this.delegate.moveUp();
            return null;
        }
        if (method.equals("moveDown")) {
            this.delegate.moveDown();
            return null;
        }
        if (method.equals("moveTo[int]")) {
            int p = (Integer)request2.getParams()[0];
            this.delegate.setPosition(p);
            return null;
        }
        if (method.equals("setPriority[int]")) {
            this.delegate.setPriority((Integer)request2.getParams()[0]);
            return null;
        }
        if (method.equals("requestTrackerAnnounce")) {
            this.delegate.requestTrackerAnnounce();
            return null;
        }
        if (method.equals("getDiskManagerFileInfo")) {
            DiskManagerFileInfo[] info = this.delegate.getDiskManagerFileInfo();
            RPDiskManagerFileInfo[] rp_info = new RPDiskManagerFileInfo[info.length];
            for (int i = 0; i < rp_info.length; ++i) {
                rp_info[i] = RPDiskManagerFileInfo.create(info[i]);
            }
            return new RPReply(rp_info);
        }
        throw new RPException("Unknown method: " + method);
    }

    public int getState() {
        this.notSupported();
        return 0;
    }

    public int getSubState() {
        this.notSupported();
        return 0;
    }

    public String getErrorStateDetails() {
        this.notSupported();
        return null;
    }

    public boolean getFlag(long flag) {
        this.notSupported();
        return false;
    }

    public long getFlags() {
        this.notSupported();
        return 0L;
    }

    public int getIndex() {
        this.notSupported();
        return 0;
    }

    public Torrent getTorrent() {
        return this.torrent;
    }

    public byte[] getDownloadPeerId() {
        return this.delegate.getDownloadPeerId();
    }

    public boolean isMessagingEnabled() {
        return this.delegate.isMessagingEnabled();
    }

    public void setMessagingEnabled(boolean enabled) {
        this.delegate.setMessagingEnabled(enabled);
    }

    public void initialize() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "initialize", null)).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public void start() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "start", null)).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public void stop() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "stop", null)).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public void restart() throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "restart", null)).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public boolean isStartStopLocked() {
        this.notSupported();
        return false;
    }

    public boolean isPaused() {
        this.notSupported();
        return false;
    }

    public void pause() {
        this.notSupported();
    }

    public void resume() {
        this.notSupported();
    }

    public int getPriority() {
        return 0;
    }

    public void setPriority(int priority) {
    }

    public boolean isPriorityLocked() {
        return false;
    }

    public void remove() throws DownloadException, DownloadRemovalVetoException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "remove", null)).getResponse();
        }
        catch (RPException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DownloadException) {
                throw (DownloadException)cause;
            }
            if (cause instanceof DownloadRemovalVetoException) {
                throw (DownloadRemovalVetoException)cause;
            }
            throw e;
        }
    }

    public void remove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        this.notSupported();
    }

    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        this.notSupported();
        return false;
    }

    public DownloadAnnounceResult getLastAnnounceResult() {
        return this.announce_result;
    }

    public DownloadScrapeResult getLastScrapeResult() {
        return this.scrape_result;
    }

    public DownloadStats getStats() {
        return this.stats;
    }

    public void addListener(DownloadListener l) {
        this.notSupported();
    }

    public void removeListener(DownloadListener l) {
        this.notSupported();
    }

    public void addPropertyListener(DownloadPropertyListener l) {
        this.notSupported();
    }

    public void removePropertyListener(DownloadPropertyListener l) {
        this.notSupported();
    }

    public void addTrackerListener(DownloadTrackerListener l) {
        this.notSupported();
    }

    public void removeTrackerListener(DownloadTrackerListener l) {
        this.notSupported();
    }

    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isForceStart() {
        return this.force_start;
    }

    public void setForceStart(boolean _force_start) {
        this.force_start = _force_start;
        this._dispatcher.dispatch(new RPRequest(this, "setForceStart[boolean]", new Object[]{new Boolean(this.force_start)})).getResponse();
    }

    public void setPosition(int new_position) {
        this._dispatcher.dispatch(new RPRequest(this, "setPosition[int]", new Object[]{new Integer(new_position)})).getResponse();
    }

    public void moveUp() {
        this._dispatcher.dispatch(new RPRequest(this, "moveUp", null)).getResponse();
    }

    public void moveDown() {
        this._dispatcher.dispatch(new RPRequest(this, "moveDown", null)).getResponse();
    }

    public void moveTo(int position) {
        this._dispatcher.dispatch(new RPRequest(this, "moveTo[int]", new Object[]{new Integer(position)})).getResponse();
    }

    public void stopAndQueue() throws DownloadException {
        this.notSupported();
    }

    public void recheckData() throws DownloadException {
        this.notSupported();
    }

    public String getName() {
        this.notSupported();
        return "";
    }

    public void addListener(DownloadPeerListener l) {
        this.notSupported(l);
    }

    public void removeListener(DownloadPeerListener l) {
        this.notSupported(l);
    }

    public void addPeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    public void removePeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    public String getTorrentFileName() {
        this.notSupported();
        return "";
    }

    public String getAttribute(TorrentAttribute attribute) {
        this.notSupported();
        return null;
    }

    public void setAttribute(TorrentAttribute attribute, String value) {
        this.notSupported();
    }

    public String[] getListAttribute(TorrentAttribute attribute) {
        this.notSupported();
        return null;
    }

    public void setMapAttribute(TorrentAttribute attribute, Map value) {
        this.notSupported();
    }

    public Map getMapAttribute(TorrentAttribute attribute) {
        this.notSupported();
        return null;
    }

    public String getCategoryName() {
        this.notSupported();
        return "";
    }

    public void setCategory(String sName) {
        this.notSupported();
    }

    public boolean isPersistent() {
        this.notSupported();
        return false;
    }

    public void setMaximumDownloadKBPerSecond(int kb) {
        this.notSupported();
    }

    public int getUploadRateLimitBytesPerSecond() {
        this.notSupported();
        return 0;
    }

    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        this.notSupported();
        return 0;
    }

    public void setDownloadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    public int getMaximumDownloadKBPerSecond() {
        this.notSupported();
        return 0;
    }

    public boolean isComplete() {
        this.notSupported();
        return false;
    }

    public boolean isComplete(boolean b) {
        this.notSupported();
        return false;
    }

    public boolean isChecking() {
        this.notSupported();
        return false;
    }

    public PeerManager getPeerManager() {
        this.notSupported();
        return null;
    }

    public DiskManager getDiskManager() {
        this.notSupported();
        return null;
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        DiskManagerFileInfo[] resp = (RPDiskManagerFileInfo[])this._dispatcher.dispatch(new RPRequest(this, "getDiskManagerFileInfo", null)).getResponse();
        for (int i = 0; i < resp.length; ++i) {
            ((RPObject)((Object)resp[i]))._setRemote(this._dispatcher);
        }
        return resp;
    }

    public DiskManagerFileInfo getDiskManagerFileInfo(int index) {
        RPDiskManagerFileInfo[] resp = (RPDiskManagerFileInfo[])this._dispatcher.dispatch(new RPRequest(this, "getDiskManagerFileInfo", null)).getResponse();
        if (index >= 0 && index < resp.length) {
            resp[index]._setRemote(this._dispatcher);
            return resp[index];
        }
        return null;
    }

    public long getCreationTime() {
        this.notSupported();
        return 0L;
    }

    public int getSeedingRank() {
        this.notSupported();
        return 0;
    }

    public String getSavePath() {
        this.notSupported();
        return null;
    }

    public void moveDataFiles(File new_parent_dir) throws DownloadException {
        this.notSupported();
    }

    public void moveDataFiles(File new_parent_dir, String new_name) throws DownloadException {
        this.notSupported();
    }

    public void moveTorrentFile(File new_parent_dir) {
        this.notSupported();
    }

    public void requestTrackerAnnounce() {
        this._dispatcher.dispatch(new RPRequest(this, "requestTrackerAnnounce", null)).getResponse();
    }

    public void requestTrackerAnnounce(boolean immediate) {
        this.notSupported();
    }

    public void requestTrackerScrape(boolean immediate) {
        this.notSupported();
    }

    public void setAnnounceResult(DownloadAnnounceResult result) {
        this.notSupported();
    }

    public void setScrapeResult(DownloadScrapeResult result) {
        this.notSupported();
    }

    public DownloadActivationEvent getActivationState() {
        this.notSupported();
        return null;
    }

    public void addActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    public void removeActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    public void setSeedingRank(int rank) {
    }

    public void addTrackerListener(DownloadTrackerListener l, boolean immediateTrigger) {
        this.notSupported();
    }

    public void renameDownload(String new_name) {
        this.notSupported();
    }

    public File[] calculateDefaultPaths(boolean for_moving) {
        this.notSupported();
        return null;
    }

    public boolean isInDefaultSaveDir() {
        this.notSupported();
        return false;
    }

    public boolean getBooleanAttribute(TorrentAttribute ta) {
        this.notSupported();
        return false;
    }

    public int getIntAttribute(TorrentAttribute ta) {
        this.notSupported();
        return 0;
    }

    public long getLongAttribute(TorrentAttribute ta) {
        this.notSupported();
        return 0L;
    }

    public boolean hasAttribute(TorrentAttribute ta) {
        this.notSupported();
        return false;
    }

    public void setBooleanAttribute(TorrentAttribute ta, boolean value) {
        this.notSupported();
    }

    public void setIntAttribute(TorrentAttribute ta, int value) {
        this.notSupported();
    }

    public void setListAttribute(TorrentAttribute ta, String[] value) {
        this.notSupported();
    }

    public void setLongAttribute(TorrentAttribute ta, long value) {
        this.notSupported();
    }

    public void setFlag(long flag, boolean set) {
        this.notSupported();
    }

    public void addAttributeListener(DownloadAttributeListener l, TorrentAttribute a, int e) {
        this.notSupported();
    }

    public void removeAttributeListener(DownloadAttributeListener l, TorrentAttribute a, int e) {
        this.notSupported();
    }

    public void addCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    public void removeCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    public boolean isRemoved() {
        this.notSupported();
        return false;
    }

    public boolean canMoveDataFiles() {
        this.notSupported();
        return false;
    }

    public SaveLocationChange calculateDefaultDownloadLocation() {
        this.notSupported();
        return null;
    }

    public Object getUserData(Object key) {
        this.notSupported();
        return null;
    }

    public void setUserData(Object key, Object data) {
        this.notSupported();
    }

    public void startDownload(boolean force) {
        this.notSupported();
    }

    public void stopDownload() {
        this.notSupported();
    }

    public void changeLocation(SaveLocationChange slc) {
        this.notSupported();
    }
}

