/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.plugins.ui.config.StringListParameter;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;

public class StringListParameterImpl
extends ParameterImpl
implements StringListParameter {
    private String defaultValue;
    private String[] values;
    private String[] labels;

    public StringListParameterImpl(PluginConfigImpl config, String key, String label, String defaultValue, String[] values, String[] labels) {
        super(config, key, label);
        this.defaultValue = defaultValue;
        this.values = values;
        this.labels = labels;
        config.notifyParamExists(this.getKey());
        COConfigurationManager.setStringDefault(this.getKey(), defaultValue);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getValues() {
        return this.values;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] _labels) {
        this.labels = _labels;
    }

    public String getValue() {
        return this.config.getUnsafeStringParameter(this.getKey(), this.getDefaultValue());
    }

    public void setValue(String s) {
        this.config.setUnsafeStringParameter(this.getKey(), s);
    }
}

