/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.IUIIntializer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.SWT.SWTManager;
import org.gudy.azureus2.plugins.ui.UIException;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIInstanceFactory;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerEvent;
import org.gudy.azureus2.plugins.ui.UIManagerEventListener;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.UIMessage;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.ui.model.PluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.PluginViewModel;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.deprecate.PluginDeprecation;
import org.gudy.azureus2.pluginsimpl.local.ui.SWT.SWTManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerEventAdapter;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.model.BasicPluginConfigModelImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.model.BasicPluginViewModelImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableManagerImpl;

public class UIManagerImpl
implements UIManager {
    protected static AEMonitor class_mon = new AEMonitor("UIManager:class");
    protected static boolean initialisation_complete;
    protected static CopyOnWriteList<Object[]> ui_listeners;
    protected static CopyOnWriteList ui_event_listeners;
    protected static List<UIInstanceFactory> ui_factories;
    protected static List<UIManagerEventAdapter> ui_event_history;
    protected static List<BasicPluginConfigModel> configModels;
    protected PluginInterface pi;
    protected PluginConfig plugin_config;
    protected String key_prefix;
    protected TableManager table_manager;
    protected MenuManager menu_manager;

    public UIManagerImpl(PluginInterface _pi) {
        this.pi = _pi;
        this.plugin_config = this.pi.getPluginconfig();
        this.key_prefix = this.plugin_config.getPluginConfigKeyPrefix();
        this.table_manager = new TableManagerImpl(this);
        this.menu_manager = new MenuManagerImpl(this);
    }

    public PluginInterface getPluginInterface() {
        return this.pi;
    }

    public BasicPluginViewModel getBasicPluginViewModel(String name) {
        return this.createBasicPluginViewModel(name);
    }

    public PluginView createPluginView(PluginViewModel model) {
        try {
            return SWTManagerImpl.getSingleton().createPluginView(model);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public BasicPluginViewModel createBasicPluginViewModel(String name) {
        BasicPluginViewModelImpl model = new BasicPluginViewModelImpl(this, name);
        UIManagerImpl.fireEvent(this.pi, 4, model);
        return model;
    }

    public void destroy(BasicPluginViewModel model) {
        UIManagerImpl.fireEvent(this.pi, 7, model);
    }

    public BasicPluginConfigModel createBasicPluginConfigModel(String section_name) {
        return this.createBasicPluginConfigModel("plugins", section_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicPluginConfigModel createBasicPluginConfigModel(String parent_section, String section_name) {
        BasicPluginConfigModelImpl model = new BasicPluginConfigModelImpl(this, parent_section, section_name);
        try {
            class_mon.enter();
            configModels.add(model);
            Object var5_4 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            class_mon.exit();
            throw throwable;
        }
        UIManagerImpl.fireEvent(this.pi, 5, model);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(BasicPluginConfigModel model) {
        try {
            class_mon.enter();
            configModels.remove(model);
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
        UIManagerImpl.fireEvent(this.pi, 8, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginConfigModel[] getPluginConfigModels() {
        try {
            class_mon.enter();
            PluginConfigModel[] pluginConfigModelArray = configModels.toArray(new PluginConfigModel[0]);
            Object var3_2 = null;
            class_mon.exit();
            return pluginConfigModelArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public void copyToClipBoard(String data) throws UIException {
        boolean ok = UIManagerImpl.fireEvent(this.pi, 6, data);
        if (!ok) {
            throw new UIException("Failed to deliver request to UI");
        }
    }

    public void openURL(URL url) throws UIException {
        boolean ok = UIManagerImpl.fireEvent(this.pi, 9, url);
        if (!ok) {
            throw new UIException("Failed to deliver request to UI");
        }
    }

    public TableManager getTableManager() {
        return this.table_manager;
    }

    public MenuManager getMenuManager() {
        return this.menu_manager;
    }

    public SWTManager getSWTManager() {
        PluginDeprecation.call("getSWTManager", this.pi.getPluginID());
        return SWTManagerImpl.getSingleton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialisationComplete() {
        ArrayList<Object[]> to_fire = new ArrayList<Object[]>();
        try {
            class_mon.enter();
            initialisation_complete = true;
            for (int j = 0; j < ui_factories.size(); ++j) {
                UIInstanceFactory factory = ui_factories.get(j);
                for (Object[] entry : ui_listeners) {
                    List fired = (List)entry[2];
                    if (fired.contains(factory)) continue;
                    fired.add(factory);
                    to_fire.add(new Object[]{entry[0], factory.getInstance((PluginInterface)entry[1])});
                }
            }
            Object var7_8 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            class_mon.exit();
            throw throwable;
        }
        for (Object[] entry : to_fire) {
            try {
                ((UIManagerListener)entry[0]).UIAttached((UIInstance)entry[1]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void attachUI(UIInstanceFactory factory) throws UIException {
        this.attachUI(factory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachUI(UIInstanceFactory factory, IUIIntializer init) {
        ArrayList<Object[]> to_fire = new ArrayList<Object[]>();
        try {
            class_mon.enter();
            ui_factories.add(factory);
            if (initialisation_complete) {
                for (Object[] entry : ui_listeners) {
                    List fired = (List)entry[2];
                    fired.add(factory);
                    to_fire.add(new Object[]{entry[0], entry[1], factory.getInstance((PluginInterface)entry[1])});
                }
            }
            Object var8_7 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            class_mon.exit();
            throw throwable;
        }
        for (Object[] entry : to_fire) {
            PluginInterface pi = (PluginInterface)entry[1];
            String name = pi.getPluginName();
            if (init != null) {
                init.reportCurrentTask(MessageText.getString("splash.plugin.UIinit", new String[]{name}));
                init.increaseProgress();
            }
            try {
                ((UIManagerListener)entry[0]).UIAttached((UIInstance)entry[2]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachUI(UIInstanceFactory factory) throws UIException {
        factory.detach();
        ArrayList<Object[]> to_fire = new ArrayList<Object[]>();
        try {
            class_mon.enter();
            ui_factories.remove(factory);
            if (initialisation_complete) {
                for (Object[] entry : ui_listeners) {
                    List fired = (List)entry[2];
                    fired.remove(factory);
                    to_fire.add(new Object[]{entry[0], factory.getInstance((PluginInterface)entry[1])});
                }
            }
            Object var7_7 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            class_mon.exit();
            throw throwable;
        }
        for (Object[] entry : to_fire) {
            try {
                ((UIManagerListener)entry[0]).UIDetached((UIInstance)entry[1]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUIListener(UIManagerListener listener) {
        ArrayList<UIInstance> to_fire = new ArrayList<UIInstance>();
        try {
            class_mon.enter();
            ArrayList fired = new ArrayList();
            ui_listeners.add(new Object[]{listener, this.pi, fired});
            if (initialisation_complete) {
                for (int i = 0; i < ui_factories.size(); ++i) {
                    UIInstanceFactory factory = ui_factories.get(i);
                    to_fire.add(factory.getInstance(this.pi));
                }
            }
            Object var7_8 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            class_mon.exit();
            throw throwable;
        }
        for (UIInstance instance : to_fire) {
            try {
                listener.UIAttached(instance);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUIListener(UIManagerListener listener) {
        try {
            class_mon.enter();
            Iterator<Object[]> it = ui_listeners.iterator();
            while (it.hasNext()) {
                Object[] entry = it.next();
                if (entry[0] != listener) continue;
                it.remove();
            }
            Object var5_4 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUIEventListener(UIManagerEventListener listener) {
        ArrayList<UIManagerEventAdapter> ui_event_history_copy;
        try {
            class_mon.enter();
            ui_event_listeners.add(listener);
            ui_event_history_copy = new ArrayList<UIManagerEventAdapter>(ui_event_history);
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < ui_event_history_copy.size(); ++i) {
            try {
                listener.eventOccurred((UIManagerEvent)ui_event_history_copy.get(i));
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUIEventListener(UIManagerEventListener listener) {
        try {
            class_mon.enter();
            ui_event_listeners.remove(listener);
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public boolean hasUIInstances() {
        return !ui_factories.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIInstance[] getUIInstances() {
        try {
            class_mon.enter();
            ArrayList<UIInstance> result = new ArrayList<UIInstance>(ui_factories.size());
            for (int i = 0; i < ui_factories.size(); ++i) {
                UIInstanceFactory instance = ui_factories.get(i);
                result.add(instance.getInstance(this.pi));
            }
            UIInstance[] uIInstanceArray = result.toArray(new UIInstance[result.size()]);
            Object var5_5 = null;
            class_mon.exit();
            return uIInstanceArray;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static boolean fireEvent(PluginInterface pi, int type, Object data) {
        return UIManagerImpl.fireEvent(new UIManagerEventAdapter(pi, type, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fireEvent(UIManagerEventAdapter event2) {
        int type;
        boolean delivered = false;
        Iterator event_it = ui_event_listeners.iterator();
        while (event_it.hasNext()) {
            try {
                if (!((UIManagerEventListener)event_it.next()).eventOccurred(event2)) continue;
                delivered = true;
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if ((type = event2.getType()) == 4 || type == 5 || type == 12 || type == 15 || type == 17 || type == 19) {
            delivered = true;
            try {
                class_mon.enter();
                ui_event_history.add(event2);
                Object var5_5 = null;
                class_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        if (type == 7 || type == 8) {
            delivered = true;
            try {
                class_mon.enter();
                Iterator<UIManagerEventAdapter> history_it = ui_event_history.iterator();
                while (history_it.hasNext()) {
                    UIManagerEvent e = history_it.next();
                    int e_type = e.getType();
                    if (e_type != 4 && e_type != 5 || e.getData() != event2.getData()) continue;
                    history_it.remove();
                    break;
                }
                Object var8_11 = null;
                class_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        return delivered;
    }

    public void showTextMessage(String title_resource, String message_resource, String contents) {
        UIManagerImpl.fireEvent(this.pi, 1, new String[]{title_resource, message_resource, contents});
    }

    public long showMessageBox(String title_resource, String message_resource, long message_map) {
        UIManagerEventAdapter event2 = new UIManagerEventAdapter(this.pi, 21, new Object[]{title_resource, message_resource, new Long(message_map)});
        if (!UIManagerImpl.fireEvent(event2)) {
            return 0L;
        }
        return (Long)event2.getResult();
    }

    public void openTorrent(Torrent torrent) {
        UIManagerImpl.fireEvent(this.pi, 22, torrent);
    }

    public void openFile(File file) {
        UIManagerImpl.fireEvent(this.pi, 24, file);
    }

    public void showFile(File file) {
        UIManagerImpl.fireEvent(this.pi, 23, file);
    }

    public boolean showConfigSection(String sectionID) {
        UIManagerEventAdapter event2 = new UIManagerEventAdapter(this.pi, 13, sectionID);
        if (!UIManagerImpl.fireEvent(event2)) {
            return false;
        }
        if (event2.getResult() instanceof Boolean) {
            return false;
        }
        return (Boolean)event2.getResult();
    }

    public UIInputReceiver getInputReceiver() {
        UIInstance[] instances = this.getUIInstances();
        UIInputReceiver r = null;
        for (int i = 0; i < instances.length; ++i) {
            r = instances[i].getInputReceiver();
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public UIMessage createMessage() {
        UIInstance[] instances = this.getUIInstances();
        UIMessage r = null;
        for (int i = 0; i < instances.length; ++i) {
            r = instances[i].createMessage();
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public BasicPluginViewModel createLoggingViewModel(LoggerChannel channel2, boolean use_plugin_name) {
        String log_view_name = use_plugin_name ? this.pi.getPluginName() : channel2.getName();
        BasicPluginViewModel model = this.createBasicPluginViewModel(log_view_name);
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        model.getStatus().setVisible(false);
        model.attachLoggerChannel(channel2);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload(PluginInterface pi) {
        try {
            class_mon.enter();
            Iterator<Object[]> it = ui_listeners.iterator();
            while (it.hasNext()) {
                Object[] entry = it.next();
                if (pi != (PluginInterface)entry[1]) continue;
                it.remove();
            }
            Iterator<UIManagerEventAdapter> ev_it = ui_event_history.iterator();
            while (ev_it.hasNext()) {
                UIManagerEventAdapter event2 = ev_it.next();
                if (event2.getPluginInterface() != pi) continue;
                ev_it.remove();
            }
            Object var5_4 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    static {
        ui_listeners = new CopyOnWriteList();
        ui_event_listeners = new CopyOnWriteList();
        ui_factories = new ArrayList<UIInstanceFactory>();
        ui_event_history = new ArrayList<UIManagerEventAdapter>();
        configModels = new ArrayList<BasicPluginConfigModel>();
    }
}

