/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentCreator;
import org.gudy.azureus2.plugins.torrent.TorrentCreatorListener;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentEncodingException;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.torrent.TorrentManagerEvent;
import org.gudy.azureus2.plugins.torrent.TorrentManagerListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeCategoryImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeDisplayNameImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeNetworksImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributePeerSourcesImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeRelativeSavePathImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeSharePropertiesImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeTrackerClientExtImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeUserCommentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentDownloaderImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class TorrentManagerImpl
implements TorrentManager,
TOTorrentProgressListener {
    private static TorrentManagerImpl singleton;
    private static AEMonitor class_mon;
    private static TorrentAttribute category_attribute;
    private static TorrentAttribute share_properties_attribute;
    private static TorrentAttribute networks_attribute;
    private static TorrentAttribute peer_sources_attribute;
    private static TorrentAttribute tr_ext_attribute;
    private static TorrentAttribute disp_name_attribute;
    private static TorrentAttribute comment_attribute;
    private static TorrentAttribute relative_save_path_attribute;
    private static Map attribute_map;
    protected static List listeners;
    protected PluginInterface plugin_interface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TorrentManagerImpl getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TorrentManagerImpl(null);
            }
            TorrentManagerImpl torrentManagerImpl = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return torrentManagerImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected TorrentManagerImpl(PluginInterface _pi) {
        this.plugin_interface = _pi;
    }

    public TorrentManager specialise(PluginInterface _pi) {
        return new TorrentManagerImpl(_pi);
    }

    public TorrentDownloader getURLDownloader(URL url) throws TorrentException {
        return new TorrentDownloaderImpl(this, url);
    }

    public TorrentDownloader getURLDownloader(URL url, String user_name, String password) throws TorrentException {
        return new TorrentDownloaderImpl(this, url, user_name, password);
    }

    public Torrent createFromBEncodedFile(File file) throws TorrentException {
        return this.createFromBEncodedFile(file, false);
    }

    public Torrent createFromBEncodedFile(File file, boolean for_seeding) throws TorrentException {
        try {
            TOTorrent torrent = for_seeding ? TorrentUtils.readFromFile(file, true, true) : TorrentUtils.readFromFile(file, false);
            return new TorrentImpl(this.plugin_interface, torrent);
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromBEncodedFile Fails", e);
        }
    }

    public Torrent createFromBEncodedInputStream(InputStream data) throws TorrentException {
        try {
            return new TorrentImpl(this.plugin_interface, TorrentUtils.readFromBEncodedInputStream(data));
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromBEncodedFile Fails", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Torrent createFromBEncodedData(byte[] data) throws TorrentException {
        TorrentImpl torrentImpl;
        ByteArrayInputStream is = null;
        try {
            try {
                is = new ByteArrayInputStream(data);
                torrentImpl = new TorrentImpl(this.plugin_interface, TorrentUtils.readFromBEncodedInputStream(is));
                Object var5_5 = null;
            }
            catch (TOTorrentException e) {
                throw new TorrentException("TorrentManager::createFromBEncodedData Fails", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable e2) {
                Debug.printStackTrace(e2);
                throw throwable;
            }
        }
        try {}
        catch (Throwable e2) {
            Debug.printStackTrace(e2);
            return torrentImpl;
        }
        is.close();
        return torrentImpl;
    }

    public Torrent createFromDataFile(File data, URL announce_url) throws TorrentException {
        return this.createFromDataFile(data, announce_url, false);
    }

    public Torrent createFromDataFile(File data, URL announce_url, boolean include_other_hashes) throws TorrentException {
        try {
            TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(data, announce_url, include_other_hashes);
            c.addListener(this);
            return new TorrentImpl(this.plugin_interface, c.create());
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromDataFile Fails", e);
        }
    }

    public TorrentCreator createFromDataFileEx(File data, URL announce_url, boolean include_other_hashes) throws TorrentException {
        try {
            final TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(data, announce_url, include_other_hashes);
            return new TorrentCreator(){
                private CopyOnWriteList listeners = new CopyOnWriteList();

                public void start() {
                    c.addListener(new TOTorrentProgressListener(){

                        public void reportProgress(int percent_complete) {
                            Iterator it = listeners.iterator();
                            while (it.hasNext()) {
                                ((TorrentCreatorListener)it.next()).reportPercentageDone(percent_complete);
                            }
                        }

                        public void reportCurrentTask(String task_description) {
                            Iterator it = listeners.iterator();
                            while (it.hasNext()) {
                                ((TorrentCreatorListener)it.next()).reportActivity(task_description);
                            }
                        }
                    });
                    new AEThread("TorrentManager::create", true){

                        public void runSupport() {
                            try {
                                TOTorrent t = c.create();
                                TorrentImpl torrent = new TorrentImpl(TorrentManagerImpl.this.plugin_interface, t);
                                Iterator it = listeners.iterator();
                                while (it.hasNext()) {
                                    ((TorrentCreatorListener)it.next()).complete(torrent);
                                }
                            }
                            catch (TOTorrentException e) {
                                Iterator it = listeners.iterator();
                                while (it.hasNext()) {
                                    ((TorrentCreatorListener)it.next()).failed(new TorrentException(e));
                                }
                            }
                        }
                    }.start();
                }

                public void cancel() {
                    c.cancel();
                }

                public void addListener(TorrentCreatorListener listener) {
                    this.listeners.add(listener);
                }

                public void removeListener(TorrentCreatorListener listener) {
                    this.listeners.remove(listener);
                }
            };
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromDataFile Fails", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentAttribute[] getDefinedAttributes() {
        try {
            class_mon.enter();
            Collection entries = attribute_map.values();
            TorrentAttribute[] res = new TorrentAttribute[entries.size()];
            entries.toArray(res);
            TorrentAttribute[] torrentAttributeArray = res;
            Object var5_4 = null;
            class_mon.exit();
            return torrentAttributeArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentAttribute getAttribute(String name) {
        try {
            class_mon.enter();
            TorrentAttribute res = (TorrentAttribute)attribute_map.get(name);
            if (res == null && name.startsWith("Plugin.")) {
                res = new TorrentAttributePluginImpl(name);
                attribute_map.put(name, res);
            }
            if (res == null) {
                throw new IllegalArgumentException("No such attribute: \"" + name + "\"");
            }
            TorrentAttribute torrentAttribute = res;
            Object var5_4 = null;
            class_mon.exit();
            return torrentAttribute;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentAttribute getPluginAttribute(String name) {
        TorrentAttribute res;
        block3: {
            name = "Plugin." + this.plugin_interface.getPluginID() + "." + name;
            try {
                class_mon.enter();
                res = (TorrentAttribute)attribute_map.get(name);
                if (res == null) break block3;
                TorrentAttribute torrentAttribute = res;
                Object var5_5 = null;
                class_mon.exit();
                return torrentAttribute;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        res = new TorrentAttributePluginImpl(name);
        attribute_map.put(name, res);
        TorrentAttribute torrentAttribute = res;
        Object var5_6 = null;
        class_mon.exit();
        return torrentAttribute;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Torrent createFromBEncodedData(byte[] data, int preserve) throws TorrentException {
        TorrentImpl torrentImpl;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            try {
                TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(bais);
                torrentImpl = new TorrentImpl(this.plugin_interface, this.preserveFields(torrent, preserve));
                Object var7_7 = null;
            }
            catch (TOTorrentException e) {
                throw new TorrentException("Failed to read TorrentData", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                bais.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return torrentImpl;
        }
        bais.close();
        return torrentImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Torrent createFromBEncodedFile(File file, int preserve) throws TorrentException {
        TorrentImpl torrentImpl;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(fis);
                torrentImpl = new TorrentImpl(this.plugin_interface, this.preserveFields(torrent, preserve));
                Object var7_8 = null;
                if (fis == null) return torrentImpl;
            }
            catch (FileNotFoundException e) {
                throw new TorrentException("Failed to read from TorrentFile", e);
            }
            catch (TOTorrentException e) {
                throw new TorrentException("Failed to read TorrentData", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return torrentImpl;
        }
        fis.close();
        return torrentImpl;
    }

    public Torrent createFromBEncodedInputStream(InputStream data, int preserve) throws TorrentException {
        try {
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(data);
            return new TorrentImpl(this.plugin_interface, this.preserveFields(torrent, preserve));
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Failed to read TorrentData", e);
        }
    }

    private TOTorrent preserveFields(TOTorrent torrent, int preserve) {
        if (preserve == -1) {
            return torrent;
        }
        if ((preserve & 1) > 0) {
            String encoding = torrent.getAdditionalStringProperty("encoding");
            torrent.removeAdditionalProperties();
            if (encoding != null) {
                torrent.setAdditionalStringProperty("encoding", encoding);
            }
        } else if (preserve == 0) {
            torrent.removeAdditionalProperties();
        }
        return torrent;
    }

    public void reportProgress(int percent_complete) {
    }

    public void reportCurrentTask(final String task_description) {
        Iterator it = listeners.iterator();
        while (it.hasNext()) {
            ((TorrentManagerListener)it.next()).event(new TorrentManagerEvent(){

                public Object getData() {
                    return task_description;
                }
            });
        }
    }

    protected void tryToSetTorrentEncoding(TOTorrent torrent, String encoding) throws TorrentEncodingException {
        try {
            LocaleTorrentUtil.setTorrentEncoding(torrent, encoding);
        }
        catch (LocaleUtilEncodingException e) {
            String[] charsets = e.getValidCharsets();
            if (charsets == null) {
                throw new TorrentEncodingException("Failed to set requested encoding", e);
            }
            throw new TorrentEncodingException(charsets, e.getValidTorrentNames());
        }
    }

    protected void tryToSetDefaultTorrentEncoding(TOTorrent torrent) throws TorrentException {
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(torrent);
        }
        catch (LocaleUtilEncodingException e) {
            String[] charsets = e.getValidCharsets();
            if (charsets == null) {
                throw new TorrentEncodingException("Failed to set default encoding", e);
            }
            throw new TorrentEncodingException(charsets, e.getValidTorrentNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TorrentManagerListener l) {
        try {
            class_mon.enter();
            ArrayList<TorrentManagerListener> new_listeners = new ArrayList<TorrentManagerListener>(listeners);
            new_listeners.add(l);
            listeners = new_listeners;
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TorrentManagerListener l) {
        try {
            class_mon.enter();
            ArrayList new_listeners = new ArrayList(listeners);
            new_listeners.remove(l);
            listeners = new_listeners;
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    static {
        class_mon = new AEMonitor("TorrentManager");
        category_attribute = new TorrentAttributeCategoryImpl();
        share_properties_attribute = new TorrentAttributeSharePropertiesImpl();
        networks_attribute = new TorrentAttributeNetworksImpl();
        peer_sources_attribute = new TorrentAttributePeerSourcesImpl();
        tr_ext_attribute = new TorrentAttributeTrackerClientExtImpl();
        disp_name_attribute = new TorrentAttributeDisplayNameImpl();
        comment_attribute = new TorrentAttributeUserCommentImpl();
        relative_save_path_attribute = new TorrentAttributeRelativeSavePathImpl();
        attribute_map = new HashMap();
        attribute_map.put("Category", category_attribute);
        attribute_map.put("ShareProperties", share_properties_attribute);
        attribute_map.put("Networks", networks_attribute);
        attribute_map.put("PeerSources", peer_sources_attribute);
        attribute_map.put("TrackerClientExtensions", tr_ext_attribute);
        attribute_map.put("DisplayName", disp_name_attribute);
        attribute_map.put("UserComment", comment_attribute);
        attribute_map.put("RelativePath", relative_save_path_attribute);
        listeners = new ArrayList();
    }
}

