/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx.access.jnilib;

import com.aelitis.azureus.core.drivedetector.DriveDetectorFactory;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.Map;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.macosx.access.jnilib.OSXDriveDetectListener;

public class OSXAccess {
    private static boolean bLoaded = false;
    private static boolean DEBUG = false;

    private static boolean loadLibrary(String lib) {
        try {
            OSXAccess.SystemLoadLibrary(lib);
            System.out.println(lib + " v" + OSXAccess.getVersion() + " Load complete!");
            bLoaded = true;
            OSXAccess.initDriveDetection();
        }
        catch (Throwable e1) {
            Debug.outNoStack("Could not find lib" + lib + ".jnilib; " + e1.toString());
        }
        return bLoaded;
    }

    private static void SystemLoadLibrary(String lib) throws Throwable {
        try {
            System.loadLibrary(lib);
        }
        catch (Throwable t) {
            try {
                File f = new File("Azureus.app/Contents/Resources/Java/dll/lib" + lib + ".jnilib");
                System.load(f.getAbsolutePath());
            }
            catch (Throwable t2) {
                throw t;
            }
        }
    }

    private static void initDriveDetection() {
        try {
            OSXAccess.initializeDriveDetection(new OSXDriveDetectListener(){

                public void driveRemoved(File mount, Map driveInfo) {
                    if (DEBUG) {
                        System.out.println("UNMounted " + mount);
                        for (Object key : driveInfo.keySet()) {
                            Object val = driveInfo.get(key);
                            System.out.println("\t" + key + "\t:\t" + val);
                        }
                    }
                    DriveDetectorFactory.getDeviceDetector().driveRemoved(mount);
                }

                public void driveDetected(File mount, Map driveInfo) {
                    if (DEBUG) {
                        System.out.println("Mounted " + mount);
                        for (Object key : driveInfo.keySet()) {
                            Object val = driveInfo.get(key);
                            System.out.println("\t" + key + "\t:\t" + val);
                        }
                    }
                    boolean isOptical = MapUtils.getMapLong(driveInfo, "isOptical", 0L) != 0L;
                    boolean isRemovable = MapUtils.getMapLong(driveInfo, "Removable", 0L) != 0L;
                    boolean isWritable = MapUtils.getMapLong(driveInfo, "Writable", 0L) != 0L;
                    boolean isWritableUSB = isRemovable && isWritable && !isOptical;
                    driveInfo.put("isWritableUSB", isWritableUSB);
                    DriveDetectorFactory.getDeviceDetector().driveDetected(mount, driveInfo);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final native int AEGetParamDesc(int var0, int var1, int var2, Object var3);

    public static final native String getVersion();

    public static final native String getDocDir();

    public static final native void memmove(byte[] var0, int var1, int var2);

    public static final native void initializeDriveDetection(OSXDriveDetectListener var0);

    public static boolean isLoaded() {
        return bLoaded;
    }

    static {
        if (!Constants.isOSX_10_5_OrHigher || !OSXAccess.loadLibrary("OSXAccess_10.5")) {
            OSXAccess.loadLibrary("OSXAccess");
        }
    }
}

