/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.macosx;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

public class PlatformManagerUpdateChecker
implements Plugin,
UpdatableComponent {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String UPDATE_NAME = "Platform-specific support";
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    protected PluginInterface plugin_interface;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Platform-Specific Support");
        String version = "1.0";
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        if (platform.getPlatformType() == 3) {
            if (platform.hasCapability(PlatformManagerCapabilities.GetVersion)) {
                try {
                    version = platform.getVersion();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, false);
        } else {
            this.plugin_interface.getPluginProperties().setProperty("plugin.version.info", "Not required for this platform");
        }
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", version);
    }

    public String getName() {
        return UPDATE_NAME;
    }

    public int getMaximumCheckTime() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdate(final UpdateChecker checker) {
        try {
            block12: {
                try {
                    String sf_cvs_version;
                    String sf_cvs_version2;
                    String sf_plugin_version;
                    SFPluginDetails sf_details = SFPluginDetailsLoaderFactory.getSingleton().getPluginDetails(this.plugin_interface.getPluginID());
                    String current_version = this.plugin_interface.getPluginVersion();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "PlatformManager:OSX update check starts: current = " + current_version));
                    }
                    boolean current_az_is_cvs = Constants.isCVSVersion();
                    String sf_comp_version = sf_plugin_version = sf_details.getVersion();
                    if (current_az_is_cvs && (sf_cvs_version2 = sf_details.getCVSVersion()).length() > 0) {
                        sf_plugin_version = sf_cvs_version2;
                        sf_comp_version = sf_plugin_version.substring(0, sf_plugin_version.length() - 4);
                    }
                    String target_version = null;
                    if (sf_comp_version.length() == 0 || !Character.isDigit(sf_comp_version.charAt(0))) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "PlatformManager:OSX no valid version to check against (" + sf_comp_version + ")"));
                        }
                    } else if (Constants.compareVersions(current_version, sf_comp_version) < 0) {
                        target_version = sf_comp_version;
                    }
                    checker.reportProgress("OSX: current = " + current_version + ", latest = " + sf_comp_version);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "PlatformManager:OSX update required = " + (target_version != null)));
                    }
                    if (target_version == null) break block12;
                    String target_download = sf_details.getDownloadURL();
                    if (current_az_is_cvs && (sf_cvs_version = sf_details.getCVSVersion()).length() > 0) {
                        target_download = sf_details.getCVSDownloadURL();
                    }
                    ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
                    ResourceDownloader direct_rdl = rdf.create(new URL(target_download));
                    String torrent_download = "http://cf1.vuze.com/torrent/torrents/";
                    int slash_pos = target_download.lastIndexOf("/");
                    torrent_download = slash_pos == -1 ? torrent_download + target_download : torrent_download + target_download.substring(slash_pos + 1);
                    torrent_download = torrent_download + ".torrent";
                    ResourceDownloader torrent_rdl = rdf.create(new URL(torrent_download));
                    torrent_rdl = rdf.getSuffixBasedDownloader(torrent_rdl);
                    ResourceDownloader alternate_rdl = rdf.getAlternateDownloader(new ResourceDownloader[]{torrent_rdl, direct_rdl});
                    rdf.getTimeoutDownloader(rdf.getRetryDownloader(alternate_rdl, 3), 10000).getSize();
                    ArrayList update_desc = new ArrayList();
                    List desc_lines = HTMLUtils.convertHTMLToText("", sf_details.getDescription());
                    update_desc.addAll(desc_lines);
                    List comment_lines = HTMLUtils.convertHTMLToText("    ", sf_details.getComment());
                    update_desc.addAll(comment_lines);
                    String[] update_d = new String[update_desc.size()];
                    update_desc.toArray(update_d);
                    final Update update = checker.addUpdate(UPDATE_NAME, update_d, target_version, alternate_rdl, 2);
                    update.setDescriptionURL(sf_details.getInfoURL());
                    alternate_rdl.addListener(new ResourceDownloaderAdapter(){

                        public boolean completed(ResourceDownloader downloader, InputStream data) {
                            PlatformManagerUpdateChecker.this.installUpdate(checker, update, downloader, data);
                            return true;
                        }

                        public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                            Debug.out(downloader.getName() + " failed", e);
                            update.complete(false);
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    checker.reportProgress("Failed to load plugin details for the platform manager: " + Debug.getNestedExceptionMessage(e));
                    checker.failed();
                    Object var21_22 = null;
                    checker.completed();
                }
            }
            Object var21_21 = null;
            checker.completed();
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            checker.completed();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void installUpdate(UpdateChecker checker, Update update, ResourceDownloader rd, InputStream data) {
        ZipInputStream zip = null;
        data = update.verifyData(data, true);
        rd.reportActivity("Data verified successfully");
        UpdateInstaller installer = checker.createInstaller();
        zip = new ZipInputStream(data);
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            String name = entry.getName();
            if (!name.toLowerCase().startsWith("osx/") || (name = name.substring(4)).length() <= 0) continue;
            rd.reportActivity("Adding update action for '" + name + "'");
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "PlatformManager:OSX adding action for '" + name + "'"));
            }
            String resource_name = name.replaceAll("/", "-");
            installer.addResource(resource_name, zip, false);
            String target = installer.getInstallDir() + File.separator + SystemProperties.getApplicationName() + ".app" + File.separator + name;
            installer.addMoveAction(resource_name, target);
            if (!name.endsWith(".jnilib") && !name.endsWith("JavaApplicationStub")) continue;
            installer.addChangeRightsAction("755", target);
        }
        update.complete(true);
        Object var12_12 = null;
        if (zip == null) return;
        try {
            zip.close();
            return;
        }
        catch (Throwable e2) {}
        return;
        {
            catch (Throwable e) {
                update.complete(false);
                rd.reportActivity("Update install failed:" + e.getMessage());
                Object var12_13 = null;
                if (zip == null) return;
                try {
                    zip.close();
                    return;
                }
                catch (Throwable e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (zip == null) throw throwable;
            try {
                zip.close();
                throw throwable;
            }
            catch (Throwable e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected List splitMultiLine(String indent, String text) {
        int p1;
        int pos = 0;
        String lc_text = text.toLowerCase();
        ArrayList<String> lines = new ArrayList<String>();
        do {
            String line;
            if ((p1 = lc_text.indexOf("<br>", pos)) == -1) {
                line = text.substring(pos);
            } else {
                line = text.substring(pos, p1);
                pos = p1 + 4;
            }
            lines.add(indent + line);
        } while (p1 != -1);
        return lines;
    }
}

