/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.protocol.azplug;

import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AZPluginConnection
extends HttpURLConnection {
    private int response_code = 200;
    private String response_msg = "OK";
    private InputStream input_stream;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    protected AZPluginConnection(URL _url) {
        super(_url);
    }

    @Override
    public void connect() throws IOException {
        String url = this.getURL().toString();
        int pos = url.indexOf("?");
        if (pos == -1) {
            throw new IOException("Malformed URL - ? missing");
        }
        url = url.substring(pos + 1);
        String[] bits = url.split("&");
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < bits.length; ++i) {
            String bit = bits[i];
            String[] x = bit.split("=");
            if (x.length != 2) continue;
            String lhs = x[0];
            String rhs = URLDecoder.decode(x[1], "UTF-8");
            args.put(lhs.toLowerCase(), rhs);
        }
        String plugin_id = (String)args.get("id");
        if (plugin_id == null) {
            throw new IOException("Plugin id missing");
        }
        String plugin_name = (String)args.get("name");
        String arg = (String)args.get("arg");
        String plugin_str = plugin_id + (plugin_name == null ? "" : " (" + plugin_name + ")");
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(plugin_id);
        if (pi == null) {
            throw new IOException("Plugin id " + plugin_str + " not installed");
        }
        IPCInterface ipc = pi.getIPC();
        try {
            this.input_stream = ipc.canInvoke("handleURLProtocol", new Object[]{this, arg}) ? (InputStream)ipc.invoke("handleURLProtocol", new Object[]{this, arg}) : (InputStream)ipc.invoke("handleURLProtocol", new Object[]{arg});
        }
        catch (IPCException ipce) {
            Throwable e = ipce;
            if (e.getCause() != null) {
                e = e.getCause();
            }
            throw new IOException("Communication error with plugin '" + plugin_str + "': " + Debug.getNestedExceptionMessage(e));
        }
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headers;
    }

    @Override
    public String getHeaderField(String name) {
        List<String> values = this.headers.get(name);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(values.size() - 1);
    }

    public void setHeaderField(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.input_stream;
    }

    public void setResponse(int _code, String _msg) {
        this.response_code = _code;
        this.response_msg = _msg;
    }

    @Override
    public int getResponseCode() {
        return this.response_code;
    }

    @Override
    public String getResponseMessage() {
        return this.response_msg;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public void disconnect() {
    }
}

