/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerStats;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerFactoryImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerRequestImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerStatsImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public abstract class TRTrackerServerImpl
implements TRTrackerServer {
    public static final int RETRY_MINIMUM_SECS = 60;
    public static final int RETRY_MINIMUM_MILLIS = 60000;
    public static final int CLIENT_TIMEOUT_MULTIPLIER = 3;
    public static final int TIMEOUT_CHECK = 180000;
    public static int max_peers_to_send = 0;
    public static boolean send_peer_ids = true;
    public static int announce_cache_period = 500;
    public static int scrape_cache_period = 5000;
    public static int announce_cache_threshold = 500;
    public static int max_seed_retention = 0;
    public static int seed_limit = 0;
    public static boolean full_scrape_enable = true;
    public static boolean restrict_non_blocking_requests = true;
    public static boolean all_networks_permitted = true;
    public static String[] permitted_networks = new String[0];
    public static boolean support_experimental_extensions;
    public static String redirect_on_not_found;
    private static Map torrent_map;
    private static Map link_map;
    protected AEMonitor class_mon = new AEMonitor("TRTrackerServer:class");
    protected IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private long current_announce_retry_interval;
    private long current_scrape_retry_interval;
    private long current_total_clients;
    private int current_min_poll_interval;
    private int current_min_seed_announce_mult;
    private TRTrackerServerStatsImpl stats = new TRTrackerServerStatsImpl(this);
    private String name;
    private boolean web_password_enabled;
    private boolean web_password_https_only;
    private boolean tracker_password_enabled;
    private String password_user;
    private byte[] password_pw;
    private boolean compact_enabled;
    private boolean key_enabled;
    private boolean enabled = true;
    private boolean keep_alive_enabled = false;
    protected CopyOnWriteList<TRTrackerServerListener> listeners = new CopyOnWriteList();
    protected CopyOnWriteList<TRTrackerServerListener2> listeners2 = new CopyOnWriteList();
    private List<TRTrackerServerAuthenticationListener> auth_listeners = new ArrayList<TRTrackerServerAuthenticationListener>();
    private Vector<TRTrackerServerRequestListener> request_listeners = new Vector();
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServer");
    private COConfigurationListener config_listener;
    private boolean destroyed;
    private Set biased_peers;
    private boolean is_ready;

    protected static void readConfig() {
        send_peer_ids = COConfigurationManager.getBooleanParameter("Tracker Send Peer IDs");
        max_peers_to_send = COConfigurationManager.getIntParameter("Tracker Max Peers Returned");
        scrape_cache_period = COConfigurationManager.getIntParameter("Tracker Scrape Cache", 5000);
        announce_cache_period = COConfigurationManager.getIntParameter("Tracker Announce Cache", 500);
        announce_cache_threshold = COConfigurationManager.getIntParameter("Tracker Announce Cache Min Peers", 500);
        max_seed_retention = COConfigurationManager.getIntParameter("Tracker Max Seeds Retained", 0);
        seed_limit = COConfigurationManager.getIntParameter("Tracker Max Seeds", 0);
        ArrayList<String> nets = new ArrayList<String>();
        for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
            String net = AENetworkClassifier.AT_NETWORKS[i];
            boolean enabled = COConfigurationManager.getBooleanParameter("Tracker Network Selection Default." + net);
            if (!enabled) continue;
            nets.add(net);
        }
        String[] s_nets = new String[nets.size()];
        nets.toArray(s_nets);
        permitted_networks = s_nets;
        all_networks_permitted = s_nets.length == AENetworkClassifier.AT_NETWORKS.length;
        full_scrape_enable = COConfigurationManager.getBooleanParameter("Tracker Server Full Scrape Enable");
        redirect_on_not_found = COConfigurationManager.getStringParameter("Tracker Server Not Found Redirect").trim();
        support_experimental_extensions = COConfigurationManager.getBooleanParameter("Tracker Server Support Experimental Extensions");
        restrict_non_blocking_requests = COConfigurationManager.getBooleanParameter("Tracker TCP NonBlocking Restrict Request Types");
    }

    protected static boolean getSendPeerIds() {
        return send_peer_ids;
    }

    protected static int getMaxPeersToSend() {
        return max_peers_to_send;
    }

    protected static int getScrapeCachePeriod() {
        return scrape_cache_period;
    }

    protected static int getAnnounceCachePeriod() {
        return announce_cache_period;
    }

    protected static int getAnnounceCachePeerThreshold() {
        return announce_cache_threshold;
    }

    protected static int getMaxSeedRetention() {
        return max_seed_retention;
    }

    protected static int getSeedLimit() {
        return seed_limit;
    }

    public static boolean isFullScrapeEnabled() {
        return full_scrape_enable;
    }

    protected static boolean getAllNetworksSupported() {
        return all_networks_permitted;
    }

    protected static String[] getPermittedNetworks() {
        return permitted_networks;
    }

    public static boolean supportsExtensions() {
        return support_experimental_extensions;
    }

    public TRTrackerServerImpl(String _name, boolean _start_up_ready) {
        this.name = _name == null ? DEFAULT_NAME : _name;
        this.is_ready = _start_up_ready;
        this.config_listener = new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerServerImpl.this.readConfigSettings();
            }
        };
        COConfigurationManager.addListener(this.config_listener);
        this.readConfigSettings();
        this.current_min_poll_interval = COConfigurationManager.getIntParameter("Tracker Poll Interval Min", 120);
        if (this.current_min_poll_interval < 60) {
            this.current_min_poll_interval = 60;
        }
        this.current_min_seed_announce_mult = COConfigurationManager.getIntParameter("Tracker Poll Seed Interval Mult");
        this.current_announce_retry_interval = this.current_min_poll_interval;
        int scrape_percentage = COConfigurationManager.getIntParameter("Tracker Scrape Retry Percentage", 200);
        this.current_scrape_retry_interval = this.current_announce_retry_interval * (long)scrape_percentage / 100L;
        AEThread timer_thread = new AEThread("TrackerServer:timer.loop"){

            public void runSupport() {
                TRTrackerServerImpl.this.timerLoop();
            }
        };
        timer_thread.setDaemon(true);
        timer_thread.start();
    }

    protected void readConfigSettings() {
        this.web_password_enabled = COConfigurationManager.getBooleanParameter("Tracker Password Enable Web");
        this.tracker_password_enabled = COConfigurationManager.getBooleanParameter("Tracker Password Enable Torrent");
        this.web_password_https_only = COConfigurationManager.getBooleanParameter("Tracker Password Web HTTPS Only");
        if (this.web_password_enabled || this.tracker_password_enabled) {
            this.password_user = COConfigurationManager.getStringParameter("Tracker Username", "");
            this.password_pw = COConfigurationManager.getByteParameter("Tracker Password", new byte[0]);
        }
        this.compact_enabled = COConfigurationManager.getBooleanParameter("Tracker Compact Enable");
        this.key_enabled = COConfigurationManager.getBooleanParameter("Tracker Key Enable Server");
    }

    public void setReady() {
        this.is_ready = true;
    }

    public final boolean isReady() {
        return this.is_ready;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnableKeepAlive(boolean enable) {
        this.keep_alive_enabled = this.enabled;
    }

    public boolean isKeepAliveEnabled() {
        return this.keep_alive_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrent addLink(String link, TRTrackerServerTorrent target) {
        try {
            this.class_mon.enter();
            TRTrackerServerTorrent tRTrackerServerTorrent = link_map.put(link, target);
            Object var5_4 = null;
            this.class_mon.exit();
            return tRTrackerServerTorrent;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLink(String link, TRTrackerServerTorrent target) {
        try {
            this.class_mon.enter();
            link_map.remove(link);
            Object var4_3 = null;
            this.class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBiasedPeers(Set peers) {
        if (this.biased_peers != null && ((Object)peers).equals(this.biased_peers)) {
            return;
        }
        String str = "";
        Iterator it = peers.iterator();
        while (it.hasNext()) {
            str = str + " " + it.next();
        }
        System.out.println("biased peers: " + str);
        try {
            this.class_mon.enter();
            this.biased_peers = new HashSet(peers);
            for (TRTrackerServerTorrentImpl this_torrent : torrent_map.values()) {
                this_torrent.updateBiasedPeers(this.biased_peers);
            }
            Object var7_6 = null;
            this.class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    protected Set getBiasedPeers() {
        return this.biased_peers;
    }

    public boolean isWebPasswordEnabled() {
        return this.web_password_enabled || this.auth_listeners.size() > 0;
    }

    public boolean isTrackerPasswordEnabled() {
        return this.tracker_password_enabled || this.auth_listeners.size() > 0;
    }

    public boolean isWebPasswordHTTPSOnly() {
        return this.web_password_https_only;
    }

    public boolean hasExternalAuthorisation() {
        return this.auth_listeners.size() > 0;
    }

    public boolean hasInternalAuthorisation() {
        return this.web_password_enabled || this.tracker_password_enabled;
    }

    public boolean performExternalAuthorisation(InetSocketAddress remote_ip, String headers, URL resource, String user, String password) {
        headers = headers.trim() + "\r\nX-Real-IP: " + remote_ip.getAddress().getHostAddress() + "\r\n\r\n";
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                if (!this.auth_listeners.get(i).authenticate(headers, resource, user, password)) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    public byte[] performExternalAuthorisation(URL resource, String user) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                byte[] sha_pw = this.auth_listeners.get(i).authenticate(resource, user);
                if (sha_pw == null) continue;
                return sha_pw;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCompactEnabled() {
        return this.compact_enabled;
    }

    public boolean isKeyEnabled() {
        return this.key_enabled;
    }

    public String getUsername() {
        return this.password_user;
    }

    public byte[] getPassword() {
        return this.password_pw;
    }

    public long getMinAnnounceRetryInterval() {
        return this.current_min_poll_interval;
    }

    public long getAnnounceRetryInterval(TRTrackerServerTorrentImpl torrent) {
        long clients = this.current_total_clients;
        if (clients == 0L) {
            return this.current_announce_retry_interval;
        }
        long res = (long)torrent.getPeerCount() * this.current_announce_retry_interval / clients;
        if (res < (long)this.current_min_poll_interval) {
            res = this.current_min_poll_interval;
        }
        return res;
    }

    public long getSeedAnnounceIntervalMultiplier() {
        return this.current_min_seed_announce_mult;
    }

    public long getScrapeRetryInterval(TRTrackerServerTorrentImpl torrent) {
        long clients = this.current_total_clients;
        if (torrent == null || clients == 0L) {
            return this.current_scrape_retry_interval;
        }
        long res = (long)torrent.getPeerCount() * this.current_scrape_retry_interval / clients;
        if (res < (long)this.current_min_poll_interval) {
            res = this.current_min_poll_interval;
        }
        return res;
    }

    public long getMinScrapeRetryInterval() {
        return this.current_min_poll_interval;
    }

    public TRTrackerServerStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(int request_type, TRTrackerServerTorrentImpl torrent, int bytes_in, int bytes_out) {
        this.stats.update(request_type, bytes_in, bytes_out);
        if (torrent != null) {
            torrent.updateXferStats(bytes_in, bytes_out);
        } else {
            int num = torrent_map.size();
            if (num < 256) {
                try {
                    this.class_mon.enter();
                    if (num > 0) {
                        int ave_in = bytes_in / num;
                        int ave_out = bytes_out / num;
                        int rem_in = bytes_in - ave_in * num;
                        int rem_out = bytes_out - ave_out * num;
                        Iterator it = torrent_map.values().iterator();
                        while (it.hasNext()) {
                            TRTrackerServerTorrentImpl this_torrent = (TRTrackerServerTorrentImpl)it.next();
                            if (it.hasNext()) {
                                this_torrent.updateXferStats(ave_in, ave_out);
                                continue;
                            }
                            this_torrent.updateXferStats(ave_in + rem_in, ave_out + rem_out);
                        }
                    }
                    Object var13_12 = null;
                    this.class_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    this.class_mon.exit();
                    throw throwable;
                }
            }
        }
    }

    protected void updateTime(int request_type, long time) {
        this.stats.updateTime(request_type, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timerLoop() {
        long time_to_go = 180000L;
        while (!this.destroyed) {
            try {
                Object var15_13;
                Object var13_12;
                Thread.sleep(60000L);
                time_to_go -= 60000L;
                this.current_min_poll_interval = COConfigurationManager.getIntParameter("Tracker Poll Interval Min", 120);
                if (this.current_min_poll_interval < 60) {
                    this.current_min_poll_interval = 60;
                }
                int min = this.current_min_poll_interval;
                int max = COConfigurationManager.getIntParameter("Tracker Poll Interval Max", 3600);
                int inc_by = COConfigurationManager.getIntParameter("Tracker Poll Inc By", 60);
                int inc_per = COConfigurationManager.getIntParameter("Tracker Poll Inc Per", 10);
                int scrape_percentage = COConfigurationManager.getIntParameter("Tracker Scrape Retry Percentage", 200);
                int retry = min;
                int clients = 0;
                try {
                    this.class_mon.enter();
                    for (TRTrackerServerTorrentImpl t : torrent_map.values()) {
                        clients += t.getPeerCount();
                    }
                    var13_12 = null;
                    this.class_mon.exit();
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    this.class_mon.exit();
                    throw throwable;
                }
                if (inc_by > 0 && inc_per > 0) {
                    retry += inc_by * (clients / inc_per);
                }
                if (max > 0 && retry > max) {
                    retry = max;
                }
                if (retry < 60) {
                    retry = 60;
                }
                this.current_announce_retry_interval = retry;
                this.current_scrape_retry_interval = this.current_announce_retry_interval * (long)scrape_percentage / 100L;
                this.current_total_clients = clients;
                if (time_to_go > 0L) continue;
                time_to_go = 180000L;
                try {
                    this.class_mon.enter();
                    for (TRTrackerServerTorrentImpl t : torrent_map.values()) {
                        t.checkTimeouts();
                    }
                    var15_13 = null;
                    this.class_mon.exit();
                }
                catch (Throwable throwable) {
                    var15_13 = null;
                    this.class_mon.exit();
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public TRTrackerServerTorrent permit(String _originator, byte[] _hash, boolean _explicit) throws TRTrackerServerException {
        return this.permit(_originator, _hash, _explicit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrent permit(String _originator, byte[] _hash, boolean _explicit, boolean _enabled) throws TRTrackerServerException {
        TRTrackerServerTorrentImpl entry;
        HashWrapper hash = new HashWrapper(_hash);
        try {
            this.class_mon.enter();
            entry = (TRTrackerServerTorrentImpl)torrent_map.get(hash);
            Object var8_7 = null;
            this.class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.class_mon.exit();
            throw throwable;
        }
        if (entry == null) {
            Iterator<TRTrackerServerListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                if (it.next().permitted(_originator, _hash, _explicit)) continue;
                throw new TRTrackerServerException("operation denied");
            }
            try {
                this.class_mon.enter();
                entry = (TRTrackerServerTorrentImpl)torrent_map.get(hash);
                if (entry == null) {
                    entry = new TRTrackerServerTorrentImpl(this, hash, _enabled);
                    torrent_map.put(hash, entry);
                }
                Object var10_11 = null;
                this.class_mon.exit();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.class_mon.exit();
                throw throwable;
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deny(byte[] _hash, boolean _explicit) throws TRTrackerServerException {
        HashWrapper hash = new HashWrapper(_hash);
        Iterator<TRTrackerServerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            if (it.next().denied(_hash, _explicit)) continue;
            throw new TRTrackerServerException("operation denied");
        }
        try {
            this.class_mon.enter();
            TRTrackerServerTorrentImpl entry = (TRTrackerServerTorrentImpl)torrent_map.get(hash);
            if (entry != null) {
                entry.delete();
            }
            torrent_map.remove(hash);
            Object var7_6 = null;
            this.class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrentImpl getTorrent(byte[] hash) {
        try {
            this.class_mon.enter();
            TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl = (TRTrackerServerTorrentImpl)torrent_map.get(new HashWrapper(hash));
            Object var4_3 = null;
            this.class_mon.exit();
            return tRTrackerServerTorrentImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrentImpl getTorrent(String link) {
        try {
            this.class_mon.enter();
            TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl = (TRTrackerServerTorrentImpl)link_map.get(link);
            Object var4_3 = null;
            this.class_mon.exit();
            return tRTrackerServerTorrentImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerTorrentImpl[] getTorrents() {
        try {
            this.class_mon.enter();
            TRTrackerServerTorrentImpl[] res = new TRTrackerServerTorrentImpl[torrent_map.size()];
            torrent_map.values().toArray(res);
            TRTrackerServerTorrentImpl[] tRTrackerServerTorrentImplArray = res;
            Object var4_3 = null;
            this.class_mon.exit();
            return tRTrackerServerTorrentImplArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.class_mon.exit();
            throw throwable;
        }
    }

    public int getTorrentCount() {
        return torrent_map.size();
    }

    public TRTrackerServerTorrentStats getStats(byte[] hash) {
        TRTrackerServerTorrentImpl torrent = this.getTorrent(hash);
        if (torrent == null) {
            return null;
        }
        return torrent.getStats();
    }

    public TRTrackerServerPeer[] getPeers(byte[] hash) {
        TRTrackerServerTorrentImpl torrent = this.getTorrent(hash);
        if (torrent == null) {
            return null;
        }
        return torrent.getPeers();
    }

    public void addListener(TRTrackerServerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(TRTrackerServerListener l) {
        this.listeners.remove(l);
    }

    public void addListener2(TRTrackerServerListener2 l) {
        this.listeners2.add(l);
    }

    public void removeListener2(TRTrackerServerListener2 l) {
        this.listeners2.remove(l);
    }

    public void addAuthenticationListener(TRTrackerServerAuthenticationListener l) {
        this.auth_listeners.add(l);
    }

    public void removeAuthenticationListener(TRTrackerServerAuthenticationListener l) {
        this.auth_listeners.remove(l);
    }

    public void preProcess(TRTrackerServerPeer peer, TRTrackerServerTorrent torrent, int type, String request2, Map response) throws TRTrackerServerException {
        if (this.request_listeners.size() > 0) {
            if (type == 2) {
                try {
                    int request_pos = 10;
                    while (true) {
                        String bit;
                        int p;
                        if ((p = request2.indexOf("info_hash=", request_pos)) == -1) {
                            if (request_pos == 10) break;
                            bit = request2.substring(request_pos);
                        } else {
                            bit = request2.substring(request_pos, p);
                        }
                        int pos = bit.indexOf(38);
                        String hash_str = pos == -1 ? bit : bit.substring(0, pos);
                        hash_str = URLDecoder.decode(hash_str, "ISO-8859-1");
                        byte[] hash = hash_str.getBytes("ISO-8859-1");
                        if (Arrays.equals(hash, torrent.getHash().getBytes())) {
                            request2 = "info_hash=" + bit;
                            if (request2.endsWith("&")) {
                                request2 = request2.substring(0, request2.length() - 1);
                            }
                        } else if (p != -1) {
                            request_pos = p + 10;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            TRTrackerServerRequestImpl req = new TRTrackerServerRequestImpl(this, peer, torrent, type, request2, response);
            for (int i = 0; i < this.request_listeners.size(); ++i) {
                try {
                    this.request_listeners.elementAt(i).preProcess(req);
                    continue;
                }
                catch (TRTrackerServerException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void postProcess(TRTrackerServerPeer peer, TRTrackerServerTorrentImpl torrent, int type, String request2, Map response) throws TRTrackerServerException {
        if (this.request_listeners.size() > 0) {
            TRTrackerServerRequestImpl req = new TRTrackerServerRequestImpl(this, peer, torrent, type, request2, response);
            for (int i = 0; i < this.request_listeners.size(); ++i) {
                try {
                    this.request_listeners.elementAt(i).postProcess(req);
                    continue;
                }
                catch (TRTrackerServerException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void addRequestListener(TRTrackerServerRequestListener l) {
        this.request_listeners.addElement(l);
    }

    public void removeRequestListener(TRTrackerServerRequestListener l) {
        this.request_listeners.removeElement(l);
    }

    public void close() {
        TRTrackerServerFactoryImpl.close(this);
    }

    protected abstract void closeSupport();

    protected void destroySupport() {
        this.destroyed = true;
        COConfigurationManager.removeListener(this.config_listener);
    }

    static {
        redirect_on_not_found = "";
        torrent_map = new HashMap();
        link_map = new HashMap();
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerServerImpl.readConfig();
            }
        });
        TRTrackerServerImpl.readConfig();
    }
}

