/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.dht;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.dht.TRTrackerDHTScraperResponseImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public class TRTrackerDHTScraperImpl {
    protected static TRTrackerDHTScraperImpl singleton;
    protected static AEMonitor class_mon;
    private TRTrackerScraperImpl scraper;
    private Map<HashWrapper, TRTrackerDHTScraperResponseImpl> responses = new HashMap<HashWrapper, TRTrackerDHTScraperResponseImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerDHTScraperImpl create(TRTrackerScraperImpl _scraper) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRTrackerDHTScraperImpl(_scraper);
            }
            TRTrackerDHTScraperImpl tRTrackerDHTScraperImpl = singleton;
            Object var3_2 = null;
            class_mon.exit();
            return tRTrackerDHTScraperImpl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected TRTrackerDHTScraperImpl(TRTrackerScraperImpl _scraper) {
        this.scraper = _scraper;
    }

    public void setScrape(TOTorrent torrent, URL url, DownloadScrapeResult result) {
        if (torrent != null && result != null) {
            try {
                TRTrackerDHTScraperResponseImpl resp = new TRTrackerDHTScraperResponseImpl(torrent.getHashWrapper(), result.getURL());
                resp.setSeedsPeers(result.getSeedCount(), result.getNonSeedCount());
                resp.setScrapeStartTime(result.getScrapeStartTime());
                resp.setNextScrapeStartTime(result.getNextScrapeStartTime());
                resp.setStatus(result.getResponseType() == 1 ? 2 : 1, result.getStatus());
                this.responses.put(torrent.getHashWrapper(), resp);
                this.scraper.scrapeReceived(resp);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, URL unused_target_url, boolean unused_force) {
        if (torrent != null) {
            try {
                int[] cache;
                TRTrackerScraperClientResolver resolver;
                HashWrapper hw = torrent.getHashWrapper();
                TRTrackerDHTScraperResponseImpl response = this.responses.get(hw);
                if (response == null && (resolver = this.scraper.getClientResolver()) != null && (cache = resolver.getCachedScrape(hw)) != null) {
                    response = new TRTrackerDHTScraperResponseImpl(hw, torrent.getAnnounceURL());
                    response.setSeedsPeers(cache[0], cache[1]);
                    long now = SystemTime.getCurrentTime();
                    response.setScrapeStartTime(now);
                    response.setNextScrapeStartTime(now + 300000L);
                    response.setStatus(2, MessageText.getString("Scrape.status.cached"));
                    this.responses.put(torrent.getHashWrapper(), response);
                    this.scraper.scrapeReceived(response);
                }
                return response;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public TRTrackerScraperResponse peekScrape(TOTorrent torrent, URL unused_target_url) {
        if (torrent != null) {
            try {
                HashWrapper hw = torrent.getHashWrapper();
                return this.responses.get(hw);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public TRTrackerScraperResponse scrape(TRTrackerAnnouncer tracker_client) {
        return this.scrape(tracker_client.getTorrent(), null, false);
    }

    public void remove(TOTorrent torrent) {
        try {
            this.responses.remove(torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    static {
        class_mon = new AEMonitor("TRTrackerDHTScraper");
    }
}

