/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class IpFilterAutoLoaderImpl {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String CFG_AUTOLOAD_LAST = "Ip Filter Autoload Last Date";
    public static final String CFG_AUTOLOAD_FILE = "Ip Filter Autoload File";
    private static AEMonitor class_mon = new AEMonitor("IpFilterAutoLoaderImpl:class");
    private Object timerEventFilterReload;
    private final IpFilterImpl ipFilter;

    public IpFilterAutoLoaderImpl(IpFilterImpl ipFilter) {
        this.ipFilter = ipFilter;
        COConfigurationManager.setLongDefault(CFG_AUTOLOAD_LAST, 0L);
        COConfigurationManager.setStringDefault(CFG_AUTOLOAD_FILE, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadDATFilters(InputStream fin) {
        try {
            block41: {
                Throwable e322;
                BufferedReader reader;
                InputStreamReader streamReader;
                ArrayList<IpRangeImpl> new_ipRanges;
                block39: {
                    String line;
                    class_mon.enter();
                    new_ipRanges = new ArrayList<IpRangeImpl>(1024);
                    streamReader = null;
                    reader = null;
                    Pattern pattern = Pattern.compile("^(.*):([0-9\\.]+)[^0-9]+([0-9\\.]+).*");
                    int parseMode = -1;
                    streamReader = new InputStreamReader(fin, "utf8");
                    reader = new BufferedReader(streamReader);
                    int numConsecutiveUnknowns = 0;
                    while (numConsecutiveUnknowns < 1000 && (line = reader.readLine()) != null) {
                        if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                        String description = "";
                        String startIp = null;
                        String endIp = null;
                        int level = 0;
                        if (parseMode <= 0 || parseMode == 1) {
                            Matcher matcher = pattern.matcher(line);
                            if (matcher.find()) {
                                if (parseMode != 1) {
                                    parseMode = 1;
                                }
                                description = matcher.group(1);
                                startIp = matcher.group(2);
                                endIp = matcher.group(3);
                            } else {
                                Logger.log(new LogEvent(LOGID, 1, "unrecognized line while reading ip filter: " + line));
                            }
                        }
                        if (parseMode != 1) {
                            String[] sections;
                            if (parseMode != 2) {
                                parseMode = 2;
                            }
                            if ((sections = line.split(" *[-,] *", 4)).length >= 2 && (sections[0].indexOf(46) < 0 || sections[1].indexOf(46) < 0 || sections[0].length() > 15 || sections[1].length() > 15 || sections[0].length() < 7 || sections[1].length() < 7)) {
                                ++numConsecutiveUnknowns;
                                continue;
                            }
                            if (sections.length >= 4) {
                                startIp = sections[0];
                                endIp = sections[1];
                                description = sections[3];
                                try {
                                    level = Integer.parseInt(sections[2]);
                                }
                                catch (NumberFormatException e2) {
                                    description = sections[2] + " " + description;
                                }
                                for (int i = 4; i < sections.length; ++i) {
                                    description = description + " " + sections[i];
                                }
                                numConsecutiveUnknowns = 0;
                            } else if (sections.length == 3) {
                                startIp = sections[0];
                                endIp = sections[1];
                                description = sections[2];
                                numConsecutiveUnknowns = 0;
                            } else if (sections.length == 2) {
                                startIp = sections[0];
                                endIp = sections[1];
                                numConsecutiveUnknowns = 0;
                            } else {
                                ++numConsecutiveUnknowns;
                                continue;
                            }
                            if (level >= 128) continue;
                        }
                        if (startIp == null || endIp == null) continue;
                        IpRangeImpl ipRange = new IpRangeImpl(description, startIp, endIp, true);
                        ipRange.setAddedToRangeList(true);
                        new_ipRanges.add(ipRange);
                    }
                    Object var16_17 = null;
                    if (reader == null) break block39;
                    try {
                        reader.close();
                    }
                    catch (Throwable e322) {
                        // empty catch block
                    }
                }
                if (streamReader != null) {
                    try {
                        streamReader.close();
                    }
                    catch (Throwable e322) {
                        // empty catch block
                    }
                }
                Iterator it = new_ipRanges.iterator();
                while (it.hasNext()) {
                    ((IpRange)it.next()).checkValid();
                }
                this.ipFilter.markAsUpToDate();
                {
                    break block41;
                    catch (IOException e4) {
                        Throwable e322;
                        Debug.out(e4);
                        Object var16_18 = null;
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable e322) {
                                // empty catch block
                            }
                        }
                        if (streamReader != null) {
                            try {
                                streamReader.close();
                            }
                            catch (Throwable e322) {
                                // empty catch block
                            }
                        }
                        it = new_ipRanges.iterator();
                        while (it.hasNext()) {
                            ((IpRange)it.next()).checkValid();
                        }
                        this.ipFilter.markAsUpToDate();
                    }
                }
                catch (Throwable throwable) {
                    Throwable e322;
                    Object var16_19 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable e322) {
                            // empty catch block
                        }
                    }
                    if (streamReader != null) {
                        try {
                            streamReader.close();
                        }
                        catch (Throwable e322) {
                            // empty catch block
                        }
                    }
                    it = new_ipRanges.iterator();
                    while (it.hasNext()) {
                        ((IpRange)it.next()).checkValid();
                    }
                    this.ipFilter.markAsUpToDate();
                    throw throwable;
                }
            }
            Object var19_24 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    private int getP2BFileVersion(InputStream is) {
        try {
            for (int i = 0; i < 4; ++i) {
                int byteRead = is.read();
                if (byteRead == 255) continue;
                return -1;
            }
            byte[] MAGIC = new byte[]{80, 50, 66};
            for (int i = 0; i < MAGIC.length; ++i) {
                byte b = MAGIC[i];
                if (b == is.read()) continue;
                return -1;
            }
            int p2bVersion = is.read();
            Logger.log(new LogEvent(LOGID, "Log Filter: loading p2b version " + p2bVersion));
            return p2bVersion;
        }
        catch (IOException e) {
            Debug.out(e);
            return -1;
        }
    }

    /*
     * Exception decompiling
     */
    protected void loadOtherFilters(boolean allowAsyncDownloading, boolean loadOldWhileAsyncDownloading) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 56[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setFileReloadTimer() {
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addPeriodicEvent("IP Filter download", 60000L, new TimerEventPerformer(){
            long lastFileModified;

            public void perform(TimerEvent event2) {
                event2.cancel();
                String file = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                File filtersFile = new File(file);
                if (!filtersFile.exists()) {
                    return;
                }
                long fileModified = filtersFile.lastModified();
                if (this.lastFileModified == 0L) {
                    this.lastFileModified = fileModified;
                } else if (this.lastFileModified != fileModified) {
                    try {
                        IpFilterAutoLoaderImpl.this.ipFilter.reload();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void downloadFiltersAsync(URL url) {
        ResourceDownloader rd = ResourceDownloaderFactoryImpl.getSingleton().create(url);
        rd.addListener(new ResourceDownloaderAdapter(){

            public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean completed(ResourceDownloader downloader, InputStream data) {
                try {
                    IpFilterAutoLoaderImpl.this.setNextAutoDownload(true);
                    Logger.log(new LogEvent(LOGID, "downloaded..waiting"));
                    class_mon.enter();
                    Logger.log(new LogEvent(LOGID, "downloaded.. copying"));
                    try {
                        FileUtil.copyFile(data, FileUtil.getUserFile("ipfilter.dl"));
                        AEThread thread = new AEThread("reload ipfilters", true){

                            public void runSupport() {
                                try {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.setStatusText("Reloading Filters..");
                                    }
                                    IpFilterAutoLoaderImpl.this.ipFilter.reload(false);
                                    if (uif != null) {
                                        uif.setStatusText(null);
                                    }
                                }
                                catch (Exception e) {
                                    Debug.out(e);
                                }
                            }
                        };
                        thread.setPriority(4);
                        thread.start();
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                    Object var5_5 = null;
                    class_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    class_mon.exit();
                    throw throwable;
                }
                return true;
            }
        });
        rd.asyncDownload();
    }

    public void setNextAutoDownload(boolean updateLastDownloadedDate) {
        long lastDL;
        long now = SystemTime.getCurrentTime();
        if (updateLastDownloadedDate) {
            COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, now);
            lastDL = now;
        } else {
            lastDL = COConfigurationManager.getLongParameter(CFG_AUTOLOAD_LAST);
            if (lastDL > now) {
                lastDL = now;
                COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, now);
            }
        }
        long nextDL = lastDL + 604800000L;
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addEvent("IP Filter download", nextDL, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                String file = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                try {
                    IpFilterAutoLoaderImpl.this.downloadFiltersAsync(new URL(file));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
    }

    private String readString(BufferedInputStream bin, byte[] descBytes, String encoding) {
        int pos = 0;
        try {
            int byteRead;
            while ((byteRead = bin.read()) >= 0) {
                if (pos < descBytes.length) {
                    descBytes[pos] = (byte)byteRead;
                    ++pos;
                }
                if (byteRead != 0) continue;
                break;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (pos > 1) {
            try {
                return new String(descBytes, 0, pos - 1, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return "";
    }
}

