/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk;

import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrent;

public class DiskManagerFactory {
    public static DiskManager create(TOTorrent torrent, DownloadManager manager) {
        DiskManagerImpl dm = new DiskManagerImpl(torrent, manager);
        if (dm.getState() != 10) {
            dm.start();
        }
        return dm;
    }

    public static void setResumeDataCompletelyValid(DownloadManagerState download_manager_state) {
        RDResumeHandler.setTorrentResumeDataComplete(download_manager_state);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState dms) {
        RDResumeHandler.setTorrentResumeDataNearlyComplete(dms);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState dms) {
        return RDResumeHandler.isTorrentResumeDataComplete(dms);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file, boolean force_no_recycle) {
        DiskManagerImpl.deleteDataFiles(torrent, torrent_save_dir, torrent_save_file, force_no_recycle);
    }

    public static DiskManagerFileInfoSet getFileInfoSkeleton(DownloadManager download_manager, DiskManagerListener listener) {
        return DiskManagerUtil.getFileInfoSkeleton(download_manager, listener);
    }

    public static void setFileLinks(DownloadManager download_manager, CaseSensitiveFileMap links) {
        DiskManagerImpl.setFileLinks(download_manager, links);
    }

    public static void clearResumeData(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.clearResumeData(download_manager, file);
    }

    public static void recheckFile(DownloadManager download_manager, DiskManagerFileInfo file) {
        RDResumeHandler.recheckFile(download_manager, file);
    }
}

