/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.params.DHParameters;

public class DHParametersGenerator {
    private int size;
    private int certainty;
    private SecureRandom random;
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private static BigInteger TWO = BigInteger.valueOf(2L);

    public void init(int size, int certainty, SecureRandom random) {
        this.size = size;
        this.certainty = certainty;
        this.random = random;
    }

    public DHParameters generateParameters() {
        BigInteger g;
        BigInteger q;
        BigInteger p;
        int qLength = this.size - 1;
        while (!(p = (q = new BigInteger(qLength, this.certainty, this.random)).multiply(TWO).add(ONE)).isProbablePrime(this.certainty)) {
        }
        while ((g = new BigInteger(qLength, this.random)).modPow(TWO, p).equals(ONE) || g.modPow(q, p).equals(ONE)) {
        }
        return new DHParameters(p, g, q, 2);
    }
}

