/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.services;

import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPActionArgument;
import com.aelitis.net.upnp.UPnPActionInvocation;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.services.UPnPServiceImpl;
import com.aelitis.net.upnp.services.UPnPOfflineDownloader;

public class UPnPSSOfflineDownloaderImpl
implements UPnPOfflineDownloader {
    private UPnPServiceImpl service;

    protected UPnPSSOfflineDownloaderImpl(UPnPServiceImpl _service) {
        this.service = _service;
    }

    public UPnPService getGenericService() {
        return this.service;
    }

    public long getFreeSpace(String client_id) throws UPnPException {
        UPnPAction act = this.service.getAction("GetFreeSpace");
        if (act == null) {
            throw new UPnPException("GetFreeSpace not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        UPnPActionArgument[] args = inv.invoke();
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (!name.equalsIgnoreCase("NewFreeSpace")) continue;
            return Long.parseLong(arg.getValue());
        }
        throw new UPnPException("result not found");
    }

    public void activate(String client_id) throws UPnPException {
        UPnPAction act = this.service.getAction("Activate");
        if (act == null) {
            throw new UPnPException("Activate not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        UPnPActionArgument[] args = inv.invoke();
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (!name.equalsIgnoreCase("NewStatus")) continue;
            return;
        }
        throw new UPnPException("status not found");
    }

    public String[] setDownloads(String client_id, String hash_list) throws UPnPException {
        UPnPAction act = this.service.getAction("SetDownloads");
        if (act == null) {
            throw new UPnPException("SetDownloads not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHashList", hash_list);
        UPnPActionArgument[] args = inv.invoke();
        String result = null;
        String status = null;
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewSetDownloadsResultList")) {
                result = arg.getValue();
                continue;
            }
            if (!name.equalsIgnoreCase("NewStatus")) continue;
            status = arg.getValue();
        }
        if (result != null && status != null) {
            return new String[]{result, status};
        }
        throw new UPnPException("result or status not found");
    }

    public String addDownload(String client_id, String hash, String torrent) throws UPnPException {
        UPnPAction act = this.service.getAction("AddDownload");
        if (act == null) {
            throw new UPnPException("AddDownload not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        inv.addArgument("NewTorrentData", torrent);
        UPnPActionArgument[] args = inv.invoke();
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (!name.equalsIgnoreCase("NewStatus")) continue;
            return arg.getValue();
        }
        throw new UPnPException("result not found");
    }

    public String addDownloadChunked(String client_id, String hash, String chunk, int offset, int total_size) throws UPnPException {
        UPnPAction act = this.service.getAction("AddDownloadChunked");
        if (act == null) {
            throw new UPnPException("AddDownloadChunked not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        inv.addArgument("NewTorrentData", chunk);
        inv.addArgument("NewChunkOffset", String.valueOf(offset));
        inv.addArgument("NewTotalLength", String.valueOf(total_size));
        UPnPActionArgument[] args = inv.invoke();
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (!name.equalsIgnoreCase("NewStatus")) continue;
            return arg.getValue();
        }
        throw new UPnPException("result not found");
    }

    public String[] updateDownload(String client_id, String hash, String required_map) throws UPnPException {
        UPnPAction act = this.service.getAction("UpdateDownload");
        if (act == null) {
            throw new UPnPException("UpdateDownload not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        inv.addArgument("NewPieceRequiredMap", required_map);
        UPnPActionArgument[] args = inv.invoke();
        String have = null;
        String status = null;
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewPieceHaveMap")) {
                have = arg.getValue();
                continue;
            }
            if (!name.equalsIgnoreCase("NewStatus")) continue;
            status = arg.getValue();
        }
        if (have != null && status != null) {
            return new String[]{have, status};
        }
        throw new UPnPException("have or status not found");
    }

    public String removeDownload(String client_id, String hash) throws UPnPException {
        UPnPAction act = this.service.getAction("RemoveDownload");
        if (act == null) {
            throw new UPnPException("RemoveDownload not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        UPnPActionArgument[] args = inv.invoke();
        String status = null;
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (!name.equalsIgnoreCase("NewStatus")) continue;
            status = arg.getValue();
        }
        if (status != null) {
            return status;
        }
        throw new UPnPException("status not found");
    }

    public String[] startDownload(String client_id, String hash) throws UPnPException {
        UPnPAction act = this.service.getAction("StartDownload");
        if (act == null) {
            throw new UPnPException("StartDownload not supported");
        }
        UPnPActionInvocation inv = act.getInvocation();
        inv.addArgument("NewClientID", client_id);
        inv.addArgument("NewTorrentHash", hash);
        UPnPActionArgument[] args = inv.invoke();
        String status = null;
        String data_port = null;
        for (int i = 0; i < args.length; ++i) {
            UPnPActionArgument arg = args[i];
            String name = arg.getName();
            if (name.equalsIgnoreCase("NewStatus")) {
                status = arg.getValue();
                continue;
            }
            if (!name.equalsIgnoreCase("NewDataPort")) continue;
            data_port = arg.getValue();
        }
        if (status != null && data_port != null) {
            return new String[]{data_port, status};
        }
        throw new UPnPException("status or data port not found");
    }
}

