/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl;

import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPLogListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPSSDP;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.SSDPIGD;
import com.aelitis.net.upnp.impl.SSDPIGDFactory;
import com.aelitis.net.upnp.impl.SSDPIGDListener;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;

public class UPnPImpl
extends ResourceDownloaderAdapter
implements UPnP,
SSDPIGDListener {
    public static final String NL = "\r\n";
    private static UPnPImpl singleton;
    private static AEMonitor class_mon;
    private UPnPAdapter adapter;
    private SSDPIGD ssdp;
    private Map<String, UPnPRootDeviceImpl> root_locations = new HashMap<String, UPnPRootDeviceImpl>();
    private List log_listeners = new ArrayList();
    private List log_history = new ArrayList();
    private List log_alert_history = new ArrayList();
    private List rd_listeners = new ArrayList();
    private AEMonitor rd_listeners_mon = new AEMonitor("UPnP:L");
    private int http_calls_ok = 0;
    private int direct_calls_ok = 0;
    private int trace_index = 0;
    private ThreadPool device_dispatcher = new ThreadPool("UPnPDispatcher", 1, true);
    private Set device_dispatcher_pending = new HashSet();
    private Map<String, long[]> failed_urls = new HashMap<String, long[]>();
    protected AEMonitor this_mon = new AEMonitor("UPnP");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UPnP getSingleton(UPnPAdapter adapter, String[] selected_interfaces) throws UPnPException {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new UPnPImpl(adapter, selected_interfaces);
            }
            UPnPImpl uPnPImpl = singleton;
            Object var4_3 = null;
            class_mon.exit();
            return uPnPImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected UPnPImpl(UPnPAdapter _adapter, String[] _selected_interfaces) throws UPnPException {
        this.adapter = _adapter;
        this.ssdp = SSDPIGDFactory.create(this, _selected_interfaces);
        this.ssdp.addListener(this);
        this.ssdp.start();
    }

    public UPnPSSDP getSSDP() {
        return this.ssdp.getSSDP();
    }

    public void injectDiscoveryCache(Map cache) {
        try {
            String ni_s = new String((byte[])cache.get("ni"), "UTF-8");
            String la_s = new String((byte[])cache.get("la"), "UTF-8");
            String usn = new String((byte[])cache.get("usn"), "UTF-8");
            String loc_s = new String((byte[])cache.get("loc"), "UTF-8");
            NetworkInterface network_interface = NetworkInterface.getByName(ni_s);
            if (network_interface == null) {
                return;
            }
            InetAddress local_address = InetAddress.getByName(la_s);
            URL location = new URL(loc_s);
            this.rootDiscovered(network_interface, local_address, usn, location);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rootDiscovered(final NetworkInterface network_interface, final InetAddress local_address, final String usn, final URL location) {
        try {
            this.rd_listeners_mon.enter();
            if (this.device_dispatcher_pending.contains(usn)) {
                Object var6_5 = null;
                this.rd_listeners_mon.exit();
                return;
            }
            if (this.device_dispatcher_pending.size() > 512) {
                Debug.out("Device dispatcher queue is full - dropping discovery of " + usn + "/" + location);
            }
            this.device_dispatcher_pending.add(usn);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.rd_listeners_mon.exit();
            throw throwable;
        }
        Object var6_6 = null;
        this.rd_listeners_mon.exit();
        this.device_dispatcher.run(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                ArrayList listeners;
                UPnPRootDeviceImpl old_root_device;
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    old_root_device = (UPnPRootDeviceImpl)UPnPImpl.this.root_locations.get(usn);
                    UPnPImpl.this.device_dispatcher_pending.remove(usn);
                    Object var3_2 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                    throw throwable;
                }
                if (old_root_device != null) {
                    if (!old_root_device.getNetworkInterface().getName().equals(network_interface.getName())) {
                        return;
                    }
                    if (old_root_device.getLocation().equals(location)) {
                        return;
                    }
                }
                if (old_root_device != null) {
                    try {
                        UPnPImpl.this.rd_listeners_mon.enter();
                        UPnPImpl.this.root_locations.remove(usn);
                        Object var5_9 = null;
                        UPnPImpl.this.rd_listeners_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        UPnPImpl.this.rd_listeners_mon.exit();
                        throw throwable;
                    }
                    old_root_device.destroy(true);
                }
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    listeners = new ArrayList(UPnPImpl.this.rd_listeners);
                    Object var7_16 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var7_17 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                    throw throwable;
                }
                for (int i = 0; i < listeners.size(); ++i) {
                    try {
                        if (((UPnPListener)listeners.get(i)).deviceDiscovered(usn, location)) continue;
                        return;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                UPnPImpl.this.log("UPnP: root discovered: usn=" + usn + ", location=" + location + ", ni=" + network_interface.getName() + ",local=" + local_address.toString());
                try {
                    UPnPRootDeviceImpl new_root_device = new UPnPRootDeviceImpl(UPnPImpl.this, network_interface, local_address, usn, location);
                    try {
                        UPnPImpl.this.rd_listeners_mon.enter();
                        UPnPImpl.this.root_locations.put(usn, new_root_device);
                        listeners = new ArrayList(UPnPImpl.this.rd_listeners);
                        Object var9_19 = null;
                        UPnPImpl.this.rd_listeners_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var9_20 = null;
                        UPnPImpl.this.rd_listeners_mon.exit();
                        throw throwable;
                    }
                    for (int i = 0; i < listeners.size(); ++i) {
                        try {
                            ((UPnPListener)listeners.get(i)).rootDeviceFound(new_root_device);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                catch (UPnPException e) {
                    String message = e.getMessage();
                    String msg = message == null ? Debug.getNestedExceptionMessageAndStack(e) : message;
                    UPnPImpl.this.adapter.log(msg);
                }
            }
        });
    }

    public void rootAlive(String usn, URL location) {
        UPnPRootDeviceImpl root_device = this.root_locations.get(usn);
        if (root_device == null) {
            this.ssdp.searchNow();
        }
    }

    public void rootLost(InetAddress local_address, final String usn) {
        this.device_dispatcher.run(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                UPnPRootDeviceImpl root_device = null;
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    root_device = (UPnPRootDeviceImpl)UPnPImpl.this.root_locations.remove(usn);
                    Object var3_2 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                    throw throwable;
                }
                if (root_device == null) {
                    return;
                }
                UPnPImpl.this.log("UPnP: root lost: usn=" + usn + ", location=" + root_device.getLocation() + ", ni=" + root_device.getNetworkInterface().getName() + ",local=" + root_device.getLocalAddress().toString());
                root_device.destroy(false);
            }
        });
    }

    public void interfaceChanged(NetworkInterface network_interface) {
        this.reset();
    }

    public void search() {
        this.ssdp.searchNow();
    }

    public void search(String[] STs) {
        this.ssdp.searchNow(STs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<UPnPRootDeviceImpl> roots;
        this.log("UPnP: reset");
        try {
            this.rd_listeners_mon.enter();
            roots = new ArrayList<UPnPRootDeviceImpl>(this.root_locations.values());
            this.root_locations.clear();
            Object var3_2 = null;
            this.rd_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.rd_listeners_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < roots.size(); ++i) {
            ((UPnPRootDeviceImpl)roots.get(i)).destroy(true);
        }
        this.ssdp.searchNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleXMLParserDocument parseXML(InputStream _is) throws SimpleXMLParserDocumentException, IOException {
        ByteArrayOutputStream baos = null;
        try {
            int len;
            baos = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[8192];
            while ((len = _is.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            baos.close();
            throw throwable;
        }
        baos.close();
        byte[] bytes_in = baos.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes_in);
        try {
            String line;
            StringBuffer data = new StringBuffer(1024);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)is, "UTF-8"));
            HashSet<Character> ignore_map = null;
            while ((line = lnr.readLine()) != null) {
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (c < ' ' && c != '\r' && c != '\t') {
                        Character cha;
                        data.append(' ');
                        if (ignore_map == null) {
                            ignore_map = new HashSet<Character>();
                        }
                        if (ignore_map.contains(cha = new Character(c))) continue;
                        ignore_map.add(cha);
                        this.adapter.trace("    ignoring character(s) " + c + " in xml response");
                        continue;
                    }
                    data.append(c);
                }
                data.append("\n");
            }
            String data_str = data.toString();
            this.adapter.trace("UPnP:Response:" + data_str);
            return this.adapter.parseXML(data_str);
        }
        catch (Throwable e) {
            try {
                FileOutputStream trace = new FileOutputStream(this.getTraceFile());
                trace.write(bytes_in);
                trace.close();
            }
            catch (Throwable f) {
                this.adapter.log(f);
            }
            if (e instanceof SimpleXMLParserDocumentException) {
                throw (SimpleXMLParserDocumentException)e;
            }
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public SimpleXMLParserDocument downloadXML(UPnPRootDeviceImpl root, URL url) throws UPnPException {
        return this.downloadXMLSupport(null, url);
    }

    public SimpleXMLParserDocument downloadXML(UPnPDeviceImpl device, URL url) throws UPnPException {
        try {
            if (device != null) {
                device.restoreRelativeBaseURL();
            }
            return this.downloadXMLSupport(device.getFriendlyName(), url);
        }
        catch (UPnPException e) {
            if (device != null) {
                device.clearRelativeBaseURL();
                return this.downloadXMLSupport(device.getFriendlyName(), url);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SimpleXMLParserDocument downloadXMLSupport(String friendly_name, URL url) throws UPnPException {
        Object object;
        String url_str = url.toExternalForm();
        boolean record_failure = true;
        try {
            try {
                int retries;
                TorrentUtils.setTLSDescription("UPnP Device" + (friendly_name == null ? "" : ": " + friendly_name));
                ResourceDownloaderFactory rdf = this.adapter.getResourceDownloaderFactory();
                Map<String, long[]> map = this.failed_urls;
                synchronized (map) {
                    long[] fails = this.failed_urls.get(url_str);
                    if (fails == null) {
                        retries = 3;
                    } else {
                        long consec_fails = fails[0];
                        long last_fail = fails[1];
                        long max_period = 600000L;
                        long period = 60000L;
                        int i = 0;
                        while ((long)i < consec_fails) {
                            if ((period <<= 1) >= max_period) {
                                period = max_period;
                                break;
                            }
                            ++i;
                        }
                        if (SystemTime.getMonotonousTime() - last_fail < period) {
                            record_failure = false;
                            throw new UPnPException("Download failed too recently, ignoring");
                        }
                        retries = 1;
                    }
                }
                ResourceDownloader rd = rdf.getRetryDownloader(rdf.create(url, true), retries);
                rd.addListener(this);
                InputStream data = rd.download();
                try {
                    SimpleXMLParserDocument res = this.parseXML(data);
                    object = this.failed_urls;
                    synchronized (object) {
                        this.failed_urls.remove(url_str);
                    }
                    object = res;
                    Object var21_19 = null;
                }
                catch (Throwable throwable) {
                    Object var21_20 = null;
                    data.close();
                    throw throwable;
                }
                data.close();
                Object var24_21 = null;
            }
            catch (Throwable e) {
                if (record_failure) {
                    Map<String, long[]> map = this.failed_urls;
                    synchronized (map) {
                        long[] fails;
                        if (this.failed_urls.size() >= 64) {
                            this.failed_urls.clear();
                        }
                        if ((fails = this.failed_urls.get(url_str)) == null) {
                            fails = new long[2];
                            this.failed_urls.put(url_str, fails);
                        }
                        fails[0] = fails[0] + 1L;
                        fails[1] = SystemTime.getMonotonousTime();
                    }
                    this.adapter.log(Debug.getNestedExceptionMessageAndStack(e));
                }
                if (!(e instanceof UPnPException)) throw new UPnPException("Root device location '" + url + "' - data read failed", e);
                throw (UPnPException)e;
            }
        }
        catch (Throwable throwable) {
            Object var24_22 = null;
            TorrentUtils.setTLSDescription(null);
            throw throwable;
        }
        TorrentUtils.setTLSDescription(null);
        return object;
    }

    protected boolean forceDirect() {
        String http_proxy = System.getProperty("http.proxyHost");
        String socks_proxy = System.getProperty("socksProxyHost");
        boolean force_direct = http_proxy != null && http_proxy.trim().length() > 0 || socks_proxy != null && socks_proxy.trim().length() > 0;
        return force_direct;
    }

    public SimpleXMLParserDocument performSOAPRequest(UPnPService service, String soap_action, String request2) throws SimpleXMLParserDocumentException, UPnPException, IOException {
        SimpleXMLParserDocument res;
        block4: {
            if (service.getDirectInvocations() || this.forceDirect()) {
                res = this.performSOAPRequest(service, soap_action, request2, false);
            } else {
                try {
                    res = this.performSOAPRequest(service, soap_action, request2, true);
                    ++this.http_calls_ok;
                }
                catch (IOException e) {
                    res = this.performSOAPRequest(service, soap_action, request2, false);
                    ++this.direct_calls_ok;
                    if (this.direct_calls_ok != 1) break block4;
                    this.log("Invocation via http connection failed (" + e.getMessage() + ") but socket connection succeeded");
                }
            }
        }
        return res;
    }

    /*
     * Exception decompiling
     */
    public SimpleXMLParserDocument performSOAPRequest(UPnPService service, String soap_action, String request, boolean use_http_connection) throws SimpleXMLParserDocumentException, UPnPException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getTraceFile() {
        try {
            this.this_mon.enter();
            ++this.trace_index;
            if (this.trace_index == 6) {
                this.trace_index = 1;
            }
            File file = new File(this.adapter.getTraceDir(), "upnp_trace" + this.trace_index + ".log");
            Object var3_2 = null;
            this.this_mon.exit();
            return file;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UPnPAdapter getAdapter() {
        return this.adapter;
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
        this.log(activity);
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.log(e);
    }

    public void log(Throwable e) {
        this.log(e.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String str) {
        ArrayList old_listeners;
        try {
            this.this_mon.enter();
            old_listeners = new ArrayList(this.log_listeners);
            this.log_history.add(str);
            if (this.log_history.size() > 32) {
                this.log_history.remove(0);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < old_listeners.size(); ++i) {
            ((UPnPLogListener)old_listeners.get(i)).log(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAlert(String str, boolean error, int type) {
        ArrayList old_listeners;
        try {
            this.this_mon.enter();
            old_listeners = new ArrayList(this.log_listeners);
            this.log_alert_history.add(new Object[]{str, new Boolean(error), new Integer(type)});
            if (this.log_alert_history.size() > 32) {
                this.log_alert_history.remove(0);
            }
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < old_listeners.size(); ++i) {
            ((UPnPLogListener)old_listeners.get(i)).logAlert(str, error, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(UPnPLogListener l) {
        int i;
        ArrayList old_alerts;
        ArrayList old_logs;
        try {
            this.this_mon.enter();
            old_logs = new ArrayList(this.log_history);
            old_alerts = new ArrayList(this.log_alert_history);
            this.log_listeners.add(l);
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (i = 0; i < old_logs.size(); ++i) {
            l.log((String)old_logs.get(i));
        }
        for (i = 0; i < old_alerts.size(); ++i) {
            Object[] entry = (Object[])old_alerts.get(i);
            l.logAlert((String)entry[0], (Boolean)entry[1], (Integer)entry[2]);
        }
    }

    public void removeLogListener(UPnPLogListener l) {
        this.log_listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPRootDevice[] getRootDevices() {
        try {
            this.this_mon.enter();
            UPnPRootDevice[] uPnPRootDeviceArray = this.root_locations.values().toArray(new UPnPRootDevice[this.root_locations.size()]);
            Object var3_2 = null;
            this.this_mon.exit();
            return uPnPRootDeviceArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRootDeviceListener(UPnPListener l) {
        ArrayList<UPnPRootDeviceImpl> old_locations;
        try {
            this.this_mon.enter();
            old_locations = new ArrayList<UPnPRootDeviceImpl>(this.root_locations.values());
            this.rd_listeners.add(l);
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < old_locations.size(); ++i) {
            UPnPRootDevice device = (UPnPRootDevice)old_locations.get(i);
            try {
                if (!l.deviceDiscovered(device.getUSN(), device.getLocation())) continue;
                l.rootDeviceFound(device);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRootDeviceListener(UPnPListener l) {
        try {
            this.this_mon.enter();
            this.rd_listeners.remove(l);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    static {
        class_mon = new AEMonitor("UPnP:class");
    }
}

