/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.util.ConstantsVuze;
import java.net.MalformedURLException;
import java.net.URL;

public class ContentNetworkUtils {
    public static String getUrl(ContentNetwork cn, int serviceID) {
        try {
            if (!cn.isServiceSupported(serviceID)) {
                return null;
            }
            return cn.getServiceURL(serviceID);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getUrl(ContentNetwork cn, int serviceID, Object[] params) {
        try {
            if (!cn.isServiceSupported(serviceID)) {
                return null;
            }
            return cn.getServiceURL(serviceID, params);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static ContentNetwork getContentNetworkFromTarget(String target) {
        ContentNetwork cn = null;
        if (target != null && target.startsWith("ContentNetwork.")) {
            long networkID = Long.parseLong(target.substring(15));
            cn = ContentNetworkManagerFactory.getSingleton().getContentNetwork(networkID);
        }
        if (cn == null) {
            cn = ConstantsVuze.getDefaultContentNetwork();
        }
        return cn;
    }

    public static String getTarget(ContentNetwork cn) {
        return "ContentNetwork." + (cn == null ? ConstantsVuze.getDefaultContentNetwork().getID() : cn.getID());
    }

    public static void setSourceRef(String target, String sourceRef, boolean override) {
        ContentNetworkUtils.setSourceRef(ContentNetworkUtils.getContentNetworkFromTarget(target), sourceRef, override);
    }

    public static void setSourceRef(ContentNetwork cn, String sourceRef, boolean override) {
        String old;
        if (cn == ConstantsVuze.getDefaultContentNetwork()) {
            return;
        }
        if (cn.isServiceSupported(31)) {
            boolean authShown = false;
            Object oAuthShown = cn.getPersistentProperty("auth_shown");
            if (oAuthShown instanceof Boolean) {
                authShown = (Boolean)oAuthShown;
            }
            if (!authShown) {
                override = true;
            }
        }
        if ((old = (String)cn.getPersistentProperty("source_ref")) == null || override) {
            if (sourceRef != null && sourceRef.startsWith("http")) {
                try {
                    URL url = new URL(sourceRef);
                    sourceRef = url.getHost() + url.getPath();
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            cn.setPersistentProperty("source_ref", sourceRef);
        }
    }
}

