/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.ISelectedVuzeFileContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.devices.DeviceManagerUI;
import com.aelitis.azureus.ui.swt.devices.TranscodeChooser;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItem;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.PlayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class ToolBarView
extends SkinView {
    private static boolean DEBUG = false;
    private static toolbarButtonListener buttonListener;
    private Map<String, ToolBarItem> items = new LinkedHashMap<String, ToolBarItem>();
    Control lastControl = null;
    private boolean showText = true;
    private SWTSkinObject skinObject;
    private SWTSkinObject so2nd;
    private SWTSkinObject soGap;
    private boolean initComplete = false;
    private ArrayList<ToolBarViewListener> listeners = new ArrayList(1);
    private FrequencyLimitedDispatcher refresh_limiter = new FrequencyLimitedDispatcher(new AERunnable(){
        private AERunnable lock = this;
        private boolean refresh_pending;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSupport() {
            AERunnable aERunnable = this.lock;
            synchronized (aERunnable) {
                if (this.refresh_pending) {
                    return;
                }
                this.refresh_pending = true;
            }
            if (DEBUG) {
                System.out.println("refreshCoreItems via " + Debug.getCompressedStackTrace());
            }
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    AERunnable aERunnable = lock;
                    synchronized (aERunnable) {
                        refresh_pending = false;
                    }
                    ToolBarView.this._refreshCoreToolBarItems();
                }
            });
        }
    }, 250);
    private Map<DownloadManager, DownloadManagerListener> dm_listener_map = new HashMap<DownloadManager, DownloadManagerListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        ToolBarItem item;
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        this.skinObject = skinObject;
        buttonListener = new toolbarButtonListener();
        this.so2nd = skinObject.getSkin().getSkinObject("global-toolbar-2nd");
        this.soGap = skinObject.getSkin().getSkinObject("toolbar-gap");
        if (this.soGap != null) {
            Control cGap = this.soGap.getControl();
            FormData fd = (FormData)cGap.getLayoutData();
            if (fd.width == -1) {
                cGap.getParent().addListener(11, new Listener(){

                    public void handleEvent(Event event2) {
                        ToolBarView.this.resizeGap();
                    }
                });
            } else {
                this.soGap = null;
            }
        }
        if (!uiClassic) {
            item = new ToolBarItem("download", "image.button.download", "v3.MainWindow.button.download"){

                public void triggerToolBarItem() {
                    String viewID = SelectedContentManager.getCurrentySelectedViewID();
                    if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                        return;
                    }
                    ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
                    if (sc != null && sc.length == 1 && (sc[0].getHash() != null || sc[0].getDownloadInfo() != null)) {
                        TorrentListViewsUtils.downloadDataSource(sc[0], false, "toolbar");
                    }
                }
            };
            this.addToolBarItem(item);
            item = new ToolBarItem("play", "image.button.play", "iconBar.play"){

                public void triggerToolBarItem() {
                    String viewID = SelectedContentManager.getCurrentySelectedViewID();
                    if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                        return;
                    }
                    ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
                    if (sc != null && sc.length > 0) {
                        if (PlayUtils.canStreamDS(sc[0], sc[0].getFileIndex())) {
                            TorrentListViewsUtils.playOrStreamDataSource(sc[0], "toolbar", true, false);
                        } else {
                            TorrentListViewsUtils.playOrStreamDataSource(sc[0], "toolbar", false, true);
                        }
                    }
                }
            };
            this.addToolBarItem(item);
            this.addSeperator((uiClassic ? "classic." : "") + "toolbar.area.item.sep", this.soMain);
            this.lastControl = null;
        } else {
            this.lastControl = null;
            item = new ToolBarItem("open", "image.toolbar.open", "Button.add"){

                public void triggerToolBarItem() {
                    TorrentOpener.openTorrentWindow();
                }
            };
            item.setAlwaysAvailable(true);
            this.addToolBarItem(item, "toolbar.area.sitem.left", this.so2nd);
            this.addSeperator(this.so2nd);
            item = new ToolBarItem("search", "search", "Button.search"){

                public void triggerToolBarItem() {
                    UIFunctionsManagerSWT.getUIFunctionsSWT().promptForSearch();
                }
            };
            item.setAlwaysAvailable(true);
            this.addToolBarItem(item, "toolbar.area.sitem.right", this.so2nd);
            this.addSeperator((uiClassic ? "classic." : "") + "toolbar.area.item.sep3", this.so2nd);
            this.addNonToolBar("toolbar.area.sitem.left2", this.so2nd);
        }
        boolean first = true;
        if (!DeviceManagerUI.DISABLED) {
            item = new ToolBarItem("transcode", "image.button.transcode", "iconBar.transcode"){

                public void triggerToolBarItem() {
                    String viewID = SelectedContentManager.getCurrentySelectedViewID();
                    if (viewID == null && ToolBarView.this.triggerIViewToolBar(this.getId())) {
                        return;
                    }
                    ISelectedContent[] contents = SelectedContentManager.getCurrentlySelectedContent();
                    if (contents.length == 0) {
                        return;
                    }
                    ToolBarView.this.deviceSelected(contents, true);
                }
            };
            this.addToolBarItem(item, first ? "toolbar.area.sitem.left" : "toolbar.area.sitem", this.so2nd);
            first = false;
            this.addSeperator(this.so2nd);
        }
        item = new ToolBarItem("run", "image.toolbar.run", "iconBar.run"){

            public void triggerToolBarItem() {
                Object[] dms;
                if (!ToolBarView.this.triggerBasicToolBarItem(this.getId()) && (dms = SelectedContentManager.getDMSFromSelectedContent()) != null) {
                    TorrentUtil.runDataSources(dms);
                    for (int i = 0; i < dms.length; ++i) {
                        Object dm = dms[i];
                        PlatformTorrentUtils.setHasBeenOpened((DownloadManager)dm, true);
                    }
                }
            }
        };
        this.addToolBarItem(item, first ? "toolbar.area.sitem.left" : "toolbar.area.sitem", this.so2nd);
        first = false;
        this.addSeperator(this.so2nd);
        if (uiClassic) {
            item = new ToolBarItem("top", "image.toolbar.top", "iconBar.top"){

                public void triggerToolBarItem() {
                    ToolBarView.this.moveTop();
                }

                public boolean triggerToolBarItemHold() {
                    return false;
                }
            };
            this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
            this.addSeperator(this.so2nd);
        }
        item = new ToolBarItem("up", "image.toolbar.up", "v3.iconBar.up"){

            public void triggerToolBarItem() {
                DownloadManager[] dms;
                if (!AzureusCoreFactory.isCoreRunning()) {
                    return;
                }
                if (!ToolBarView.this.triggerBasicToolBarItem(this.getId()) && (dms = SelectedContentManager.getDMSFromSelectedContent()) != null) {
                    Arrays.sort(dms, new Comparator<DownloadManager>(){

                        @Override
                        public int compare(DownloadManager a, DownloadManager b) {
                            return a.getPosition() - b.getPosition();
                        }
                    });
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    for (int i = 0; i < dms.length; ++i) {
                        DownloadManager dm = dms[i];
                        if (!gm.isMoveableUp(dm)) continue;
                        gm.moveUp(dm);
                    }
                }
            }

            public boolean triggerToolBarItemHold() {
                return ToolBarView.this.moveTop();
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("down", "image.toolbar.down", "v3.iconBar.down"){

            public void triggerToolBarItem() {
                if (!AzureusCoreFactory.isCoreRunning()) {
                    return;
                }
                if (!ToolBarView.this.triggerBasicToolBarItem(this.getId())) {
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        Arrays.sort(dms, new Comparator<DownloadManager>(){

                            @Override
                            public int compare(DownloadManager a, DownloadManager b) {
                                return b.getPosition() - a.getPosition();
                            }
                        });
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = dms[i];
                            if (!gm.isMoveableDown(dm)) continue;
                            gm.moveDown(dm);
                        }
                    }
                }
            }

            public boolean triggerToolBarItemHold() {
                return ToolBarView.this.moveBottom();
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        if (uiClassic) {
            item = new ToolBarItem("bottom", "image.toolbar.bottom", "iconBar.bottom"){

                public void triggerToolBarItem() {
                    ToolBarView.this.moveBottom();
                }

                public boolean triggerToolBarItemHold() {
                    return false;
                }
            };
            this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
            this.addSeperator(this.so2nd);
        }
        item = new ToolBarItem("start", "image.toolbar.start", "iconBar.start"){

            public void triggerToolBarItem() {
                Object[] dms;
                if (!ToolBarView.this.triggerBasicToolBarItem(this.getId()) && (dms = SelectedContentManager.getDMSFromSelectedContent()) != null) {
                    TorrentUtil.queueDataSources(dms, true);
                }
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("stop", "image.toolbar.stop", "iconBar.stop"){

            public void triggerToolBarItem() {
                if (!ToolBarView.this.triggerBasicToolBarItem(this.getId())) {
                    Object[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
                    TorrentUtil.stopDataSources(currentContent);
                }
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem", this.so2nd);
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("remove", "image.toolbar.remove", "iconBar.remove"){

            public void triggerToolBarItem() {
                if (!ToolBarView.this.triggerBasicToolBarItem(this.getId())) {
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    TorrentUtil.removeDownloads(dms, null);
                }
            }
        };
        this.addToolBarItem(item, "toolbar.area.sitem.right", this.so2nd);
        this.addSeperator((uiClassic ? "classic." : "") + "toolbar.area.item.sep3", this.so2nd);
        this.addNonToolBar("toolbar.area.sitem.left2", this.so2nd);
        item = new ToolBarItem("modeBig", "image.toolbar.table_large", "v3.iconBar.view.big"){

            public void triggerToolBarItem() {
                ToolBarView.this.triggerBasicToolBarItem(this.getId());
            }

            public void setEnabled(boolean enabled) {
                SWTSkinObject so;
                if (!enabled && (so = this.getSkinButton().getSkinObject()) != null && so.getSuffix().contains("-down")) {
                    so.switchSuffix("");
                }
                super.setEnabled(enabled);
            }
        };
        this.addToolBarItem(item, "toolbar.area.vitem.left", this.so2nd);
        SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", item.getSkinButton().getSkinObject());
        if (soTitle instanceof SWTSkinObjectText) {
            ((SWTSkinObjectText)soTitle).setStyle(131072);
        }
        this.addSeperator(this.so2nd);
        item = new ToolBarItem("modeSmall", "image.toolbar.table_normal", "v3.iconBar.view.small"){

            public void triggerToolBarItem() {
                ToolBarView.this.triggerBasicToolBarItem(this.getId());
            }

            public void setEnabled(boolean enabled) {
                SWTSkinObject so;
                if (!enabled && (so = this.getSkinButton().getSkinObject()) != null && so.getSuffix().contains("-down")) {
                    so.switchSuffix("");
                }
                super.setEnabled(enabled);
            }
        };
        this.addToolBarItem(item, "toolbar.area.vitem.right", this.so2nd);
        soTitle = this.skin.getSkinObject("toolbar-item-title", item.getSkinButton().getSkinObject());
        if (soTitle instanceof SWTSkinObjectText) {
            ((SWTSkinObjectText)soTitle).setStyle(16384);
        }
        this.resizeGap();
        SelectedContentManager.addCurrentlySelectedContentListener(new SelectedContentListener(){

            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
                ToolBarView.this.refreshCoreToolBarItems();
                UIFunctionsManagerSWT.getUIFunctionsSWT().refreshTorrentMenu();
            }
        });
        try {
            if (!COConfigurationManager.getBooleanParameter("ToolBar.showText")) {
                this.flipShowText();
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        this.initComplete = true;
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (ToolBarViewListener l : this.listeners) {
                try {
                    l.toolbarViewInitialized(this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        return null;
    }

    protected boolean triggerBasicToolBarItem(String itemKey) {
        if (this.triggerIViewToolBar(itemKey)) {
            return true;
        }
        if (DEBUG) {
            String viewID = SelectedContentManager.getCurrentySelectedViewID();
            System.out.println("Warning: Fallback of toolbar button " + itemKey + " via " + viewID + " view");
        }
        return false;
    }

    protected boolean moveBottom() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
        if (dms != null) {
            gm.moveEnd(dms);
        }
        return true;
    }

    protected void deviceSelected(final ISelectedContent[] contents, final boolean allow_retry) {
        TranscodeChooser deviceChooser = new TranscodeChooser(){

            public void closed() {
                DeviceManager deviceManager = DeviceManagerFactory.getSingleton();
                if (this.selectedTranscodeTarget != null && this.selectedProfile != null) {
                    for (int i = 0; i < contents.length; ++i) {
                        DiskManagerFileInfo[] files;
                        ISelectedContent selectedContent = contents[i];
                        DownloadManager dm = selectedContent.getDownloadManager();
                        if (dm == null) continue;
                        for (DiskManagerFileInfo file : files = dm.getDiskManagerFileInfo()) {
                            try {
                                deviceManager.getTranscodeManager().getQueue().add(this.selectedTranscodeTarget, this.selectedProfile, (org.gudy.azureus2.plugins.disk.DiskManagerFileInfo)PluginCoreUtils.convert(file, false), false);
                            }
                            catch (TranscodeException e) {
                                Debug.out(e);
                            }
                        }
                    }
                }
            }
        };
        deviceChooser.show(new Runnable(){

            public void run() {
                if (allow_retry) {
                    ToolBarView.this.deviceSelected(contents, false);
                }
            }
        });
    }

    protected boolean moveTop() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
        if (dms != null) {
            gm.moveTop(dms);
        }
        return true;
    }

    protected void resizeGap() {
        if (this.soGap == null) {
            this.skinObject.getControl().getParent().layout();
            return;
        }
        Rectangle boundsLeft = this.skinObject.getControl().getBounds();
        Rectangle boundsRight = this.so2nd.getControl().getBounds();
        Rectangle clientArea = this.soGap.getControl().getParent().getClientArea();
        FormData fd = (FormData)this.soGap.getControl().getLayoutData();
        fd.width = clientArea.width - (boundsLeft.x + boundsLeft.width) - boundsRight.width;
        if (fd.width < 0) {
            fd.width = 0;
        } else if (fd.width > 50) {
            fd.width -= 30;
        } else if (fd.width > 20) {
            fd.width = 20;
        }
        this.soGap.getControl().getParent().layout();
    }

    protected void updateCoreItems(ISelectedContent[] currentContent, String viewID) {
        Map<String, Boolean> mapNewToolbarStates = TorrentUtil.calculateToolbarStates(currentContent, viewID);
        for (String key : mapNewToolbarStates.keySet()) {
            Boolean enable = mapNewToolbarStates.get(key);
            ToolBarItem item = this.getToolBarItem(key);
            if (item == null) continue;
            item.setEnabled(enable);
        }
    }

    protected void activateViaSideBar(ToolBarItem toolBarItem) {
        MdiEntrySWT entry;
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getCurrentEntrySWT()).getIView() != null) {
            entry.getIView().itemActivated(toolBarItem.getId());
        }
    }

    public ToolBarItem getToolBarItem(String itemID) {
        return this.items.get(itemID);
    }

    public ToolBarItem[] getAllToolBarItems() {
        return this.items.values().toArray(new ToolBarItem[0]);
    }

    public void refreshCoreToolBarItems() {
        this.refresh_limiter.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _refreshCoreToolBarItems() {
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null) {
            boolean bl;
            ToolBarItem[] allToolBarItems = this.getAllToolBarItems();
            MdiEntrySWT entry = mdi.getCurrentEntrySWT();
            HashMap<String, Boolean> mapStates = new HashMap<String, Boolean>();
            if (entry != null) {
                ToolBarEnabler[] enablers;
                for (ToolBarEnabler toolBarEnabler : enablers = entry.getToolbarEnablers()) {
                    toolBarEnabler.refreshToolBar(mapStates);
                }
            }
            ISelectedContent[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
            Map<DownloadManager, DownloadManagerListener> map = this.dm_listener_map;
            synchronized (map) {
                HashMap<DownloadManager, DownloadManagerListener> copy = new HashMap<DownloadManager, DownloadManagerListener>(this.dm_listener_map);
                for (ISelectedContent content : currentContent) {
                    DownloadManager dm = content.getDownloadManager();
                    if (dm == null || copy.remove(dm) != null) continue;
                    DownloadManagerListener l = new DownloadManagerListener(){

                        public void stateChanged(DownloadManager manager, int state) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void downloadComplete(DownloadManager manager) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void completionChanged(DownloadManager manager, boolean bCompleted) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }
                    };
                    dm.addListener(l, false);
                    this.dm_listener_map.put(dm, l);
                }
                for (Map.Entry entry2 : copy.entrySet()) {
                    DownloadManager dm = (DownloadManager)entry2.getKey();
                    dm.removeListener((DownloadManagerListener)entry2.getValue());
                    this.dm_listener_map.remove(dm);
                }
            }
            if (!mapStates.containsKey("download")) {
                for (ISelectedContent iSelectedContent : currentContent) {
                    if (iSelectedContent.getDownloadManager() != null || iSelectedContent.getDownloadInfo() == null) continue;
                    mapStates.put("download", true);
                    break;
                }
            }
            boolean bl2 = currentContent.length == 1;
            boolean can_play = false;
            boolean can_stream = false;
            boolean bl3 = false;
            if (bl2 && !(currentContent[0] instanceof ISelectedVuzeFileContent)) {
                can_play = PlayUtils.canPlayDS(currentContent[0], currentContent[0].getFileIndex());
                can_stream = PlayUtils.canStreamDS(currentContent[0], currentContent[0].getFileIndex());
                if (can_stream) {
                    bl = PlayUtils.isStreamPermitted();
                }
            }
            if (mapStates.containsKey("play")) {
                can_play |= ((Boolean)mapStates.get("play")).booleanValue();
            }
            if (mapStates.containsKey("stream")) {
                can_stream |= ((Boolean)mapStates.get("stream")).booleanValue();
            }
            mapStates.put("play", can_play | can_stream);
            ToolBarItem pitem = this.getToolBarItem("play");
            if (pitem != null) {
                if (can_stream) {
                    pitem.setImageID(bl ? "image.button.stream" : "image.button.pstream");
                    pitem.setTextID(bl ? "iconBar.stream" : "iconBar.pstream");
                } else {
                    pitem.setImageID("image.button.play");
                    pitem.setTextID("iconBar.play");
                }
            }
            for (int i = 0; i < allToolBarItems.length; ++i) {
                ToolBarItem toolBarItem = allToolBarItems[i];
                if (toolBarItem.isAlwaysAvailable()) {
                    toolBarItem.setEnabled(true);
                    continue;
                }
                Boolean b = (Boolean)mapStates.get(toolBarItem.getId());
                if (b == null) {
                    b = false;
                }
                toolBarItem.setEnabled(b);
            }
            return;
        }
    }

    private boolean triggerIViewToolBar(String id) {
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null) {
            ToolBarEnabler[] enablers;
            MdiEntrySWT entry = mdi.getCurrentEntrySWT();
            for (ToolBarEnabler enabler : enablers = entry.getToolbarEnablers()) {
                if (!enabler.toolBarItemActivated(id)) continue;
                return true;
            }
        }
        return false;
    }

    public void addToolBarItem(ToolBarItem item) {
        this.addToolBarItem(item, "toolbar.area.item", this.soMain);
    }

    public void addToolBarItem(ToolBarItem item, String templateID, SWTSkinObject soMain) {
        SWTSkinObject so = this.skin.createSkinObject("toolbar:" + item.getId(), templateID, soMain);
        if (so != null) {
            so.setTooltipID(item.getTooltipID());
            if (this.lastControl != null) {
                FormData fd = (FormData)so.getControl().getLayoutData();
                fd.left = new FormAttachment(this.lastControl);
            }
            so.setData("toolbaritem", item);
            SWTSkinButtonUtility btn = new SWTSkinButtonUtility(so, "toolbar-item-image");
            btn.setImage(item.getImageID());
            btn.addSelectionListener(buttonListener);
            item.setSkinButton(btn);
            SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
            if (soTitle instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)soTitle).setTextID(item.getTextID());
                item.setSkinTitle((SWTSkinObjectText)soTitle);
            }
            if (this.initComplete) {
                Utils.relayout(so.getControl().getParent());
            }
            this.lastControl = item.getSkinButton().getSkinObject().getControl();
            this.items.put(item.getId(), item);
        }
    }

    private void addSeperator(SWTSkinObject soMain) {
        this.addSeperator("toolbar.area.sitem.sep", soMain);
    }

    private void addSeperator(String id, SWTSkinObject soMain) {
        SWTSkinObject so = this.skin.createSkinObject("toolbar_sep" + Math.random(), id, soMain);
        if (so != null) {
            if (this.lastControl != null) {
                FormData fd = (FormData)so.getControl().getLayoutData();
                fd.left = new FormAttachment(this.lastControl, fd.left == null ? 0 : fd.left.offset);
            }
            this.lastControl = so.getControl();
        }
    }

    private void addNonToolBar(String skinid, SWTSkinObject soMain) {
        SWTSkinObject so = this.skin.createSkinObject("toolbar_d" + Math.random(), skinid, soMain);
        if (so != null) {
            if (this.lastControl != null) {
                FormData fd = (FormData)so.getControl().getLayoutData();
                fd.left = new FormAttachment(this.lastControl, fd.left == null ? 0 : fd.left.offset);
            }
            this.lastControl = so.getControl();
        }
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
        ToolBarItem[] allToolBarItems = this.getAllToolBarItems();
        for (int i = 0; i < allToolBarItems.length; ++i) {
            ToolBarItem tbi = allToolBarItems[i];
            SWTSkinObject so = tbi.getSkinButton().getSkinObject();
            SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
            soTitle.setVisible(showText);
        }
    }

    public boolean getShowText() {
        return this.showText;
    }

    public void flipShowText() {
        ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
        if (tb == null) {
            SkinViewManager.addListener(new SkinViewManager.SkinViewManagerListener(){

                public void skinViewAdded(SkinView skinview) {
                    if (skinview instanceof ToolBarView) {
                        SkinViewManager.RemoveListener(this);
                        ToolBarView.this.flipShowText();
                    }
                }
            });
            return;
        }
        try {
            FormData fd;
            Control control;
            boolean showText = !tb.getShowText();
            COConfigurationManager.setParameter("ToolBar.showText", showText);
            tb.setShowText(showText);
            SWTSkinObject skinObject = this.skin.getSkinObject("search-text");
            if (skinObject != null) {
                control = skinObject.getControl();
                fd = (FormData)control.getLayoutData();
                fd.top.offset = showText ? 6 : 5;
                int n = fd.bottom.offset = showText ? -3 : -2;
            }
            if ((skinObject = this.skin.getSkinObject("topgap")) != null) {
                control = skinObject.getControl();
                fd = (FormData)control.getLayoutData();
                int n = fd.height = showText ? 6 : 2;
            }
            if ((skinObject = this.skin.getSkinObject("tabbar")) != null) {
                control = skinObject.getControl();
                fd = (FormData)control.getLayoutData();
                fd.height = showText ? 50 : 32;
                skinObject.switchSuffix(showText ? "" : "-small", 4, true);
                Shell shell = control.getShell();
                shell.layout(true, true);
                shell.redraw();
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ToolBarViewListener l) {
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
            if (this.initComplete) {
                try {
                    l.toolbarViewInitialized(this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ToolBarViewListener l) {
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    public static interface ToolBarViewListener {
        public void toolbarViewInitialized(ToolBarView var1);
    }

    private static class toolbarButtonListener
    extends SWTSkinButtonUtility.ButtonListenerAdapter {
        private toolbarButtonListener() {
        }

        public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            item.triggerToolBarItem();
        }

        public boolean held(SWTSkinButtonUtility buttonUtility) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            buttonUtility.getSkinObject().switchSuffix("", 0, false, true);
            boolean triggerToolBarItemHold = item.triggerToolBarItemHold();
            return triggerToolBarItemHold;
        }

        public void disabledStateChanged(SWTSkinButtonUtility buttonUtility, boolean disabled) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            item.setEnabled(!disabled);
        }
    }
}

