/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfoContentNetwork;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.ISelectedVuzeFileContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.columns.utils.TableColumnCreatorV3;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.MyTorrentsView_Big;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.PlayUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowRefreshListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_LibraryTableView
extends SkinView
implements UIUpdatable,
ToolBarEnabler,
ObfusticateImage {
    private static final String ID = "SBC_LibraryTableView";
    private IView view;
    private Composite viewComposite;
    private TableViewSWT tv;
    protected int torrentFilterMode = 0;
    private SWTSkinObject soParent;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.soParent = skinObject.getParent();
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (SBC_LibraryTableView.this.soParent == null || SBC_LibraryTableView.this.soParent.isDisposed()) {
                            return;
                        }
                        SBC_LibraryTableView.this.initShow(core);
                    }
                });
            }
        });
        return null;
    }

    public void initShow(AzureusCore core) {
        SWTSkinObject so;
        SWTSkinObject soSizeSlider;
        TableColumnCore[] columns;
        Object data = this.soParent.getControl().getData("TorrentFilterMode");
        if (data instanceof Long) {
            this.torrentFilterMode = (int)((Long)data).longValue();
        }
        data = this.soParent.getControl().getData("DataSource");
        boolean useBigTable = this.useBigTable();
        SWTSkinObjectTextbox soFilter = (SWTSkinObjectTextbox)this.skin.getSkinObject("library-filter", this.soParent.getParent());
        Text txtFilter = soFilter == null ? null : soFilter.getTextControl();
        SWTSkinObjectContainer soCats = (SWTSkinObjectContainer)this.skin.getSkinObject("library-categories", this.soParent.getParent());
        Composite cCats = soCats == null ? null : soCats.getComposite();
        Object object = columns = useBigTable || this.torrentFilterMode != 0 ? this.getColumns() : null;
        if (null != columns) {
            TableColumnManager tcManager = TableColumnManager.getInstance();
            tcManager.addColumns(columns);
        }
        if (useBigTable) {
            this.view = this.torrentFilterMode == 1 || this.torrentFilterMode == 2 || this.torrentFilterMode == 3 ? new MyTorrentsView_Big(core, this.torrentFilterMode, columns, txtFilter, cCats) : new MyTorrentsView_Big(core, this.torrentFilterMode, columns, txtFilter, cCats);
        } else {
            String tableID = SB_Transfers.getTableIdFromFilterMode(this.torrentFilterMode, false);
            this.view = this.torrentFilterMode == 1 ? new MyTorrentsView(core, tableID, true, columns, txtFilter, cCats) : (this.torrentFilterMode == 2 ? new MyTorrentsView(core, tableID, false, columns, txtFilter, cCats) : (this.torrentFilterMode == 3 ? new MyTorrentsView(core, tableID, true, columns, txtFilter, cCats){

                public boolean isOurDownloadManager(DownloadManager dm) {
                    if (PlatformTorrentUtils.getHasBeenOpened(dm)) {
                        return false;
                    }
                    return super.isOurDownloadManager(dm);
                }
            } : new MyTorrentsSuperView(txtFilter, cCats){

                public void initializeDone() {
                    MyTorrentsView seedingview = this.getSeedingview();
                    if (seedingview != null) {
                        seedingview.overrideDefaultSelected(new TableSelectionAdapter(){

                            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                                SBC_LibraryTableView.doDefaultClick(rows, stateMask, false);
                            }
                        });
                        MyTorrentsView torrentview = this.getTorrentview();
                        if (torrentview != null) {
                            torrentview.overrideDefaultSelected(new TableSelectionAdapter(){

                                public void defaultSelected(TableRowCore[] rows, int stateMask) {
                                    SBC_LibraryTableView.doDefaultClick(rows, stateMask, false);
                                }
                            });
                        }
                    }
                }
            }));
            if (this.view instanceof MyTorrentsView) {
                ((MyTorrentsView)this.view).overrideDefaultSelected(new TableSelectionAdapter(){

                    public void defaultSelected(TableRowCore[] rows, int stateMask) {
                        SBC_LibraryTableView.doDefaultClick(rows, stateMask, false);
                    }
                });
            }
        }
        if (data != null) {
            this.view.dataSourceChanged(data);
        }
        SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), this.getUpdateUIName(), "", this.soMain);
        this.skin.layout();
        this.viewComposite = soContents.getComposite();
        this.viewComposite.setLayoutData(Utils.getFilledFormData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.viewComposite.setLayout(gridLayout);
        this.view.initialize(this.viewComposite);
        if (this.tv == null) {
            if (this.view instanceof TableViewTab) {
                TableViewTab tvt = (TableViewTab)this.view;
                this.tv = tvt.getTableView();
            } else if (this.view instanceof TableViewSWT) {
                this.tv = (TableViewSWT)((Object)this.view);
            }
        }
        if ((soSizeSlider = this.skin.getSkinObject("table-size-slider", this.soParent.getParent())) instanceof SWTSkinObjectContainer) {
            so = (SWTSkinObjectContainer)soSizeSlider;
            if (this.tv != null && !this.tv.enableSizeSlider(((SWTSkinObjectContainer)so).getComposite(), 16, 100)) {
                ((SWTSkinObjectBasic)so).setVisible(false);
            }
        }
        if (this.torrentFilterMode == 0 && this.tv != null) {
            this.tv.addRefreshListener(new TableRowRefreshListener(){

                public void rowRefresh(TableRow row) {
                    TableRowSWT rowCore = (TableRowSWT)row;
                    Object ds = rowCore.getDataSource(true);
                    if (!(ds instanceof DownloadManager)) {
                        return;
                    }
                    DownloadManager dm = (DownloadManager)ds;
                    boolean changed = false;
                    boolean assumedComplete = dm.getAssumedComplete();
                    changed = !assumedComplete ? (changed |= rowCore.setAlpha(160)) : (!PlatformTorrentUtils.getHasBeenOpened(dm) ? (changed |= rowCore.setAlpha(255)) : (changed |= rowCore.setAlpha(255)));
                }
            });
        }
        if (this.tv != null) {
            this.tv.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\u000f' && e.stateMask == 393216) {
                        Object[] selectedDataSources = SBC_LibraryTableView.this.tv.getSelectedDataSources().toArray();
                        for (int i = 0; i < selectedDataSources.length; ++i) {
                            TOTorrent torrent;
                            String contentHash;
                            DownloadManager dm = (DownloadManager)selectedDataSources[i];
                            if (dm == null || (contentHash = PlatformTorrentUtils.getContentHash(torrent = dm.getTorrent())) == null || contentHash.length() <= 0) continue;
                            ContentNetwork cn = DataSourceUtils.getContentNetwork(torrent);
                            if (cn == null) {
                                new MessageBoxShell(32, "coq", "Not in Content Network List").open(null);
                                return;
                            }
                            String url = cn.getTorrentDownloadService(contentHash, "coq");
                            DownloadUrlInfoContentNetwork dlInfo = new DownloadUrlInfoContentNetwork(url, cn);
                            TorrentUIUtilsV3.loadTorrent(dlInfo, false, false, true);
                        }
                    }
                }
            });
        }
        if (this.torrentFilterMode == 3 && (so = this.skin.getSkinObject("library-list-button-right", this.soParent.getParent())) != null) {
            so.setVisible(true);
            SWTSkinButtonUtility btn = new SWTSkinButtonUtility(so);
            btn.setTextID("Mark All UnNew");
            btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    TableViewSWT<Object> tv = ((MyTorrentsView)SBC_LibraryTableView.this.view).getTableView();
                    Object[] dataSources = tv.getDataSources().toArray();
                    for (int i = 0; i < dataSources.length; ++i) {
                        Object ds = dataSources[i];
                        if (!(ds instanceof DownloadManager)) continue;
                        PlatformTorrentUtils.setHasBeenOpened((DownloadManager)ds, true);
                        tv.removeDataSource(ds);
                    }
                }
            });
        }
        this.viewComposite.getParent().layout(true);
    }

    public static void doDefaultClick(TableRowCore[] rows, int stateMask, boolean neverPlay) {
        DownloadManager dm;
        if (rows == null || rows.length != 1) {
            return;
        }
        Object ds = rows[0].getDataSource(true);
        String mode = COConfigurationManager.getStringParameter("list.dm.dblclick");
        if (mode.equals("1")) {
            DownloadManager dm2 = DataSourceUtils.getDM(ds);
            if (dm2 != null) {
                UIFunctionsManager.getUIFunctions().openView(5, dm2);
                return;
            }
        } else if (mode.equals("2") && (dm = DataSourceUtils.getDM(ds)) != null) {
            boolean openMode = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
            ManagerUtils.open(dm, openMode);
            return;
        }
        if (neverPlay) {
            return;
        }
        if (PlayUtils.canPlayDS(ds, -1) || (stateMask & 0x40000) > 0) {
            TorrentListViewsUtils.playOrStreamDataSource(ds, "dblclick", false, true);
        }
        if (PlayUtils.canStreamDS(ds, -1)) {
            TorrentListViewsUtils.playOrStreamDataSource(ds, "dblclick", true, false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return ID;
    }

    @Override
    public void updateUI() {
        if (this.viewComposite == null || this.viewComposite.isDisposed() || !this.viewComposite.isVisible() || this.view == null) {
            return;
        }
        this.view.refresh();
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        MdiEntrySWT entry;
        super.skinObjectShown(skinObject, params);
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getEntryFromSkinObject(skinObject)) != null) {
            entry.addToolbarEnabler(this);
        }
        if (this.view instanceof IViewExtension) {
            ((IViewExtension)((Object)this.view)).viewActivated();
        }
        if (this.torrentFilterMode == 3 && AzureusCoreFactory.isCoreRunning() && this.view instanceof MyTorrentsView) {
            MyTorrentsView torrentsView = (MyTorrentsView)this.view;
            TableViewSWT<DownloadManager> tv = torrentsView.getTableView();
            List dms = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
            for (DownloadManager dm : dms) {
                if (!torrentsView.isOurDownloadManager(dm)) {
                    tv.removeDataSource(dm);
                    continue;
                }
                tv.addDataSource(dm);
            }
        }
        if (this.view instanceof MyTorrentsView) {
            ((MyTorrentsView)this.view).updateSelectedContent(true);
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SBC_LibraryTableView.this.updateUI();
            }
        });
        return null;
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        MdiEntrySWT entry;
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getEntryFromSkinObject(skinObject)) != null) {
            entry.removeToolbarEnabler(this);
        }
        if (this.view instanceof IViewExtension) {
            ((IViewExtension)((Object)this.view)).viewDeactivated();
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public void refreshToolBar(Map<String, Boolean> list) {
        if (this.view instanceof ToolBarEnabler) {
            ((ToolBarEnabler)((Object)this.view)).refreshToolBar(list);
        }
        if (this.tv == null) {
            return;
        }
        ISelectedContent[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
        boolean has1Selection = currentContent.length == 1;
        list.put("play", has1Selection && !(currentContent[0] instanceof ISelectedVuzeFileContent) && PlayUtils.canPlayDS(currentContent[0], currentContent[0].getFileIndex()));
        list.put("stream", has1Selection && !(currentContent[0] instanceof ISelectedVuzeFileContent) && PlayUtils.canStreamDS(currentContent[0], currentContent[0].getFileIndex()));
    }

    @Override
    public boolean toolBarItemActivated(String itemKey) {
        return this.view instanceof ToolBarEnabler && ((ToolBarEnabler)((Object)this.view)).toolBarItemActivated(itemKey);
    }

    protected int getTableMode() {
        return 1;
    }

    protected boolean useBigTable() {
        return false;
    }

    protected TableColumnCore[] getColumns() {
        if (this.torrentFilterMode == 1) {
            return TableColumnCreator.createCompleteDM("MySeeders");
        }
        if (this.torrentFilterMode == 2) {
            return TableColumnCreator.createIncompleteDM("MyTorrents");
        }
        if (this.torrentFilterMode == 3) {
            return TableColumnCreatorV3.createUnopenedDM("Unopened", false);
        }
        if (this.torrentFilterMode == 0) {
            return TableColumnCreator.createCompleteDM("MyLibrary.big");
        }
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.view != null) {
            this.view.delete();
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public Image obfusticatedImage(Image image) {
        if (this.view instanceof ObfusticateImage) {
            ObfusticateImage oi = (ObfusticateImage)((Object)this.view);
            return oi.obfusticatedImage(image);
        }
        return image;
    }
}

