/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class ViewUpSpeedGraph
extends AbstractIView {
    GlobalManager manager = null;
    GlobalManagerStats stats = null;
    Canvas upSpeedCanvas;
    SpeedGraphic upSpeedGraphic;
    TimerEventPeriodic timerEvent;
    private boolean everRefreshed = false;

    public ViewUpSpeedGraph() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                ViewUpSpeedGraph.this.manager = core.getGlobalManager();
                ViewUpSpeedGraph.this.stats = ViewUpSpeedGraph.this.manager.getStats();
            }
        });
    }

    public void initialize(Composite composite) {
        this.upSpeedCanvas = new Canvas(composite, 0x20000000);
        GridData gridData = new GridData(1808);
        this.upSpeedCanvas.setLayoutData(gridData);
        this.upSpeedGraphic = SpeedGraphic.getInstance();
        this.upSpeedGraphic.initialize(this.upSpeedCanvas);
    }

    public void periodicUpdate() {
        if (this.stats == null || this.manager == null) {
            return;
        }
        int swarms_peer_speed = (int)this.stats.getTotalSwarmsPeerRate(true, false);
        this.upSpeedGraphic.addIntsValue(new int[]{this.stats.getDataSendRate() + this.stats.getProtocolSendRate(), this.stats.getProtocolSendRate(), COConfigurationManager.getIntParameter(TransferSpeedValidator.getActiveUploadParameter(this.manager)) * 1024, swarms_peer_speed});
    }

    public void delete() {
        Utils.disposeComposite(this.upSpeedCanvas);
        this.upSpeedGraphic.dispose();
    }

    public String getFullTitle() {
        return "UL Speed";
    }

    public Composite getComposite() {
        return this.upSpeedCanvas;
    }

    public void refresh() {
        if (!this.everRefreshed) {
            this.everRefreshed = true;
            this.timerEvent = SimpleTimer.addPeriodicEvent("TopBarSpeedGraphicView", 1000L, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    if (ViewUpSpeedGraph.this.upSpeedCanvas.isDisposed()) {
                        ViewUpSpeedGraph.this.timerEvent.cancel();
                    } else {
                        ViewUpSpeedGraph.this.periodicUpdate();
                    }
                }
            });
        }
        this.upSpeedGraphic.refresh();
    }

    public String getData() {
        return "SpeedView.title.full";
    }
}

