/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.toolbar;

import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ToolBarItem {
    String imageID;
    String id;
    private SWTSkinButtonUtility skinButton;
    private SWTSkinObjectText skinTitle;
    boolean enabled = true;
    private String textID;
    private String tooltipID;
    private List listeners = Collections.EMPTY_LIST;
    private boolean alwaysAvailable = false;

    public ToolBarItem(String id, String imageid) {
        this.id = id;
        this.imageID = imageid;
    }

    public ToolBarItem(String id, String imageid, String textID) {
        this.id = id;
        this.imageID = imageid;
        this.textID = textID;
        this.tooltipID = textID + ".tooltip";
    }

    public void triggerToolBarItem() {
        Object[] array = this.listeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            ToolBarItemListener l = (ToolBarItemListener)array[i];
            l.pressed(this);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setSkinButton(SWTSkinButtonUtility btn) {
        this.skinButton = btn;
    }

    public SWTSkinButtonUtility getSkinButton() {
        return this.skinButton;
    }

    public void setSkinTitle(SWTSkinObjectText s) {
        this.skinTitle = s;
    }

    public boolean isEnabled() {
        if (this.skinButton != null) {
            return !this.skinButton.isDisabled();
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.skinButton != null) {
            this.skinButton.setDisabled(!enabled);
        }
    }

    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
        if (this.skinButton != null) {
            this.skinButton.setImage(imageID);
        }
    }

    public void setTextID(String textID) {
        this.textID = textID;
        if (this.skinTitle != null) {
            this.skinTitle.setTextID(textID);
        }
    }

    public String getTextID() {
        return this.textID;
    }

    public boolean triggerToolBarItemHold() {
        Object[] array = this.listeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            ToolBarItemListener l = (ToolBarItemListener)array[i];
            if (!l.held(this)) continue;
            return true;
        }
        return false;
    }

    public String getTooltipID() {
        return this.tooltipID;
    }

    public void setTooltipID(String tooltipID) {
        this.tooltipID = tooltipID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ToolBarItemListener l) {
        Class<ToolBarItem> clazz = ToolBarItem.class;
        synchronized (ToolBarItem.class) {
            if (this.listeners == Collections.EMPTY_LIST) {
                this.listeners = new ArrayList(1);
            }
            this.listeners.add(l);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ToolBarItemListener l) {
        Class<ToolBarItem> clazz = ToolBarItem.class;
        synchronized (ToolBarItem.class) {
            this.listeners.remove(l);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setAlwaysAvailable(boolean alwaysAvailable) {
        this.alwaysAvailable = alwaysAvailable;
    }

    public boolean isAlwaysAvailable() {
        return this.alwaysAvailable;
    }
}

