/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryLogIdListener;
import com.aelitis.azureus.ui.mdi.MdiEntryOpenListener;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UISkinnableManagerSWT;
import com.aelitis.azureus.ui.swt.UISkinnableSWTListener;
import com.aelitis.azureus.ui.swt.columns.utils.TableColumnCreatorV3;
import com.aelitis.azureus.ui.swt.extlistener.StimulusRPC;
import com.aelitis.azureus.ui.swt.mdi.BaseMDI;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.mdi.TabbedMDI;
import com.aelitis.azureus.ui.swt.shells.main.MainMDISetup;
import com.aelitis.azureus.ui.swt.shells.main.MainMenu;
import com.aelitis.azureus.ui.swt.shells.main.UIFunctionsImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import com.aelitis.azureus.ui.swt.utils.PlayNowList;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SearchResultsTabArea;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.ui.swt.views.skin.WelcomeView;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.NavigationHelper;
import com.aelitis.azureus.util.UrlFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelationUtils;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.OpenTorrentWindow;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.TrayWindow;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.associations.AssociationChecker;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.ObfusticateShell;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.donations.DonationWindow;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.sharing.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.shells.MessageSlideShell;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestSelector;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.swt.welcome.WelcomeWindow;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWindow
implements IMainWindow,
ObfusticateShell,
MdiListener,
AEDiagnosticsEvidenceGenerator,
MdiEntryLogIdListener,
UIUpdatable {
    private static final LogIDs LOGID = LogIDs.GUI;
    protected Shell shell;
    private Display display;
    private AzureusCore core;
    private IUIIntializer uiInitializer;
    private SWTSkin skin;
    private IMainMenu menu;
    private UISWTInstanceImpl uiSWTInstanceImpl;
    private UIFunctionsImpl uiFunctions;
    private SystemTraySWT systemTraySWT;
    private static Map<String, Long> mapTrackUsage = null;
    private static final AEMonitor mapTrackUsage_mon = new AEMonitor("mapTrackUsage");
    private long lCurrentTrackTime = 0L;
    private long lCurrentTrackTimeIdle = 0L;
    private boolean disposedOrDisposing;
    private DownloadManager[] dms_Startup;
    protected boolean isReady = false;
    private MainStatusBar statusBar;
    private String lastShellStatus = null;
    private Color colorSearchTextBG;
    private Color colorSearchTextFGdef;
    private Color colorSearchTextFG;
    private boolean delayedCore;
    private TrayWindow downloadBasket;

    public MainWindow(AzureusCore core, Display display, final IUIIntializer uiInitializer) {
        this.delayedCore = false;
        this.core = core;
        this.display = display;
        this.uiInitializer = uiInitializer;
        AEDiagnostics.addEvidenceGenerator(this);
        this.disposedOrDisposing = false;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    MainWindow.this.createWindow(uiInitializer);
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(false, "Error Initialize MainWindow", e));
                }
                if (uiInitializer != null) {
                    uiInitializer.abortProgress();
                }
            }
        });
        GlobalManager gm = core.getGlobalManager();
        this.dms_Startup = gm.getDownloadManagers().toArray(new DownloadManager[0]);
        gm.addListener(new GlobalManagerListener(){

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }

            public void downloadManagerRemoved(DownloadManager dm) {
            }

            public void downloadManagerAdded(DownloadManager dm) {
                MainWindow.this.downloadAdded(new DownloadManager[]{dm});
            }

            public void destroyed() {
            }

            public void destroyInitiated() {
            }
        }, false);
        gm.addDownloadWillBeRemovedListener(new GlobalManagerDownloadWillBeRemovedListener(){

            public void downloadWillBeRemoved(DownloadManager dm, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
                TOTorrent torrent = dm.getTorrent();
                if (PlatformTorrentUtils.isContentDRM(torrent) && remove_data) {
                    String prefix = "v3.mb.deletePurchased.";
                    String title = MessageText.getString(prefix + "title");
                    String text = MessageText.getString(prefix + "text", new String[]{dm.getDisplayName()});
                    MessageBoxShell mb = new MessageBoxShell(title, text, new String[]{MessageText.getString(prefix + "button.delete"), MessageText.getString(prefix + "button.cancel")}, 1);
                    mb.setRelatedObject(dm);
                    mb.open(null);
                    int result = mb.waitUntilClosed();
                    if (result != 0) {
                        throw new GlobalManagerDownloadRemovalVetoException("", true);
                    }
                }
            }
        });
        Alerts.addListener(new Alerts.AlertListener(){

            public boolean allowPopup(Object[] relatedObjects, int configID) {
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                if (dm == null) {
                    return true;
                }
                if (dm.getDownloadState().getFlag(16L)) {
                    return false;
                }
                try {
                    HashWrapper hw = dm.getTorrent().getHashWrapper();
                    if (PlayNowList.contains(hw)) {
                        return false;
                    }
                }
                catch (TOTorrentException e) {
                    // empty catch block
                }
                return true;
            }
        });
    }

    public MainWindow(final Display display, final IUIIntializer uiInitializer) {
        this.delayedCore = true;
        this.display = display;
        this.uiInitializer = uiInitializer;
        AEDiagnostics.addEvidenceGenerator(this);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    MainWindow.this.createWindow(uiInitializer);
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(false, "Error Initialize MainWindow", e));
                }
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
            }
        });
    }

    public void init(final AzureusCore core) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MainWindow.this._init(core);
                if (MainWindow.this.uiInitializer != null) {
                    MainWindow.this.uiInitializer.abortProgress();
                }
            }
        });
        UIUpdaterSWT.getInstance().addUpdater(this);
    }

    public void _init(AzureusCore core) {
        this.core = core;
        this.disposedOrDisposing = false;
        StimulusRPC.hookListeners(core, this);
        this.uiSWTInstanceImpl = new UISWTInstanceImpl(core);
        this.uiSWTInstanceImpl.init(this.uiInitializer);
        this.postPluginSetup(core);
        GlobalManager gm = core.getGlobalManager();
        this.dms_Startup = gm.getDownloadManagers().toArray(new DownloadManager[0]);
        gm.addListener(new GlobalManagerListener(){

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }

            public void downloadManagerRemoved(DownloadManager dm) {
            }

            public void downloadManagerAdded(DownloadManager dm) {
                MainWindow.this.downloadAdded(new DownloadManager[]{dm});
            }

            public void destroyed() {
            }

            public void destroyInitiated() {
            }
        }, false);
        gm.addDownloadWillBeRemovedListener(new GlobalManagerDownloadWillBeRemovedListener(){

            public void downloadWillBeRemoved(DownloadManager dm, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
                TOTorrent torrent = dm.getTorrent();
                if (PlatformTorrentUtils.isContentDRM(torrent) && remove_data) {
                    String prefix = "v3.mb.deletePurchased.";
                    String title = MessageText.getString(prefix + "title");
                    String text = MessageText.getString(prefix + "text", new String[]{dm.getDisplayName()});
                    MessageBoxShell mb = new MessageBoxShell(title, text, new String[]{MessageText.getString(prefix + "button.delete"), MessageText.getString(prefix + "button.cancel")}, 1);
                    mb.setRelatedObject(dm);
                    mb.open(null);
                    int result = mb.waitUntilClosed();
                    if (result != 0) {
                        throw new GlobalManagerDownloadRemovalVetoException("", true);
                    }
                }
            }
        });
        Alerts.addListener(new Alerts.AlertListener(){

            public boolean allowPopup(Object[] relatedObjects, int configID) {
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                if (dm == null) {
                    return true;
                }
                if (dm.getDownloadState().getFlag(16L)) {
                    return false;
                }
                try {
                    HashWrapper hw = dm.getTorrent().getHashWrapper();
                    if (PlayNowList.contains(hw)) {
                        return false;
                    }
                }
                catch (TOTorrentException e) {
                    // empty catch block
                }
                return true;
            }
        });
        core.triggerLifeCycleComponentCreated(this.uiFunctions);
        this.processStartupDMS();
    }

    private void postPluginSetup(AzureusCore core) {
        if (core == null) {
            return;
        }
        if (!Utils.isAZ2UI()) {
            VuzeActivitiesManager.initialize(core);
        }
        if (!Constants.isSafeMode) {
            if (core.getTrackerHost().getTorrents().length > 0) {
                Utils.execSWTThreadLater(0, new Runnable(){

                    public void run() {
                        MainWindow.this.uiFunctions.openView(9, null);
                    }
                });
            }
            PluginInterface default_pi = PluginInitializer.getDefaultInterface();
            try {
                final ShareManager share_manager = default_pi.getShareManager();
                default_pi.addListener(new PluginListener(){

                    public void initializationComplete() {
                    }

                    public void closedownInitiated() {
                        int share_count = share_manager.getShares().length;
                        COConfigurationManager.setParameter("GUI_SWT_share_count_at_close", share_count);
                    }

                    public void closedownComplete() {
                    }
                });
                if (share_manager.getShares().length > 0 || COConfigurationManager.getIntParameter("GUI_SWT_share_count_at_close") > 0) {
                    Utils.execSWTThreadLater(0, new Runnable(){

                        public void run() {
                            MainWindow.this.uiFunctions.openView(7, null);
                        }
                    });
                }
            }
            catch (ShareException e) {
                Debug.out(e);
            }
            if (COConfigurationManager.getBooleanParameter("Open Transfer Bar On Start")) {
                this.uiFunctions.showGlobalTransferBar();
            }
            COConfigurationManager.addAndFireParameterListener("IconBar.enabled", new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    MainWindow.this.setVisible(2, COConfigurationManager.getBooleanParameter(parameterName));
                }
            });
        }
        new ProgressWindow(this.display);
    }

    private void processStartupDMS() {
        AEThread2 thread = new AEThread2("v3.mw.dmAdded", true){

            public void run() {
                long startTime = SystemTime.getCurrentTime();
                if (MainWindow.this.dms_Startup == null || MainWindow.this.dms_Startup.length == 0) {
                    MainWindow.access$302(MainWindow.this, null);
                    return;
                }
                MainWindow.this.downloadAdded(MainWindow.this.dms_Startup);
                MainWindow.access$302(MainWindow.this, null);
                System.out.println("psDMS " + (SystemTime.getCurrentTime() - startTime) + "ms");
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    private void downloadAdded(DownloadManager[] dms) {
        boolean oneIsNotPlatformAndPersistent = false;
        for (final DownloadManager dm : dms) {
            boolean isContent;
            long completedTime;
            String lastVersion;
            if (dm == null) continue;
            DownloadManagerState dmState = dm.getDownloadState();
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null) continue;
            String title = PlatformTorrentUtils.getContentTitle(torrent);
            if (title != null && title.length() > 0 && dmState.getDisplayName() == null) {
                dmState.setDisplayName(title);
            }
            if (ConfigurationChecker.isNewVersion() && dm.getAssumedComplete() && Constants.compareVersions(lastVersion = COConfigurationManager.getStringParameter("Last Version"), "3.1.1.1") <= 0 && (completedTime = dmState.getLongParameter("stats.download.completed.time")) < SystemTime.getOffsetTime(-60000L)) {
                PlatformTorrentUtils.setHasBeenOpened(dm, true);
            }
            boolean bl = isContent = PlatformTorrentUtils.isContent(torrent, true) || PlatformTorrentUtils.getContentNetworkID(torrent) == 3L;
            if (!oneIsNotPlatformAndPersistent && !isContent && !dmState.getFlag(16L) && dm.isPersistent()) {
                oneIsNotPlatformAndPersistent = true;
            }
            if (!isContent) continue;
            long now = SystemTime.getCurrentTime();
            long expiresOn = PlatformTorrentUtils.getExpiresOn(torrent);
            if (expiresOn <= now) continue;
            SimpleTimer.addEvent("dm Expirey", expiresOn, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    dm.getDownloadState().setFlag(16L, true);
                    ManagerUtils.asyncStopDelete(dm, 70, true, true, null);
                }
            });
        }
        if (oneIsNotPlatformAndPersistent && this.dms_Startup == null) {
            DonationWindow.checkForDonationPopup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createWindow(IUIIntializer uiInitializer) {
        String configID2222;
        long startTime;
        block30: {
            startTime = SystemTime.getCurrentTime();
            this.uiFunctions = new UIFunctionsImpl(this);
            UIFunctionsManager.setUIFunctions(this.uiFunctions);
            Utils.disposeComposite(this.shell);
            this.increaseProgress(uiInitializer, "splash.initializeGui");
            System.out.println("UIFunctions/ImageLoad took " + (SystemTime.getCurrentTime() - startTime) + "ms");
            startTime = SystemTime.getCurrentTime();
            this.shell = new Shell(this.display, 1264);
            if (Constants.isWindows) {
                try {
                    Class<?> ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.win32.Win32UIEnhancer");
                    Method method = ehancerClass.getMethod("initMainShell", Shell.class);
                    method.invoke(null, this.shell);
                }
                catch (Exception e) {
                    Debug.outNoStack(Debug.getCompressedStackTrace(e, 0, 30), true);
                }
            }
            try {
                try {
                    this.shell.setData("class", this);
                    this.shell.setText("Vuze");
                    Utils.setShellIcon(this.shell);
                    Utils.linkShellMetricsToConfig(this.shell, "window");
                    System.out.println("new shell took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    PlatformConfigMessenger.addPlatformLoginCompleteListener(new PlatformConfigMessenger.PlatformLoginCompleteListener(){

                        public void platformLoginComplete() {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    MainWindow.this.setupUsageTracker();
                                }
                            });
                        }
                    });
                    try {
                        PlatformDevicesMessenger.setupDeviceSender();
                    }
                    catch (Exception e) {
                        Debug.out("failed to setup device sender ", e);
                    }
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.skin = SWTSkinFactory.getInstance();
                    if (Utils.isAZ2UI()) {
                        String[] ids;
                        SWTSkinProperties skinProperties = this.skin.getSkinProperties();
                        String skinPath = "com/aelitis/azureus/ui/skin/skin3_classic";
                        ResourceBundle rb = ResourceBundle.getBundle(skinPath);
                        skinProperties.addResourceBundle(rb, skinPath);
                        for (String id : ids = new String[]{"image.toolbar.2nd.m-bg", "image.toolbar.2nd.r-bg", "image.toolbar.2nd.l-bg", "image.toolbar.2nd-view.l-bg", "image.toolbar.2nd-view.r-bg", "image.toolbar.start", "image.toolbar.stop", "image.toolbar.remove", "image.toolbar.up", "image.toolbar.down"}) {
                            String s = skinProperties.getStringValue(id);
                            if (s == null) continue;
                            skinProperties.addProperty(id, s.replaceAll("/tb/", "/tb/c/"));
                        }
                    }
                    this.uiFunctions.setSkin(this.skin);
                    System.out.println("new shell setup took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.initSkinListeners();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    String startID = Utils.isAZ2UI() ? "classic.shell" : "main.shell";
                    this.skin.initialize(this.shell, startID, uiInitializer);
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("skin init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.menu = Utils.isAZ2UI() ? new org.gudy.azureus2.ui.swt.mainwindow.MainMenu(this.shell) : new MainMenu(this.skin, this.shell);
                    this.shell.setData("MainMenu", this.menu);
                    System.out.println("MainMenu init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (Constants.isOSX) {
                        Class<?> ehancerClass;
                        if (Utils.isCarbon) {
                            try {
                                ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CarbonUIEnhancer");
                                Method method = ehancerClass.getMethod("registerToolbarToggle", Shell.class);
                                method.invoke(null, this.shell);
                            }
                            catch (Exception e) {
                                Debug.printStackTrace(e);
                            }
                        } else if (Utils.isCocoa) {
                            try {
                                ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CocoaUIEnhancer");
                                Method mGetInstance = ehancerClass.getMethod("getInstance", new Class[0]);
                                Object claObj = mGetInstance.invoke(null, new Object[0]);
                                Method mregTBToggle = claObj.getClass().getMethod("registerToolbarToggle", Shell.class);
                                if (mregTBToggle != null) {
                                    mregTBToggle.invoke(claObj, this.shell);
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        Listener toggleListener = new Listener(){

                            public void handleEvent(Event event2) {
                                ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
                                if (tb != null) {
                                    tb.flipShowText();
                                }
                            }
                        };
                        this.shell.addListener(17, toggleListener);
                        this.shell.addListener(18, toggleListener);
                        System.out.println("createWindow init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                        startTime = SystemTime.getCurrentTime();
                    }
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.skin.layout();
                    try {
                        Utils.createTorrentDropTarget(this.shell, false);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LOGID, "Drag and Drop not available", e));
                    }
                    this.shell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            MainWindow.this.dispose(false, false);
                        }
                    });
                    this.shell.addShellListener(new ShellAdapter(){

                        public void shellClosed(ShellEvent event2) {
                            if (MainWindow.this.disposedOrDisposing) {
                                return;
                            }
                            if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray")) {
                                MainWindow.this.minimizeToTray(event2);
                            } else {
                                event2.doit = MainWindow.this.dispose(false, false);
                            }
                        }

                        public void shellActivated(ShellEvent e) {
                            Shell shellAppModal = Utils.findFirstShellWithStyle(65536);
                            if (shellAppModal != null) {
                                shellAppModal.forceActive();
                            } else {
                                MainWindow.this.shell.forceActive();
                            }
                        }

                        public void shellIconified(ShellEvent event2) {
                            if (MainWindow.this.disposedOrDisposing) {
                                return;
                            }
                            if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Minimize To Tray")) {
                                MainWindow.this.minimizeToTray(event2);
                            }
                        }

                        public void shellDeiconified(ShellEvent e) {
                            if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Password enabled")) {
                                MainWindow.this.shell.setVisible(false);
                                if (PasswordWindow.showPasswordWindow(MainWindow.this.display)) {
                                    MainWindow.this.shell.setVisible(true);
                                }
                            }
                        }
                    });
                    this.display.addFilter(1, new Listener(){

                        public void handleEvent(Event event2) {
                            Control focus_control = MainWindow.this.display.getFocusControl();
                            if (focus_control != null && focus_control.getShell() != MainWindow.this.shell) {
                                return;
                            }
                            int key = event2.character;
                            if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                                key += 96;
                            }
                            if (key == 108 && (event2.stateMask & SWT.MOD1) != 0) {
                                if (MainWindow.this.core == null) {
                                    return;
                                }
                                GlobalManager gm = MainWindow.this.core.getGlobalManager();
                                if (gm != null) {
                                    OpenTorrentWindow.invokeURLPopup(MainWindow.this.shell, gm);
                                    event2.doit = false;
                                }
                            }
                        }
                    });
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("pre skin widgets init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        StimulusRPC.hookListeners(this.core, this);
                    }
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.initMDI();
                    System.out.println("skin widgets (1/2) init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.initWidgets2();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("skin widgets (2/2) init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    System.out.println("pre SWTInstance init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "v3.splash.hookPluginUI");
                    startTime = SystemTime.getCurrentTime();
                    TableColumnCreatorV3.initCoreColumns();
                    System.out.println("Init Core Columns took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "v3.splash.hookPluginUI");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        this.uiSWTInstanceImpl = new UISWTInstanceImpl(this.core);
                        this.uiSWTInstanceImpl.init(uiInitializer);
                    }
                    System.out.println("SWTInstance init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "splash.initializeGui");
                    startTime = SystemTime.getCurrentTime();
                }
                catch (Throwable t) {
                    Debug.out(t);
                    Object var14_19 = null;
                    String configID2222 = "pluginbar.visible";
                    if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) {
                        COConfigurationManager.setBooleanDefault(configID2222, true);
                    }
                    this.setVisible(4, COConfigurationManager.getBooleanParameter(configID2222) && COConfigurationManager.getIntParameter("User Mode") > 1);
                    this.setVisible(2, COConfigurationManager.getBooleanParameter("IconBar.enabled"));
                    this.shell.layout(true, true);
                    System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.showMainWindow();
                    this.increaseProgress(uiInitializer, "splash.initializeGui");
                    System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.processStartupDMS();
                    System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        this.postPluginSetup(this.core);
                    }
                    System.out.println("vuzeactivities init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    NavigationHelper.addListener(new NavigationHelper.navigationListener(){

                        public void processCommand(final int type, final String[] args) {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (type == 1) {
                                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                                        if (mdi == null) {
                                            return;
                                        }
                                        ContentNetworkUtils.setSourceRef(args[0], "menu", false);
                                        mdi.showEntryByID(args[0]);
                                        if (uif != null) {
                                            uif.bringToFront();
                                        }
                                    } else if (type == 2) {
                                        // empty if block
                                    }
                                }
                            });
                        }
                    });
                    return;
                }
                Object var14_18 = null;
                configID2222 = "pluginbar.visible";
                if (ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) break block30;
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                String configID2222 = "pluginbar.visible";
                if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) {
                    COConfigurationManager.setBooleanDefault(configID2222, true);
                }
                this.setVisible(4, COConfigurationManager.getBooleanParameter(configID2222) && COConfigurationManager.getIntParameter("User Mode") > 1);
                this.setVisible(2, COConfigurationManager.getBooleanParameter("IconBar.enabled"));
                this.shell.layout(true, true);
                System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                this.showMainWindow();
                this.increaseProgress(uiInitializer, "splash.initializeGui");
                System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                this.processStartupDMS();
                System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                if (this.core != null) {
                    this.postPluginSetup(this.core);
                }
                System.out.println("vuzeactivities init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                NavigationHelper.addListener(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            COConfigurationManager.setBooleanDefault(configID2222, true);
        }
        this.setVisible(4, COConfigurationManager.getBooleanParameter(configID2222) && COConfigurationManager.getIntParameter("User Mode") > 1);
        this.setVisible(2, COConfigurationManager.getBooleanParameter("IconBar.enabled"));
        this.shell.layout(true, true);
        System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.showMainWindow();
        this.increaseProgress(uiInitializer, "splash.initializeGui");
        System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.processStartupDMS();
        System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        if (this.core != null) {
            this.postPluginSetup(this.core);
        }
        System.out.println("vuzeactivities init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        NavigationHelper.addListener(new /* invalid duplicate definition of identical inner class */);
    }

    private void increaseProgress(IUIIntializer uiInitializer, String taskKey) {
        if (uiInitializer != null) {
            uiInitializer.increaseProgress();
            if (taskKey != null) {
                uiInitializer.reportCurrentTask(MessageText.getString(taskKey));
            }
        }
    }

    public boolean dispose(final boolean for_restart, final boolean close_already_in_progress) {
        if (this.disposedOrDisposing) {
            return true;
        }
        return Utils.execSWTThreadWithBool("v3.MainWindow.dispose", new AERunnableBoolean(){

            public boolean runSupport() {
                return MainWindow.this._dispose(for_restart, close_already_in_progress);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _dispose(final boolean bForRestart, boolean bCloseAlreadyInProgress) {
        if (this.disposedOrDisposing) {
            return true;
        }
        this.isReady = false;
        this.disposedOrDisposing = true;
        if (this.core != null && !UIExitUtilsSWT.canClose(this.core.getGlobalManager(), bForRestart)) {
            this.disposedOrDisposing = false;
            return false;
        }
        UIExitUtilsSWT.uiShutdown();
        if (this.systemTraySWT != null) {
            this.systemTraySWT.dispose();
        }
        try {
            AllTransfersBar transfer_bar = AllTransfersBar.getBarIfOpen(this.core.getGlobalManager());
            if (transfer_bar != null) {
                transfer_bar.forceSaveLocation();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        mapTrackUsage_mon.enter();
        try {
            if (mapTrackUsage != null) {
                String id = this.getUsageActiveTabID();
                if (id != null) {
                    if (this.lastShellStatus == null) {
                        this.lastShellStatus = id;
                    }
                    this.updateMapTrackUsage(this.lastShellStatus);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("version", "4.6.0.4");
                map.put("statsmap", mapTrackUsage);
                FileUtil.writeResilientFile(new File(SystemProperties.getUserPath(), "timingstats.dat"), map);
            }
            Object var6_6 = null;
            mapTrackUsage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            mapTrackUsage_mon.exit();
            throw throwable;
        }
        if (!SWTThread.getInstance().isTerminated()) {
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    if (!SWTThread.getInstance().isTerminated()) {
                        SWTThread.getInstance().getInitializer().stopIt(bForRestart, false);
                    }
                }
            });
        }
        return true;
    }

    private String getUsageActiveTabID() {
        try {
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                MdiEntry curEntry = mdi.getCurrentEntry();
                if (curEntry == null) {
                    return "none";
                }
                String id = curEntry.getLogID();
                return id == null ? "null" : id;
            }
        }
        catch (Exception e) {
            String name = e.getClass().getName();
            int i = name.indexOf(46);
            if (i > 0) {
                return name.substring(i);
            }
            return name;
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupUsageTracker() {
        mapTrackUsage_mon.enter();
        try {
            try {
                File f = new File(SystemProperties.getUserPath(), "timingstats.dat");
                if (COConfigurationManager.getBooleanParameter("Send Version Info") && PlatformConfigMessenger.allowSendStats()) {
                    mapTrackUsage = new HashMap<String, Long>();
                    if (f.exists()) {
                        Map oldMapTrackUsage = FileUtil.readResilientFile(f);
                        String version = MapUtils.getMapString(oldMapTrackUsage, "version", null);
                        Map map = MapUtils.getMapMap(oldMapTrackUsage, "statsmap", null);
                        if (version != null && map != null) {
                            PlatformConfigMessenger.sendUsageStats(map, f.lastModified(), version, null);
                        }
                    }
                    SimpleTimer.addPeriodicEvent("UsageTracker", 1000L, new TimerEventPerformer(){
                        long lLastMouseMove = SystemTime.getCurrentTime();
                        Point ptLastMousePos = new Point(0, 0);

                        public void perform(TimerEvent event2) {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    if (MainWindow.this.shell == null || MainWindow.this.shell.isDisposed() || MainWindow.this.shell.getDisplay().getActiveShell() == null) {
                                        if (ptLastMousePos.x > 0) {
                                            ptLastMousePos.x = 0;
                                            ptLastMousePos.y = 0;
                                            lLastMouseMove = 0L;
                                        }
                                        return;
                                    }
                                    Point pt = MainWindow.this.shell.getDisplay().getCursorLocation();
                                    if (pt.equals(ptLastMousePos)) {
                                        return;
                                    }
                                    ptLastMousePos = pt;
                                    long now = SystemTime.getCurrentTime();
                                    if (lLastMouseMove > 0L) {
                                        long diff = now - lLastMouseMove;
                                        if (diff < 10000L) {
                                            MainWindow.this.lCurrentTrackTime += diff;
                                        } else {
                                            MainWindow.this.lCurrentTrackTimeIdle += diff;
                                        }
                                    }
                                    lLastMouseMove = now;
                                }
                            });
                        }
                    });
                    Listener lActivateDeactivate = new Listener(){
                        long start;

                        public void handleEvent(Event event2) {
                            if (event2.type == 26) {
                                MainWindow.this.lCurrentTrackTimeIdle = 0L;
                                if (this.start > 0L && MainWindow.this.lastShellStatus != null) {
                                    MainWindow.this.lCurrentTrackTime = SystemTime.getCurrentTime() - this.start;
                                    MainWindow.this.updateMapTrackUsage(MainWindow.this.lastShellStatus);
                                }
                                MainWindow.this.lastShellStatus = null;
                            } else {
                                MainWindow.this.updateMapTrackUsage(MainWindow.this.getUsageActiveTabID());
                                if (MainWindow.this.shell.getMinimized()) {
                                    MainWindow.this.lastShellStatus = "idle-minimized";
                                } else if (!MainWindow.this.shell.isVisible()) {
                                    MainWindow.this.lastShellStatus = "idle-invisible";
                                } else {
                                    MainWindow.this.lastShellStatus = "idle-nofocus";
                                }
                                this.start = SystemTime.getCurrentTime();
                            }
                        }
                    };
                    this.shell.addListener(26, lActivateDeactivate);
                    this.shell.addListener(27, lActivateDeactivate);
                } else {
                    mapTrackUsage = null;
                    try {
                        if (f.exists()) {
                            f.delete();
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                Object var6_7 = null;
                mapTrackUsage_mon.exit();
            }
            catch (Exception e) {
                Debug.out(e);
                Object var6_8 = null;
                mapTrackUsage_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            mapTrackUsage_mon.exit();
            throw throwable;
        }
    }

    private void showMainWindow() {
        COConfigurationManager.addAndFireParameterListener("Show Download Basket", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainWindow.this.configureDownloadBasket();
            }
        });
        boolean isOSX = Constants.isOSX;
        boolean bEnableTray = COConfigurationManager.getBooleanParameter("Enable System Tray");
        boolean bPassworded = COConfigurationManager.getBooleanParameter("Password enabled");
        boolean bStartMinimize = bEnableTray && (bPassworded || COConfigurationManager.getBooleanParameter("Start Minimized"));
        SWTSkinObject soMain = this.skin.getSkinObject("main");
        if (soMain != null) {
            soMain.getControl().setVisible(true);
        }
        this.shell.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                System.out.println("---------SHOWN AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
            }
        });
        if (!bStartMinimize) {
            this.shell.open();
            if (!isOSX) {
                this.shell.forceActive();
            }
        } else if (Utils.isCarbon) {
            this.shell.setVisible(true);
            this.shell.setMinimized(true);
        }
        if (this.delayedCore) {
            try {
                long endSWTDispatchOn = SystemTime.getOffsetTime(5000L);
                while (SystemTime.getCurrentTime() < endSWTDispatchOn && !this.display.isDisposed() && this.display.readAndDispatch()) {
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
            System.out.println("---------DONE DISPATCH AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
            if (this.display.isDisposed()) {
                return;
            }
        }
        if (bEnableTray) {
            try {
                this.systemTraySWT = new SystemTraySWT();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Logger.log(new LogEvent(LOGID, 3, "Upgrade to SWT3.0M8 or later for system tray support."));
            }
            if (bStartMinimize) {
                this.minimizeToTray(null);
            } else if (bPassworded) {
                this.minimizeToTray(null);
                this.setVisible(true);
            }
        }
        if (this.uiInitializer != null) {
            this.uiInitializer.initializationComplete();
        }
        boolean run_speed_test = false;
        if (!Utils.isAZ2UI() && !COConfigurationManager.getBooleanParameter("SpeedTest Completed")) {
            if (ConfigurationChecker.isNewInstall()) {
                run_speed_test = true;
            } else if (FeatureAvailability.triggerSpeedTestV1()) {
                long upload_limit = COConfigurationManager.getLongParameter("Max Upload Speed KBs");
                boolean auto_up = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
                if (auto_up) {
                    if (upload_limit <= 18L) {
                        run_speed_test = true;
                    }
                } else {
                    boolean up_seed_limit = COConfigurationManager.getBooleanParameter("enable.seedingonly.upload.rate");
                    if (upload_limit == 0L && !up_seed_limit) {
                        run_speed_test = true;
                    }
                }
            }
        }
        if (run_speed_test) {
            SpeedTestSelector.runMLABTest(false, new AERunnable(){

                public void runSupport() {
                    WelcomeView.setWaitLoadingURL(false);
                }
            });
        } else {
            WelcomeView.setWaitLoadingURL(false);
        }
        if (Utils.isAZ2UI()) {
            if (!COConfigurationManager.getBooleanParameter("Wizard Completed")) {
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        new ConfigureWizard(false, 0);
                    }
                });
            }
            this.checkForWhatsNewWindow();
        }
        AssociationChecker.checkAssociations();
        Map map = VersionCheckClient.getSingleton().getMostRecentVersionCheckData();
        DonationWindow.setInitialAskHours(MapUtils.getMapInt(map, "donations.askhrs", DonationWindow.getInitialAskHours()));
        if (this.core != null) {
            this.core.triggerLifeCycleComponentCreated(this.uiFunctions);
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                MainWindow.this.fixupActionBarSize();
                SWTSkinObject soPlusHeader = MainWindow.this.skin.getSkinObject("plus-header");
                if (soPlusHeader != null) {
                    soPlusHeader.addListener(new SWTSkinObjectListener(){

                        public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                            if (eventType == 1 || eventType == 0) {
                                MainWindow.this.fixupActionBarSize();
                            }
                            return null;
                        }
                    });
                }
            }
        });
        System.out.println("---------READY AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
        this.isReady = true;
    }

    private void configureDownloadBasket() {
        if (COConfigurationManager.getBooleanParameter("Show Download Basket")) {
            if (this.downloadBasket == null) {
                this.downloadBasket = new TrayWindow();
                this.downloadBasket.setVisible(true);
            }
        } else if (this.downloadBasket != null) {
            this.downloadBasket.setVisible(false);
            this.downloadBasket = null;
        }
    }

    private void checkForWhatsNewWindow() {
        String CONFIG_LASTSHOWN = "welcome.version.lastshown";
        try {
            int latestDisplayed;
            String lastShown = "";
            boolean bIsStringParam = true;
            try {
                lastShown = COConfigurationManager.getStringParameter("welcome.version.lastshown", "");
            }
            catch (Exception e) {
                bIsStringParam = false;
            }
            if (lastShown.length() == 0 && (latestDisplayed = COConfigurationManager.getIntParameter("welcome.version.lastshown", 0)) > 0) {
                bIsStringParam = false;
                String s = "" + latestDisplayed;
                for (int i = 0; i < s.length(); ++i) {
                    if (i != 0) {
                        lastShown = lastShown + ".";
                    }
                    lastShown = lastShown + s.charAt(i);
                }
            }
            if (Constants.compareVersions(lastShown, Constants.getBaseVersion()) < 0) {
                new WelcomeWindow(this.shell);
                if (!bIsStringParam) {
                    COConfigurationManager.removeParameter("welcome.version.lastshown");
                }
                COConfigurationManager.setParameter("welcome.version.lastshown", Constants.getBaseVersion());
                COConfigurationManager.save();
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void setVisible(boolean visible) {
        this.setVisible(visible, true);
    }

    public void setVisible(final boolean visible, boolean tryTricks) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int i;
                Shell[] shells;
                boolean currentlyVisible;
                boolean bl = currentlyVisible = MainWindow.this.shell.getVisible() && !MainWindow.this.shell.getMinimized();
                if (visible && !currentlyVisible && COConfigurationManager.getBooleanParameter("Password enabled") && !PasswordWindow.showPasswordWindow(MainWindow.this.display)) {
                    MainWindow.this.shell.setVisible(false);
                    return;
                }
                if (!MainWindow.this.isReady) {
                    return;
                }
                ArrayList<Shell> wasVisibleList = null;
                boolean bHideAndShow = false;
                if (bHideAndShow) {
                    wasVisibleList = new ArrayList<Shell>();
                    try {
                        MainWindow.this.shell.setMinimized(true);
                        shells = MainWindow.this.shell.getDisplay().getShells();
                        for (i = 0; i < shells.length; ++i) {
                            if (!shells[i].isVisible()) continue;
                            wasVisibleList.add(shells[i]);
                            shells[i].setVisible(false);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (visible) {
                    if (MainWindow.this.shell.getMinimized()) {
                        MainWindow.this.shell.setMinimized(false);
                    }
                    if (!currentlyVisible && COConfigurationManager.getBooleanParameter("window.maximized")) {
                        MainWindow.this.shell.setMaximized(true);
                    }
                } else {
                    COConfigurationManager.setParameter("window.maximized", MainWindow.this.shell.getMaximized());
                }
                MainWindow.this.shell.setVisible(visible);
                if (visible) {
                    MainWindow.this.shell.forceActive();
                    if (bHideAndShow) {
                        try {
                            shells = MainWindow.this.shell.getDisplay().getShells();
                            for (i = 0; i < shells.length; ++i) {
                                if (shells[i] == MainWindow.this.shell) continue;
                                if (wasVisibleList.contains(shells[i])) {
                                    shells[i].setVisible(visible);
                                }
                                shells[i].setFocus();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    private void minimizeToTray(ShellEvent event2) {
        if (event2 != null) {
            event2.doit = false;
        }
        COConfigurationManager.setParameter("window.maximized", this.shell.getMaximized());
        this.shell.setVisible(false);
        MiniBarManager.getManager().setAllVisible(true);
    }

    private void initSkinListeners() {
        UISkinnableManagerSWT skinnableManagerSWT = UISkinnableManagerSWT.getInstance();
        skinnableManagerSWT.addSkinnableListener(MessageBoxShell.class.toString(), new UISkinnableSWTListener(){

            public void skinBeforeComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
                byte[] contentThumbnail;
                MessageBoxShell shell = (MessageBoxShell)skinnableObject;
                TOTorrent torrent = null;
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                torrent = dm != null ? dm.getTorrent() : (TOTorrent)LogRelationUtils.queryForClass(relatedObjects, TOTorrent.class);
                if (torrent != null && shell.getLeftImage() == null && (contentThumbnail = PlatformTorrentUtils.getContentThumbnail(torrent)) != null) {
                    try {
                        ByteArrayInputStream bis = new ByteArrayInputStream(contentThumbnail);
                        final Image img = new Image((Device)Display.getDefault(), bis);
                        shell.setLeftImage(img);
                        composite.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (!img.isDisposed()) {
                                    img.dispose();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }

            public void skinAfterComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
            }
        });
        skinnableManagerSWT.addSkinnableListener(MessageSlideShell.class.toString(), new UISkinnableSWTListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void skinBeforeComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
                if (skinnableObject instanceof MessageSlideShell) {
                    final Image image = new Image((Device)composite.getDisplay(), 250, 300);
                    TOTorrent torrent = null;
                    DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                    torrent = dm != null ? dm.getTorrent() : (TOTorrent)LogRelationUtils.queryForClass(relatedObjects, TOTorrent.class);
                    MessageSlideShell shell = (MessageSlideShell)skinnableObject;
                    byte[] contentThumbnail = PlatformTorrentUtils.getContentThumbnail(torrent);
                    GC gc = new GC(image);
                    try {
                        gc.setBackground(gc.getDevice().getSystemColor(22));
                        gc.fillRectangle(image.getBounds());
                        if (contentThumbnail != null) {
                            try {
                                ByteArrayInputStream bis = new ByteArrayInputStream(contentThumbnail);
                                Image img = new Image((Device)Display.getDefault(), bis);
                                Rectangle imgBounds = img.getBounds();
                                double pct = 35.0 / (double)imgBounds.height;
                                int w = (int)((double)imgBounds.width * pct);
                                try {
                                    gc.setAdvanced(true);
                                    gc.setInterpolation(2);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                gc.drawImage(img, 0, 0, imgBounds.width, imgBounds.height, 0, 265, w, 35);
                                img.dispose();
                            }
                            catch (Exception e) {
                            }
                        }
                        Object var18_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_18 = null;
                        gc.dispose();
                        throw throwable;
                    }
                    gc.dispose();
                    shell.setImgPopup(image);
                    composite.addListener(12, new Listener(){

                        public void handleEvent(Event event2) {
                            if (!image.isDisposed()) {
                                image.dispose();
                            }
                        }
                    });
                }
            }

            public void skinAfterComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
            }
        });
    }

    private void setChildrenFG(Control parent, Color color) {
        parent.setForeground(color);
        if (parent instanceof Composite) {
            Control[] children = ((Composite)parent).getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control control = children[i];
                if (control instanceof Button && (((Button)control).getStyle() & 0x20) <= 0) continue;
                this.setChildrenFG(control, color);
            }
        }
    }

    private void initMDI() {
        Class classMDI = Utils.isAZ2UI() ? TabbedMDI.class : SideBar.class;
        try {
            SWTSkinObject skinObject = this.skin.getSkinObject("mdi");
            if (null != skinObject) {
                BaseMDI mdi = (BaseMDI)classMDI.newInstance();
                mdi.setMainSkinObject(skinObject);
                skinObject.addListener(mdi);
                MainMDISetup.setupSideBar(mdi, this);
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    private void initWidgets2() {
        SWTSkinObject skinObject = this.skin.getSkinObject("statusbar");
        if (skinObject != null) {
            Composite cArea = (Composite)skinObject.getControl();
            this.statusBar = new MainStatusBar();
            Composite composite = this.statusBar.initStatusBar(cArea);
            composite.setLayoutData(Utils.getFilledFormData());
        }
        if ((skinObject = this.skin.getSkinObject("search-text")) != null) {
            this.attachSearchBox(skinObject);
        }
        if ((skinObject = this.skin.getSkinObject("pluginbar")) != null) {
            Menu topbarMenu = new Menu(this.shell, 8);
            if (COConfigurationManager.getIntParameter("User Mode") > 1) {
                MainMenu.createViewMenuItem(this.skin, topbarMenu, "v3.MainWindow.menu.view.pluginbar", "pluginbar.visible", "pluginbar", true, -1);
            }
            final MenuItem itemShowText = new MenuItem(topbarMenu, 32);
            Messages.setLanguageText(itemShowText, "v3.MainWindow.menu.showActionBarText");
            itemShowText.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
                    if (tb != null) {
                        tb.flipShowText();
                    }
                }
            });
            new MenuItem(topbarMenu, 2);
            MenuItem itemExport = new MenuItem(topbarMenu, 8);
            Messages.setLanguageText(itemExport, "search.export.all");
            itemExport.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final Shell shell = Utils.findAnyShell();
                    shell.getDisplay().asyncExec(new AERunnable(){

                        public void runSupport() {
                            FileDialog dialog = new FileDialog(shell, 139264);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                            dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                            dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                            String path = TorrentOpener.setFilterPathData(dialog.open());
                            if (path != null) {
                                String lc = path.toLowerCase();
                                if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                                    path = path + ".vuze";
                                }
                                try {
                                    MetaSearchManagerFactory.getSingleton().getMetaSearch().exportEngines(new File(path));
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            });
            topbarMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
                    if (tb != null) {
                        itemShowText.setSelection(tb.getShowText());
                    }
                }

                public void menuHidden(MenuEvent e) {
                }
            });
            this.addMenuAndNonTextChildren((Composite)skinObject.getControl(), topbarMenu);
            skinObject = this.skin.getSkinObject("tabbar");
            if (skinObject != null) {
                this.addMenuAndNonTextChildren((Composite)skinObject.getControl(), topbarMenu);
            }
        }
    }

    private void addMenuAndNonTextChildren(Composite parent, Menu menu) {
        parent.setMenu(menu);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control instanceof Composite) {
                Composite c = (Composite)control;
                this.addMenuAndNonTextChildren(c, menu);
                continue;
            }
            if (control instanceof Text) continue;
            control.setMenu(menu);
        }
    }

    private void attachSearchBox(SWTSkinObject skinObject) {
        SWTSkinObject so;
        Composite cArea = (Composite)skinObject.getControl();
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                MainWindow.this.fixupActionBarSize();
            }
        });
        final Text text = new Text(cArea, 0);
        FormData filledFormData = Utils.getFilledFormData();
        text.setLayoutData(filledFormData);
        text.setData("ObfusticateImage", new ObfusticateImage(){

            public Image obfusticatedImage(Image image) {
                Point location = Utils.getLocationRelativeToShell(text);
                Point size = text.getSize();
                UIDebugGenerator.obfusticateArea(MainWindow.this.display, image, new Rectangle(location.x, location.y, size.x, size.y));
                return image;
            }
        });
        text.addListener(11, new Listener(){
            Font lastFont = null;

            public void handleEvent(Event event2) {
                Text text = (Text)event2.widget;
                int h = text.getClientArea().height - 2;
                Font font = FontUtils.getFontWithHeight(text.getFont(), null, h);
                if (font != null) {
                    text.setFont(font);
                    Utils.disposeSWTObjects(new Object[]{this.lastFont});
                    text.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            Text text = (Text)e.widget;
                            text.setFont(null);
                            Utils.disposeSWTObjects(new Object[]{lastFont});
                        }
                    });
                }
            }
        });
        text.setTextLimit(254);
        if (Constants.isWindows) {
            text.addListener(3, new Listener(){

                public void handleEvent(Event event2) {
                    if (event2.count == 3) {
                        text.selectAll();
                    }
                }
            });
        }
        final String sDefault = MessageText.getString("v3.MainWindow.search.defaultText");
        SWTSkinProperties properties = skinObject.getProperties();
        this.colorSearchTextBG = properties.getColor("color.search.text.bg");
        this.colorSearchTextFG = properties.getColor("color.search.text.fg");
        this.colorSearchTextFGdef = properties.getColor("color.search.text.fg.default");
        if (this.colorSearchTextFGdef != null) {
            text.setForeground(this.colorSearchTextFGdef);
        }
        if (this.colorSearchTextBG != null) {
            text.setBackground(this.colorSearchTextBG);
        }
        text.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Text text = (Text)e.widget;
                if (text.getText().equals(sDefault)) {
                    if (MainWindow.this.colorSearchTextFG != null) {
                        text.setForeground(MainWindow.this.colorSearchTextFG);
                    }
                    text.setText("");
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == SWT.MOD1) {
                    int key = e.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (key == 97) {
                        text.selectAll();
                    }
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        text.addListener(1, new Listener(){

            public void handleEvent(Event event2) {
                if (text.getText().equals(sDefault)) {
                    if (MainWindow.this.colorSearchTextFG != null) {
                        text.setForeground(MainWindow.this.colorSearchTextFG);
                    }
                    if (event2.character != '\u0000') {
                        text.setText("");
                    }
                    return;
                }
                Text text2 = (Text)event2.widget;
                if (event2.keyCode == 27) {
                    text2.setText("");
                    return;
                }
                if (event2.character == '\r') {
                    MainWindow.doSearch(text2.getText());
                }
            }
        });
        text.setText(sDefault);
        SWTSkinObject searchGo = this.skin.getSkinObject("search-go");
        if (searchGo != null) {
            SWTSkinButtonUtility btnGo = new SWTSkinButtonUtility(searchGo);
            btnGo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String sSearchText = text.getText().trim();
                    MainWindow.doSearch(sSearchText);
                }
            });
        }
        if ((so = this.skin.getSkinObject("sidebar-list")) != null && so.getProperties().getBooleanValue(so.getConfigID() + ".resizeSearch", false)) {
            Listener l = new Listener(){

                public void handleEvent(Event event2) {
                    SWTSkinObject soSearchArea = MainWindow.this.skin.getSkinObject("topbar-area-search");
                    if (soSearchArea != null) {
                        Control c = soSearchArea.getControl();
                        Rectangle bounds = ((Control)event2.widget).getBounds();
                        FormData fd = (FormData)c.getLayoutData();
                        int newWidth = bounds.width - 1 - c.getBounds().x;
                        if (bounds.width < 125) {
                            return;
                        }
                        fd.width = newWidth;
                        Utils.relayout(c);
                    }
                }
            };
            so.getControl().addListener(11, l);
        }
        if ((so = this.skin.getSkinObject("search-dropdown")) != null) {
            SWTSkinButtonUtility btnSearchDD = new SWTSkinButtonUtility(so);
            btnSearchDD.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String sSearchText = text.getText().trim();
                    MainWindow.doSearch(sSearchText);
                }
            });
        }
    }

    protected void fixupActionBarSize() {
        int MAXWIDTH = 320;
        Rectangle clientArea = this.shell.getClientArea();
        SWTSkinObject soSearch = this.skin.getSkinObject("topbar-area-search");
        if (soSearch == null) {
            return;
        }
        FormData fd = (FormData)soSearch.getControl().getLayoutData();
        if (fd == null || fd.width <= 0) {
            return;
        }
        if (clientArea.width > 1124 && fd.width == 320) {
            return;
        }
        SWTSkinObject soTabBar = this.skin.getSkinObject("tabbar");
        if (soTabBar == null) {
            return;
        }
        Point size = soTabBar.getControl().computeSize(-1, -1);
        int oldWidth = fd.width;
        fd.width = clientArea.width - (size.x - oldWidth) - 5;
        if (fd.width < 100) {
            fd.width = 100;
        } else if (fd.width > 320) {
            fd.width = 320;
        }
        if (oldWidth != fd.width) {
            ((Composite)soTabBar.getControl()).layout(true, true);
        }
    }

    public static void doSearch(final String sSearchText) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MainWindow.doSearch(sSearchText, false);
            }
        });
    }

    public static void doSearch(String sSearchText, boolean toSubscribe) {
        String id;
        String sDefault = MessageText.getString("v3.MainWindow.search.defaultText");
        if (sSearchText.equals(sDefault) || sSearchText.length() == 0) {
            return;
        }
        SearchResultsTabArea.SearchQuery sq = new SearchResultsTabArea.SearchQuery(sSearchText, toSubscribe);
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        MdiEntry existingEntry = mdi.getEntry(id = "Search");
        if (existingEntry != null && existingEntry.isAdded()) {
            SearchResultsTabArea searchClass = (SearchResultsTabArea)SkinViewManager.getByClass(SearchResultsTabArea.class);
            if (searchClass != null) {
                searchClass.anotherSearch(sSearchText, toSubscribe);
            }
            mdi.showEntry(existingEntry);
            return;
        }
        MdiEntry entry = mdi.createEntryFromSkinRef("header.vuze", id, "main.area.searchresultstab", sSearchText, null, (Object)sq, true, null);
        if (entry != null) {
            entry.setImageLeftID("image.sidebar.search");
            entry.setDatasource(sq);
            entry.setViewTitleInfo(new ViewTitleInfo(){

                public Object getTitleInfoProperty(int propertyID) {
                    SearchResultsTabArea searchClass;
                    if (propertyID == 5 && (searchClass = (SearchResultsTabArea)SkinViewManager.getByClass(SearchResultsTabArea.class)) != null && searchClass.sq != null) {
                        return searchClass.sq.term;
                    }
                    return null;
                }
            });
        }
        mdi.showEntryByID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapTrackUsage(String sTabID) {
        if (mapTrackUsage != null) {
            mapTrackUsage_mon.enter();
            try {
                Long currentLength;
                long newLength;
                if (this.lCurrentTrackTime > 0L && (newLength = (currentLength = mapTrackUsage.get(sTabID)) == null ? this.lCurrentTrackTime : currentLength + this.lCurrentTrackTime) > 1000L) {
                    mapTrackUsage.put(sTabID, new Long(newLength / 1000L));
                }
                if (this.lCurrentTrackTimeIdle > 0L) {
                    long newLengthIdle;
                    String id = "idle-" + sTabID;
                    Long currentLengthIdle = mapTrackUsage.get(id);
                    long l = newLengthIdle = currentLengthIdle == null ? this.lCurrentTrackTimeIdle : currentLengthIdle + this.lCurrentTrackTimeIdle;
                    if (newLengthIdle > 1000L) {
                        mapTrackUsage.put(id, new Long(newLengthIdle / 1000L));
                    }
                }
                Object var7_6 = null;
                mapTrackUsage_mon.exit();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                mapTrackUsage_mon.exit();
                throw throwable;
            }
        }
        this.lCurrentTrackTime = 0L;
        this.lCurrentTrackTimeIdle = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUsageStat(String id, long value) {
        if (id == null) {
            return;
        }
        if (id.length() > 150) {
            id = id.substring(0, 150);
        }
        if (mapTrackUsage != null) {
            mapTrackUsage_mon.enter();
            try {
                Long currentLength = mapTrackUsage.get(id);
                long newLength = currentLength == null ? value : currentLength + value;
                if (newLength > 1000L) {
                    mapTrackUsage.put(id, new Long(newLength / 1000L));
                }
                Object var7_4 = null;
                mapTrackUsage_mon.exit();
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                mapTrackUsage_mon.exit();
                throw throwable;
            }
        }
    }

    public UISWTInstance getUISWTInstanceImpl() {
        return this.uiSWTInstanceImpl;
    }

    public void showURL(final String url, String target) {
        if ("_blank".equalsIgnoreCase(target)) {
            Utils.launch(url);
            return;
        }
        if (target.startsWith("tab-")) {
            target = target.substring(4);
        }
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if ("Plus".equals(target)) {
            SBC_PlusFTUX.setSourceRef(url.substring(1));
            mdi.showEntryByID(target);
            return;
        }
        if (mdi == null || !mdi.showEntryByID(target)) {
            Utils.launch(url);
            return;
        }
        MdiEntry entry = mdi.getEntry(target);
        entry.addListener(new MdiEntryOpenListener(){

            public void mdiEntryOpen(MdiEntry entry) {
                entry.removeListener(this);
                MainWindow.this.setVisible(true);
                if (!(entry instanceof SideBarEntrySWT)) {
                    return;
                }
                SideBarEntrySWT entrySWT = (SideBarEntrySWT)entry;
                SWTSkinObjectBrowser soBrowser = SWTSkinUtils.findBrowserSO(entrySWT.getSkinObject());
                if (soBrowser != null) {
                    if (url == null || url.length() == 0) {
                        soBrowser.restart();
                    } else {
                        String fullURL = url;
                        if (UrlFilter.getInstance().urlCanRPC(url)) {
                            fullURL = ConstantsVuze.getDefaultContentNetwork().appendURLSuffix(url, false, true);
                        }
                        soBrowser.setURL(fullURL);
                    }
                }
            }
        });
    }

    protected MainStatusBar getMainStatusBar() {
        return this.statusBar;
    }

    @Override
    public boolean isVisible(int windowElement) {
        if (windowElement == 2) {
            SWTSkinObject skinObject = this.skin.getSkinObject("tabbar");
            if (skinObject != null) {
                return skinObject.isVisible();
            }
        } else if (windowElement == 4) {
            SWTSkinObject skinObject = this.skin.getSkinObject("pluginbar");
            if (skinObject != null) {
                return skinObject.isVisible();
            }
        } else if (windowElement == 3 || windowElement == 1) {
            // empty if block
        }
        return false;
    }

    @Override
    public void setVisible(int windowElement, boolean value) {
        if (windowElement == 2) {
            SWTSkinUtils.setVisibility(this.skin, "IconBar.enabled", "tabbar", value, true, true);
        } else if (windowElement == 4) {
            SWTSkinUtils.setVisibility(this.skin, "pluginbar.visible", "pluginbar", value, true, true);
        } else if (windowElement == 3 || windowElement == 1) {
            // empty if block
        }
    }

    @Override
    public Rectangle getMetrics(int windowElement) {
        if (windowElement != 2) {
            if (windowElement == 4) {
                SWTSkinObject skinObject = this.skin.getSkinObject("pluginbar");
                if (skinObject != null) {
                    return skinObject.getControl().getBounds();
                }
            } else {
                if (windowElement == 3) {
                    return this.statusBar.getBounds();
                }
                if (windowElement == 6) {
                    return this.shell.getClientArea();
                }
                if (windowElement == 7) {
                    Rectangle r = this.getMetrics(6);
                    r.height -= this.getMetrics((int)4).height;
                    r.height -= this.getMetrics((int)2).height;
                    r.height -= this.getMetrics((int)3).height;
                    return r;
                }
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public boolean isReady() {
        return this.isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image generateObfusticatedImage() {
        Rectangle shellBounds = this.shell.getBounds();
        Rectangle shellClientArea = this.shell.getClientArea();
        Image fullImage = new Image((Device)this.display, shellBounds.width, shellBounds.height);
        Image subImage = new Image((Device)this.display, shellClientArea.width, shellClientArea.height);
        GC gc = new GC((Drawable)this.display);
        try {
            gc.copyArea(fullImage, shellBounds.x, shellBounds.y);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        GC gcShell = new GC(this.shell);
        try {
            gcShell.copyArea(subImage, 0, 0);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            gcShell.dispose();
            throw throwable;
        }
        gcShell.dispose();
        GC gcFullImage = new GC(fullImage);
        try {
            Point location = this.shell.toDisplay(0, 0);
            gcFullImage.drawImage(subImage, location.x - shellBounds.x, location.y - shellBounds.y);
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            gcFullImage.dispose();
            throw throwable;
        }
        gcFullImage.dispose();
        subImage.dispose();
        Control[] children = this.shell.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            SWTSkinObject so = (SWTSkinObject)control.getData("SkinObject");
            if (!(so instanceof ObfusticateImage)) continue;
            ObfusticateImage oi = (ObfusticateImage)((Object)so);
            oi.obfusticatedImage(fullImage);
        }
        return fullImage;
    }

    public void openView(final String parentID, final Class<?> cla, String id, final Object data, final boolean closeable) {
        IView viewFromID;
        int i;
        final MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return;
        }
        if (id == null && (i = (id = cla.getName()).lastIndexOf(46)) > 0) {
            id = id.substring(i + 1);
        }
        if ((viewFromID = mdi.getIViewFromID(id)) != null) {
            mdi.showEntryByID(id);
        }
        final String _id = id;
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (mdi.showEntryByID(_id)) {
                    return;
                }
                if (UISWTViewEventListener.class.isAssignableFrom(cla)) {
                    UISWTViewEventListener l = null;
                    try {
                        Constructor constructor = cla.getConstructor(data.getClass());
                        l = (UISWTViewEventListener)constructor.newInstance(data);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (l == null) {
                            l = (UISWTViewEventListener)cla.newInstance();
                        }
                        mdi.createEntryFromEventListener(parentID, l, _id, closeable, data);
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                } else {
                    mdi.createEntryFromIViewClass(parentID, _id, null, cla, null, null, data, null, true);
                }
                mdi.showEntryByID(_id);
            }
        });
    }

    @Override
    public void mdiEntrySelected(MdiEntry newEntry, MdiEntry oldEntry) {
        if (newEntry == null) {
            return;
        }
        COConfigurationManager.setParameter("v3.StartTab", newEntry.getId());
        if (mapTrackUsage != null && oldEntry != null) {
            oldEntry.removeListener(this);
            String id2 = null;
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                id2 = oldEntry.getLogID();
            }
            if (id2 == null) {
                id2 = oldEntry.getId();
            }
            this.updateMapTrackUsage(id2);
        }
        if (mapTrackUsage != null) {
            newEntry.addListener(this);
        }
    }

    @Override
    public void mdiEntryLogIdChanged(MdiEntry sideBarEntrySWT, String oldID, String newID) {
        if (oldID == null) {
            oldID = "null";
        }
        this.updateMapTrackUsage(oldID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("SWT UI");
        try {
            writer.indent();
            TableColumnManager.getInstance().generateDiagnostics(writer);
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }

    protected void setSelectedLanguageItem() {
        Messages.updateLanguageForControl(this.shell);
        if (this.systemTraySWT != null) {
            this.systemTraySWT.updateLanguage();
        }
        if (this.statusBar != null) {
            this.statusBar.refreshStatusText();
        }
        this.skin.triggerLanguageChange();
        if (this.statusBar != null) {
            this.statusBar.updateStatusText();
        }
        if (this.menu != null) {
            MenuFactory.updateMenuText(this.menu.getMenu("menu.bar"));
        }
    }

    protected IMainMenu getMainMenu() {
        return this.menu;
    }

    @Override
    public void updateUI() {
    }

    @Override
    public String getUpdateUIName() {
        return "MainWindow";
    }

    static /* synthetic */ DownloadManager[] access$302(MainWindow x0, DownloadManager[] x1) {
        x0.dms_Startup = x1;
        return x1;
    }

    static /* synthetic */ void access$1700(MainWindow x0, Control x1, Color x2) {
        x0.setChildrenFG(x1, x2);
    }
}

