/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.FilesViewMenuUtil;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnProgressETA
extends CoreTableColumn
implements TableCellAddedListener,
TableCellMouseListener,
TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "ProgressETA";
    private static final int borderWidth = 1;
    private static final int COLUMN_WIDTH = 200;
    public static final long SHOW_ETA_AFTER_MS = 30000L;
    private static final Object CLICK_KEY = new Object();
    private static Font fontText = null;
    Display display;
    private Color cBG;
    private Color cBorder;
    private Color cText;
    Color textColor;
    private Image imgArrowButton;
    private Image imgPriHi;
    private Image imgPriNormal;
    private Image imgPriStopped;
    private Image imgBGTorrent;
    private Image imgBGfile;
    private Color cTextDrop;
    private static final int MAX_PROGRESS_FILL_HEIGHT = 19;
    private Font progressFont;

    public ColumnProgressETA(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 200, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.initializeAsGraphic(200);
        this.setAlignment(1);
        this.setMinWidth(200);
        this.display = SWTThread.getInstance().getDisplay();
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.cBG = skinProperties.getColor("color.progress.bg");
        if (this.cBG == null) {
            this.cBG = Colors.blues[9];
        }
        this.cBorder = skinProperties.getColor("color.progress.border");
        if (this.cBorder == null) {
            this.cBorder = Colors.grey;
        }
        this.cText = skinProperties.getColor("color.progress.text");
        if (this.cText == null) {
            this.cText = Colors.black;
        }
        this.cTextDrop = skinProperties.getColor("color.progress.text.drop");
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgArrowButton = imageLoader.getImage("image.fileprogress.arrowbtn");
        this.imgPriHi = imageLoader.getImage("image.fileprogress.pri.hi");
        this.imgPriNormal = imageLoader.getImage("image.fileprogress.pri.normal");
        this.imgPriStopped = imageLoader.getImage("image.fileprogress.pri.stopped");
        this.imgBGTorrent = imageLoader.getImage("image.progress.bg.torrent");
        this.imgBGfile = imageLoader.getImage("image.progress.bg.file");
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "essential", "time"});
        info.setProficiency((byte)0);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(3);
        cell.setMarginWidth(8);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String url;
        Object ds = event2.cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            this.fileInfoMouseTrigger(event2);
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm == null) {
            return;
        }
        String clickable = (String)dm.getUserData(CLICK_KEY);
        if (clickable == null) {
            return;
        }
        event2.skipCoreFunctionality = true;
        if (event2.eventType == 1 && (url = UrlUtils.getURL(clickable)) != null) {
            Utils.launch(url);
        }
    }

    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        int percentDone = this.getPercentDone(ds);
        long sortValue = 0L;
        if (ds instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            long completedTime = dm.getDownloadState().getLongParameter("stats.download.completed.time");
            sortValue = completedTime <= 0L || !dm.isDownloadComplete(false) ? 9223372036854765807L + (long)percentDone : completedTime;
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            int st = fileInfo2.getStorageType();
            if ((st == 2 || st == 4) && fileInfo2.isSkipped()) {
                sortValue = 1L;
            } else if (fileInfo2.isSkipped()) {
                sortValue = 2L;
            } else if (fileInfo2.getPriority() > 0) {
                int pri = fileInfo2.getPriority();
                sortValue = 4L;
                if (pri > 1) {
                    sortValue += (long)pri;
                }
            } else {
                sortValue = 3L;
            }
            sortValue = (long)(fileInfo2.getDownloadManager().getState() * 10000 + percentDone) + sortValue;
        }
        long eta = this.getETA(cell);
        long speed = this.getSpeed(ds);
        boolean sortChanged = cell.setSortValue(sortValue);
        if (sortChanged) {
            UIFunctionsManagerSWT.getUIFunctionsSWT().refreshIconBar();
        }
        long lastETA = 0L;
        long lastSpeed = 0L;
        TableRow row = cell.getTableRow();
        if (row != null) {
            Object data = row.getData("lastETA");
            if (data instanceof Number) {
                lastETA = ((Number)data).longValue();
            }
            row.setData("lastETA", new Long(eta));
            data = row.getData("lastSpeed");
            if (data instanceof Number) {
                lastSpeed = ((Number)data).longValue();
            }
            row.setData("lastSpeed", new Long(speed));
        }
        if (!(sortChanged || lastETA == eta && lastSpeed == speed)) {
            cell.invalidate();
        }
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        boolean showSecondLine;
        Color fgFirst;
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            this.fillInfoProgressETA(cell.getTableRowCore(), gc, (DiskManagerFileInfo)ds, cell.getBounds());
            return;
        }
        if (!(ds instanceof DownloadManager)) {
            return;
        }
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int percentDone = this.getPercentDone(ds);
        long eta = this.getETA(cell);
        int newWidth = cell.getWidth();
        if (newWidth <= 0) {
            return;
        }
        int newHeight = cell.getHeight();
        Color fgOriginal = fgFirst = gc.getForeground();
        Rectangle cellBounds = cell.getBounds();
        int xStart = cellBounds.x;
        int yStart = cellBounds.y;
        int xRelProgressFillStart = 1;
        int yRelProgressFillStart = 1;
        int xRelProgressFillEnd = newWidth - xRelProgressFillStart - 1;
        int yRelProgressFillEnd = yRelProgressFillStart + 13;
        boolean bl = showSecondLine = yRelProgressFillEnd + 10 < newHeight;
        if (xRelProgressFillEnd < 10 || xRelProgressFillEnd < 10) {
            return;
        }
        String sETALine = null;
        if (percentDone < 1000) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            Rectangle boundsImgBG = !ImageLoader.isRealImage(this.imgBGTorrent) ? new Rectangle(0, 0, 0, 13) : this.imgBGTorrent.getBounds();
            if (fontText == null) {
                fontText = FontUtils.getFontWithHeight(gc.getFont(), gc, boundsImgBG.height - 3);
            }
            if (!showSecondLine) {
                yRelProgressFillStart = cellBounds.height / 2 - (boundsImgBG.height + 2) / 2;
            }
            yRelProgressFillEnd = yRelProgressFillStart + boundsImgBG.height;
            int progressWidth = newWidth - 2;
            gc.setForeground(this.cBorder);
            gc.drawRectangle(xStart + xRelProgressFillStart - 1, yStart + yRelProgressFillStart - 1, progressWidth + 1, boundsImgBG.height + 1);
            int pctWidth = percentDone * (progressWidth - 1) / 1000;
            gc.setBackground(this.cBG);
            gc.fillRectangle(xStart + xRelProgressFillStart, yStart + yRelProgressFillStart, pctWidth, boundsImgBG.height);
            gc.setBackground(Colors.white);
            gc.fillRectangle(xStart + xRelProgressFillStart + pctWidth, yStart + yRelProgressFillStart, progressWidth - pctWidth, boundsImgBG.height);
            if (boundsImgBG.width > 0) {
                gc.drawImage(this.imgBGTorrent, 0, 0, boundsImgBG.width, boundsImgBG.height, xStart + xRelProgressFillStart, yStart + yRelProgressFillStart, progressWidth - 2, boundsImgBG.height);
            }
        }
        if (sETALine == null) {
            int cursor_id;
            if (dm.isUnauthorisedOnTracker()) {
                sETALine = dm.getTrackerStatus();
            } else if (!dm.isDownloadComplete(true)) {
                if (eta > 0L) {
                    String sETA = TimeFormatter.format(eta);
                    sETALine = MessageText.getString("MyTorrents.column.ColumnProgressETA.2ndLine", new String[]{sETA});
                } else {
                    sETALine = DisplayFormatters.formatDownloadStatus(dm).toUpperCase();
                }
            }
            if (sETALine != null && sETALine.indexOf("http://") == -1) {
                dm.setUserData(CLICK_KEY, null);
                cursor_id = 0;
            } else {
                dm.setUserData(CLICK_KEY, sETALine);
                cursor_id = 21;
                if (!cell.getTableRow().isSelected()) {
                    fgFirst = Colors.blue;
                }
            }
            cell.setCursorID(cursor_id);
        }
        gc.setTextAntialias(1);
        gc.setFont(fontText);
        if (showSecondLine && sETALine != null) {
            gc.setForeground(fgFirst);
            boolean over = GCStringPrinter.printString(gc, sETALine, new Rectangle(xStart + 2, yStart + yRelProgressFillEnd, xRelProgressFillEnd, newHeight - yRelProgressFillEnd), true, false, 0x1000000);
            cell.setToolTip(over ? sETALine : null);
        }
        int middleY = (yRelProgressFillEnd - 12) / 2;
        if (percentDone == 1000 || dm.isDownloadComplete(false)) {
            gc.setForeground(fgFirst);
            long completedTime = dm.getDownloadState().getLongParameter("stats.download.completed.time");
            long value = completedTime <= 0L ? dm.getDownloadState().getLongParameter("stats.download.added.time") : completedTime;
            if (this.getTableID() == "MyLibrary.big") {
                if (percentDone == 1000) {
                    gc.setForeground(fgOriginal);
                } else {
                    gc.setForeground(Colors.black);
                }
            } else {
                gc.setForeground(this.cText);
            }
            String s = MessageText.getString("MyTorrents.column.ColumnProgressETA.compon", new String[]{DisplayFormatters.formatDateShort(value)});
            if (percentDone < 1000) {
                s = DisplayFormatters.formatPercentFromThousands(percentDone) + " " + s;
            }
            GCStringPrinter.printString(gc, s, new Rectangle(xStart + 2, yStart, newWidth - 4, newHeight), true, false, 64);
        } else {
            long lSpeed = this.getSpeed(ds);
            String sSpeed = lSpeed <= 0L ? "" : " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(lSpeed, true) + ")";
            String sPercent = DisplayFormatters.formatPercentFromThousands(percentDone);
            Rectangle area = new Rectangle(xStart + xRelProgressFillStart + 3, yStart + yRelProgressFillStart, xRelProgressFillEnd - xRelProgressFillStart - 6, yRelProgressFillEnd - yRelProgressFillStart);
            GCStringPrinter sp = new GCStringPrinter(gc, sPercent + sSpeed, area, true, false, 16384);
            if (this.cTextDrop != null) {
                ++area.x;
                ++area.y;
                gc.setForeground(this.cTextDrop);
                sp.printString();
                --area.x;
                --area.y;
            }
            gc.setForeground(this.cText);
            sp.printString();
            Point pctExtent = sp.getCalculatedSize();
            area.width -= pctExtent.x + 3;
            area.x += pctExtent.x + 3;
            if (!showSecondLine && sETALine != null) {
                boolean fit = GCStringPrinter.printString(gc, sETALine, area.intersection(cellBounds), true, false, 131072);
                cell.setToolTip(fit ? null : sETALine);
            }
        }
        gc.setFont(null);
    }

    private int getPercentDone(Object ds) {
        if (ds instanceof DownloadManager) {
            return ((DownloadManager)ds).getStats().getDownloadCompleted(true);
        }
        if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            long length = fileInfo2.getLength();
            if (length == 0L) {
                return 1000;
            }
            return (int)(fileInfo2.getDownloaded() * 1000L / length);
        }
        return 0;
    }

    private long getETA(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            return 0L;
        }
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long diff = SystemTime.getCurrentTime() - dm.getStats().getTimeStarted();
        if (diff > 30000L) {
            return dm.getStats().getETA();
        }
        return 0L;
    }

    private int getState(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return 100;
        }
        return dm.getState();
    }

    private boolean isStopped(TableCell cell) {
        int state = this.getState(cell);
        return state == 75 || state == 70 || state == 65 || state == 100;
    }

    private long getSpeed(Object ds) {
        if (!(ds instanceof DownloadManager)) {
            return 0L;
        }
        return ((DownloadManager)ds).getStats().getDataReceiveRate();
    }

    public EnhancedDownloadManager getEDM(DownloadManager dm) {
        DownloadManagerEnhancer dmEnhancer = DownloadManagerEnhancer.getSingleton();
        if (dmEnhancer == null) {
            return null;
        }
        return dmEnhancer.getEnhancedDownload(dm);
    }

    private void log(TableCell cell, String s) {
        System.out.println(((TableRowCore)cell.getTableRow()).getIndex() + ":" + System.currentTimeMillis() + ": " + s);
    }

    private void fillInfoProgressETA(TableRowCore row, GC gc, DiskManagerFileInfo fileInfo2, Rectangle cellArea) {
        long percent = 0L;
        long bytesDownloaded = fileInfo2.getDownloaded();
        long length = fileInfo2.getLength();
        if (bytesDownloaded < 0L) {
            return;
        }
        if (length == 0L) {
            percent = 1000L;
        } else if (fileInfo2.getLength() != 0L) {
            percent = 1000L * bytesDownloaded / length;
        }
        gc.setAdvanced(true);
        gc.setTextAntialias(1);
        int BUTTON_WIDTH = this.imgArrowButton.getBounds().width;
        int HILOW_WIDTH = this.imgPriHi.getBounds().width;
        int BUTTON_HEIGHT = this.imgArrowButton.getBounds().height;
        int HILOW_HEIGHT = this.imgPriHi.getBounds().height;
        int PADDING_X = 12;
        int PADDING_TEXT = 5;
        int PROGRESS_HEIGHT = this.imgBGfile.getBounds().height;
        int PROGRESS_TO_HILOW_GAP = 3;
        int HILOW_TO_BUTTON_GAP = 3;
        cellArea.width -= 3;
        int ofsX = 12;
        int ofsY = cellArea.height / 2 - PROGRESS_HEIGHT / 2 - 1;
        int progressWidth = cellArea.width - ofsX * 2 - 3 - HILOW_WIDTH - 3 - BUTTON_WIDTH;
        if (progressWidth > 0) {
            if (this.progressFont == null) {
                this.progressFont = FontUtils.getFontWithHeight(gc.getFont(), gc, PROGRESS_HEIGHT - 2);
            }
            gc.setFont(this.progressFont);
            gc.setForeground(ColorCache.getSchemedColor(this.display, fileInfo2.isSkipped() ? "#95a6b2" : "#88acc1"));
            gc.drawRectangle(cellArea.x + ofsX, cellArea.y + ofsY - 1, progressWidth, PROGRESS_HEIGHT + 1);
            int pctWidth = (int)(percent * (long)(progressWidth - 1) / 1000L);
            gc.setBackground(ColorCache.getSchemedColor(this.display, fileInfo2.isSkipped() ? "#a6bdce" : "#8ccfff"));
            gc.fillRectangle(cellArea.x + ofsX + 1, cellArea.y + ofsY, pctWidth, PROGRESS_HEIGHT);
            gc.setBackground(Colors.white);
            gc.fillRectangle(cellArea.x + ofsX + pctWidth + 1, cellArea.y + ofsY, progressWidth - pctWidth - 1, PROGRESS_HEIGHT);
            Rectangle boundsImgBG = this.imgBGfile.getBounds();
            gc.drawImage(this.imgBGfile, boundsImgBG.x, boundsImgBG.y, boundsImgBG.width, boundsImgBG.height, cellArea.x + ofsX + 1, cellArea.y + ofsY, progressWidth - 1, PROGRESS_HEIGHT);
        }
        Color colorText = ColorCache.getSchemedColor(this.display, fileInfo2.isSkipped() ? "#556875" : "#2678b1");
        Rectangle printBounds = new Rectangle(cellArea.x + 12 + 5, cellArea.y, progressWidth - 10, cellArea.height);
        ofsY = cellArea.height / 2 - BUTTON_HEIGHT / 2 - 1;
        Rectangle buttonBounds = new Rectangle(cellArea.x + cellArea.width - BUTTON_WIDTH - 12, cellArea.y + ofsY, BUTTON_WIDTH, BUTTON_HEIGHT);
        row.setData("buttonBounds", buttonBounds);
        ofsY = cellArea.height / 2 - HILOW_HEIGHT / 2 - 1;
        Rectangle hilowBounds = new Rectangle(buttonBounds.x - 3 - HILOW_WIDTH, cellArea.y + ofsY, HILOW_WIDTH, HILOW_HEIGHT);
        row.setData("hilowBounds", hilowBounds);
        gc.setForeground(colorText);
        String s = DisplayFormatters.formatPercentFromThousands((int)percent);
        GCStringPrinter.printString(gc, s, printBounds, true, false, 16384);
        String tmp = null;
        if (fileInfo2.getDownloadManager().getState() == 70) {
            tmp = MessageText.getString("FileProgress.stopped");
        } else {
            int pri;
            int st = fileInfo2.getStorageType();
            if ((st == 2 || st == 4) && fileInfo2.isSkipped()) {
                tmp = MessageText.getString("FileProgress.deleted");
            } else if (fileInfo2.isSkipped()) {
                tmp = MessageText.getString("FileProgress.stopped");
            } else if (fileInfo2.getPriority() > 0 && (pri = fileInfo2.getPriority()) > 1) {
                tmp = MessageText.getString("FileItem.high");
                tmp = tmp + " (" + pri + ")";
            }
        }
        if (tmp != null) {
            GCStringPrinter.printString(gc, tmp.toUpperCase(), printBounds, false, false, 131072);
        }
        gc.drawImage(this.imgArrowButton, buttonBounds.x, buttonBounds.y);
        Image imgPriority = fileInfo2.isSkipped() ? this.imgPriStopped : (fileInfo2.getPriority() > 0 ? this.imgPriHi : this.imgPriNormal);
        gc.drawImage(imgPriority, hilowBounds.x, hilowBounds.y);
        hilowBounds.y -= cellArea.y;
        hilowBounds.x -= cellArea.x;
        buttonBounds.x -= cellArea.x;
        buttonBounds.y -= cellArea.y;
    }

    public void fileInfoMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType != 0) {
            return;
        }
        final Object dataSource = ((TableRowCore)event2.row).getDataSource(true);
        if (dataSource instanceof DiskManagerFileInfo) {
            Rectangle buttonBounds;
            final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)dataSource;
            Rectangle hilowBounds = (Rectangle)event2.row.getData("hilowBounds");
            if (event2.button == 1 && hilowBounds != null && hilowBounds.contains(event2.x, event2.y)) {
                if (fileInfo2.getPriority() > 0) {
                    fileInfo2.setPriority(0);
                } else {
                    fileInfo2.setPriority(1);
                }
                ((TableRowCore)event2.row).redraw();
            }
            if ((buttonBounds = (Rectangle)event2.row.getData("buttonBounds")) != null && buttonBounds.contains(event2.x, event2.y)) {
                Menu menu = new Menu(Display.getDefault().getActiveShell(), 8);
                MenuItem itemHigh = new MenuItem(menu, 16);
                Messages.setLanguageText(itemHigh, "priority.high");
                itemHigh.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_HIGH, new Object[]{dataSource});
                    }
                });
                itemHigh.setSelection(fileInfo2.getPriority() != 0);
                MenuItem itemNormal = new MenuItem(menu, 16);
                Messages.setLanguageText(itemNormal, "priority.normal");
                itemNormal.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_NORMAL, new Object[]{dataSource});
                    }
                });
                itemNormal.setSelection(fileInfo2.getPriority() == 0);
                new MenuItem(menu, 2);
                boolean canStart = fileInfo2.isSkipped() || fileInfo2.getDownloadManager().getState() == 70;
                MenuItem itemStop = new MenuItem(menu, 8);
                Messages.setLanguageText(itemStop, "v3.MainWindow.button.stop");
                itemStop.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_SKIPPED, new Object[]{dataSource});
                    }
                });
                itemStop.setEnabled(!canStart);
                MenuItem itemStart = new MenuItem(menu, 8);
                Messages.setLanguageText(itemStart, "v3.MainWindow.button.start");
                itemStart.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        if (fileInfo2.getDownloadManager().getState() == 70) {
                            TorrentUtil.queueDataSources(new Object[]{dataSource}, true);
                        }
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_NORMAL, new Object[]{dataSource});
                    }
                });
                itemStart.setEnabled(canStart);
                new MenuItem(menu, 2);
                MenuItem itemDelete = new MenuItem(menu, 8);
                Messages.setLanguageText(itemDelete, "v3.MainWindow.button.delete");
                itemDelete.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_DELETE, new Object[]{dataSource});
                    }
                });
                menu.setVisible(true);
                event2.skipCoreFunctionality = true;
            }
        }
    }
}

