/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnSubscriptionNbResults
extends CoreTableColumn
implements TableCellRefreshListener {
    public static String COLUMN_ID = "nb-results";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnSubscriptionNbResults(String sTableID) {
        super(COLUMN_ID, -2, 100, sTableID);
        this.setMinWidth(100);
        this.setMaxWidth(100);
        this.setAlignment(2);
    }

    public void refresh(TableCell cell) {
        int nbResults = 0;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            nbResults = sub.getHistory().getNumUnread() + sub.getHistory().getNumRead();
        }
        if (!cell.setSortValue(nbResults) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText("" + nbResults);
    }
}

