/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;

public class UPnPPluginService {
    protected UPnPWANConnection connection;
    protected BooleanParameter alert_success;
    protected BooleanParameter grab_ports;
    protected BooleanParameter alert_other_port_param;
    protected BooleanParameter release_mappings;
    protected List<serviceMapping> service_mappings = new ArrayList<serviceMapping>();
    protected AEMonitor this_mon = new AEMonitor("UPnPPluginService");

    protected UPnPPluginService(UPnPWANConnection _connection, UPnPWANConnectionPortMapping[] _ports, BooleanParameter _alert_success, BooleanParameter _grab_ports, BooleanParameter _alert_other_port_param, BooleanParameter _release_mappings) {
        this.connection = _connection;
        this.alert_success = _alert_success;
        this.grab_ports = _grab_ports;
        this.alert_other_port_param = _alert_other_port_param;
        this.release_mappings = _release_mappings;
        for (int i = 0; i < _ports.length; ++i) {
            this.service_mappings.add(new serviceMapping(_ports[i]));
        }
    }

    public String getName() {
        return this.connection.getGenericService().getDevice().getRootDevice().getDevice().getFriendlyName();
    }

    public String getInfo() {
        return this.connection.getGenericService().getDevice().getRootDevice().getInfo();
    }

    public String getAddress() {
        return this.connection.getGenericService().getDevice().getRootDevice().getLocation().getHost();
    }

    public int getPort() {
        URL url = this.connection.getGenericService().getDevice().getRootDevice().getLocation();
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return port;
    }

    public String getExternalAddress() {
        try {
            return this.connection.getExternalIPAddress();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public UPnPWANConnection getService() {
        return this.connection;
    }

    protected String getOldDescriptionForPort(int port) {
        return "Azureus UPnP " + port;
    }

    protected String getDescriptionForPort(boolean TCP, int port) {
        return "Azureus UPnP " + port + " " + (TCP ? "TCP" : "UDP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkMapping(LoggerChannel log, UPnPMapping mapping2) {
        block16: {
            serviceMapping grab_in_progress;
            block17: {
                String local_address;
                block15: {
                    try {
                        this.this_mon.enter();
                        if (mapping2.isEnabled()) {
                            for (int i = 0; i < this.service_mappings.size(); ++i) {
                                serviceMapping sm = this.service_mappings.get(i);
                                if (!sm.getMappings().contains(mapping2) || sm.getPort() == mapping2.getPort()) continue;
                                this.removeMapping(log, mapping2, sm, false);
                            }
                            grab_in_progress = null;
                            local_address = this.connection.getGenericService().getDevice().getRootDevice().getLocalAddress().getHostAddress();
                            break block15;
                        }
                        this.removeMapping(log, mapping2, false);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                }
                for (int i = 0; i < this.service_mappings.size(); ++i) {
                    serviceMapping sm = this.service_mappings.get(i);
                    if (sm.isTCP() != mapping2.isTCP() || sm.getPort() != mapping2.getPort()) continue;
                    if (sm.getInternalHost().equals(local_address)) {
                        sm.addMapping(mapping2);
                        if (!sm.getLogged(mapping2)) {
                            sm.setLogged(mapping2);
                            log.log("Mapping " + mapping2.getString() + " already established");
                        }
                        Object var9_10 = null;
                        this.this_mon.exit();
                        return;
                    }
                    if (!this.grab_ports.getValue()) {
                        if (!sm.getLogged(mapping2)) {
                            sm.setLogged(mapping2);
                            String text = MessageText.getString("upnp.alert.differenthost", new String[]{mapping2.getString(), sm.getInternalHost()});
                            if (this.alert_other_port_param.getValue()) {
                                log.logAlertRepeatable(2, text);
                            } else {
                                log.log(text);
                            }
                        }
                        Object var9_11 = null;
                        this.this_mon.exit();
                        return;
                    }
                    sm.addMapping(mapping2);
                    grab_in_progress = sm;
                }
                try {
                    this.connection.addPortMapping(mapping2.isTCP(), mapping2.getPort(), this.getDescriptionForPort(mapping2.isTCP(), mapping2.getPort()));
                    String text = grab_in_progress != null ? MessageText.getString("upnp.alert.mappinggrabbed", new String[]{mapping2.getString(), grab_in_progress.getInternalHost()}) : MessageText.getString("upnp.alert.mappingok", new String[]{mapping2.getString()});
                    log.log(text);
                    if (this.alert_success.getValue()) {
                        log.logAlertRepeatable(1, text);
                    }
                }
                catch (Throwable e) {
                    String text = MessageText.getString("upnp.alert.mappingfailed", new String[]{mapping2.getString()});
                    log.log(text, e);
                    if (!this.alert_other_port_param.getValue()) break block17;
                    log.logAlertRepeatable(3, text);
                }
            }
            if (grab_in_progress == null) {
                serviceMapping new_mapping = new serviceMapping(mapping2);
                this.service_mappings.add(new_mapping);
            }
        }
        Object var9_12 = null;
        this.this_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMapping(LoggerChannel log, UPnPMapping mapping2, boolean end_of_day) {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.service_mappings.size(); ++i) {
                serviceMapping sm = this.service_mappings.get(i);
                if (sm.isTCP() != mapping2.isTCP() || sm.getPort() != mapping2.getPort() || !sm.getMappings().contains(mapping2)) continue;
                this.removeMapping(log, mapping2, sm, end_of_day);
                Object var7_6 = null;
                this.this_mon.exit();
                return;
            }
            Object var7_7 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void removeMapping(LoggerChannel log, UPnPMapping upnp_mapping, serviceMapping service_mapping, boolean end_of_day) {
        if (service_mapping.isExternal()) {
            log.log("Mapping " + service_mapping.getString() + " not removed as not created by Azureus");
        } else {
            int persistent = 1;
            List mappings = service_mapping.getMappings();
            for (int i = 0; i < mappings.size(); ++i) {
                UPnPMapping map = (UPnPMapping)mappings.get(i);
                int p = map.getPersistent();
                if (p == 1) continue;
                if (p == 3) {
                    if (persistent != 1) continue;
                    persistent = p;
                    continue;
                }
                persistent = 2;
            }
            if (persistent == 1) {
                int n = persistent = this.release_mappings.getValue() ? 3 : 2;
            }
            if (end_of_day && persistent == 2) {
                log.log("Mapping " + service_mapping.getString() + " not removed as mapping is persistent");
            } else {
                String service_name = service_mapping.getString();
                service_mapping.removeMapping(upnp_mapping);
                if (service_mapping.getMappings().size() == 0) {
                    try {
                        this.connection.deletePortMapping(service_mapping.isTCP(), service_mapping.getPort());
                        log.log("Mapping " + service_name + " removed");
                    }
                    catch (Throwable e) {
                        log.log("Mapping " + service_name + " failed to delete", e);
                    }
                    this.service_mappings.remove(service_mapping);
                } else {
                    log.log("Mapping " + service_mapping.getString() + " not removed as interest remains");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public serviceMapping[] getMappings() {
        try {
            this.this_mon.enter();
            serviceMapping[] serviceMappingArray = this.service_mappings.toArray(new serviceMapping[this.service_mappings.size()]);
            Object var3_2 = null;
            this.this_mon.exit();
            return serviceMappingArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public class serviceMapping {
        private List mappings = new ArrayList();
        private boolean tcp;
        private int port;
        private String internal_host;
        private boolean external;
        private List logged_mappings = new ArrayList();

        protected serviceMapping(UPnPWANConnectionPortMapping device_mapping) {
            this.tcp = device_mapping.isTCP();
            this.port = device_mapping.getExternalPort();
            this.internal_host = device_mapping.getInternalHost();
            String desc = device_mapping.getDescription();
            if (desc == null || !desc.equalsIgnoreCase(UPnPPluginService.this.getOldDescriptionForPort(this.port)) && !desc.equalsIgnoreCase(UPnPPluginService.this.getDescriptionForPort(this.tcp, this.port))) {
                this.external = true;
            }
        }

        protected serviceMapping(UPnPMapping _mapping) {
            this.mappings.add(_mapping);
            this.tcp = _mapping.isTCP();
            this.port = _mapping.getPort();
            this.internal_host = UPnPPluginService.this.connection.getGenericService().getDevice().getRootDevice().getLocalAddress().getHostAddress();
        }

        public boolean isExternal() {
            return this.external;
        }

        protected List getMappings() {
            return this.mappings;
        }

        protected void addMapping(UPnPMapping _mapping) {
            if (!this.mappings.contains(_mapping)) {
                this.mappings.add(_mapping);
            }
        }

        protected void removeMapping(UPnPMapping _mapping) {
            this.mappings.remove(_mapping);
        }

        protected boolean getLogged(UPnPMapping mapping2) {
            return this.logged_mappings.contains(mapping2);
        }

        protected void setLogged(UPnPMapping mapping2) {
            if (!this.logged_mappings.contains(mapping2)) {
                this.logged_mappings.add(mapping2);
            }
        }

        public boolean isTCP() {
            return this.tcp;
        }

        public int getPort() {
            return this.port;
        }

        public String getInternalHost() {
            return this.internal_host;
        }

        public String getString() {
            if (this.mappings.size() == 0) {
                return "<external> (" + (this.isTCP() ? "TCP" : "UDP") + "/" + this.getPort() + ")";
            }
            String str = "";
            for (int i = 0; i < this.mappings.size(); ++i) {
                str = str + (i == 0 ? "" : ",") + ((UPnPMapping)this.mappings.get(i)).getString(this.getPort());
            }
            return str;
        }
    }
}

