/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.dht;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTTrackerPlugin
implements Plugin,
DownloadListener,
DownloadAttributeListener,
DownloadTrackerListener {
    private static final String PLUGIN_NAME = "Distributed Tracker";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.dhttracker";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.dhttracker";
    private static final int ANNOUNCE_TIMEOUT = 120000;
    private static final int ANNOUNCE_DERIVED_TIMEOUT = 60000;
    private static final int SCRAPE_TIMEOUT = 30000;
    private static final int ANNOUNCE_MIN_DEFAULT = 120000;
    private static final int ANNOUNCE_MAX = 3600000;
    private static final int ANNOUNCE_MAX_DERIVED_ONLY = 1800000;
    private static final int INTERESTING_CHECK_PERIOD = 14400000;
    private static final int INTERESTING_INIT_RAND_OURS = 300000;
    private static final int INTERESTING_INIT_MIN_OURS = 120000;
    private static final int INTERESTING_INIT_RAND_OTHERS = 1800000;
    private static final int INTERESTING_INIT_MIN_OTHERS = 300000;
    private static final int INTERESTING_DHT_CHECK_PERIOD = 3600000;
    private static final int INTERESTING_DHT_INIT_RAND = 300000;
    private static final int INTERESTING_DHT_INIT_MIN = 120000;
    private static final int INTERESTING_AVAIL_MAX = 8;
    private static final int INTERESTING_PUB_MAX_DEFAULT = 30;
    private static final int REG_TYPE_NONE = 1;
    private static final int REG_TYPE_FULL = 2;
    private static final int REG_TYPE_DERIVED = 3;
    private static final int LIMITED_TRACK_SIZE = 16;
    private static final boolean TRACK_NORMAL_DEFAULT = true;
    private static final boolean TRACK_LIMITED_DEFAULT = true;
    private static final boolean TEST_ALWAYS_TRACK = false;
    public static final int NUM_WANT = 30;
    private static final long start_time = SystemTime.getCurrentTime();
    private static final Object DL_DERIVED_METRIC_KEY = new Object();
    private static final int DL_DERIVED_MIN_TRACK = 5;
    private static final int DL_DERIVED_MAX_TRACK = 20;
    private static final int DIRECT_INJECT_PEER_MAX = 5;
    private static boolean ADD_ASN_DERIVED_TARGET = true;
    private static boolean ADD_NETPOS_DERIVED_TARGETS = false;
    private static URL DEFAULT_URL;
    private PluginInterface plugin_interface;
    private BasicPluginViewModel model;
    private DHTPlugin dht;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_peer_sources;
    private Map<Download, Long> interesting_downloads = new HashMap<Download, Long>();
    private int interesting_published = 0;
    private int interesting_pub_max = 30;
    private Map<Download, int[]> running_downloads = new HashMap<Download, int[]>();
    private Map<Download, int[]> run_data_cache = new HashMap<Download, int[]>();
    private Map<Download, RegistrationDetails> registered_downloads = new HashMap<Download, RegistrationDetails>();
    private Map<Download, Boolean> limited_online_tracking = new HashMap<Download, Boolean>();
    private Map<Download, Long> query_map = new HashMap<Download, Long>();
    private Map<Download, Integer> in_progress = new HashMap<Download, Integer>();
    private boolean track_only_decentralsed = COConfigurationManager.getBooleanParameter("dhtplugin.track.only.decentralised", false);
    private BooleanParameter track_normal_when_offline;
    private BooleanParameter track_limited_when_online;
    private long current_announce_interval = 120000L;
    private LoggerChannel log;
    private Map<Download, int[]> scrape_injection_map = new WeakHashMap<Download, int[]>();
    private Random random = new Random();
    private boolean is_running;
    private AEMonitor this_mon = new AEMonitor("DHTTrackerPlugin");
    private DHTNetworkPosition[] current_network_positions;
    private long last_net_pos_time;
    private AESemaphore initialised_sem = new AESemaphore("DHTTrackerPlugin:init");
    private boolean disable_put;

    public DHTTrackerPlugin() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable.Proxy", "Enable.SOCKS"}, new org.gudy.azureus2.core3.config.ParameterListener(){

            public void parameterChanged(String parameter_name) {
                boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                DHTTrackerPlugin.this.disable_put = enable_proxy && enable_socks;
            }
        });
    }

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
        this.ta_peer_sources = this.plugin_interface.getTorrentManager().getAttribute("PeerSources");
        UIManager ui_manager = this.plugin_interface.getUIManager();
        this.model = ui_manager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        this.model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        this.track_normal_when_offline = config.addBooleanParameter2("dhttracker.tracknormalwhenoffline", "dhttracker.tracknormalwhenoffline", true);
        this.track_limited_when_online = config.addBooleanParameter2("dhttracker.tracklimitedwhenonline", "dhttracker.tracklimitedwhenonline", true);
        this.track_limited_when_online.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DHTTrackerPlugin.this.configChanged();
            }
        });
        this.track_normal_when_offline.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DHTTrackerPlugin.this.track_limited_when_online.setEnabled(DHTTrackerPlugin.this.track_normal_when_offline.getValue());
                DHTTrackerPlugin.this.configChanged();
            }
        });
        if (!this.track_normal_when_offline.getValue()) {
            this.track_limited_when_online.setEnabled(false);
        }
        this.interesting_pub_max = this.plugin_interface.getPluginconfig().getPluginIntParameter("dhttracker.presencepubmax", 30);
        this.model.getActivity().setVisible(false);
        this.model.getProgress().setVisible(false);
        this.model.getLogArea().setMaximumSize(80000);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                DHTTrackerPlugin.this.model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                DHTTrackerPlugin.this.model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        this.model.getStatus().setText(MessageText.getString("ManagerItem.initializing"));
        this.log.log("Waiting for Distributed Database initialisation");
        this.plugin_interface.addListener(new PluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void initializationComplete() {
                boolean release_now = true;
                try {
                    PluginInterface dht_pi = DHTTrackerPlugin.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                    if (dht_pi != null) {
                        DHTTrackerPlugin.this.dht = (DHTPlugin)dht_pi.getPlugin();
                        DelayedTask dt = DHTTrackerPlugin.this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

                            public void run() {
                                AEThread2 t = new AEThread2("DHTTrackerPlugin:init", true){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        try {
                                            block5: {
                                                try {
                                                    if (DHTTrackerPlugin.this.dht.isEnabled()) {
                                                        DHTTrackerPlugin.this.log.log("DDB Available");
                                                        DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("DHTView.activity.status.false"));
                                                        DHTTrackerPlugin.this.initialise();
                                                        break block5;
                                                    }
                                                    DHTTrackerPlugin.this.log.log("DDB Disabled");
                                                    DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("dht.status.disabled"));
                                                    DHTTrackerPlugin.this.notRunning();
                                                }
                                                catch (Throwable e) {
                                                    DHTTrackerPlugin.this.log.log("DDB Failed", e);
                                                    DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("DHTView.operations.failed"));
                                                    DHTTrackerPlugin.this.notRunning();
                                                    Object var3_2 = null;
                                                    DHTTrackerPlugin.this.initialised_sem.releaseForever();
                                                }
                                            }
                                            Object var3_1 = null;
                                            DHTTrackerPlugin.this.initialised_sem.releaseForever();
                                        }
                                        catch (Throwable throwable) {
                                            Object var3_3 = null;
                                            DHTTrackerPlugin.this.initialised_sem.releaseForever();
                                            throw throwable;
                                        }
                                    }
                                };
                                t.start();
                            }
                        });
                        dt.queue();
                        release_now = false;
                    } else {
                        DHTTrackerPlugin.this.log.log("DDB Plugin missing");
                        DHTTrackerPlugin.this.model.getStatus().setText(MessageText.getString("DHTView.operations.failed"));
                        DHTTrackerPlugin.this.notRunning();
                    }
                    Object var5_4 = null;
                    if (release_now) {
                        DHTTrackerPlugin.this.initialised_sem.releaseForever();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (release_now) {
                        DHTTrackerPlugin.this.initialised_sem.releaseForever();
                    }
                    throw throwable;
                }
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    protected void notRunning() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                DHTTrackerPlugin.this.addDownload(download);
            }

            public void downloadRemoved(Download download) {
                DHTTrackerPlugin.this.removeDownload(download);
            }
        });
    }

    protected void initialise() {
        this.is_running = true;
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                DHTTrackerPlugin.this.addDownload(download);
            }

            public void downloadRemoved(Download download) {
                DHTTrackerPlugin.this.removeDownload(download);
            }
        });
        this.plugin_interface.getUtilities().createTimer("DHT Tracker", true).addPeriodicEvent(15000L, new UTTimerEventPerformer(){
            private int ticks;

            public void perform(UTTimerEvent event2) {
                ++this.ticks;
                DHTTrackerPlugin.this.processRegistrations(this.ticks % 8 == 0);
                if (this.ticks == 2 || this.ticks % 4 == 0) {
                    DHTTrackerPlugin.this.processNonRegistrations();
                }
            }
        });
    }

    public void waitUntilInitialised() {
        this.initialised_sem.reserve();
    }

    public boolean isRunning() {
        return this.is_running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownload(final Download download) {
        Torrent torrent = download.getTorrent();
        boolean is_decentralised = false;
        if (torrent != null) {
            is_decentralised = TorrentUtils.isDecentralised(torrent.getAnnounceURL());
        }
        if (download.getFlag(16L) && !is_decentralised) {
            return;
        }
        if (this.track_only_decentralsed && torrent != null && !is_decentralised) {
            return;
        }
        if (this.is_running) {
            String[] networks = download.getListAttribute(this.ta_networks);
            if (torrent != null && networks != null) {
                boolean public_net = false;
                for (int i = 0; i < networks.length; ++i) {
                    if (!networks[i].equalsIgnoreCase("Public")) continue;
                    public_net = true;
                    break;
                }
                if (public_net && !torrent.isPrivate()) {
                    long delay;
                    boolean our_download = torrent.wasCreatedByUs();
                    if (our_download) {
                        delay = download.getCreationTime() > start_time ? 0L : this.plugin_interface.getUtilities().getCurrentSystemTime() + 120000L + (long)this.random.nextInt(300000);
                    } else {
                        int rand;
                        int min;
                        if (TorrentUtils.isDecentralised(torrent.getAnnounceURL())) {
                            min = 120000;
                            rand = 300000;
                        } else {
                            min = 300000;
                            rand = 1800000;
                        }
                        delay = this.plugin_interface.getUtilities().getCurrentSystemTime() + (long)min + (long)this.random.nextInt(rand);
                    }
                    try {
                        this.this_mon.enter();
                        this.interesting_downloads.put(download, new Long(delay));
                        Object var12_10 = null;
                        this.this_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var12_11 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                }
            }
            download.addAttributeListener(this, this.ta_networks, 1);
            download.addAttributeListener(this, this.ta_peer_sources, 1);
            download.addTrackerListener(this);
            download.addListener(this);
            this.checkDownloadForRegistration(download, true);
        } else if (torrent != null && torrent.isDecentralised()) {
            download.addListener(new DownloadListener(){

                public void stateChanged(final Download download, int old_state, int new_state) {
                    int state = download.getState();
                    if (state == 4 || state == 5) {
                        download.setAnnounceResult(new DownloadAnnounceResult(){

                            public Download getDownload() {
                                return download;
                            }

                            public int getResponseType() {
                                return 2;
                            }

                            public int getReportedPeerCount() {
                                return 0;
                            }

                            public int getSeedCount() {
                                return 0;
                            }

                            public int getNonSeedCount() {
                                return 0;
                            }

                            public String getError() {
                                return "Distributed Database Offline";
                            }

                            public URL getURL() {
                                return download.getTorrent().getAnnounceURL();
                            }

                            public DownloadAnnounceResultPeer[] getPeers() {
                                return new DownloadAnnounceResultPeer[0];
                            }

                            public long getTimeToWait() {
                                return 0L;
                            }

                            public Map getExtensions() {
                                return null;
                            }
                        });
                    }
                }

                public void positionChanged(Download download, int oldPosition, int newPosition) {
                }
            });
            download.setScrapeResult(new DownloadScrapeResult(){

                public Download getDownload() {
                    return download;
                }

                public int getResponseType() {
                    return 2;
                }

                public int getSeedCount() {
                    return -1;
                }

                public int getNonSeedCount() {
                    return -1;
                }

                public long getScrapeStartTime() {
                    return SystemTime.getCurrentTime();
                }

                public void setNextScrapeStartTime(long nextScrapeStartTime) {
                }

                public long getNextScrapeStartTime() {
                    return -1L;
                }

                public String getStatus() {
                    return "Distributed Database Offline";
                }

                public URL getURL() {
                    return download.getTorrent().getAnnounceURL();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownload(Download download) {
        if (this.is_running) {
            download.removeTrackerListener(this);
            download.removeListener(this);
            try {
                this.this_mon.enter();
                this.interesting_downloads.remove(download);
                this.running_downloads.remove(download);
                this.run_data_cache.remove(download);
                this.limited_online_tracking.remove(download);
                Object var3_2 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
    }

    @Override
    public void attributeEventOccurred(Download download, TorrentAttribute attr, int event_type) {
        this.checkDownloadForRegistration(download, false);
    }

    @Override
    public void scrapeResult(DownloadScrapeResult result) {
        this.checkDownloadForRegistration(result.getDownload(), false);
    }

    @Override
    public void announceResult(DownloadAnnounceResult result) {
        this.checkDownloadForRegistration(result.getDownload(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDownloadForRegistration(Download download, boolean first_time) {
        String register_reason;
        boolean skip_log = false;
        int state = download.getState();
        int register_type = 1;
        Random random = new Random();
        if (state == 4 || state == 5 || download.isPaused()) {
            String[] networks = download.getListAttribute(this.ta_networks);
            Torrent torrent = download.getTorrent();
            if (torrent != null && networks != null) {
                boolean public_net = false;
                for (int i = 0; i < networks.length; ++i) {
                    if (!networks[i].equalsIgnoreCase("Public")) continue;
                    public_net = true;
                    break;
                }
                if (public_net && !torrent.isPrivate()) {
                    if (torrent.isDecentralised()) {
                        register_type = 2;
                        register_reason = "decentralised";
                    } else if (torrent.isDecentralisedBackupEnabled()) {
                        String[] sources = download.getListAttribute(this.ta_peer_sources);
                        boolean ok = false;
                        for (int i = 0; i < sources.length; ++i) {
                            if (!sources[i].equalsIgnoreCase("DHT")) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            register_reason = "decentralised peer source disabled";
                        } else {
                            boolean is_active;
                            boolean bl = is_active = state == 4 || state == 5 || download.isPaused();
                            if (is_active) {
                                register_type = 3;
                            }
                            if (torrent.isDecentralisedBackupRequested()) {
                                register_type = 2;
                                register_reason = "torrent requests decentralised tracking";
                            } else if (this.track_normal_when_offline.getValue()) {
                                Object result;
                                if (is_active) {
                                    result = download.getLastAnnounceResult();
                                    if (result == null || result.getResponseType() == 2 || TorrentUtils.isDecentralised(result.getURL())) {
                                        register_type = 2;
                                        register_reason = "tracker unavailable (announce)";
                                    } else {
                                        register_reason = "tracker available (announce: " + result.getURL() + ")";
                                    }
                                } else {
                                    result = download.getLastScrapeResult();
                                    if (result == null || result.getResponseType() == 2 || TorrentUtils.isDecentralised(result.getURL())) {
                                        register_type = 2;
                                        register_reason = "tracker unavailable (scrape)";
                                    } else {
                                        register_reason = "tracker available (scrape: " + result.getURL() + ")";
                                    }
                                }
                                if (register_type != 2 && this.track_limited_when_online.getValue()) {
                                    Boolean existing = this.limited_online_tracking.get(download);
                                    boolean track_it = false;
                                    if (existing != null) {
                                        track_it = existing;
                                    } else {
                                        DownloadScrapeResult result2 = download.getLastScrapeResult();
                                        if (result2 != null && result2.getResponseType() == 1) {
                                            int leechers;
                                            int seeds = result2.getSeedCount();
                                            int swarm_size = seeds + (leechers = result2.getNonSeedCount());
                                            if (swarm_size <= 16) {
                                                track_it = true;
                                            } else {
                                                boolean bl2 = track_it = random.nextInt(swarm_size) < 16;
                                            }
                                            if (track_it) {
                                                this.limited_online_tracking.put(download, new Boolean(track_it));
                                            }
                                        }
                                    }
                                    if (track_it) {
                                        register_type = 2;
                                        register_reason = "limited online tracking";
                                    }
                                }
                            } else {
                                register_type = 2;
                                register_reason = "peer source enabled";
                            }
                        }
                    } else {
                        register_reason = "decentralised backup disabled for the torrent";
                    }
                } else {
                    register_reason = "not public";
                }
            } else {
                register_reason = "torrent is broken";
            }
            if (register_type == 3) {
                register_reason = register_reason.length() == 0 ? "derived" : "derived (overriding ' " + register_reason + "')";
            }
        } else if (state == 7 || state == 8) {
            register_reason = "not running";
            skip_log = true;
        } else {
            register_reason = state == 9 ? "" : "";
        }
        if (register_reason.length() > 0) {
            try {
                this.this_mon.enter();
                int[] run_data = this.running_downloads.get(download);
                if (register_type != 1) {
                    if (run_data == null) {
                        this.log(download, "Monitoring '" + download.getName() + "': " + register_reason);
                        int[] cache = this.run_data_cache.remove(download);
                        if (cache == null) {
                            this.running_downloads.put(download, new int[]{register_type, 0, 0, 0});
                        } else {
                            cache[0] = register_type;
                            this.running_downloads.put(download, cache);
                        }
                        this.query_map.put(download, new Long(SystemTime.getCurrentTime()));
                    } else {
                        Integer existing_type = run_data[0];
                        if (existing_type == 3 && register_type == 2) {
                            run_data[0] = register_type;
                        }
                    }
                } else if (run_data != null) {
                    if (!skip_log) {
                        this.log(download, "Not monitoring: " + register_reason);
                    }
                    this.running_downloads.remove(download);
                    this.run_data_cache.put(download, run_data);
                    this.interesting_downloads.put(download, new Long(this.plugin_interface.getUtilities().getCurrentSystemTime() + 300000L));
                } else if (first_time && !skip_log) {
                    this.log(download, "Not monitoring: " + register_reason);
                }
                Object var21_21 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var21_22 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRegistrations(boolean full_processing) {
        ArrayList<Download> rds;
        int dht_port;
        int udp_port;
        int tcp_port = this.plugin_interface.getPluginconfig().getIntParameter("TCP.Listen.Port");
        String port_override = COConfigurationManager.getStringParameter("TCP.Listen.Port.Override");
        if (!port_override.equals("")) {
            try {
                tcp_port = Integer.parseInt(port_override);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (tcp_port == 0) {
            this.log.log("TCP port=0, registration not performed");
            return;
        }
        String override_ips = COConfigurationManager.getStringParameter("Override Ip", "");
        String override_ip = null;
        if (override_ips.length() > 0) {
            StringTokenizer tok = new StringTokenizer(override_ips, ";");
            while (tok.hasMoreTokens()) {
                String cat;
                String this_address = tok.nextToken().trim();
                if (this_address.length() <= 0 || (cat = AENetworkClassifier.categoriseAddress(this_address)) != "Public") continue;
                override_ip = this_address;
                break;
            }
        }
        if (override_ip != null) {
            try {
                override_ip = PRHelpers.DNSToIPAddress(override_ip);
            }
            catch (UnknownHostException e) {
                this.log.log("    Can't resolve IP override '" + override_ip + "'");
                override_ip = null;
            }
        }
        String value_to_put = override_ip == null ? "" : override_ip + ":";
        value_to_put = value_to_put + tcp_port;
        if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE) {
            value_to_put = value_to_put + ";C";
        }
        if ((udp_port = this.plugin_interface.getPluginconfig().getIntParameter("UDP.Listen.Port")) != (dht_port = this.dht.getLocalAddress().getAddress().getPort())) {
            value_to_put = value_to_put + ";" + udp_port;
        }
        putDetails put_details = new putDetails(value_to_put, override_ip, tcp_port, udp_port);
        try {
            this.this_mon.enter();
            rds = new ArrayList<Download>(this.running_downloads.keySet());
            Object var12_15 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.this_mon.exit();
            throw throwable;
        }
        long now = SystemTime.getCurrentTime();
        if (full_processing) {
            Iterator<Download> rds_it = rds.iterator();
            ArrayList<Object[]> interesting = new ArrayList<Object[]>();
            while (rds_it.hasNext()) {
                Object var19_35;
                Download dl = rds_it.next();
                int reg_type = 1;
                try {
                    this.this_mon.enter();
                    int[] run_data = this.running_downloads.get(dl);
                    if (run_data != null) {
                        reg_type = run_data[0];
                    }
                    var19_35 = null;
                    this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    var19_35 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
                if (reg_type == 1) continue;
                long metric = this.getDerivedTrackMetric(dl);
                interesting.add(new Object[]{dl, new Long(metric)});
            }
            Collections.sort(interesting, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] entry1, Object[] entry2) {
                    long res = (Long)entry2[1] - (Long)entry1[1];
                    if (res < 0L) {
                        return -1;
                    }
                    if (res > 0L) {
                        return 1;
                    }
                    return 0;
                }
            });
            Iterator it = interesting.iterator();
            int num = 0;
            while (it.hasNext()) {
                Object[] entry = (Object[])it.next();
                Download dl = (Download)entry[0];
                long metric = (Long)entry[1];
                if (metric > 0L && ++num > 5) {
                    metric = num <= 20 ? metric * (long)(20 - num) / 15L : 0L;
                }
                if (metric > 0L) {
                    dl.setUserData(DL_DERIVED_METRIC_KEY, new Long(metric));
                    continue;
                }
                dl.setUserData(DL_DERIVED_METRIC_KEY, null);
            }
        }
        for (Download dl : rds) {
            Object var24_44;
            Object var22_43;
            int reg_type = 1;
            try {
                this.this_mon.enter();
                int[] run_data = this.running_downloads.get(dl);
                if (run_data != null) {
                    reg_type = run_data[0];
                }
                var22_43 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                var22_43 = null;
                this.this_mon.exit();
                throw throwable;
            }
            if (reg_type == 1) continue;
            byte flags = this.isComplete(dl) ? (byte)2 : 1;
            RegistrationDetails registration = this.registered_downloads.get(dl);
            boolean do_it = false;
            if (registration == null) {
                this.log(dl, "Registering download as " + (flags == 2 ? "Seeding" : "Downloading"));
                registration = new RegistrationDetails(dl, reg_type, put_details, flags);
                this.registered_downloads.put(dl, registration);
                do_it = true;
            } else {
                boolean targets_changed = false;
                if (full_processing) {
                    targets_changed = registration.updateTargets(dl, reg_type);
                }
                if (targets_changed || registration.getFlags() != flags || !registration.getPutDetails().sameAs(put_details)) {
                    this.log(dl, (registration == null ? "Registering" : "Re-registering") + " download as " + (flags == 2 ? "Seeding" : "Downloading"));
                    registration.update(put_details, flags);
                    do_it = true;
                }
            }
            if (!do_it) continue;
            try {
                this.this_mon.enter();
                this.query_map.put(dl, new Long(now));
                var24_44 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                var24_44 = null;
                this.this_mon.exit();
                throw throwable;
            }
            this.trackerPut(dl, registration);
        }
        Iterator<Map.Entry<Download, RegistrationDetails>> rd_it = this.registered_downloads.entrySet().iterator();
        while (rd_it.hasNext()) {
            Object var28_51;
            Object var26_50;
            boolean unregister;
            Map.Entry<Download, RegistrationDetails> entry = rd_it.next();
            Download dl = entry.getKey();
            try {
                this.this_mon.enter();
                unregister = !this.running_downloads.containsKey(dl);
                var26_50 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                var26_50 = null;
                this.this_mon.exit();
                throw throwable;
            }
            if (!unregister) continue;
            this.log.log(dl, "Unregistering download");
            rd_it.remove();
            try {
                this.this_mon.enter();
                this.query_map.remove(dl);
                var28_51 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                var28_51 = null;
                this.this_mon.exit();
                throw throwable;
            }
            this.trackerRemove(dl, entry.getValue());
        }
        for (Download dl : rds) {
            Object var34_57;
            RegistrationDetails registration;
            boolean skip;
            Object var32_56;
            Object var30_55;
            Long next_time;
            try {
                this.this_mon.enter();
                next_time = this.query_map.get(dl);
                var30_55 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                var30_55 = null;
                this.this_mon.exit();
                throw throwable;
            }
            if (next_time == null || now < next_time) continue;
            int reg_type = 1;
            try {
                this.this_mon.enter();
                this.query_map.remove(dl);
                int[] run_data = this.running_downloads.get(dl);
                if (run_data != null) {
                    reg_type = run_data[0];
                }
                var32_56 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                var32_56 = null;
                this.this_mon.exit();
                throw throwable;
            }
            long start = SystemTime.getCurrentTime();
            PeerManager pm = dl.getPeerManager();
            boolean bl = skip = this.isActive(dl) || reg_type == 1;
            if (skip) {
                this.log(dl, "Deferring announce as activity outstanding");
            }
            if ((registration = this.registered_downloads.get(dl)) == null) {
                Debug.out("Inconsistent, registration should be non-null");
                continue;
            }
            boolean derived_only = false;
            if (pm != null && !skip) {
                int con = pm.getStats().getConnectedLeechers() + pm.getStats().getConnectedSeeds();
                boolean bl2 = derived_only = con >= 30;
            }
            if (!skip) {
                boolean bl3 = skip = this.trackerGet(dl, registration, derived_only) == 0;
            }
            if (!skip) continue;
            try {
                this.this_mon.enter();
                if (this.running_downloads.containsKey(dl)) {
                    this.query_map.put(dl, new Long(start + 120000L));
                }
                var34_57 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                var34_57 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
    }

    protected long getDerivedTrackMetric(Download download) {
        Torrent t = download.getTorrent();
        if (t == null) {
            return -100L;
        }
        if (t.getSize() < 0xA00000L) {
            return -99L;
        }
        DownloadAnnounceResult announce = download.getLastAnnounceResult();
        if (announce == null || announce.getResponseType() != 1) {
            return -98L;
        }
        DownloadScrapeResult scrape = download.getLastScrapeResult();
        if (scrape == null || scrape.getResponseType() != 1) {
            return -97L;
        }
        int leechers = scrape.getNonSeedCount();
        int total = leechers;
        if (total >= 2000) {
            return 100L;
        }
        if (total <= 200) {
            return 0L;
        }
        return (total - 200) / 4;
    }

    protected void trackerPut(final Download download, RegistrationDetails details) {
        final long start = SystemTime.getCurrentTime();
        trackerTarget[] targets = details.getTargets(true);
        byte flags = details.getFlags();
        for (int i = 0; i < targets.length; ++i) {
            final trackerTarget target = targets[i];
            String encoded = details.getPutDetails().getEncoded();
            byte[] encoded_bytes = encoded.getBytes();
            DHTPluginValue existing = this.dht.getLocalValue(target.getHash());
            if (existing != null && existing.getFlags() == flags && Arrays.equals(existing.getValue(), encoded_bytes)) continue;
            if (this.disable_put) {
                if (target.getType() != 2) continue;
                this.log(download, "Registration of '" + target.getDesc() + " skipped as disabled due to use of SOCKS proxy");
                continue;
            }
            this.dht.put(target.getHash(), "Tracker registration of '" + download.getName() + "'" + target.getDesc() + " -> " + encoded, encoded_bytes, flags, false, new DHTPluginOperationListener(){

                public void diversified() {
                }

                public void starts(byte[] key) {
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                public void valueWritten(DHTPluginContact target2, DHTPluginValue value) {
                }

                public void complete(byte[] key, boolean timeout_occurred) {
                    if (target.getType() == 2) {
                        DHTTrackerPlugin.this.log(download, "Registration of '" + target.getDesc() + " completed (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + ")");
                    }
                }
            });
        }
    }

    protected int trackerGet(final Download download, final RegistrationDetails details, final boolean derived_only) {
        final long start = SystemTime.getCurrentTime();
        final Torrent torrent = download.getTorrent();
        final URL url_to_report = torrent.isDecentralised() ? torrent.getAnnounceURL() : DEFAULT_URL;
        trackerTarget[] targets = details.getTargets(false);
        final long[] max_retry = new long[]{0L};
        int num_done = 0;
        for (int i = 0; i < targets.length; ++i) {
            final trackerTarget target = targets[i];
            if (target.getType() == 2 && derived_only) continue;
            this.increaseActive(download);
            ++num_done;
            this.dht.get(target.getHash(), "Tracker announce for '" + download.getName() + "'" + target.getDesc(), this.isComplete(download) ? (byte)2 : 1, 30, target.getType() == 2 ? 120000L : 60000L, false, false, new DHTPluginOperationListener(){
                List<String> addresses = new ArrayList<String>();
                List<Integer> ports = new ArrayList<Integer>();
                List<Integer> udp_ports = new ArrayList<Integer>();
                List<Boolean> is_seeds = new ArrayList<Boolean>();
                List<String> flags = new ArrayList<String>();
                int seed_count;
                int leecher_count;
                boolean complete;

                public void diversified() {
                }

                public void starts(byte[] key) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    13 var3_3 = this;
                    synchronized (var3_3) {
                        block14: {
                            if (this.complete) {
                                return;
                            }
                            try {
                                String tcp_port_str;
                                String[] tokens = new String(value.getValue()).split(";");
                                String tcp_part = tokens[0].trim();
                                int sep = tcp_part.indexOf(58);
                                String ip_str = null;
                                if (sep == -1) {
                                    tcp_port_str = tcp_part;
                                } else {
                                    ip_str = tcp_part.substring(0, sep);
                                    tcp_port_str = tcp_part.substring(sep + 1);
                                }
                                int tcp_port = Integer.parseInt(tcp_port_str);
                                if (tcp_port <= 0 || tcp_port >= 65536) break block14;
                                String flag_str = null;
                                int udp_port = -1;
                                try {
                                    for (int i = 1; i < tokens.length; ++i) {
                                        String token = tokens[i].trim();
                                        if (token.length() <= 0) continue;
                                        if (Character.isDigit(token.charAt(0))) {
                                            udp_port = Integer.parseInt(token);
                                            if (udp_port > 0 && udp_port < 65536) continue;
                                            udp_port = -1;
                                            continue;
                                        }
                                        flag_str = token;
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                this.addresses.add(ip_str == null ? originator.getAddress().getAddress().getHostAddress() : ip_str);
                                this.ports.add(new Integer(tcp_port));
                                this.udp_ports.add(new Integer(udp_port == -1 ? originator.getAddress().getPort() : udp_port));
                                this.flags.add(flag_str);
                                if ((value.getFlags() & 1) == 1) {
                                    ++this.leecher_count;
                                    this.is_seeds.add(new Boolean(false));
                                } else {
                                    this.is_seeds.add(new Boolean(true));
                                    ++this.seed_count;
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                    }
                }

                public void valueWritten(DHTPluginContact target2, DHTPluginValue value) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(byte[] key, boolean timeout_occurred) {
                    int[] prev;
                    PeerManager pm;
                    13 var3_3 = this;
                    synchronized (var3_3) {
                        if (this.complete) {
                            return;
                        }
                        this.complete = true;
                    }
                    if (target.getType() == 2 || target.getType() == 3 && this.seed_count + this.leecher_count > 1) {
                        DHTTrackerPlugin.this.log(download, "Get of '" + target.getDesc() + " completed (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + "), addresses=" + this.addresses.size() + ", seeds=" + this.seed_count + ", leechers=" + this.leecher_count);
                    }
                    DHTTrackerPlugin.this.decreaseActive(download);
                    int peers_found = this.addresses.size();
                    ArrayList<1> peers_for_announce = new ArrayList<1>();
                    int announce_per_min = 4;
                    int num_active = DHTTrackerPlugin.this.query_map.size();
                    int announce_min = Math.max(120000, num_active / announce_per_min * 60 * 1000);
                    int announce_max = derived_only ? 1800000 : 3600000;
                    announce_min = Math.min(announce_min, announce_max);
                    DHTTrackerPlugin.this.current_announce_interval = announce_min;
                    final long retry = announce_min + peers_found * (announce_max - announce_min) / 30;
                    int download_state = download.getState();
                    boolean we_are_seeding = download_state == 5;
                    try {
                        DHTTrackerPlugin.this.this_mon.enter();
                        int[] run_data = (int[])DHTTrackerPlugin.this.running_downloads.get(download);
                        if (run_data != null) {
                            Long existing;
                            boolean full = target.getType() == 2;
                            int peer_count = we_are_seeding ? this.leecher_count : this.seed_count + this.leecher_count;
                            run_data[1] = full ? this.seed_count : Math.max(run_data[1], this.seed_count);
                            run_data[2] = full ? this.leecher_count : Math.max(run_data[2], this.leecher_count);
                            run_data[3] = full ? peer_count : Math.max(run_data[3], peer_count);
                            long absolute_retry = SystemTime.getCurrentTime() + retry;
                            if (absolute_retry > max_retry[0] && ((existing = (Long)DHTTrackerPlugin.this.query_map.get(download)) == null || existing == max_retry[0])) {
                                max_retry[0] = absolute_retry;
                                DHTTrackerPlugin.this.query_map.put(download, new Long(absolute_retry));
                            }
                        }
                        Object var20_28 = null;
                        DHTTrackerPlugin.this.this_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var20_29 = null;
                        DHTTrackerPlugin.this.this_mon.exit();
                        throw throwable;
                    }
                    putDetails put_details = details.getPutDetails();
                    String ext_address = put_details.getIPOverride();
                    if (ext_address == null) {
                        ext_address = DHTTrackerPlugin.this.dht.getLocalAddress().getAddress().getAddress().getHostAddress();
                    }
                    for (int i = 0; i < this.addresses.size(); ++i) {
                        String ip;
                        if (we_are_seeding && this.is_seeds.get(i).booleanValue() || (ip = this.addresses.get(i)).equals(ext_address) && this.ports.get(i).intValue() == put_details.getTCPPort() && this.udp_ports.get(i).intValue() == put_details.getUDPPort()) continue;
                        final int f_i = i;
                        peers_for_announce.add(new DownloadAnnounceResultPeer(){

                            public String getSource() {
                                return "DHT";
                            }

                            public String getAddress() {
                                return addresses.get(f_i);
                            }

                            public int getPort() {
                                return ports.get(f_i);
                            }

                            public int getUDPPort() {
                                return udp_ports.get(f_i);
                            }

                            public byte[] getPeerID() {
                                return null;
                            }

                            public short getProtocol() {
                                String flag = flags.get(f_i);
                                int protocol = flag != null && flag.indexOf("C") != -1 ? 2 : 1;
                                return (short)protocol;
                            }
                        });
                    }
                    if (target.getType() == 3 && peers_for_announce.size() > 0 && (pm = download.getPeerManager()) != null) {
                        ArrayList temp = new ArrayList(peers_for_announce);
                        Random rand = new Random();
                        for (int i = 0; i < 5 && temp.size() > 0; ++i) {
                            DownloadAnnounceResultPeer peer = (DownloadAnnounceResultPeer)temp.remove(rand.nextInt(temp.size()));
                            DHTTrackerPlugin.this.log(download, "Injecting derived peer " + peer.getAddress() + " into " + download.getName());
                            HashMap<Object, Object> user_data = new HashMap<Object, Object>();
                            user_data.put(Peer.PR_PRIORITY_CONNECTION, new Boolean(true));
                            pm.addPeer(peer.getAddress(), peer.getPort(), peer.getUDPPort(), peer.getProtocol() == 2, user_data);
                        }
                    }
                    if (download_state == 4 || download_state == 5) {
                        final DownloadAnnounceResultPeer[] peers = new DownloadAnnounceResultPeer[peers_for_announce.size()];
                        peers_for_announce.toArray(peers);
                        download.setAnnounceResult(new DownloadAnnounceResult(){

                            public Download getDownload() {
                                return download;
                            }

                            public int getResponseType() {
                                return 1;
                            }

                            public int getReportedPeerCount() {
                                return peers.length;
                            }

                            public int getSeedCount() {
                                return seed_count;
                            }

                            public int getNonSeedCount() {
                                return leecher_count;
                            }

                            public String getError() {
                                return null;
                            }

                            public URL getURL() {
                                return url_to_report;
                            }

                            public DownloadAnnounceResultPeer[] getPeers() {
                                return peers;
                            }

                            public long getTimeToWait() {
                                return retry / 1000L;
                            }

                            public Map getExtensions() {
                                return null;
                            }
                        });
                    }
                    boolean inject_scrape = this.leecher_count > 0;
                    DownloadScrapeResult result = download.getLastScrapeResult();
                    if (result != null && result.getResponseType() != 2 && (prev = (int[])DHTTrackerPlugin.this.scrape_injection_map.get(download)) != null && prev[0] == result.getSeedCount() && prev[1] == result.getNonSeedCount()) {
                        inject_scrape = true;
                    }
                    if (torrent.isDecentralised() || inject_scrape) {
                        PeerManager pm2 = download.getPeerManager();
                        int local_seeds = 0;
                        int local_leechers = 0;
                        if (pm2 != null) {
                            Peer[] dl_peers = pm2.getPeers();
                            for (int i = 0; i < dl_peers.length; ++i) {
                                Peer dl_peer = dl_peers[i];
                                if (dl_peer.getPercentDoneInThousandNotation() == 1000) {
                                    ++local_seeds;
                                    continue;
                                }
                                ++local_leechers;
                            }
                        }
                        final int f_adj_seeds = Math.max(this.seed_count, local_seeds);
                        final int f_adj_leechers = Math.max(this.leecher_count, local_leechers);
                        DHTTrackerPlugin.this.scrape_injection_map.put(download, new int[]{f_adj_seeds, f_adj_leechers});
                        try {
                            DHTTrackerPlugin.this.this_mon.enter();
                            int[] run_data = (int[])DHTTrackerPlugin.this.running_downloads.get(download);
                            if (run_data == null) {
                                run_data = (int[])DHTTrackerPlugin.this.run_data_cache.get(download);
                            }
                            if (run_data != null) {
                                run_data[1] = f_adj_seeds;
                                run_data[2] = f_adj_leechers;
                            }
                            Object var24_40 = null;
                            DHTTrackerPlugin.this.this_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var24_41 = null;
                            DHTTrackerPlugin.this.this_mon.exit();
                            throw throwable;
                        }
                        download.setScrapeResult(new DownloadScrapeResult(){

                            public Download getDownload() {
                                return download;
                            }

                            public int getResponseType() {
                                return 1;
                            }

                            public int getSeedCount() {
                                return f_adj_seeds;
                            }

                            public int getNonSeedCount() {
                                return f_adj_leechers;
                            }

                            public long getScrapeStartTime() {
                                return start;
                            }

                            public void setNextScrapeStartTime(long nextScrapeStartTime) {
                            }

                            public long getNextScrapeStartTime() {
                                return SystemTime.getCurrentTime() + retry;
                            }

                            public String getStatus() {
                                return "OK";
                            }

                            public URL getURL() {
                                return url_to_report;
                            }
                        });
                    }
                }
            });
        }
        return num_done;
    }

    protected boolean isComplete(Download download) {
        PEPeerManager core_pm;
        PeerManager pm;
        if (Constants.DOWNLOAD_SOURCES_PRETEND_COMPLETE) {
            return true;
        }
        boolean is_complete = download.isComplete();
        if (is_complete && (pm = download.getPeerManager()) != null && (core_pm = PluginCoreUtils.unwrap(pm)) != null && core_pm.getHiddenBytes() > 0L) {
            is_complete = false;
        }
        return is_complete;
    }

    protected void trackerRemove(final Download download, RegistrationDetails details) {
        final long start = SystemTime.getCurrentTime();
        trackerTarget[] targets = details.getTargets(true);
        for (int i = 0; i < targets.length; ++i) {
            final trackerTarget target = targets[i];
            if (!this.dht.hasLocalKey(target.getHash())) continue;
            this.increaseActive(download);
            this.dht.remove(target.getHash(), "Tracker deregistration of '" + download.getName() + "' " + target.getDesc(), new DHTPluginOperationListener(){

                public void diversified() {
                }

                public void starts(byte[] key) {
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                public void valueWritten(DHTPluginContact target2, DHTPluginValue value) {
                }

                public void complete(byte[] key, boolean timeout_occurred) {
                    if (target.getType() == 2) {
                        DHTTrackerPlugin.this.log(download, "Unregistration of '" + target.getDesc() + "' completed (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + ")");
                    }
                    DHTTrackerPlugin.this.decreaseActive(download);
                }
            });
        }
    }

    protected void trackerRemove(final Download download, final trackerTarget target) {
        final long start = SystemTime.getCurrentTime();
        if (this.dht.hasLocalKey(target.getHash())) {
            this.increaseActive(download);
            this.dht.remove(target.getHash(), "Tracker deregistration of '" + download.getName() + "' " + target.getDesc(), new DHTPluginOperationListener(){

                public void diversified() {
                }

                public void starts(byte[] key) {
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                }

                public void valueWritten(DHTPluginContact target2, DHTPluginValue value) {
                }

                public void complete(byte[] key, boolean timeout_occurred) {
                    if (target.getType() == 2) {
                        DHTTrackerPlugin.this.log(download, "Unregistration of '" + target.getDesc() + "' completed (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + ")");
                    }
                    DHTTrackerPlugin.this.decreaseActive(download);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNonRegistrations() {
        Download download;
        Torrent torrent;
        Download ready_download = null;
        long ready_download_next_check = -1L;
        long now = this.plugin_interface.getUtilities().getCurrentSystemTime();
        ArrayList<Download> to_scrape = new ArrayList<Download>();
        try {
            this.this_mon.enter();
            Iterator<Download> it = this.interesting_downloads.keySet().iterator();
            while (it.hasNext() && ready_download == null) {
                int[] run_data;
                Download download2 = it.next();
                torrent = download2.getTorrent();
                if (torrent == null || (run_data = this.running_downloads.get(download2)) != null && run_data[0] != 3) continue;
                to_scrape.add(download2);
            }
            Object var12_12 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.this_mon.exit();
            throw throwable;
        }
        HashMap<Download, DownloadScrapeResult> scrapes = new HashMap<Download, DownloadScrapeResult>();
        for (int i = 0; i < to_scrape.size(); ++i) {
            download = (Download)to_scrape.get(i);
            scrapes.put(download, download.getLastScrapeResult());
        }
        try {
            this.this_mon.enter();
            Iterator<Download> it = this.interesting_downloads.keySet().iterator();
            while (it.hasNext() && ready_download == null) {
                long check_period;
                DownloadScrapeResult scrape;
                boolean force;
                int[] run_data;
                download = it.next();
                Torrent torrent2 = download.getTorrent();
                if (torrent2 == null || (run_data = this.running_downloads.get(download)) != null && run_data[0] != 3 || !(force = torrent2.wasCreatedByUs()) && (this.interesting_pub_max > 0 && this.interesting_published > this.interesting_pub_max || (scrape = (DownloadScrapeResult)scrapes.get(download)) == null || scrape.getSeedCount() + scrape.getNonSeedCount() > 30)) continue;
                long target = this.interesting_downloads.get(download);
                long l = check_period = TorrentUtils.isDecentralised(torrent2.getAnnounceURL()) ? 3600000L : 14400000L;
                if (target <= now) {
                    ready_download = download;
                    ready_download_next_check = now + check_period;
                    this.interesting_downloads.put(download, new Long(ready_download_next_check));
                    continue;
                }
                if (target - now <= check_period) continue;
                this.interesting_downloads.put(download, new Long(now + target % check_period));
            }
            Object var18_21 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (ready_download != null) {
            final Download f_ready_download = ready_download;
            torrent = ready_download.getTorrent();
            if (this.dht.isDiversified(torrent.getHash())) {
                try {
                    this.this_mon.enter();
                    this.interesting_downloads.remove(f_ready_download);
                    Object var20_24 = null;
                    this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var20_25 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            } else {
                final long start = now;
                final long f_next_check = ready_download_next_check;
                this.dht.get(torrent.getHash(), "Presence query for '" + ready_download.getName() + "'", (byte)0, 8, 120000L, false, false, new DHTPluginOperationListener(){
                    private boolean diversified;
                    private int leechers = 0;
                    private int seeds = 0;

                    public void diversified() {
                        this.diversified = true;
                    }

                    public void starts(byte[] key) {
                    }

                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                        if ((value.getFlags() & 1) == 1) {
                            ++this.leechers;
                        } else {
                            ++this.seeds;
                        }
                    }

                    public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void complete(byte[] key, boolean timeout_occurred) {
                        int total = this.leechers + this.seeds;
                        DHTTrackerPlugin.this.log(torrent, "Presence query: availability=" + (total == 8 ? "8+" : total + "") + ",div=" + this.diversified + " (elapsed=" + TimeFormatter.formatColonMillis(SystemTime.getCurrentTime() - start) + ")");
                        if (this.diversified) {
                            try {
                                DHTTrackerPlugin.this.this_mon.enter();
                                DHTTrackerPlugin.this.interesting_downloads.remove(f_ready_download);
                                Object var5_4 = null;
                                DHTTrackerPlugin.this.this_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                DHTTrackerPlugin.this.this_mon.exit();
                                throw throwable;
                            }
                        }
                        if (total < 8) {
                            try {
                                DHTTrackerPlugin.this.this_mon.enter();
                                DHTTrackerPlugin.this.interesting_downloads.remove(f_ready_download);
                                Object var7_8 = null;
                                DHTTrackerPlugin.this.this_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var7_9 = null;
                                DHTTrackerPlugin.this.this_mon.exit();
                                throw throwable;
                            }
                            DHTTrackerPlugin.this.interesting_published++;
                            if (!DHTTrackerPlugin.this.disable_put) {
                                DHTTrackerPlugin.this.dht.put(torrent.getHash(), "Presence store '" + f_ready_download.getName() + "'", "0".getBytes(), (byte)0, new DHTPluginOperationListener(){

                                    public void diversified() {
                                    }

                                    public void starts(byte[] key) {
                                    }

                                    public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                                    }

                                    public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                                    }

                                    public void complete(byte[] key, boolean timeout_occurred) {
                                    }
                                });
                            }
                        }
                        try {
                            DHTTrackerPlugin.this.this_mon.enter();
                            int[] run_data = (int[])DHTTrackerPlugin.this.running_downloads.get(f_ready_download);
                            if (run_data == null) {
                                run_data = (int[])DHTTrackerPlugin.this.run_data_cache.get(f_ready_download);
                            }
                            if (run_data != null) {
                                if (total < 8) {
                                    run_data[1] = this.seeds;
                                    run_data[2] = this.leechers;
                                    run_data[3] = total;
                                } else {
                                    run_data[1] = Math.max(run_data[1], this.seeds);
                                    run_data[2] = Math.max(run_data[2], this.leechers);
                                }
                            }
                            Object var9_11 = null;
                            DHTTrackerPlugin.this.this_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            DHTTrackerPlugin.this.this_mon.exit();
                            throw throwable;
                        }
                        f_ready_download.setScrapeResult(new DownloadScrapeResult(){

                            public Download getDownload() {
                                return null;
                            }

                            public int getResponseType() {
                                return 1;
                            }

                            public int getSeedCount() {
                                return seeds;
                            }

                            public int getNonSeedCount() {
                                return leechers;
                            }

                            public long getScrapeStartTime() {
                                return SystemTime.getCurrentTime();
                            }

                            public void setNextScrapeStartTime(long nextScrapeStartTime) {
                            }

                            public long getNextScrapeStartTime() {
                                return f_next_check;
                            }

                            public String getStatus() {
                                return "OK";
                            }

                            public URL getURL() {
                                URL url_to_report = torrent.isDecentralised() ? torrent.getAnnounceURL() : DEFAULT_URL;
                                return url_to_report;
                            }
                        });
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(Download download, int old_state, int new_state) {
        int state = download.getState();
        try {
            this.this_mon.enter();
            if ((state == 4 || state == 5 || state == 9) && this.running_downloads.containsKey(download)) {
                this.query_map.put(download, new Long(SystemTime.getCurrentTime()));
            }
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (!download.isPaused()) {
            this.checkDownloadForRegistration(download, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announceAll() {
        this.log.log("Announce-all requested");
        Long now = new Long(SystemTime.getCurrentTime());
        try {
            this.this_mon.enter();
            for (Map.Entry<Download, Long> entry : this.query_map.entrySet()) {
                entry.setValue(now);
            }
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void positionChanged(Download download, int oldPosition, int newPosition) {
    }

    protected void configChanged() {
        Download[] downloads = this.plugin_interface.getDownloadManager().getDownloads();
        for (int i = 0; i < downloads.length; ++i) {
            this.checkDownloadForRegistration(downloads[i], false);
        }
    }

    public DownloadScrapeResult scrape(byte[] hash) {
        final int[] seeds = new int[]{0};
        final int[] leechers = new int[]{0};
        final AESemaphore sem = new AESemaphore("DHTTrackerPlugin:scrape");
        this.dht.get(hash, "Scrape for '" + ByteFormatter.nicePrint(hash) + "'", (byte)1, 30, 30000L, false, false, new DHTPluginOperationListener(){

            public void diversified() {
            }

            public void starts(byte[] key) {
            }

            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                if ((value.getFlags() & 1) == 1) {
                    leechers[0] = leechers[0] + 1;
                } else {
                    seeds[0] = seeds[0] + 1;
                }
            }

            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            public void complete(byte[] key, boolean timeout_occurred) {
                sem.release();
            }
        });
        sem.reserve();
        return new DownloadScrapeResult(){

            public Download getDownload() {
                return null;
            }

            public int getResponseType() {
                return 1;
            }

            public int getSeedCount() {
                return seeds[0];
            }

            public int getNonSeedCount() {
                return leechers[0];
            }

            public long getScrapeStartTime() {
                return 0L;
            }

            public void setNextScrapeStartTime(long nextScrapeStartTime) {
            }

            public long getNextScrapeStartTime() {
                return 0L;
            }

            public String getStatus() {
                return "OK";
            }

            public URL getURL() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseActive(Download dl) {
        try {
            this.this_mon.enter();
            Integer active_i = this.in_progress.get(dl);
            int active = active_i == null ? 0 : active_i;
            this.in_progress.put(dl, new Integer(active + 1));
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseActive(Download dl) {
        try {
            this.this_mon.enter();
            Integer active_i = this.in_progress.get(dl);
            if (active_i == null) {
                Debug.out("active count inconsistent");
            } else {
                int active = active_i - 1;
                if (active == 0) {
                    this.in_progress.remove(dl);
                } else {
                    this.in_progress.put(dl, new Integer(active));
                }
            }
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive(Download dl) {
        try {
            this.this_mon.enter();
            boolean bl = this.in_progress.get(dl) != null;
            Object var4_3 = null;
            this.this_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected DHTNetworkPosition[] getNetworkPositions() {
        DHTNetworkPosition[] res = this.current_network_positions;
        long now = SystemTime.getMonotonousTime();
        if (res == null || now - this.last_net_pos_time > 1800000L) {
            this.current_network_positions = DHTNetworkPositionManager.getLocalPositions();
            res = this.current_network_positions;
            this.last_net_pos_time = now;
        }
        return res;
    }

    private void log(Download download, String str) {
        this.log(download.getTorrent(), str);
    }

    private void log(Torrent torrent, String str) {
        this.log.log((Object)torrent, 1, str);
    }

    public TrackerPeerSource getTrackerPeerSource(final Download download) {
        return new TrackerPeerSourceAdapter(){
            private long last_fixup;
            private boolean updating;
            private int status = 0;
            private long next_time = -1L;
            private int[] run_data;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fixup() {
                long now = SystemTime.getMonotonousTime();
                if (now - this.last_fixup > 5000L) {
                    try {
                        DHTTrackerPlugin.this.this_mon.enter();
                        this.updating = false;
                        this.next_time = -1L;
                        this.run_data = (int[])DHTTrackerPlugin.this.running_downloads.get(download);
                        if (this.run_data != null) {
                            if (DHTTrackerPlugin.this.in_progress.containsKey(download)) {
                                this.updating = true;
                            }
                            this.status = DHTTrackerPlugin.this.initialised_sem.isReleasedForever() ? 5 : 2;
                            Long l_next_time = (Long)DHTTrackerPlugin.this.query_map.get(download);
                            if (l_next_time != null) {
                                this.next_time = l_next_time;
                            }
                        } else {
                            int dl_state;
                            this.status = DHTTrackerPlugin.this.interesting_downloads.containsKey(download) ? 2 : ((dl_state = download.getState()) == 4 || dl_state == 5 || dl_state == 9 ? 1 : 2);
                        }
                        if (this.run_data == null) {
                            this.run_data = (int[])DHTTrackerPlugin.this.run_data_cache.get(download);
                        }
                        Object var5_4 = null;
                        DHTTrackerPlugin.this.this_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        DHTTrackerPlugin.this.this_mon.exit();
                        throw throwable;
                    }
                    String[] sources = download.getListAttribute(DHTTrackerPlugin.this.ta_peer_sources);
                    boolean ok = false;
                    for (int i = 0; i < sources.length; ++i) {
                        if (!sources[i].equalsIgnoreCase("DHT")) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        this.status = 1;
                    }
                    this.last_fixup = now;
                }
            }

            public int getType() {
                return 3;
            }

            public String getName() {
                return "DHT: " + DHTTrackerPlugin.this.model.getStatus().getText();
            }

            public int getStatus() {
                this.fixup();
                return this.status;
            }

            public int getSeedCount() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return this.run_data[1];
            }

            public int getLeecherCount() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return this.run_data[2];
            }

            public int getPeers() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return this.run_data[3];
            }

            public int getSecondsToUpdate() {
                this.fixup();
                if (this.next_time < 0L) {
                    return -1;
                }
                return (int)((this.next_time - SystemTime.getCurrentTime()) / 1000L);
            }

            public int getInterval() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return (int)(DHTTrackerPlugin.this.current_announce_interval / 1000L);
            }

            public int getMinInterval() {
                this.fixup();
                if (this.run_data == null) {
                    return -1;
                }
                return 120;
            }

            public boolean isUpdating() {
                return this.updating;
            }
        };
    }

    public static List<Object[]> getVivaldiTargets(byte[] torrent_hash, double[] loc) {
        ArrayList<Object[]> derived_results = new ArrayList<Object[]>();
        String loc_str = "";
        for (int j = 0; j < loc.length; ++j) {
            loc_str = loc_str + (j == 0 ? "" : ",") + loc[j];
        }
        TriangleSlicer slicer = new TriangleSlicer(25);
        double t1_x = loc[0];
        double t1_y = loc[1];
        double t2_x = loc[2];
        double t2_y = loc[3];
        int[] triangle1 = slicer.findVertices(t1_x, t1_y);
        int[] triangle2 = slicer.findVertices(t2_x, t2_y);
        for (int j = 0; j < triangle1.length; j += 2) {
            int t1_vx = triangle1[j];
            int t1_vy = triangle1[j + 1];
            double t1_distance = DHTTrackerPlugin.getDistance(t1_x, t1_y, t1_vx, t1_vy);
            for (int k = 0; k < triangle2.length; k += 2) {
                int t2_vx = triangle2[k];
                int t2_vy = triangle2[k + 1];
                double t2_distance = DHTTrackerPlugin.getDistance(t2_x, t2_y, t2_vx, t2_vy);
                double distance = DHTTrackerPlugin.getDistance(t1_distance, 0.0, 0.0, t2_distance);
                String key = "azderived:vivaldi:";
                String v_str = t1_vx + "." + t1_vy + "." + t2_vx + "." + t2_vy;
                key = key + v_str;
                try {
                    byte[] v_bytes = key.getBytes("UTF-8");
                    byte[] key_bytes = new byte[torrent_hash.length + v_bytes.length];
                    System.arraycopy(torrent_hash, 0, key_bytes, 0, torrent_hash.length);
                    System.arraycopy(v_bytes, 0, key_bytes, torrent_hash.length, v_bytes.length);
                    derived_results.add(new Object[]{new Integer((int)distance), new trackerTarget(key_bytes, 3, "Vivaldi: " + v_str)});
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        Collections.sort(derived_results, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] entry1, Object[] entry2) {
                int d1 = (Integer)entry1[0];
                int d2 = (Integer)entry2[0];
                return d1 - d2;
            }
        });
        return derived_results;
    }

    protected static double getDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    static {
        try {
            DEFAULT_URL = new URL("dht:");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected class RegistrationDetails {
        private static final int DERIVED_ACTIVE_MIN_MILLIS = 0x6DDD00;
        private putDetails put_details;
        private byte flags;
        private trackerTarget[] put_targets;
        private List<trackerTarget> not_put_targets;
        private long derived_active_start = -1L;
        private long previous_metric;

        protected RegistrationDetails(Download _download, int _reg_type, putDetails _put_details, byte _flags) {
            this.put_details = _put_details;
            this.flags = _flags;
            this.getTrackerTargets(_download, _reg_type);
        }

        protected void update(putDetails _put_details, byte _flags) {
            this.put_details = _put_details;
            this.flags = _flags;
        }

        protected boolean updateTargets(Download _download, int _reg_type) {
            trackerTarget[] old_put_targets = this.put_targets;
            this.getTrackerTargets(_download, _reg_type);
            for (int i = 0; i < old_put_targets.length; ++i) {
                boolean found = false;
                byte[] old_hash = old_put_targets[i].getHash();
                for (int j = 0; j < this.put_targets.length; ++j) {
                    if (!Arrays.equals(this.put_targets[j].getHash(), old_hash)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                DHTTrackerPlugin.this.trackerRemove(_download, old_put_targets[i]);
            }
            boolean changed = false;
            for (int i = 0; i < this.put_targets.length; ++i) {
                byte[] new_hash = this.put_targets[i].getHash();
                boolean found = false;
                for (int j = 0; j < old_put_targets.length; ++j) {
                    if (!Arrays.equals(old_put_targets[j].getHash(), new_hash)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                changed = true;
            }
            return changed;
        }

        protected putDetails getPutDetails() {
            return this.put_details;
        }

        protected byte getFlags() {
            return this.flags;
        }

        protected trackerTarget[] getTargets(boolean for_put) {
            if (for_put || this.not_put_targets == null) {
                return this.put_targets;
            }
            ArrayList<trackerTarget> result = new ArrayList<trackerTarget>(Arrays.asList(this.put_targets));
            for (int i = 0; i < this.not_put_targets.size() && i < 2; ++i) {
                trackerTarget target = this.not_put_targets.remove(0);
                this.not_put_targets.add(target);
                result.add(target);
            }
            return result.toArray(new trackerTarget[result.size()]);
        }

        protected void getTrackerTargets(Download download, int type) {
            byte[] torrent_hash = download.getTorrent().getHash();
            ArrayList<trackerTarget> result = new ArrayList<trackerTarget>();
            if (type == 2) {
                result.add(new trackerTarget(torrent_hash, 2, ""));
            }
            if (ADD_ASN_DERIVED_TARGET) {
                NetworkAdminASN net_asn = NetworkAdmin.getSingleton().getCurrentASN();
                String as = net_asn.getAS();
                String asn = net_asn.getASName();
                if (as.length() > 0 && asn.length() > 0) {
                    String key = "azderived:asn:" + as;
                    try {
                        byte[] asn_bytes = key.getBytes("UTF-8");
                        byte[] key_bytes = new byte[torrent_hash.length + asn_bytes.length];
                        System.arraycopy(torrent_hash, 0, key_bytes, 0, torrent_hash.length);
                        System.arraycopy(asn_bytes, 0, key_bytes, torrent_hash.length, asn_bytes.length);
                        result.add(new trackerTarget(key_bytes, 3, asn + "/" + as));
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            if (ADD_NETPOS_DERIVED_TARGETS) {
                boolean do_it;
                boolean do_it_now;
                long now = SystemTime.getMonotonousTime();
                Long metric = (Long)download.getUserData(DL_DERIVED_METRIC_KEY);
                boolean bl = do_it_now = metric != null;
                if (this.derived_active_start >= 0L && now - this.derived_active_start <= 0x6DDD00L) {
                    do_it = true;
                    if (metric == null) {
                        metric = new Long(this.previous_metric);
                    }
                } else if (do_it_now) {
                    do_it = true;
                } else {
                    this.derived_active_start = -1L;
                    do_it = false;
                }
                boolean newly_active = false;
                if (do_it_now) {
                    newly_active = this.derived_active_start == -1L;
                    this.derived_active_start = now;
                }
                ArrayList<trackerTarget> skipped_targets = null;
                if (do_it) {
                    this.previous_metric = metric;
                    try {
                        DHTNetworkPosition[] positions = DHTTrackerPlugin.this.getNetworkPositions();
                        for (int i = 0; i < positions.length; ++i) {
                            DHTNetworkPosition pos = positions[i];
                            if (pos.getPositionType() != 5 || !pos.isValid()) continue;
                            List<Object[]> derived_results = DHTTrackerPlugin.getVivaldiTargets(torrent_hash, pos.getLocation());
                            int num_to_add = metric.intValue() * derived_results.size() / 100;
                            for (int j = 0; j < derived_results.size(); ++j) {
                                Object[] entry = derived_results.get(j);
                                trackerTarget target = (trackerTarget)entry[1];
                                if (j < num_to_add) {
                                    result.add(target);
                                    continue;
                                }
                                if (skipped_targets == null) {
                                    skipped_targets = new ArrayList<trackerTarget>();
                                }
                                skipped_targets.add(target);
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                this.not_put_targets = skipped_targets;
            }
            this.put_targets = result.toArray(new trackerTarget[result.size()]);
        }
    }

    public static class TriangleSlicer {
        int width;
        private double w;
        private double w2;
        private double h;
        private double tan60;

        public TriangleSlicer(int width) {
            this.width = width;
            this.w = width;
            this.w2 = this.w / 2.0;
            this.h = Math.cos(0.5235987755982988) * this.w;
            this.tan60 = Math.tan(1.0471975511965976);
        }

        public int[] findVertices(double x, double y) {
            double v3y;
            double v3x;
            double v2y;
            double v2x;
            double v1y;
            double v1x;
            boolean upTriangle;
            int yN = (int)Math.floor(y / this.h);
            int xN = (int)Math.floor(x / this.w2);
            if ((xN + yN) % 2 == 0) {
                if (y - this.h * (double)yN > (x - this.w2 * (double)xN) * this.tan60) {
                    upTriangle = false;
                    v1x = this.w2 * (double)(xN - 1);
                    v1y = this.h * (double)(yN + 1);
                } else {
                    upTriangle = true;
                    v1x = this.w2 * (double)xN;
                    v1y = this.h * (double)yN;
                }
            } else if (y - this.h * (double)yN > (this.w2 - (x - this.w2 * (double)xN)) * this.tan60) {
                upTriangle = false;
                v1x = this.w2 * (double)xN;
                v1y = this.h * (double)(yN + 1);
            } else {
                upTriangle = true;
                v1x = this.w2 * (double)(xN - 1);
                v1y = this.h * (double)yN;
            }
            if (upTriangle) {
                v2x = v1x + this.w;
                v2y = v1y;
                v3x = v1x + this.w2;
                v3y = v1y + this.h;
            } else {
                v2x = v1x + this.w;
                v2y = v1y;
                v3x = v1x + this.w2;
                v3y = v1y - this.h;
            }
            int[] result = new int[]{(int)v1x, (int)v1y, (int)v2x, (int)v2y, (int)v3x, (int)v3y};
            return result;
        }
    }

    protected static class putDetails {
        private String encoded;
        private String ip_override;
        private int tcp_port;
        private int udp_port;

        private putDetails(String _encoded, String _ip, int _tcp_port, int _udp_port) {
            this.encoded = _encoded;
            this.ip_override = _ip;
            this.tcp_port = _tcp_port;
            this.udp_port = _udp_port;
        }

        protected String getEncoded() {
            return this.encoded;
        }

        protected String getIPOverride() {
            return this.ip_override;
        }

        protected int getTCPPort() {
            return this.tcp_port;
        }

        protected int getUDPPort() {
            return this.udp_port;
        }

        protected boolean sameAs(putDetails other) {
            return this.getEncoded().equals(other.getEncoded());
        }
    }

    public static class trackerTarget {
        private String desc;
        private byte[] hash;
        private int type;

        protected trackerTarget(byte[] _hash, int _type, String _desc) {
            this.hash = _hash;
            this.type = _type;
            this.desc = _desc;
        }

        public int getType() {
            return this.type;
        }

        public byte[] getHash() {
            return this.hash;
        }

        public String getDesc() {
            if (this.type != 2) {
                return " (" + this.desc + ")";
            }
            return "";
        }
    }
}

