/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin;

import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DefaultRankCalculator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;

public class SeedingRankColumnListener
implements TableCellRefreshListener,
COConfigurationListener {
    private Map downloadDataMap;
    private PluginConfig pluginConfig;
    private int minTimeAlive;
    private int iRankType;
    private boolean bDebugLog;

    public SeedingRankColumnListener(Map _downloadDataMap, PluginConfig pc) {
        this.downloadDataMap = _downloadDataMap;
        this.pluginConfig = pc;
        COConfigurationManager.addListener(this);
        this.configurationSaved();
    }

    public void refresh(TableCell cell) {
        Download dl = (Download)cell.getDataSource();
        if (dl == null) {
            return;
        }
        DefaultRankCalculator dlData = null;
        Comparable o = cell.getSortValue();
        if (o instanceof DefaultRankCalculator) {
            dlData = (DefaultRankCalculator)o;
        } else {
            dlData = (DefaultRankCalculator)this.downloadDataMap.get(dl);
            cell.setSortValue(dlData);
        }
        if (dlData == null) {
            return;
        }
        long sr = dl.getSeedingRank();
        String sText = "";
        if (sr >= 0L) {
            if (dlData.getCachedIsFP()) {
                sText = sText + MessageText.getString("StartStopRules.firstPriority") + " ";
            }
            if (this.iRankType == 3) {
                if (sr > 999999L) {
                    long timeStarted = dl.getStats().getTimeStartedSeeding();
                    long timeLeft = dl.isForceStart() ? 31536000L : (timeStarted <= 0L ? (long)this.minTimeAlive : (long)this.minTimeAlive - (SystemTime.getCurrentTime() - timeStarted));
                    sText = sText + TimeFormatter.format(timeLeft / 1000L);
                } else if (sr > 0L) {
                    sText = sText + MessageText.getString("StartStopRules.waiting");
                }
            } else if (sr > 0L) {
                sText = sText + String.valueOf(sr);
            }
        } else {
            sText = sr == -6L ? MessageText.getString("StartStopRules.FP0Peers") : (sr == -3L ? MessageText.getString("StartStopRules.SPratioMet") : (sr == -4L ? MessageText.getString("StartStopRules.ratioMet") : (sr == -5L ? MessageText.getString("StartStopRules.numSeedsMet") : (sr == -2L ? "" : (sr == -7L ? MessageText.getString("StartStopRules.0Peers") : (sr == -8L ? MessageText.getString("StartStopRules.shareRatioMet") : "ERR" + sr))))));
        }
        if (SystemTime.getCurrentTime() - dl.getStats().getTimeStartedSeeding() < (long)this.minTimeAlive) {
            sText = "* " + sText;
        }
        cell.setText(sText);
        if (this.bDebugLog) {
            cell.setToolTip("FP:\n" + dlData.sExplainFP + "\n" + "SR:" + dlData.sExplainSR + "\n" + "TRACE:\n" + dlData.sTrace);
        } else {
            cell.setToolTip(null);
        }
    }

    public void configurationSaved() {
        this.minTimeAlive = this.pluginConfig.getUnsafeIntParameter("StartStopManager_iMinSeedingTime") * 1000;
        this.iRankType = this.pluginConfig.getUnsafeIntParameter("StartStopManager_iRankType");
        this.bDebugLog = this.pluginConfig.getUnsafeBooleanParameter("StartStopManager_bDebugLog");
    }
}

