/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin;

import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesFPListener;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadStats;

public class DefaultRankCalculator
implements Comparable {
    public static final int FIRSTPRIORITY_ALL = 0;
    public static final int FIRSTPRIORITY_ANY = 1;
    private static final int FORCE_ACTIVE_FOR = 30000;
    private static final int ACTIVE_CHANGE_WAIT = 10000;
    private static int SPRATIO_BASE_LIMIT = 99999;
    private static int SEEDONLY_SHIFT = SPRATIO_BASE_LIMIT + 1;
    private static COConfigurationListener configListener = null;
    public static final int SR_COMPLETE_STARTS_AT = 1000000000;
    public static final int SR_TIMED_QUEUED_ENDS_AT = 999999;
    public static final int SR_IGNORED_LESS_THAN = -1;
    public static final int SR_NOTQUEUED = -2;
    public static final int SR_FP_SPRATIOMET = -3;
    public static final int SR_RATIOMET = -4;
    public static final int SR_NUMSEEDSMET = -5;
    public static final int SR_FP0PEERS = -6;
    public static final int SR_0PEERS = -7;
    public static final int SR_SHARERATIOMET = -8;
    public static final String[] SR_NEGATIVE_DEBUG = new String[]{"?", "Not Qd", "FP SPRatioMet", "Ratio Met", "# CDs Met", "FP 0 Peers", "0 Peers", "Share Ratio Met"};
    private static final long STALE_REFRESH_INTERVAL = 60000L;
    protected static int iRankType = -1;
    private static int minPeersToBoostNoSeeds;
    private static int minSpeedForActiveDL;
    private static int minSpeedForActiveSeeding;
    private static int iIgnoreSeedCount;
    private static boolean bIgnore0Peers;
    private static int iIgnoreShareRatio;
    private static int iIgnoreShareRatio_SeedStart;
    private static int iIgnoreRatioPeers;
    private static int iIgnoreRatioPeers_SeedStart;
    private static int iRankTypeSeedFallback;
    private static boolean bPreferLargerSwarms;
    private static int minQueueingShareRatio;
    private static int iFirstPriorityIgnoreSPRatio;
    private static boolean bFirstPriorityIgnore0Peer;
    private static int iFirstPriorityType;
    private static int iFirstPrioritySeedingMinutes;
    private static int iFirstPriorityActiveMinutes;
    private static int iFirstPriorityIgnoreIdleHours;
    private static long minTimeAlive;
    private static boolean bAutoStart0Peers;
    protected Download dl;
    private boolean bActivelyDownloading;
    private long lDLActivelyChangedOn;
    private boolean bActivelySeeding;
    private long lCDActivelyChangedOn;
    private long staleCDSince;
    private long staleCDOffset;
    private long lastStaleCDRefresh;
    private boolean bIsFirstPriority;
    public String sExplainFP = "";
    public String sExplainSR = "";
    public String sTrace = "";
    private AEMonitor downloadData_this_mon = new AEMonitor("StartStopRules:downloadData");
    private final StartStopRulesDefaultPlugin rules;
    int lastModifiedScrapeResultPeers = 0;
    int lastModifiedScrapeResultSeeds = 0;
    int lastModifiedShareRatio = 0;
    boolean lastScrapeResultOk = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRankCalculator(StartStopRulesDefaultPlugin _rules, Download _dl) {
        this.rules = _rules;
        this.dl = _dl;
        try {
            this.downloadData_this_mon.enter();
            if (configListener == null) {
                configListener = new COConfigurationListener(){

                    public void configurationSaved() {
                        DefaultRankCalculator.reloadConfigParams(((DefaultRankCalculator)DefaultRankCalculator.this).rules.plugin_config);
                    }
                };
                COConfigurationManager.addListener(configListener);
                configListener.configurationSaved();
            }
            Object var4_3 = null;
            this.downloadData_this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.downloadData_this_mon.exit();
            throw throwable;
        }
    }

    public static void reloadConfigParams(PluginConfig cfg) {
        String PREFIX = "StartStopManager_";
        iRankType = cfg.getUnsafeIntParameter("StartStopManager_iRankType");
        minPeersToBoostNoSeeds = cfg.getUnsafeIntParameter("StartStopManager_iMinPeersToBoostNoSeeds");
        minSpeedForActiveDL = cfg.getUnsafeIntParameter("StartStopManager_iMinSpeedForActiveDL");
        minSpeedForActiveSeeding = cfg.getUnsafeIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
        iRankTypeSeedFallback = cfg.getUnsafeIntParameter("StartStopManager_iRankTypeSeedFallback");
        bPreferLargerSwarms = cfg.getUnsafeBooleanParameter("StartStopManager_bPreferLargerSwarms");
        minTimeAlive = cfg.getUnsafeIntParameter("StartStopManager_iMinSeedingTime") * 1000;
        bAutoStart0Peers = cfg.getUnsafeBooleanParameter("StartStopManager_bAutoStart0Peers");
        iIgnoreSeedCount = cfg.getUnsafeIntParameter("StartStopManager_iIgnoreSeedCount");
        bIgnore0Peers = cfg.getUnsafeBooleanParameter("StartStopManager_bIgnore0Peers");
        iIgnoreShareRatio = (int)(1000.0f * cfg.getFloatParameter("Stop Ratio"));
        iIgnoreShareRatio_SeedStart = cfg.getUnsafeIntParameter("StartStopManager_iIgnoreShareRatioSeedStart");
        iIgnoreRatioPeers = cfg.getIntParameter("Stop Peers Ratio", 0);
        iIgnoreRatioPeers_SeedStart = cfg.getUnsafeIntParameter("StartStopManager_iIgnoreRatioPeersSeedStart", 0);
        minQueueingShareRatio = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_ShareRatio");
        iFirstPriorityType = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_Type");
        iFirstPrioritySeedingMinutes = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_SeedingMinutes");
        iFirstPriorityActiveMinutes = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_DLMinutes");
        iFirstPriorityIgnoreSPRatio = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_ignoreSPRatio");
        bFirstPriorityIgnore0Peer = cfg.getUnsafeBooleanParameter("StartStopManager_bFirstPriority_ignore0Peer");
        iFirstPriorityIgnoreIdleHours = cfg.getUnsafeIntParameter("StartStopManager_iFirstPriority_ignoreIdleHours");
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof DefaultRankCalculator)) {
            return -1;
        }
        DefaultRankCalculator dlData = (DefaultRankCalculator)obj;
        if (dlData.bIsFirstPriority && !this.bIsFirstPriority) {
            return 1;
        }
        if (!dlData.bIsFirstPriority && this.bIsFirstPriority) {
            return -1;
        }
        boolean aIsComplete = dlData.dl.isComplete();
        boolean bIsComplete = this.dl.isComplete();
        if (aIsComplete && !bIsComplete) {
            return -1;
        }
        if (!aIsComplete && bIsComplete) {
            return 1;
        }
        if (iRankType == 0) {
            return this.dl.getPosition() - dlData.dl.getPosition();
        }
        int value = dlData.dl.getSeedingRank() - this.dl.getSeedingRank();
        if (value != 0) {
            return value;
        }
        if (iRankType != 3) {
            int numPeersThem = dlData.lastModifiedScrapeResultPeers;
            int numPeersUs = this.lastModifiedScrapeResultPeers;
            value = bPreferLargerSwarms ? numPeersThem - numPeersUs : numPeersUs - numPeersThem;
            if (value != 0) {
                return value;
            }
            value = this.lastModifiedShareRatio - dlData.lastModifiedShareRatio;
            if (value != 0) {
                return value;
            }
        }
        return this.dl.getPosition() - dlData.dl.getPosition();
    }

    public Download getDownloadObject() {
        return this.dl;
    }

    public boolean isForceActive() {
        DownloadStats stats2 = this.dl.getStats();
        return SystemTime.getCurrentTime() - stats2.getTimeStarted() <= 30000L;
    }

    public boolean getActivelyDownloading() {
        boolean bIsActive = false;
        DownloadStats stats2 = this.dl.getStats();
        int state = this.dl.getState();
        if (state != 4) {
            bIsActive = false;
        } else if (SystemTime.getCurrentTime() - stats2.getTimeStarted() <= 30000L) {
            bIsActive = true;
        } else {
            boolean bl = bIsActive = stats2.getDownloadAverage() >= (long)minSpeedForActiveDL;
            if (this.bActivelyDownloading != bIsActive) {
                long now = SystemTime.getCurrentTime();
                if (this.lDLActivelyChangedOn == -1L) {
                    this.lDLActivelyChangedOn = now;
                    bIsActive = !bIsActive;
                } else if (now - this.lDLActivelyChangedOn < 10000L) {
                    bIsActive = !bIsActive;
                }
            } else {
                this.lDLActivelyChangedOn = -1L;
            }
        }
        if (this.bActivelyDownloading != bIsActive) {
            this.bActivelyDownloading = bIsActive;
            if (this.rules != null) {
                this.rules.requestProcessCycle(null);
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: ActivelyDownloading changed");
                }
            }
        }
        return this.bActivelyDownloading;
    }

    public boolean getActivelySeeding() {
        boolean bIsActive = false;
        DownloadStats stats2 = this.dl.getStats();
        int state = this.dl.getState();
        if (!(iRankType != 3 || this.isFirstPriority() || bAutoStart0Peers && this.rules.calcPeersNoUs(this.dl) == 0 && this.lastScrapeResultOk)) {
            bIsActive = state == 5;
        } else if (state != 5 || bAutoStart0Peers && this.rules.calcPeersNoUs(this.dl) == 0) {
            bIsActive = false;
            this.staleCDSince = -1L;
        } else if (SystemTime.getCurrentTime() - stats2.getTimeStarted() <= 30000L) {
            bIsActive = true;
            this.staleCDSince = -1L;
        } else {
            boolean bl = bIsActive = stats2.getUploadAverage() >= (long)minSpeedForActiveSeeding;
            if (this.bActivelySeeding != bIsActive) {
                long now = SystemTime.getCurrentTime();
                if (this.lCDActivelyChangedOn < 0L) {
                    this.lCDActivelyChangedOn = now;
                    bIsActive = !bIsActive;
                } else if (now - this.lCDActivelyChangedOn < 10000L) {
                    boolean bl2 = bIsActive = !bIsActive;
                }
                if (this.bActivelySeeding != bIsActive) {
                    if (bIsActive) {
                        this.staleCDSince = -1L;
                        this.staleCDOffset = 0L;
                    } else {
                        this.staleCDSince = System.currentTimeMillis();
                    }
                }
            } else {
                this.lCDActivelyChangedOn = -1L;
            }
        }
        if (this.bActivelySeeding != bIsActive) {
            this.bActivelySeeding = bIsActive;
            if (this.rules != null) {
                this.rules.requestProcessCycle(null);
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: ActivelySeeding changed");
                }
            }
        }
        return this.bActivelySeeding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int recalcSeedingRank() {
        int n;
        block48: {
            int n2;
            block47: {
                int n3;
                block46: {
                    int n4;
                    block45: {
                        int ratio22;
                        block44: {
                            int ratio22;
                            block43: {
                                int n5;
                                block42: {
                                    int n6;
                                    block41: {
                                        int n7;
                                        block40: {
                                            int n8;
                                            block39: {
                                                try {
                                                    int newSR;
                                                    int oldSR;
                                                    block55: {
                                                        block53: {
                                                            block56: {
                                                                block54: {
                                                                    boolean bScrapeResultsOk;
                                                                    block49: {
                                                                        block50: {
                                                                            block52: {
                                                                                long lMsElapsed;
                                                                                block51: {
                                                                                    this.downloadData_this_mon.enter();
                                                                                    this.sExplainSR = "";
                                                                                    oldSR = this.dl.getSeedingRank();
                                                                                    DownloadStats stats2 = this.dl.getStats();
                                                                                    newSR = 0;
                                                                                    if (!this.dl.isComplete()) {
                                                                                        newSR = 1000000000 + (10000 - this.dl.getPosition());
                                                                                        this.dl.setSeedingRank(newSR);
                                                                                        this.isFirstPriority();
                                                                                        if (this.rules.bDebugLog) {
                                                                                            this.sExplainSR = this.sExplainSR + "  not complete. SetSR " + newSR + "\n";
                                                                                        }
                                                                                        int n9 = newSR;
                                                                                        Object var10_6 = null;
                                                                                        this.downloadData_this_mon.exit();
                                                                                        return n9;
                                                                                    }
                                                                                    this.lastModifiedShareRatio = stats2.getShareRatio();
                                                                                    this.lastModifiedScrapeResultPeers = this.rules.calcPeersNoUs(this.dl);
                                                                                    this.lastModifiedScrapeResultSeeds = this.rules.calcSeedsNoUs(this.dl);
                                                                                    boolean bl = bScrapeResultsOk = (this.lastModifiedScrapeResultPeers > 0 || this.lastModifiedScrapeResultSeeds > 0 || this.lastScrapeResultOk) && this.lastModifiedScrapeResultPeers >= 0 && this.lastModifiedScrapeResultSeeds >= 0;
                                                                                    if (!this.isFirstPriority()) {
                                                                                        float ratio22;
                                                                                        if (!(iIgnoreShareRatio == 0 || this.lastModifiedShareRatio < iIgnoreShareRatio || this.lastModifiedScrapeResultSeeds < iIgnoreShareRatio_SeedStart && bScrapeResultsOk || this.lastModifiedShareRatio == -1)) {
                                                                                            if (this.rules.bDebugLog) {
                                                                                                this.sExplainSR = this.sExplainSR + "  shareratio met: shareRatio(" + this.lastModifiedShareRatio + ") >= " + iIgnoreShareRatio + "\n";
                                                                                            }
                                                                                            this.dl.setSeedingRank(-8);
                                                                                            n8 = -8;
                                                                                            break block39;
                                                                                        }
                                                                                        if (this.rules.bDebugLog && iIgnoreShareRatio != 0 && this.lastModifiedShareRatio >= iIgnoreShareRatio) {
                                                                                            this.sExplainSR = this.sExplainSR + "  shareratio NOT met: ";
                                                                                            if (this.lastModifiedScrapeResultSeeds >= iIgnoreShareRatio_SeedStart) {
                                                                                                this.sExplainSR = this.sExplainSR + this.lastModifiedScrapeResultSeeds + " below seed threshold of " + iIgnoreShareRatio_SeedStart;
                                                                                            }
                                                                                            this.sExplainSR = this.sExplainSR + "\n";
                                                                                        }
                                                                                        if (this.lastModifiedScrapeResultPeers == 0 && bScrapeResultsOk) {
                                                                                            if (bIgnore0Peers) {
                                                                                                if (this.rules.bDebugLog) {
                                                                                                    this.sExplainSR = this.sExplainSR + "  Ignore 0 Peers criteria met\n";
                                                                                                }
                                                                                                this.dl.setSeedingRank(-7);
                                                                                                n7 = -7;
                                                                                                break block40;
                                                                                            }
                                                                                        } else if (this.rules.bDebugLog && this.lastModifiedScrapeResultPeers == 0) {
                                                                                            this.sExplainSR = this.sExplainSR + "  0 Peer Ignore rule NOT applied: Scrape invalid\n";
                                                                                        }
                                                                                        if (iIgnoreSeedCount != 0 && this.lastModifiedScrapeResultSeeds >= iIgnoreSeedCount) {
                                                                                            if (this.rules.bDebugLog) {
                                                                                                this.sExplainSR = this.sExplainSR + "  SeedCount Ignore rule met.  numSeeds(" + this.lastModifiedScrapeResultSeeds + " >= iIgnoreSeedCount(" + iIgnoreSeedCount + ")\n";
                                                                                            }
                                                                                            this.dl.setSeedingRank(-5);
                                                                                            n6 = -5;
                                                                                            break block41;
                                                                                        }
                                                                                        if (iIgnoreRatioPeers != 0 && this.lastModifiedScrapeResultSeeds != 0 && (ratio22 = (float)this.lastModifiedScrapeResultPeers / (float)this.lastModifiedScrapeResultSeeds) <= (float)iIgnoreRatioPeers && this.lastModifiedScrapeResultSeeds >= iIgnoreRatioPeers_SeedStart) {
                                                                                            if (this.rules.bDebugLog) {
                                                                                                this.sExplainSR = this.sExplainSR + "  P:S Ignore rule met.  ratio(" + ratio22 + " <= threshold(" + iIgnoreRatioPeers_SeedStart + ")\n";
                                                                                            }
                                                                                            this.dl.setSeedingRank(-4);
                                                                                            n5 = -4;
                                                                                            break block42;
                                                                                        }
                                                                                    }
                                                                                    if (iRankType == 0) {
                                                                                        if (this.rules.bDebugLog) {
                                                                                            this.sExplainSR = this.sExplainSR + "  Ranking Type set to none.. blanking seeding rank\n";
                                                                                        }
                                                                                        this.dl.setSeedingRank(newSR);
                                                                                        ratio22 = newSR;
                                                                                        break block43;
                                                                                    }
                                                                                    if (iRankType != 3) break block49;
                                                                                    if (this.bIsFirstPriority) {
                                                                                        this.dl.setSeedingRank(newSR += 1000000);
                                                                                        ratio22 = newSR;
                                                                                        break block44;
                                                                                    }
                                                                                    int state = this.dl.getState();
                                                                                    if (state == 6 || state == 7 || state == 8) {
                                                                                        if (this.rules.bDebugLog) {
                                                                                            this.sExplainSR = this.sExplainSR + "  Download stopping, stopped or in error\n";
                                                                                        }
                                                                                        this.dl.setSeedingRank(-2);
                                                                                        n4 = -2;
                                                                                        break block45;
                                                                                    }
                                                                                    if (state != 5 && state != 3 && state != 1 && state != 2) break block50;
                                                                                    lMsElapsed = 0L;
                                                                                    if (state == 5 && !this.dl.isForceStart()) {
                                                                                        lMsElapsed = SystemTime.getCurrentTime() - stats2.getTimeStartedSeeding();
                                                                                    }
                                                                                    if (lMsElapsed < minTimeAlive) break block51;
                                                                                    this.dl.setSeedingRank(1);
                                                                                    if (oldSR > 999999) {
                                                                                        this.rules.requestProcessCycle(null);
                                                                                        if (this.rules.bDebugLog) {
                                                                                            this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: TimeUp");
                                                                                        }
                                                                                    }
                                                                                    break block52;
                                                                                }
                                                                                newSR = 1000000 + (int)(lMsElapsed / 1000L);
                                                                                this.dl.setSeedingRank(newSR);
                                                                                if (oldSR <= 999999) {
                                                                                    this.rules.requestProcessCycle(null);
                                                                                    if (this.rules.bDebugLog) {
                                                                                        this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: strange timer change");
                                                                                    }
                                                                                }
                                                                            }
                                                                            n3 = newSR;
                                                                            break block46;
                                                                        }
                                                                        if (oldSR <= 0) {
                                                                            newSR = 999999 - this.dl.getPosition();
                                                                            this.dl.setSeedingRank(newSR);
                                                                            this.rules.requestProcessCycle(null);
                                                                            if (this.rules.bDebugLog) {
                                                                                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: NotIgnored");
                                                                            }
                                                                        }
                                                                        n2 = newSR;
                                                                        break block47;
                                                                    }
                                                                    if (!bScrapeResultsOk) break block53;
                                                                    if (iRankType != 4) break block54;
                                                                    newSR = this.lastModifiedScrapeResultPeers > this.lastModifiedScrapeResultSeeds * 10 ? 100 * this.lastModifiedScrapeResultPeers * 10 : (int)(100L * (long)this.lastModifiedScrapeResultPeers * (long)this.lastModifiedScrapeResultPeers / (long)(this.lastModifiedScrapeResultSeeds + 1));
                                                                    break block55;
                                                                }
                                                                if (iRankType != 2 || iRankTypeSeedFallback != 0 && iRankTypeSeedFallback <= this.lastModifiedScrapeResultSeeds) break block56;
                                                                newSR = this.lastModifiedScrapeResultSeeds < 10000 ? 10000 - this.lastModifiedScrapeResultSeeds : 1;
                                                                newSR *= SEEDONLY_SHIFT;
                                                                break block55;
                                                            }
                                                            if (this.lastModifiedScrapeResultPeers == 0) break block55;
                                                            if (this.lastModifiedScrapeResultSeeds == 0) {
                                                                if (this.lastModifiedScrapeResultPeers >= minPeersToBoostNoSeeds) {
                                                                    newSR += SPRATIO_BASE_LIMIT;
                                                                }
                                                                break block55;
                                                            } else {
                                                                float x = (float)this.lastModifiedScrapeResultSeeds / (float)this.lastModifiedScrapeResultPeers;
                                                                newSR = (int)((float)newSR + (float)SPRATIO_BASE_LIMIT / ((x + 1.0f) * (x + 1.0f)));
                                                            }
                                                            break block55;
                                                        }
                                                        if (this.rules.bDebugLog) {
                                                            this.sExplainSR = this.sExplainSR + "  Can't calculate SR, no scrape results\n";
                                                        }
                                                    }
                                                    if (this.staleCDOffset > 0L) {
                                                        if ((long)newSR > this.staleCDOffset) {
                                                            newSR = (int)((long)newSR - this.staleCDOffset);
                                                            this.sExplainSR = this.sExplainSR + "  subtracted " + this.staleCDOffset + " due to non-activeness\n";
                                                        } else {
                                                            this.staleCDOffset = 0L;
                                                        }
                                                    }
                                                    if (newSR < 0) {
                                                        newSR = 1;
                                                    }
                                                    if (newSR != oldSR) {
                                                        this.dl.setSeedingRank(newSR);
                                                    }
                                                    n = newSR;
                                                    break block48;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var10_17 = null;
                                                    this.downloadData_this_mon.exit();
                                                    throw throwable;
                                                }
                                            }
                                            Object var10_7 = null;
                                            this.downloadData_this_mon.exit();
                                            return n8;
                                        }
                                        Object var10_8 = null;
                                        this.downloadData_this_mon.exit();
                                        return n7;
                                    }
                                    Object var10_9 = null;
                                    this.downloadData_this_mon.exit();
                                    return n6;
                                }
                                Object var10_10 = null;
                                this.downloadData_this_mon.exit();
                                return n5;
                            }
                            Object var10_11 = null;
                            this.downloadData_this_mon.exit();
                            return ratio22;
                        }
                        Object var10_12 = null;
                        this.downloadData_this_mon.exit();
                        return ratio22;
                    }
                    Object var10_13 = null;
                    this.downloadData_this_mon.exit();
                    return n4;
                }
                Object var10_14 = null;
                this.downloadData_this_mon.exit();
                return n3;
            }
            Object var10_15 = null;
            this.downloadData_this_mon.exit();
            return n2;
        }
        Object var10_16 = null;
        this.downloadData_this_mon.exit();
        return n;
    }

    public boolean isFirstPriority() {
        boolean bFP = this.pisFirstPriority();
        if (this.bIsFirstPriority != bFP) {
            this.bIsFirstPriority = bFP;
            this.rules.requestProcessCycle(null);
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: FP changed");
            }
        }
        return this.bIsFirstPriority;
    }

    private boolean pisFirstPriority() {
        int shareRatio;
        boolean bLastMatched;
        if (this.rules.bDebugLog) {
            this.sExplainFP = "FP if " + (iFirstPriorityType == 0 ? "all" : "any") + " criteria match:\n";
        }
        if (!this.dl.isPersistent()) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: Download not persistent\n";
            }
            return false;
        }
        int state = this.dl.getState();
        if (state == 8 || state == 7) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: Download is ERROR or STOPPED\n";
            }
            return false;
        }
        if (!this.dl.isComplete()) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: Download not complete\n";
            }
            return false;
        }
        List listeners = this.rules.getFPListeners();
        StringBuffer fp_listener_debug = null;
        if (!listeners.isEmpty()) {
            if (this.rules.bDebugLog) {
                fp_listener_debug = new StringBuffer();
            }
            for (StartStopRulesFPListener l : listeners) {
                boolean result = l.isFirstPriority(this.dl, this.lastModifiedScrapeResultSeeds, this.lastModifiedScrapeResultPeers, fp_listener_debug);
                if (fp_listener_debug != null && fp_listener_debug.length() > 0) {
                    char last_ch = fp_listener_debug.charAt(fp_listener_debug.length() - 1);
                    if (last_ch != '\n') {
                        fp_listener_debug.append('\n');
                    }
                    this.sExplainFP = this.sExplainFP + fp_listener_debug;
                    fp_listener_debug.setLength(0);
                }
                if (!result) continue;
                return true;
            }
        }
        if (this.lastModifiedScrapeResultPeers > 0 && this.lastModifiedScrapeResultSeeds > 0 && this.lastModifiedScrapeResultSeeds / this.lastModifiedScrapeResultPeers >= iFirstPriorityIgnoreSPRatio && iFirstPriorityIgnoreSPRatio != 0) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: S:P >= " + iFirstPriorityIgnoreSPRatio + ":1\n";
            }
            return false;
        }
        if (this.lastModifiedScrapeResultPeers == 0 && this.lastScrapeResultOk && bFirstPriorityIgnore0Peer) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: 0 peers\n";
            }
            return false;
        }
        if (iFirstPriorityIgnoreIdleHours > 0) {
            long lastUploadSecs = this.dl.getStats().getSecondsSinceLastUpload();
            if (lastUploadSecs < 0L) {
                lastUploadSecs = this.dl.getStats().getSecondsOnlySeeding();
            }
            if (lastUploadSecs > (long)(3600 * iFirstPriorityIgnoreIdleHours)) {
                if (this.rules.bDebugLog) {
                    this.sExplainFP = this.sExplainFP + "Not FP: " + lastUploadSecs + "s > " + iFirstPriorityIgnoreIdleHours + "h of no upload\n";
                }
                return false;
            }
        }
        boolean bl = bLastMatched = (shareRatio = this.dl.getStats().getShareRatio()) != -1 && shareRatio < minQueueingShareRatio;
        if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "  shareRatio(" + shareRatio + ") < " + minQueueingShareRatio + "=" + bLastMatched + "\n";
        }
        if (!bLastMatched && iFirstPriorityType == 0) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "..Not FP.  Exit Early\n";
            }
            return false;
        }
        if (bLastMatched && iFirstPriorityType == 1) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "..Is FP.  Exit Early\n";
            }
            return true;
        }
        boolean bl2 = bLastMatched = iFirstPrioritySeedingMinutes == 0;
        if (!bLastMatched) {
            long timeSeeding = this.dl.getStats().getSecondsOnlySeeding();
            if (timeSeeding >= 0L) {
                boolean bl3 = bLastMatched = timeSeeding < (long)(iFirstPrioritySeedingMinutes * 60);
                if (this.rules.bDebugLog) {
                    this.sExplainFP = this.sExplainFP + "  SeedingTime(" + timeSeeding + ") < " + iFirstPrioritySeedingMinutes * 60 + "=" + bLastMatched + "\n";
                }
                if (!bLastMatched && iFirstPriorityType == 0) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Not FP.  Exit Early\n";
                    }
                    return false;
                }
                if (bLastMatched && iFirstPriorityType == 1) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Is FP.  Exit Early\n";
                    }
                    return true;
                }
            }
        } else if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "  Skipping Seeding Time check (user disabled)\n";
        }
        boolean bl4 = bLastMatched = iFirstPriorityActiveMinutes == 0;
        if (!bLastMatched) {
            long timeActive = this.dl.getStats().getSecondsDownloading() + this.dl.getStats().getSecondsOnlySeeding();
            if (timeActive >= 0L) {
                boolean bl5 = bLastMatched = timeActive < (long)(iFirstPriorityActiveMinutes * 60);
                if (this.rules.bDebugLog) {
                    this.sExplainFP = this.sExplainFP + "  ActiveTime(" + timeActive + ") < " + iFirstPriorityActiveMinutes * 60 + "=" + bLastMatched + "\n";
                }
                if (!bLastMatched && iFirstPriorityType == 0) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Not FP.  Exit Early\n";
                    }
                    return false;
                }
                if (bLastMatched && iFirstPriorityType == 1) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Is FP.  Exit Early\n";
                    }
                    return true;
                }
            }
        } else if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "  Skipping DL Time check (user disabled)\n";
        }
        if (iFirstPriorityType == 0) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "..Is FP\n";
            }
            return true;
        }
        if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "..Not FP\n";
        }
        return false;
    }

    public boolean getCachedIsFP() {
        return this.bIsFirstPriority;
    }

    public String toString() {
        return String.valueOf(this.dl.getSeedingRank());
    }

    public boolean changeChecker() {
        long now;
        if (this.getActivelySeeding()) {
            int shareRatio = this.dl.getStats().getShareRatio();
            int numSeeds = this.rules.calcSeedsNoUs(this.dl);
            if (!(iIgnoreShareRatio == 0 || shareRatio < iIgnoreShareRatio || numSeeds < iIgnoreShareRatio_SeedStart && this.lastScrapeResultOk || shareRatio == -1)) {
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: shareRatio changeChecker");
                }
                return true;
            }
        }
        if (this.dl.getState() == 3) {
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: Download is ready");
            }
            return true;
        }
        if (this.staleCDSince > 0L && (now = SystemTime.getCurrentTime()) - this.lastStaleCDRefresh > 60000L) {
            this.staleCDOffset += (now - this.lastStaleCDRefresh) / 60000L;
            this.lastStaleCDRefresh = now;
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: staleCD changeChecker");
            }
            return true;
        }
        return false;
    }
}

