/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.core.util.Java15Utils;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.Debug;

public class ExternalSeedHTTPDownloaderRange
implements ExternalSeedHTTPDownloader,
SEPasswordListener {
    public static final String NL = "\r\n";
    private URL original_url;
    private String user_agent;
    private URL redirected_url;
    private int consec_redirect_fails;
    private int last_response;
    private int last_response_retry_after_secs;

    public ExternalSeedHTTPDownloaderRange(URL _url, String _user_agent) {
        this.original_url = _url;
        this.user_agent = _user_agent;
    }

    public URL getURL() {
        return this.original_url;
    }

    public void download(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        this.download(new String[0], new String[0], length, listener, con_fail_is_perm_fail);
    }

    public void downloadRange(long offset, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        this.download(new String[]{"Range"}, new String[]{"bytes=" + offset + "-" + (offset + (long)length - 1L)}, length, listener, con_fail_is_perm_fail);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void download(String[] prop_names, String[] prop_values, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        boolean connected = false;
        InputStream is = null;
        String outcome = "";
        try {
            try {
                int pos;
                int len;
                int response;
                HttpURLConnection connection;
                SESecurityManager.setThreadPasswordHandler(this);
                while (true) {
                    URL target = this.redirected_url == null ? this.original_url : this.redirected_url;
                    connection = (HttpURLConnection)target.openConnection();
                    connection.setRequestProperty("Connection", "Keep-Alive");
                    connection.setRequestProperty("User-Agent", this.user_agent);
                    for (int i = 0; i < prop_names.length; ++i) {
                        connection.setRequestProperty(prop_names[i], prop_values[i]);
                    }
                    int time_remaining = listener.getPermittedTime();
                    if (time_remaining > 0) {
                        Java15Utils.setConnectTimeout(connection, time_remaining);
                    }
                    connection.connect();
                    time_remaining = listener.getPermittedTime();
                    if (time_remaining < 0) {
                        throw new IOException("Timeout during connect");
                    }
                    Java15Utils.setReadTimeout(connection, time_remaining);
                    connected = true;
                    response = connection.getResponseCode();
                    if (response == 202 || response == 200 || response == 206) {
                        if (this.redirected_url == null) break;
                        this.consec_redirect_fails = 0;
                        break;
                    }
                    if (this.redirected_url == null) break;
                    ++this.consec_redirect_fails;
                    this.redirected_url = null;
                }
                URL final_url = connection.getURL();
                if (this.consec_redirect_fails < 10 && !this.original_url.toExternalForm().equals(final_url.toExternalForm())) {
                    this.redirected_url = final_url;
                }
                this.last_response = response;
                this.last_response_retry_after_secs = -1;
                if (response == 503) {
                    long retry_after_date = new Long(connection.getHeaderFieldDate("Retry-After", -1L));
                    if (retry_after_date <= -1L) {
                        this.last_response_retry_after_secs = connection.getHeaderFieldInt("Retry-After", -1);
                    } else {
                        this.last_response_retry_after_secs = (int)((retry_after_date - System.currentTimeMillis()) / 1000L);
                        if (this.last_response_retry_after_secs < 0) {
                            this.last_response_retry_after_secs = -1;
                        }
                    }
                }
                is = connection.getInputStream();
                if (response != 202 && response != 200 && response != 206) {
                    outcome = "Connection failed: " + connection.getResponseMessage();
                    ExternalSeedException error = new ExternalSeedException(outcome);
                    error.setPermanentFailure(true);
                    throw error;
                }
                byte[] buffer = null;
                int buffer_pos = 0;
                int buffer_len = 0;
                for (pos = 0; pos < length; pos += len) {
                    if (buffer == null) {
                        buffer = listener.getBuffer();
                        buffer_pos = listener.getBufferPosition();
                        buffer_len = listener.getBufferLength();
                    }
                    listener.setBufferPosition(buffer_pos);
                    int to_read = buffer_len - buffer_pos;
                    int permitted = listener.getPermittedBytes();
                    if (permitted < to_read) {
                        to_read = permitted;
                    }
                    if ((len = is.read(buffer, buffer_pos, to_read)) < 0) break;
                    listener.reportBytesRead(len);
                    if ((buffer_pos += len) != buffer_len) continue;
                    listener.done();
                    buffer = null;
                    buffer_pos = 0;
                }
                if (pos != length) {
                    String log_str;
                    if (buffer == null) {
                        log_str = "No buffer assigned";
                    } else {
                        log_str = new String(buffer, 0, length);
                        if (log_str.length() > 64) {
                            log_str = log_str.substring(0, 64);
                        }
                    }
                    outcome = "Connection failed: data too short - " + length + "/" + pos + " [" + log_str + "]";
                    throw new ExternalSeedException(outcome);
                }
                outcome = "read " + pos + " bytes";
                Object var20_28 = null;
            }
            catch (IOException e) {
                if (con_fail_is_perm_fail && !connected) {
                    outcome = "Connection failed: " + e.getMessage();
                    ExternalSeedException error = new ExternalSeedException(outcome);
                    error.setPermanentFailure(true);
                    throw error;
                }
                outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                if (this.last_response_retry_after_secs >= 0) {
                    outcome = outcome + ", Retry-After: " + this.last_response_retry_after_secs + " seconds";
                }
                ExternalSeedException excep = new ExternalSeedException(outcome, e);
                if (!(e instanceof FileNotFoundException)) throw excep;
                excep.setPermanentFailure(true);
                throw excep;
            }
            catch (Throwable e) {
                if (e instanceof ExternalSeedException) {
                    throw (ExternalSeedException)e;
                }
                outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                throw new ExternalSeedException("Connection failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var20_29 = null;
            SESecurityManager.unsetThreadPasswordHandler();
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        SESecurityManager.unsetThreadPasswordHandler();
        if (is == null) return;
        try {}
        catch (Throwable e) {}
        is.close();
        return;
    }

    public void downloadSocket(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        this.downloadSocket(new String[0], new String[0], length, listener, con_fail_is_perm_fail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void downloadSocket(String[] prop_names, String[] prop_values, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        int pos;
        int len;
        int buffer_len;
        int buffer_pos;
        byte[] buffer2;
        InputStream is;
        Socket socket;
        block27: {
            socket = null;
            boolean connected = false;
            try {
                try {
                    String output_header = "GET " + this.original_url.getPath() + "?" + this.original_url.getQuery() + " HTTP/1.1" + NL + "Host: " + this.original_url.getHost() + (this.original_url.getPort() == -1 ? "" : ":" + this.original_url.getPort()) + NL + "Accept: */*" + NL + "Connection: Close" + NL + "User-Agent: " + this.user_agent + NL;
                    for (int i = 0; i < prop_names.length; ++i) {
                        output_header = output_header + prop_names[i] + ":" + prop_values[i] + NL;
                    }
                    output_header = output_header + NL;
                    int time_remaining = listener.getPermittedTime();
                    if (time_remaining > 0) {
                        socket = new Socket();
                        socket.connect(new InetSocketAddress(this.original_url.getHost(), this.original_url.getPort() == -1 ? this.original_url.getDefaultPort() : this.original_url.getPort()), time_remaining);
                    } else {
                        socket = new Socket(this.original_url.getHost(), this.original_url.getPort() == -1 ? this.original_url.getDefaultPort() : this.original_url.getPort());
                    }
                    connected = true;
                    time_remaining = listener.getPermittedTime();
                    if (time_remaining < 0) {
                        throw new IOException("Timeout during connect");
                    }
                    if (time_remaining > 0) {
                        socket.setSoTimeout(time_remaining);
                    }
                    OutputStream os = socket.getOutputStream();
                    os.write(output_header.getBytes("ISO-8859-1"));
                    os.flush();
                    is = socket.getInputStream();
                    try {
                        int response;
                        byte[] buffer;
                        String input_header = "";
                        do {
                            int len2;
                            if ((len2 = is.read(buffer = new byte[1])) >= 0) continue;
                            throw new IOException("input too short reading header");
                        } while (!(input_header = input_header + (char)buffer[0]).endsWith("\r\n\r\n"));
                        int line_end = input_header.indexOf(NL);
                        if (line_end == -1) {
                            throw new IOException("header too short");
                        }
                        String first_line = input_header.substring(0, line_end);
                        StringTokenizer tok = new StringTokenizer(first_line, " ");
                        tok.nextToken();
                        this.last_response = response = Integer.parseInt(tok.nextToken());
                        this.last_response_retry_after_secs = -1;
                        String response_str = tok.nextToken();
                        if (response == 202 || response == 200 || response == 206) {
                            buffer2 = null;
                            buffer_pos = 0;
                            buffer_len = 0;
                            break block27;
                        }
                        if (response != 503) {
                            ExternalSeedException error = new ExternalSeedException("Connection failed: " + response_str);
                            error.setPermanentFailure(true);
                            throw error;
                        }
                        String data_str = "";
                        while (true) {
                            byte[] buffer3;
                            int len3;
                            if ((len3 = is.read(buffer3 = new byte[1])) < 0) {
                                this.last_response_retry_after_secs = Integer.parseInt(data_str);
                                throw new IOException("Server overloaded");
                            }
                            data_str = data_str + (char)buffer3[0];
                        }
                    }
                    catch (Throwable throwable) {
                        Object var26_37 = null;
                        is.close();
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (con_fail_is_perm_fail && !connected) {
                        ExternalSeedException error = new ExternalSeedException("Connection failed: " + e.getMessage());
                        error.setPermanentFailure(true);
                        throw error;
                    }
                    String outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                    if (this.last_response_retry_after_secs < 0) throw new ExternalSeedException(outcome, e);
                    outcome = outcome + ", Retry-After: " + this.last_response_retry_after_secs + " seconds";
                    throw new ExternalSeedException(outcome, e);
                }
                catch (Throwable e) {
                    if (!(e instanceof ExternalSeedException)) throw new ExternalSeedException("Connection failed", e);
                    throw (ExternalSeedException)e;
                }
            }
            catch (Throwable throwable) {
                Object var28_40 = null;
                if (socket == null) throw throwable;
                try {
                    socket.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        for (pos = 0; pos < length; pos += len) {
            if (buffer2 == null) {
                buffer2 = listener.getBuffer();
                buffer_pos = listener.getBufferPosition();
                buffer_len = listener.getBufferLength();
            }
            int to_read = buffer_len - buffer_pos;
            int permitted = listener.getPermittedBytes();
            if (permitted < to_read) {
                to_read = permitted;
            }
            if ((len = is.read(buffer2, buffer_pos, to_read)) < 0) break;
            listener.reportBytesRead(len);
            if ((buffer_pos += len) != buffer_len) continue;
            listener.done();
            buffer2 = null;
            buffer_pos = 0;
        }
        if (pos != length) {
            String log_str;
            if (buffer2 == null) {
                log_str = "No buffer assigned";
                throw new ExternalSeedException("Connection failed: data too short - " + length + "/" + pos + " [last=" + log_str + "]");
            }
            log_str = new String(buffer2, 0, buffer_pos > 64 ? 64 : buffer_pos);
            throw new ExternalSeedException("Connection failed: data too short - " + length + "/" + pos + " [last=" + log_str + "]");
        }
        Object var26_36 = null;
        is.close();
        Object var28_39 = null;
        if (socket == null) return;
        try {}
        catch (Throwable e) {
            return;
        }
        socket.close();
    }

    public void deactivate() {
    }

    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        return null;
    }

    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }

    public void clearPasswords() {
    }

    public int getLastResponse() {
        return this.last_response;
    }

    public int getLast503RetrySecs() {
        return this.last_response_retry_after_secs;
    }

    public static void main(String[] args) {
        try {
            String url_str = "";
            ExternalSeedHTTPDownloaderRange downloader = new ExternalSeedHTTPDownloaderRange(new URL(url_str), "Azureus");
            downloader.downloadRange(0L, 1, new ExternalSeedHTTPDownloaderListener(){
                private int position;

                public byte[] getBuffer() throws ExternalSeedException {
                    return new byte[1024];
                }

                public void setBufferPosition(int _position) {
                    this.position = _position;
                }

                public int getBufferPosition() {
                    return this.position;
                }

                public int getBufferLength() {
                    return 1024;
                }

                public int getPermittedBytes() throws ExternalSeedException {
                    return 1024;
                }

                public int getPermittedTime() {
                    return Integer.MAX_VALUE;
                }

                public void reportBytesRead(int num) {
                    System.out.println("read " + num);
                }

                public boolean isCancelled() {
                    return false;
                }

                public void done() {
                    System.out.println("done");
                }
            }, true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

