/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import com.aelitis.azureus.plugins.extseed.ExternalSeedManualPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderFactory;
import com.aelitis.azureus.plugins.extseed.impl.getright.ExternalSeedReaderFactoryGetRight;
import com.aelitis.azureus.plugins.extseed.impl.webseed.ExternalSeedReaderFactoryWebSeed;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadManagerStats;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.components.UITextField;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.plugins.utils.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalSeedPlugin
implements Plugin,
DownloadManagerListener {
    private static ExternalSeedReaderFactory[] factories = new ExternalSeedReaderFactory[]{new ExternalSeedReaderFactoryGetRight(), new ExternalSeedReaderFactoryWebSeed()};
    private PluginInterface plugin_interface;
    private DownloadManagerStats dm_stats;
    private UITextField status_field;
    private LoggerChannel log;
    private Random random = new Random();
    private Map download_map = new HashMap();
    private Monitor download_mon;

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", "External Seed");
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.dm_stats = this.plugin_interface.getDownloadManager().getStats();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel("External Seeds");
        final BasicPluginViewModel view_model = this.plugin_interface.getUIManager().createBasicPluginViewModel("Plugin.extseed.name");
        view_model.getActivity().setVisible(false);
        view_model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                view_model.getLogArea().appendText(content + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                if (str.length() > 0) {
                    view_model.getLogArea().appendText(str + "\n");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                pw.flush();
                view_model.getLogArea().appendText(sw.toString() + "\n");
            }
        });
        this.status_field = view_model.getStatus();
        this.setStatus("Initialising");
        this.download_mon = this.plugin_interface.getUtilities().getMonitor();
        Utilities utilities = this.plugin_interface.getUtilities();
        DelayedTask dt = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            public void run() {
                AEThread2 t = new AEThread2("ExternalSeedInitialise", true){

                    public void run() {
                        ExternalSeedPlugin.this.setStatus("Running");
                        ExternalSeedPlugin.this.plugin_interface.getDownloadManager().addListener(ExternalSeedPlugin.this);
                    }
                };
                t.setPriority(1);
                t.start();
            }
        });
        dt.queue();
        UTTimer timer = utilities.createTimer("ExternalPeerScheduler", true);
        timer.addPeriodicEvent(5000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent event2) {
                try {
                    Iterator it = ExternalSeedPlugin.this.download_map.values().iterator();
                    while (it.hasNext()) {
                        List peers = ExternalSeedPlugin.this.randomiseList((List)it.next());
                        for (int i = 0; i < peers.size() && !((ExternalSeedPeer)peers.get(i)).checkConnection(); ++i) {
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void downloadAdded(Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent == null) {
            return;
        }
        ArrayList<ExternalSeedPeer> peers = new ArrayList<ExternalSeedPeer>();
        for (int i = 0; i < factories.length; ++i) {
            String attributeID = "no-ext-seeds-" + factories[i].getClass().getSimpleName();
            TorrentAttribute attribute = this.plugin_interface.getTorrentManager().getPluginAttribute(attributeID);
            boolean noExternalSeeds = download.getBooleanAttribute(attribute);
            if (noExternalSeeds) continue;
            ExternalSeedReader[] x = factories[i].getSeedReaders(this, download);
            if (x.length == 0) {
                download.setBooleanAttribute(attribute, true);
                continue;
            }
            for (int j = 0; j < x.length; ++j) {
                ExternalSeedReader reader = x[j];
                ExternalSeedPeer peer = new ExternalSeedPeer(this, download, reader);
                peers.add(peer);
            }
        }
        this.addPeers(download, peers);
    }

    public void downloadChanged(Download download) {
        this.downloadRemoved(download);
        this.downloadAdded(download);
    }

    public List<ExternalSeedPeer> addSeed(Download download, Map config) {
        Torrent torrent = download.getTorrent();
        ArrayList<ExternalSeedPeer> peers = new ArrayList<ExternalSeedPeer>();
        if (torrent != null) {
            for (int i = 0; i < factories.length; ++i) {
                String attributeID = "no-ext-seeds-" + factories[i].getClass().getSimpleName();
                TorrentAttribute attribute = this.plugin_interface.getTorrentManager().getPluginAttribute(attributeID);
                ExternalSeedReader[] x = factories[i].getSeedReaders(this, download, config);
                download.setBooleanAttribute(attribute, x.length == 0);
                for (int j = 0; j < x.length; ++j) {
                    ExternalSeedReader reader = x[j];
                    ExternalSeedPeer peer = new ExternalSeedPeer(this, download, reader);
                    peers.add(peer);
                }
            }
            this.addPeers(download, peers);
        }
        return peers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeers(final Download download, List _peers) {
        ArrayList peers = new ArrayList();
        peers.addAll(_peers);
        if (peers.size() > 0) {
            ExternalSeedPeer peer;
            boolean add_listener = false;
            try {
                this.download_mon.enter();
                ArrayList<ExternalSeedPeer> existing_peers = (ArrayList<ExternalSeedPeer>)this.download_map.get(download);
                if (existing_peers == null) {
                    add_listener = true;
                    existing_peers = new ArrayList<ExternalSeedPeer>();
                    this.download_map.put(download, existing_peers);
                }
                Iterator it = peers.iterator();
                while (it.hasNext()) {
                    peer = (ExternalSeedPeer)it.next();
                    boolean skip = false;
                    for (int j = 0; j < existing_peers.size(); ++j) {
                        ExternalSeedPeer existing_peer = (ExternalSeedPeer)existing_peers.get(j);
                        if (!existing_peer.sameAs(peer)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) {
                        it.remove();
                        continue;
                    }
                    this.log(download.getName() + " found seed " + peer.getName());
                    existing_peers.add(peer);
                }
                this.setStatus("Running: Downloads with external seeds = " + this.download_map.size());
                Object var12_12 = null;
                this.download_mon.exit();
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this.download_mon.exit();
                throw throwable;
            }
            if (add_listener) {
                download.addPeerListener(new DownloadPeerListener(){

                    public void peerManagerAdded(Download download2, PeerManager peer_manager) {
                        List existing_peers = this.getPeers();
                        if (existing_peers == null) {
                            return;
                        }
                        for (int i = 0; i < existing_peers.size(); ++i) {
                            ExternalSeedPeer peer = (ExternalSeedPeer)existing_peers.get(i);
                            peer.setManager(peer_manager);
                        }
                    }

                    public void peerManagerRemoved(Download download2, PeerManager peer_manager) {
                        List existing_peers = this.getPeers();
                        if (existing_peers == null) {
                            return;
                        }
                        for (int i = 0; i < existing_peers.size(); ++i) {
                            ExternalSeedPeer peer = (ExternalSeedPeer)existing_peers.get(i);
                            peer.setManager(null);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected List getPeers() {
                        ArrayList existing_peers = null;
                        try {
                            ExternalSeedPlugin.this.download_mon.enter();
                            List temp = (List)ExternalSeedPlugin.this.download_map.get(download);
                            if (temp != null) {
                                existing_peers = new ArrayList(temp.size());
                                existing_peers.addAll(temp);
                            }
                            Object var4_3 = null;
                            ExternalSeedPlugin.this.download_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            ExternalSeedPlugin.this.download_mon.exit();
                            throw throwable;
                        }
                        return existing_peers;
                    }
                });
            } else {
                PeerManager existing_pm = download.getPeerManager();
                if (existing_pm != null) {
                    for (int i = 0; i < peers.size(); ++i) {
                        peer = (ExternalSeedPeer)peers.get(i);
                        if (peer.getManager() != null) continue;
                        peer.setManager(existing_pm);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer(ExternalSeedPeer peer) {
        Download download = peer.getDownload();
        try {
            this.download_mon.enter();
            List existing_peers = (List)this.download_map.get(download);
            if (existing_peers != null && existing_peers.remove(peer)) {
                this.log(download.getName() + " removed seed " + peer.getName());
            }
            Object var5_4 = null;
            this.download_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.download_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadRemoved(Download download) {
        try {
            this.download_mon.enter();
            this.download_map.remove(download);
            this.setStatus("Running: Downloads with external seeds = " + this.download_map.size());
            Object var3_2 = null;
            this.download_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.download_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalSeedManualPeer[] getManualWebSeeds(Download download) {
        List peers;
        block4: {
            this.download_mon.enter();
            peers = (List)this.download_map.get(download);
            if (peers != null) break block4;
            ExternalSeedManualPeer[] externalSeedManualPeerArray = new ExternalSeedManualPeer[]{};
            Object var6_5 = null;
            this.download_mon.exit();
            return externalSeedManualPeerArray;
        }
        try {
            ExternalSeedManualPeer[] result = new ExternalSeedManualPeer[peers.size()];
            for (int i = 0; i < peers.size(); ++i) {
                result[i] = new ExternalSeedManualPeer((ExternalSeedPeer)peers.get(i));
            }
            ExternalSeedManualPeer[] externalSeedManualPeerArray = result;
            Object var6_6 = null;
            this.download_mon.exit();
            return externalSeedManualPeerArray;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.download_mon.exit();
            throw throwable;
        }
    }

    public TrackerPeerSource getTrackerPeerSource(final Download download) {
        return new TrackerPeerSourceAdapter(){
            private long fixup_time;
            private ExternalSeedManualPeer[] peers;
            private boolean running;

            public int getType() {
                return 2;
            }

            public int getStatus() {
                this.fixup();
                if (this.running) {
                    return this.peers.length == 0 ? 8 : 7;
                }
                return 2;
            }

            public String getName() {
                this.fixup();
                if (this.peers.length == 0) {
                    return "";
                }
                StringBuffer sb = new StringBuffer();
                for (ExternalSeedManualPeer peer : this.peers) {
                    String str;
                    int pos;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    if ((pos = (str = peer.getDelegate().getURL().toExternalForm()).indexOf(63)) != -1) {
                        str = str.substring(0, pos);
                    }
                    sb.append(str);
                }
                return sb.toString();
            }

            public int getPeers() {
                this.fixup();
                if (this.running) {
                    return this.peers.length;
                }
                return -1;
            }

            protected void fixup() {
                long now = SystemTime.getMonotonousTime();
                if (now - this.fixup_time > 10000L) {
                    this.fixup_time = now;
                    this.peers = ExternalSeedPlugin.this.getManualWebSeeds(download);
                    int state = download.getState();
                    this.running = state == 4 || state == 5;
                }
            }
        };
    }

    public int getGlobalDownloadRateBytesPerSec() {
        return this.dm_stats.getDataAndProtocolReceiveRate();
    }

    protected void setStatus(String str) {
        this.status_field.setText(str);
    }

    public void log(String str) {
        this.log.log(str);
    }

    public void log(String str, Throwable e) {
        this.log.log(str, e);
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected List randomiseList(List l) {
        if (l.size() < 2) {
            return l;
        }
        ArrayList new_list = new ArrayList();
        for (int i = 0; i < l.size(); ++i) {
            new_list.add(this.random.nextInt(new_list.size() + 1), l.get(i));
        }
        return new_list;
    }
}

