/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.dht.impl;

import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginImpl;
import java.net.InetSocketAddress;
import java.util.Map;

public class DHTPluginContactImpl
implements DHTPluginContact {
    private DHTPluginImpl plugin;
    private DHTTransportContact contact;

    protected DHTPluginContactImpl(DHTPluginImpl _plugin, DHTTransportContact _contact) {
        this.plugin = _plugin;
        this.contact = _contact;
    }

    public DHTPluginImpl getDHT() {
        return this.plugin;
    }

    protected DHTTransportContact getContact() {
        return this.contact;
    }

    public String getName() {
        return this.contact.getName();
    }

    public byte getProtocolVersion() {
        return this.contact.getProtocolVersion();
    }

    public InetSocketAddress getAddress() {
        return this.contact.getAddress();
    }

    public boolean isAlive(long timeout) {
        return this.contact.isAlive(timeout);
    }

    public void isAlive(long timeout, final DHTPluginOperationListener listener) {
        this.contact.isAlive(new DHTTransportReplyHandlerAdapter(){

            public void pingReply(DHTTransportContact contact) {
                listener.complete(null, false);
            }

            public void failed(DHTTransportContact contact, Throwable error) {
                listener.complete(null, true);
            }
        }, timeout);
    }

    public boolean isOrHasBeenLocal() {
        return this.plugin.isRecentAddress(this.contact.getAddress().getAddress().getHostAddress());
    }

    public Map openTunnel() {
        DHTNATPuncher puncher = this.plugin.getDHT().getNATPuncher();
        if (puncher == null) {
            return null;
        }
        return puncher.punch("Tunnel", this.contact, null, null);
    }

    public byte[] read(DHTPluginProgressListener listener, byte[] handler_key, byte[] key, long timeout) {
        return this.plugin.read(listener, this, handler_key, key, timeout);
    }
}

