/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.vuzefile;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;

public class VuzeFileHandler {
    private static VuzeFileHandler singleton = new VuzeFileHandler();
    private CopyOnWriteList processors = new CopyOnWriteList();

    public static VuzeFileHandler getSingleton() {
        return singleton;
    }

    protected VuzeFileHandler() {
    }

    public VuzeFile loadVuzeFile(String target) {
        try {
            File test_file = new File(target);
            if (test_file.isFile()) {
                return this.getVuzeFile(new FileInputStream(test_file));
            }
            URL url = new URI(target).toURL();
            String protocol = url.getProtocol().toLowerCase();
            if (protocol.equals("http") || protocol.equals("https")) {
                ResourceDownloader rd = StaticUtilities.getResourceDownloaderFactory().create(url);
                return this.getVuzeFile(rd.download());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public VuzeFile loadVuzeFile(byte[] bytes) {
        return this.loadVuzeFile(new ByteArrayInputStream(bytes));
    }

    public VuzeFile loadVuzeFile(InputStream is) {
        return this.getVuzeFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VuzeFile loadVuzeFile(File file) {
        VuzeFile vuzeFile;
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(file);
                vuzeFile = this.getVuzeFile(is);
                Object var6_5 = null;
                if (is == null) return vuzeFile;
            }
            catch (Throwable e) {
                VuzeFile vuzeFile2 = null;
                Object var6_6 = null;
                if (is == null) return vuzeFile2;
                try {
                    ((InputStream)is).close();
                    return vuzeFile2;
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                return vuzeFile2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (is == null) throw throwable;
            try {}
            catch (Throwable e2) {
                throw throwable;
            }
            ((InputStream)is).close();
            throw throwable;
        }
        try {}
        catch (Throwable e2) {
            // empty catch block
            return vuzeFile;
        }
        ((InputStream)is).close();
        return vuzeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected VuzeFile getVuzeFile(InputStream is) {
        try {
            VuzeFile vuzeFile;
            BufferedInputStream bis = new BufferedInputStream(is);
            try {
                Map map = BDecoder.decode(bis);
                vuzeFile = this.loadVuzeFile(map);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                is.close();
                throw throwable;
            }
            is.close();
            return vuzeFile;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public VuzeFile loadVuzeFile(Map map) {
        if (map.containsKey("vuze") && !map.containsKey("info")) {
            return new VuzeFileImpl(this, (Map)map.get("vuze"));
        }
        return null;
    }

    public VuzeFile loadAndHandleVuzeFile(String target, int expected_types) {
        VuzeFile vf = this.loadVuzeFile(target);
        if (vf == null) {
            return null;
        }
        this.handleFiles(new VuzeFile[]{vf}, expected_types);
        return vf;
    }

    public void handleFiles(VuzeFile[] files, int expected_types) {
        for (VuzeFileProcessor proc : this.processors) {
            try {
                proc.process(files, expected_types);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (int i = 0; i < files.length; ++i) {
            VuzeFile vf = files[i];
            VuzeFileComponent[] comps = vf.getComponents();
            for (int j = 0; j < comps.length; ++j) {
                VuzeFileComponent comp2 = comps[j];
                if (comp2.isProcessed()) continue;
                Debug.out("Failed to handle Vuze file component " + comp2.getContent());
            }
        }
    }

    public VuzeFile create() {
        return new VuzeFileImpl(this);
    }

    public void addProcessor(VuzeFileProcessor proc) {
        this.processors.add(proc);
    }
}

