/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BloomFilterRotator
implements BloomFilter {
    private volatile BloomFilter current_filter;
    private int current_filter_index;
    private final BloomFilter[] filters;

    public BloomFilterRotator(BloomFilter _target, int _num) {
        this.filters = new BloomFilter[_num];
        this.filters[0] = _target;
        for (int i = 1; i < this.filters.length; ++i) {
            this.filters[i] = _target.getReplica();
        }
        this.current_filter = _target;
        this.current_filter_index = 0;
    }

    public BloomFilterRotator(Map<String, Object> x) {
        List list = (List)x.get("list");
        this.filters = new BloomFilter[list.size()];
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i] = BloomFilterImpl.deserialiseFromMap((Map)list.get(i));
        }
        this.current_filter_index = ((Long)x.get("index")).intValue();
        this.current_filter = this.filters[this.current_filter_index];
    }

    @Override
    public Map<String, Object> serialiseToMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        this.serialiseToMap(m);
        return m;
    }

    protected void serialiseToMap(Map<String, Object> x) {
        String cla = this.getClass().getName();
        if (cla.startsWith("com.aelitis.azureus.core.util.bloom.impl")) {
            cla = cla.substring("com.aelitis.azureus.core.util.bloom.impl".length());
        }
        x.put("_impl", cla);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (BloomFilter filter2 : this.filters) {
            list.add(filter2.serialiseToMap());
        }
        x.put("list", list);
        x.put("index", new Long(this.current_filter_index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(byte[] value) {
        BloomFilter[] bloomFilterArray = this.filters;
        synchronized (this.filters) {
            int update_chunk;
            int num_to_update;
            int filter_size = this.current_filter.getSize();
            int filter_entries = this.current_filter.getEntryCount();
            int limit = filter_size / 8;
            if (filter_entries > limit) {
                filter_entries = limit;
            }
            if ((num_to_update = filter_entries / (update_chunk = limit / this.filters.length) + 1) > this.filters.length) {
                num_to_update = this.filters.length;
            }
            int res = 0;
            for (int i = this.current_filter_index; i < this.current_filter_index + num_to_update; ++i) {
                int r = this.filters[i % this.filters.length].add(value);
                if (i != this.current_filter_index) continue;
                res = r;
            }
            if (this.current_filter.getEntryCount() > limit) {
                this.filters[this.current_filter_index] = this.current_filter.getReplica();
                this.current_filter_index = (this.current_filter_index + 1) % this.filters.length;
                this.current_filter = this.filters[this.current_filter_index];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return res;
        }
    }

    @Override
    public int remove(byte[] value) {
        int res = 0;
        for (int i = 0; i < this.filters.length; ++i) {
            BloomFilter filter2 = this.filters[i];
            int r = filter2.remove(value);
            if (filter2 != this.current_filter) continue;
            res = r;
        }
        return res;
    }

    @Override
    public boolean contains(byte[] value) {
        return this.current_filter.contains(value);
    }

    @Override
    public int count(byte[] value) {
        return this.current_filter.count(value);
    }

    @Override
    public int getEntryCount() {
        return this.current_filter.getEntryCount();
    }

    @Override
    public int getSize() {
        return this.current_filter.getSize();
    }

    @Override
    public BloomFilter getReplica() {
        return new BloomFilterRotator(this.current_filter, this.filters.length);
    }

    @Override
    public String getString() {
        return "ind=" + this.current_filter_index + ",filt=" + this.current_filter.getString();
    }
}

