/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl;

import com.aelitis.azureus.core.proxy.AEProxyConnection;
import com.aelitis.azureus.core.proxy.AEProxyConnectionListener;
import com.aelitis.azureus.core.proxy.AEProxyHandler;
import com.aelitis.azureus.core.proxy.AEProxyState;
import com.aelitis.azureus.core.proxy.impl.AEProxyImpl;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEProxyConnectionImpl
implements AEProxyConnection {
    private static final LogIDs LOGID = LogIDs.NET;
    protected AEProxyImpl server;
    protected SocketChannel source_channel;
    protected volatile AEProxyState proxy_read_state = null;
    protected volatile AEProxyState proxy_write_state = null;
    protected volatile AEProxyState proxy_connect_state = null;
    protected long time_stamp;
    protected boolean is_connected;
    protected boolean is_closed;
    protected List listeners = new ArrayList(1);

    protected AEProxyConnectionImpl(AEProxyImpl _server, SocketChannel _socket, AEProxyHandler _handler) {
        this.server = _server;
        this.source_channel = _socket;
        this.setTimeStamp();
        try {
            this.proxy_read_state = _handler.getInitialState(this);
        }
        catch (Throwable e) {
            this.failed(e);
        }
    }

    public String getName() {
        String name = this.source_channel.socket().getInetAddress() + ":" + this.source_channel.socket().getPort() + " -> ";
        return name;
    }

    public SocketChannel getSourceChannel() {
        return this.source_channel;
    }

    public void setReadState(AEProxyState state) {
        this.proxy_read_state = state;
    }

    public void setWriteState(AEProxyState state) {
        this.proxy_write_state = state;
    }

    public void setConnectState(AEProxyState state) {
        this.proxy_connect_state = state;
    }

    protected boolean read(SocketChannel sc) {
        try {
            return this.proxy_read_state.read(sc);
        }
        catch (Throwable e) {
            this.failed(e);
            return false;
        }
    }

    protected boolean write(SocketChannel sc) {
        try {
            return this.proxy_write_state.write(sc);
        }
        catch (Throwable e) {
            this.failed(e);
            return false;
        }
    }

    protected boolean connect(SocketChannel sc) {
        try {
            return this.proxy_connect_state.connect(sc);
        }
        catch (Throwable e) {
            this.failed(e);
            return false;
        }
    }

    public void requestWriteSelect(SocketChannel sc) {
        this.server.requestWriteSelect(this, sc);
    }

    public void cancelWriteSelect(SocketChannel sc) {
        this.server.cancelWriteSelect(sc);
    }

    public void requestConnectSelect(SocketChannel sc) {
        this.server.requestConnectSelect(this, sc);
    }

    public void cancelConnectSelect(SocketChannel sc) {
        this.server.cancelConnectSelect(sc);
    }

    public void requestReadSelect(SocketChannel sc) {
        this.server.requestReadSelect(this, sc);
    }

    public void cancelReadSelect(SocketChannel sc) {
        this.server.cancelReadSelect(sc);
    }

    public void failed(Throwable reason) {
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "AEProxyProcessor: " + this.getName() + " failed", reason));
            }
            this.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.is_closed = true;
        try {
            try {
                this.cancelReadSelect(this.source_channel);
                this.cancelWriteSelect(this.source_channel);
                this.source_channel.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((AEProxyConnectionListener)this.listeners.get(i)).connectionClosed(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            Object var4_4 = null;
            this.server.close(this);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.server.close(this);
            throw throwable;
        }
    }

    public boolean isClosed() {
        return this.is_closed;
    }

    public void setConnected() {
        this.setTimeStamp();
        this.is_connected = true;
    }

    protected boolean isConnected() {
        return this.is_connected;
    }

    public void setTimeStamp() {
        this.time_stamp = SystemTime.getCurrentTime();
    }

    protected long getTimeStamp() {
        return this.time_stamp;
    }

    public void addListener(AEProxyConnectionListener l) {
        this.listeners.add(l);
    }

    public void removeListener(AEProxyConnectionListener l) {
        this.listeners.remove(l);
    }

    protected String getStateString() {
        return this.getName() + "connected = " + this.is_connected + ", closed = " + this.is_closed + ", " + "chan: reg = " + this.source_channel.isRegistered() + ", open = " + this.source_channel.isOpen() + ", " + "read:" + (this.proxy_read_state == null ? null : this.proxy_read_state.getStateName()) + ", " + "write:" + (this.proxy_write_state == null ? null : this.proxy_write_state.getStateName()) + ", " + "connect:" + (this.proxy_connect_state == null ? null : this.proxy_connect_state.getStateName());
    }
}

