/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoder;
import com.aelitis.azureus.core.util.FeatureAvailability;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;

public class PeerClassifier {
    public static final String CACHE_LOGIC = "CacheLogic";
    private static Set platform_ips = Collections.synchronizedSet(new HashSet());

    public static String getClientDescription(byte[] peer_id) {
        return BTPeerIDByteDecoder.decode(peer_id);
    }

    public static String getPrintablePeerID(byte[] peer_id) {
        return BTPeerIDByteDecoder.getPrintablePeerID(peer_id);
    }

    public static boolean isClientTypeAllowed(String client_description) {
        return true;
    }

    public static boolean fullySupportsFE(String client_description) {
        if (FeatureAvailability.allowAllFEClients()) {
            return true;
        }
        boolean res = !client_description.startsWith("\u00b5") && !client_description.startsWith("Trans");
        return res;
    }

    public static boolean isAzureusIP(String ip) {
        return platform_ips.contains(ip);
    }

    public static void setAzureusIP(String ip) {
        platform_ips.add(ip);
    }

    public static boolean testIfAzureusIP(String ip) {
        try {
            InetAddress address = HostNameToIPResolver.syncResolve(ip);
            String host_address = address.getHostAddress();
            if (platform_ips.contains(host_address)) {
                return true;
            }
            String name = IPToHostNameResolver.syncResolve(ip, 10000);
            if (Constants.isAzureusDomain(name)) {
                platform_ips.add(host_address);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

