/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoderDefinitions;
import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoderUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class BTPeerIDByteDecoder {
    static final boolean LOG_UNKNOWN;
    private static HashSet logged_discrepancies;
    private static AEDiagnosticsLogger logger;
    static boolean client_logging_allowed;
    private static HashSet logged_ids;

    private static String logUnknownClient0(byte[] peer_id_bytes) throws IOException {
        String text = new String(peer_id_bytes, 0, 20, "ISO-8859-1");
        text = text.replace('\f', ' ');
        text = text.replace('\n', ' ');
        return "[" + text + "] " + ByteFormatter.encodeString(peer_id_bytes) + " ";
    }

    private static String asUTF8ByteString(String text) {
        try {
            byte[] utf_bytes = text.getBytes("UTF8");
            return ByteFormatter.encodeString(utf_bytes);
        }
        catch (UnsupportedEncodingException uee) {
            return "";
        }
    }

    public static void logClientDiscrepancy(String peer_id_name, String handshake_name, String discrepancy, String protocol, byte[] peer_id) {
        if (!client_logging_allowed) {
            return;
        }
        String line_to_log = discrepancy + " [" + protocol + "]: ";
        line_to_log = line_to_log + "\"" + peer_id_name + "\" / \"" + handshake_name + "\" ";
        line_to_log = line_to_log + "[" + BTPeerIDByteDecoder.asUTF8ByteString(handshake_name) + "]";
        boolean log_to_debug_out = Constants.isCVSVersion();
        if ((log_to_debug_out || LOG_UNKNOWN) && !logged_discrepancies.add(line_to_log)) {
            return;
        }
        if (peer_id != null) {
            line_to_log = line_to_log + ", Peer ID: " + ByteFormatter.encodeString(peer_id);
        }
        if (log_to_debug_out) {
            Debug.outNoStack("Conflicting peer identification: " + line_to_log);
        }
        if (!LOG_UNKNOWN) {
            return;
        }
        BTPeerIDByteDecoder.logClientDiscrepancyToFile(line_to_log);
    }

    private static synchronized void logClientDiscrepancyToFile(String line_to_log) {
        if (logger == null) {
            logger = AEDiagnostics.getLogger("clientid");
        }
        try {
            logger.log(line_to_log);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    static void logUnknownClient(byte[] peer_id_bytes) {
        BTPeerIDByteDecoder.logUnknownClient(peer_id_bytes, true);
    }

    static void logUnknownClient(byte[] peer_id_bytes, boolean to_debug_out) {
        boolean log_to_debug_out;
        if (!client_logging_allowed) {
            return;
        }
        boolean bl = log_to_debug_out = to_debug_out && Constants.isCVSVersion();
        if ((log_to_debug_out || LOG_UNKNOWN) && !logged_ids.add(BTPeerIDByteDecoder.makePeerIDReadableAndUsable(peer_id_bytes))) {
            return;
        }
        if (log_to_debug_out) {
            Debug.outNoStack("Unable to decode peer correctly - peer ID bytes: " + BTPeerIDByteDecoder.makePeerIDReadableAndUsable(peer_id_bytes));
        }
        if (!LOG_UNKNOWN) {
            return;
        }
        try {
            BTPeerIDByteDecoder.logClientDiscrepancyToFile(BTPeerIDByteDecoder.logUnknownClient0(peer_id_bytes));
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
    }

    static void logUnknownClient(String peer_id) {
        try {
            BTPeerIDByteDecoder.logUnknownClient(peer_id.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static String decode0(byte[] peer_id_bytes) {
        String client_ver;
        String UNKNOWN = MessageText.getString("PeerSocket.unknown");
        String FAKE = MessageText.getString("PeerSocket.fake_client");
        String BAD_PEER_ID = MessageText.getString("PeerSocket.bad_peer_id");
        String peer_id = null;
        try {
            peer_id = new String(peer_id_bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            return "";
        }
        String client = null;
        if (BTPeerIDByteDecoderUtils.isPossibleSpoofClient(peer_id)) {
            client = BTPeerIDByteDecoder.decodeBitSpiritClient(peer_id, peer_id_bytes);
            if (client != null) {
                return client;
            }
            client = BTPeerIDByteDecoder.decodeBitCometClient(peer_id, peer_id_bytes);
            if (client != null) {
                return client;
            }
            return "BitSpirit? (" + BAD_PEER_ID + ")";
        }
        if (BTPeerIDByteDecoderUtils.isAzStyle(peer_id) && (client = BTPeerIDByteDecoderDefinitions.getAzStyleClientName(peer_id)) != null) {
            String client_with_version = BTPeerIDByteDecoderDefinitions.getAzStyleClientVersion(client, peer_id);
            if (client.startsWith("ZipTorrent") && peer_id.startsWith("bLAde", 8)) {
                String client_name = client_with_version == null ? client : client_with_version;
                return UNKNOWN + " [" + FAKE + ": " + client_name + "]";
            }
            if ("\u00b5Torrent 6.0.0 Beta".equals(client_with_version)) {
                return "Mainline 6.0 Beta";
            }
            if (client.startsWith("libTorrent (Rakshasa)")) {
                String client_name = client_with_version == null ? client : client_with_version;
                return client_name + " / rTorrent*";
            }
            if (client_with_version != null) {
                return client_with_version;
            }
            return client;
        }
        if (BTPeerIDByteDecoderUtils.isShadowStyle(peer_id) && (client = BTPeerIDByteDecoderDefinitions.getShadowStyleClientName(peer_id)) != null) {
            String client_ver2 = BTPeerIDByteDecoderUtils.getShadowStyleVersionNumber(peer_id);
            if (client_ver2 != null) {
                return client + " " + client_ver2;
            }
            return client;
        }
        client = BTPeerIDByteDecoderDefinitions.getMainlineStyleClientName(peer_id);
        if (client != null && (client_ver = BTPeerIDByteDecoderUtils.getMainlineStyleVersionNumber(peer_id)) != null) {
            String result = client + " " + client_ver;
            return result;
        }
        client = BTPeerIDByteDecoder.decodeBitSpiritClient(peer_id, peer_id_bytes);
        if (client != null) {
            return client;
        }
        client = BTPeerIDByteDecoder.decodeBitCometClient(peer_id, peer_id_bytes);
        if (client != null) {
            return client;
        }
        BTPeerIDByteDecoderDefinitions.ClientData client_data = BTPeerIDByteDecoderDefinitions.getSubstringStyleClient(peer_id);
        if (client_data != null) {
            client = client_data.client_name;
            String client_with_version = BTPeerIDByteDecoderDefinitions.getSubstringStyleClientVersion(client_data, peer_id, peer_id_bytes);
            if (client_with_version != null) {
                return client_with_version;
            }
            return client;
        }
        client = BTPeerIDByteDecoder.identifyAwkwardClient(peer_id_bytes);
        if (client != null) {
            return client;
        }
        return null;
    }

    public static String decode(byte[] peer_id) {
        if (peer_id.length > 0) {
            try {
                String client = BTPeerIDByteDecoder.decode0(peer_id);
                if (client != null) {
                    return client;
                }
            }
            catch (Throwable e) {
                Debug.out("Failed to decode peer id " + ByteFormatter.encodeString(peer_id) + ": " + Debug.getNestedExceptionMessageAndStack(e));
            }
            try {
                String peer_id_as_string = new String(peer_id, "ISO-8859-1");
                boolean is_az_style = BTPeerIDByteDecoderUtils.isAzStyle(peer_id_as_string);
                boolean is_shadow_style = BTPeerIDByteDecoderUtils.isShadowStyle(peer_id_as_string);
                BTPeerIDByteDecoder.logUnknownClient(peer_id, !is_az_style && !is_shadow_style);
                if (is_az_style) {
                    return BTPeerIDByteDecoderDefinitions.formatUnknownAzStyleClient(peer_id_as_string);
                }
                if (is_shadow_style) {
                    return BTPeerIDByteDecoderDefinitions.formatUnknownShadowStyleClient(peer_id_as_string);
                }
            }
            catch (Throwable e) {
                Debug.out("Failed to decode peer id " + ByteFormatter.encodeString(peer_id) + ": " + Debug.getNestedExceptionMessageAndStack(e));
            }
        }
        String sPeerID = BTPeerIDByteDecoder.getPrintablePeerID(peer_id);
        return MessageText.getString("PeerSocket.unknown") + " [" + sPeerID + "]";
    }

    public static String identifyAwkwardClient(byte[] peer_id) {
        int iFirstNonZeroPos = 0;
        iFirstNonZeroPos = 20;
        for (int i = 0; i < 20; ++i) {
            if (peer_id[i] == 0) continue;
            iFirstNonZeroPos = i;
            break;
        }
        if (iFirstNonZeroPos == 0) {
            int i;
            boolean bShareaza = true;
            for (i = 0; i < 16; ++i) {
                if (peer_id[i] != 0) continue;
                bShareaza = false;
                break;
            }
            if (bShareaza) {
                for (i = 16; i < 20; ++i) {
                    if (peer_id[i] == (peer_id[i % 16] ^ peer_id[15 - i % 16])) continue;
                    bShareaza = false;
                    break;
                }
                if (bShareaza) {
                    return "Shareaza";
                }
            }
        }
        byte three = 3;
        if (iFirstNonZeroPos == 9 && peer_id[9] == three && peer_id[10] == three && peer_id[11] == three) {
            return "Snark";
        }
        if (iFirstNonZeroPos == 12 && peer_id[12] == 97 && peer_id[13] == 97) {
            return "Experimental 3.2.1b2";
        }
        if (iFirstNonZeroPos == 12 && peer_id[12] == 0 && peer_id[13] == 0) {
            return "Experimental 3.1";
        }
        if (iFirstNonZeroPos == 12) {
            return "Mainline";
        }
        return null;
    }

    private static String decodeBitSpiritClient(String peer_id, byte[] peer_id_bytes) {
        if (!peer_id.substring(2, 4).equals("BS")) {
            return null;
        }
        String version = BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(peer_id_bytes[1]);
        if ("0".equals(version)) {
            version = "1";
        }
        return "BitSpirit v" + version;
    }

    private static String decodeBitCometClient(String peer_id, byte[] peer_id_bytes) {
        String mod_name = null;
        if (peer_id.startsWith("exbc")) {
            mod_name = "";
        } else if (peer_id.startsWith("FUTB")) {
            mod_name = "(Solidox Mod) ";
        } else if (peer_id.startsWith("xUTB")) {
            mod_name = "(Mod 2) ";
        } else {
            return null;
        }
        boolean is_bitlord = peer_id.substring(6, 10).equals("LORD");
        String client_name = is_bitlord ? "BitLord " : "BitComet ";
        String maj_version = BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(peer_id_bytes[4]);
        int min_version_length = is_bitlord && !maj_version.equals("0") ? 1 : 2;
        return client_name + mod_name + maj_version + "." + BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(peer_id_bytes[5], min_version_length);
    }

    protected static String getPrintablePeerID(byte[] peer_id) {
        return BTPeerIDByteDecoder.getPrintablePeerID(peer_id, '-');
    }

    protected static String getPrintablePeerID(byte[] peer_id, char fallback_char) {
        String sPeerID = "";
        byte[] peerID = new byte[peer_id.length];
        System.arraycopy(peer_id, 0, peerID, 0, peer_id.length);
        try {
            for (int i = 0; i < peerID.length; ++i) {
                int b = 0xFF & peerID[i];
                if (b >= 32 && b <= 127) continue;
                peerID[i] = (byte)fallback_char;
            }
            sPeerID = new String(peerID, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ignore) {
        }
        catch (Throwable e) {
            // empty catch block
        }
        return sPeerID;
    }

    private static String makePeerIDReadableAndUsable(byte[] peer_id) {
        boolean as_ascii = true;
        for (int i = 0; i < peer_id.length; ++i) {
            int b = 0xFF & peer_id[i];
            if (b >= 32 && b <= 127 && b != 10 && b != 9 && b != 13) continue;
            as_ascii = false;
            break;
        }
        if (as_ascii) {
            try {
                return new String(peer_id, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                return "";
            }
        }
        return ByteFormatter.encodeString(peer_id);
    }

    static byte[] peerIDStringToBytes(String peer_id) throws Exception {
        if (peer_id.length() > 40) {
            peer_id = peer_id.replaceAll("[ ]", "");
        }
        byte[] byte_peer_id = null;
        if (peer_id.length() == 40) {
            byte_peer_id = ByteFormatter.decodeString(peer_id);
            String readable_peer_id = BTPeerIDByteDecoder.makePeerIDReadableAndUsable(byte_peer_id);
            if (!peer_id.equals(readable_peer_id)) {
                throw new RuntimeException("Use alternative format for peer ID - from " + peer_id + " to " + readable_peer_id);
            }
        } else if (peer_id.length() == 20) {
            byte_peer_id = peer_id.getBytes("ISO-8859-1");
        } else {
            throw new IllegalArgumentException(peer_id);
        }
        return byte_peer_id;
    }

    private static void assertDecode(String client_result, String peer_id) throws Exception {
        BTPeerIDByteDecoder.assertDecode(client_result, BTPeerIDByteDecoder.peerIDStringToBytes(peer_id));
    }

    private static void assertDecode(String client_result, byte[] peer_id) throws Exception {
        String peer_id_as_string = BTPeerIDByteDecoder.getPrintablePeerID(peer_id, '*');
        System.out.println("   Peer ID: " + peer_id_as_string + "   Client: " + client_result);
        String decoded_result = BTPeerIDByteDecoder.decode(peer_id);
        if (client_result.equals(decoded_result)) {
            return;
        }
        throw new RuntimeException("assertion failure - expected \"" + client_result + "\", got \"" + decoded_result + "\": " + peer_id_as_string);
    }

    public static void main(String[] args) throws Exception {
        client_logging_allowed = false;
        String FAKE = MessageText.getString("PeerSocket.fake_client");
        String UNKNOWN = MessageText.getString("PeerSocket.unknown");
        String BAD_PEER_ID = MessageText.getString("PeerSocket.bad_peer_id");
        System.out.println("Testing AZ style clients...");
        BTPeerIDByteDecoder.assertDecode("Ares 2.0.5.3", "-AG2053-Em6o1EmvwLtD");
        BTPeerIDByteDecoder.assertDecode("Ares 1.6.7.0", "-AR1670-3Ql6wM3hgtCc");
        BTPeerIDByteDecoder.assertDecode("Artemis 2.5.2.0", "-AT2520-vEEt0wO6v0cr");
        BTPeerIDByteDecoder.assertDecode("Azureus 2.2.0.0", "-AZ2200-6wfG2wk6wWLc");
        BTPeerIDByteDecoder.assertDecode("BT Next Evolution 1.0.9", "-NE1090002IKyMn4g7Ko");
        BTPeerIDByteDecoder.assertDecode("BitRocket 0.3(32)", "-BR0332-!XVceSn(*KIl");
        BTPeerIDByteDecoder.assertDecode("Mainline 6.0 Beta", "2D555436 3030422D A78DC290 C3F7BDE0 15EC3CC7");
        BTPeerIDByteDecoder.assertDecode("FlashGet 1.80", "2D464730 31383075 F8005782 1359D64B B3DFD265");
        BTPeerIDByteDecoder.assertDecode("GetRight 6.3", "-GR6300-13s3iFKmbArc");
        BTPeerIDByteDecoder.assertDecode("Halite 0.2.9", "-HL0290-xUO*9ugvENUE");
        BTPeerIDByteDecoder.assertDecode("KTorrent 1.1 RC1", "-KT11R1-693649213030");
        BTPeerIDByteDecoder.assertDecode("KTorrent 3.0", "2D4B543330302D006A7139727958377731756A4B");
        BTPeerIDByteDecoder.assertDecode("libTorrent (Rakshasa) 0.11.2 / rTorrent*", "2D6C74304232302D0D739B93E6BE21FEBB557B20");
        BTPeerIDByteDecoder.assertDecode("libtorrent (Rasterbar) 0.13.0", "-LT0D00-eZ0PwaDDr-~v");
        BTPeerIDByteDecoder.assertDecode("linkage 0.1.4", "-LK0140-ATIV~nbEQAMr");
        BTPeerIDByteDecoder.assertDecode("LimeWire", "2D4C57303030312D31E0B3A0B46F7D4E954F4103");
        BTPeerIDByteDecoder.assertDecode("Lphant 3.02", "2D4C5030 3330322D 00383336 35363935 37373030");
        BTPeerIDByteDecoder.assertDecode("Shareaza 2.1.3.2", "2D535A323133322D000000000000000000000000");
        BTPeerIDByteDecoder.assertDecode("SymTorrent 1.17", "-ST0117-01234567890!");
        BTPeerIDByteDecoder.assertDecode("Transmission 0.6", "-TR0006-01234567890!");
        BTPeerIDByteDecoder.assertDecode("Transmission 0.72 (Dev)", "-TR072Z-zihst5yvg22f");
        BTPeerIDByteDecoder.assertDecode("Transmission 0.72", "-TR0072-8vd6hrmp04an");
        BTPeerIDByteDecoder.assertDecode("TuoTu 2.1.0", "-TT210w-dq!nWf~Qcext");
        BTPeerIDByteDecoder.assertDecode("\u00b5Torrent 1.7.0 Beta", "2D555431 3730422D 92844644 1DB0A094 A01C01E5");
        BTPeerIDByteDecoder.assertDecode("\u54c7\u560e (Vagaa) 2.6.4.4", "2D5647323634342D4FD62CDA69E235717E3BB94B");
        BTPeerIDByteDecoder.assertDecode("FireTorrent 0.3.0.0", "-WY0300-6huHF5Pr7Vde");
        BTPeerIDByteDecoder.assertDecode("CacheLogic 25.1-26", "-PC251Q-6huHF5Pr7Vde");
        BTPeerIDByteDecoder.assertDecode("KGet 2.4.5.0", "-KG2450-BDEw8OM14Hk6");
        System.out.println();
        System.out.println("Testing Shadow style clients...");
        BTPeerIDByteDecoder.assertDecode("ABC", "A--------YMyoBPXYy2L");
        BTPeerIDByteDecoder.assertDecode("ABC 2.6.9", "413236392D2D2D2D345077199FAEC4A673BECA01");
        BTPeerIDByteDecoder.assertDecode("ABC 3.1", "A310--001v5Gysr4NxNK");
        BTPeerIDByteDecoder.assertDecode("BitTornado 0.3.12", "T03C-----6tYolxhVUFS");
        BTPeerIDByteDecoder.assertDecode("BitTornado 0.3.18", "T03I--008gY6iB6Aq27C");
        BTPeerIDByteDecoder.assertDecode("BitTornado 0.3.9", "T0390----5uL5NvjBe2z");
        BTPeerIDByteDecoder.assertDecode("Tribler 1", "R100--003hR6s07XWcov");
        BTPeerIDByteDecoder.assertDecode("Tribler 3.7", "R37---003uApHy851-Pq");
        System.out.println();
        System.out.println("Testing simple substring clients...");
        BTPeerIDByteDecoder.assertDecode("Azureus 1", "417A7572 65757300 00000000 000000A0 76F0AEF7");
        BTPeerIDByteDecoder.assertDecode("Azureus 2.0.3.2", "2D2D2D2D2D417A757265757354694E7A2A6454A7");
        BTPeerIDByteDecoder.assertDecode("G3 Torrent", "2D473341 6E6F6E79 6D6F7573 70E8D9CB 30250AD4");
        BTPeerIDByteDecoder.assertDecode("Hurricane Electric", "6172636C696768742E68652EA5860C157A5ADC35");
        BTPeerIDByteDecoder.assertDecode("Pando", "Pando-6B511B691CAC2E");
        BTPeerIDByteDecoder.assertDecode("\u00b5Torrent 1.7.0 RC", "2D55543137302D00AF8BC5ACCC4631481EB3EB60");
        System.out.println();
        System.out.println("Testing versioned substring clients...");
        BTPeerIDByteDecoder.assertDecode("Bitlet 0.1", "4269744C657430319AEA4E02A09E318D70CCF47D");
        BTPeerIDByteDecoder.assertDecode("BitsOnWheels", "-BOWP05-EPICNZOGQPHP");
        BTPeerIDByteDecoder.assertDecode("Burst! 1.1.3", "Mbrst1-1-32e3c394b43");
        BTPeerIDByteDecoder.assertDecode("Opera (Build 7685)", "OP7685f2c1495b1680bf");
        BTPeerIDByteDecoder.assertDecode("Opera (Build 10063)", "O100634008270e29150a");
        BTPeerIDByteDecoder.assertDecode("Rufus 0.6.9", "00455253 416E6F6E 796D6F75 7382BE42 75024AE3");
        BTPeerIDByteDecoder.assertDecode("BitTorrent DNA 1.0", "444E413031303030DD01C9B2DA689E6E02803E91");
        BTPeerIDByteDecoder.assertDecode("BTuga Revolution 2.1", "BTM21abcdefghijklmno");
        BTPeerIDByteDecoder.assertDecode("AllPeers 0.70rc30", "4150302E3730726333302D3E3EB87B31F241DBFE");
        BTPeerIDByteDecoder.assertDecode("External Webseed", "45787420EC7CC30033D7801FEEB713FBB0557AC4");
        BTPeerIDByteDecoder.assertDecode("QVOD (Build 0054)", "QVOD00541234567890AB");
        BTPeerIDByteDecoder.assertDecode("Top-BT 1.0.0", "TB100----abcdefghijk");
        System.out.println();
        System.out.println("Testing BitComet/Lord/Spirit clients...");
        BTPeerIDByteDecoder.assertDecode("BitComet 0.56", "6578626300387A4463102D6E9AD6723B339F35A9");
        BTPeerIDByteDecoder.assertDecode("BitLord 0.56", "6578626300384C4F52443200048ECED57BD71028");
        BTPeerIDByteDecoder.assertDecode("BitSpirit? (" + BAD_PEER_ID + ")", "4D342D302D322D2D6898D9D0CAF25E4555445030");
        BTPeerIDByteDecoder.assertDecode("BitSpirit v2", "000242539B7ED3E058A8384AA748485454504254");
        BTPeerIDByteDecoder.assertDecode("BitSpirit v3", "00034253 07248896 44C59530 8A5FF2CA 55445030");
        System.out.println();
        System.out.println("Testing new mainline style clients...");
        BTPeerIDByteDecoder.assertDecode("Mainline 5.0.7", "M5-0-7--9aa757efd5be");
        BTPeerIDByteDecoder.assertDecode("Amazon AWS S3", "S3-1-0-0--0123456789");
        System.out.println();
        System.out.println("Testing various specialised clients...");
        BTPeerIDByteDecoder.assertDecode("Mainline", "0000000000000000000000004C53441933104277");
        BTPeerIDByteDecoder.assertDecode(UNKNOWN + " [" + FAKE + ": ZipTorrent 1.6.0.0]", "-ZT1600-bLAdeY9rdjbe");
        BTPeerIDByteDecoder.assertDecode("Tixati 1.37", "TIX0137-i6i6f0i5d5b7");
        BTPeerIDByteDecoder.assertDecode("folx 0.9", "2D464C3039C6F22D5F436863327A6D792E283867");
        System.out.println();
        System.out.println("Testing unknown (random byte?) clients...");
        BTPeerIDByteDecoder.assertDecode(UNKNOWN + " [--------1}-/---A---<]", "0000000000000000317DA32F831FF041A515FE3C");
        BTPeerIDByteDecoder.assertDecode(UNKNOWN + " [------- --  ------@(]", "000000DF05020020100020200008000000004028");
        BTPeerIDByteDecoder.assertDecode(UNKNOWN + " [-----------D-y-I--aO]", "0000000000000000F106CE44F179A2498FAC614F");
        BTPeerIDByteDecoder.assertDecode(UNKNOWN + " [--c--_-5-\\----t-#---]", "E7F163BB0E5FCD35005C09A11BC274C42385A1A0");
        System.out.println();
        System.out.println("Testing unknown AZ style clients...");
        String unknown_az = MessageText.getString("PeerSocket.unknown_az_style", new String[]{"BD", "0.3.0.0"});
        BTPeerIDByteDecoder.assertDecode(unknown_az, "-BD0300-1SGiRZ8uWpWH");
        unknown_az = MessageText.getString("PeerSocket.unknown_az_style", new String[]{"wF", "2.2.0.0"});
        BTPeerIDByteDecoder.assertDecode(unknown_az, "2D7746323230302D9DFF296B56AFC2DF751C609C");
        unknown_az = MessageText.getString("PeerSocket.unknown_az_style", new String[]{"X1", "0.0.6.4"});
        BTPeerIDByteDecoder.assertDecode(unknown_az, "2D5831303036342D12FB8A5B954153A114267F1F");
        unknown_az = MessageText.getString("PeerSocket.unknown_az_style", new String[]{"bF", "2q00"});
        BTPeerIDByteDecoder.assertDecode(unknown_az, "2D6246327130302D9DFF296B56AFC2DF751C609C");
        System.out.println();
        System.out.println("Testing unknown Shadow style clients...");
        String unknown_shadow = MessageText.getString("PeerSocket.unknown_shadow_style", new String[]{"B", "1.2"});
        BTPeerIDByteDecoder.assertDecode(unknown_shadow, "B12------xgTofhetSVQ");
        System.out.println();
        System.out.println("Done.");
    }

    static {
        String prop = System.getProperty("log.unknown.peerids");
        LOG_UNKNOWN = prop == null || prop.equals("1");
        logged_discrepancies = new HashSet();
        logger = null;
        client_logging_allowed = true;
        logged_ids = new HashSet();
    }
}

